/*
 * Decompiled with CFR 0.152.
 */
package io.inversion;

import io.inversion.Action;
import io.inversion.Api;
import io.inversion.ApiException;
import io.inversion.Chain;
import io.inversion.Db;
import io.inversion.Endpoint;
import io.inversion.Op;
import io.inversion.Request;
import io.inversion.Response;
import io.inversion.Rule;
import io.inversion.Server;
import io.inversion.Url;
import io.inversion.action.db.DbAction;
import io.inversion.config.Config;
import io.inversion.context.Codec;
import io.inversion.context.Context;
import io.inversion.context.Includer;
import io.inversion.context.InversionNamer;
import io.inversion.context.Namer;
import io.inversion.context.codec.ToStringCodec;
import io.inversion.json.JSList;
import io.inversion.json.JSMap;
import io.inversion.json.JSNode;
import io.inversion.json.JSParser;
import io.inversion.rql.Rql;
import io.inversion.utils.Path;
import io.inversion.utils.Utils;
import java.io.File;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Engine {
    protected final transient Logger log = LoggerFactory.getLogger((String)this.getClass().getName());
    final String name = "engine";
    protected transient String configPath = null;
    protected transient String configProfile = null;
    protected transient Context context = null;
    protected transient Config config = null;
    protected final transient List<EngineListener> listeners = new ArrayList<EngineListener>();
    protected volatile transient Response lastResponse = null;
    protected List<Api> apis = new Vector<Api>();
    protected final List<Action> filters = new ArrayList<Action>();
    protected String corsAllowHeaders = "accept,accept-encoding,accept-language,access-control-request-headers,access-control-request-method,authorization,connection,content-type,host,user-agent,x-auth-token";
    volatile transient boolean started = false;
    volatile transient boolean starting = false;

    public Engine() {
    }

    public Engine(String configPath, String configProfile) {
        this.configPath = configPath;
        this.configProfile = configProfile;
    }

    public Engine(Api ... apis) {
        if (apis != null) {
            for (Api api : apis) {
                this.withApi(api);
            }
        }
    }

    protected void startup0() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Engine startup() {
        if (this.started || this.starting) {
            return this;
        }
        System.out.println("STARTING ENGINE...");
        long start = System.currentTimeMillis();
        this.starting = true;
        try {
            this.startup0();
            Config config = this.getConfig();
            Context context = this.getContext();
            TreeMap properties = config.getProperties();
            LinkedHashMap firstPassEncoded = context.encode(new Object[]{this});
            LinkedHashMap firstPassApplied = context.decode((Map)properties);
            this.autowire(context);
            properties.entrySet().removeIf(entry -> ((String)entry.getKey()).toLowerCase().endsWith(".class") || ((String)entry.getKey()).toLowerCase().endsWith(".classname"));
            LinkedHashMap secondPassEncoded = context.encode(new Object[]{this});
            LinkedHashMap secondPassApplied = context.decode((Map)properties);
            this.started = true;
            boolean hasApi = false;
            for (Api api : this.apis) {
                hasApi = true;
                if (api.getEndpoints().size() == 0) {
                    throw ApiException.new500InternalServerError("CONFIGURATION ERROR: You have configured an Api without any Endpoints.", new Object[0]);
                }
                this.startupApi(api);
            }
            if (!hasApi) {
                throw ApiException.new500InternalServerError("CONFIGURATION ERROR: You don't have any Apis configured.", new Object[0]);
            }
            System.out.println("...ENGINE STARTED IN: " + (System.currentTimeMillis() - start) + "ms");
            Engine engine = this;
            return engine;
        }
        finally {
            this.starting = false;
        }
    }

    public void shutdown() {
        for (Api api : this.getApis()) {
            this.shutdownApi(api);
        }
        for (EngineListener listener : this.listeners) {
            try {
                listener.onShutdown(this);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.started = false;
        this.starting = false;
        Chain.resetAll();
    }

    public Response get(String url) {
        return this.service("GET", url, null);
    }

    public Response get(String url, Map<String, String> params) {
        return this.service("GET", url, null, params);
    }

    public Response get(String url, List queryTerms) {
        if (queryTerms != null && queryTerms.size() > 0) {
            HashMap<String, String> params = new HashMap<String, String>();
            queryTerms.stream().filter(Objects::nonNull).forEach(key -> params.put(key.toString(), null));
            return this.service("GET", url, null, params);
        }
        return this.service("GET", url, null, null);
    }

    public Response post(String url, JSNode body) {
        return this.service("POST", url, body.toString());
    }

    public Response put(String url, JSNode body) {
        return this.service("PUT", url, body.toString());
    }

    public Response patch(String url, JSNode body) {
        return this.service("PATCH", url, body.toString());
    }

    public Response delete(String url) {
        return this.service("DELETE", url, null);
    }

    public Response delete(String url, JSList hrefs) {
        return this.service("DELETE", url, hrefs.toString());
    }

    public Response service(String method, String url) {
        return this.service(method, url, null);
    }

    public Response service(String method, String url, String body) {
        return this.service(method, url, body, null);
    }

    public Response service(String method, String url, String body, Map<String, String> params) {
        if (url == null) {
            throw new ApiException("Unable to service request with null url.", new Object[0]);
        }
        Request req = new Request(method, url, body);
        req.withEngine(this);
        if (params != null) {
            for (String key : params.keySet()) {
                req.getUrl().withParam(key, params.get(key));
            }
        }
        Response res = new Response();
        this.service(req, res);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chain service(Request req, Response res) {
        Chain chain = null;
        if (res.getRequest() == null) {
            res.withRequest(req);
        }
        try {
            if (!this.started) {
                this.startup();
            }
            chain = Chain.push(this, req, res);
            req.withEngine(this);
            req.withChain(chain);
            Url url = req.getUrl();
            if (req.isMethod("options")) {
                res.withStatus("200 OK");
                Chain chain2 = chain;
                return chain2;
            }
            String allowedHeaders = this.corsAllowHeaders;
            String corsRequestHeader = req.getHeader("Access-Control-Request-Header");
            if (corsRequestHeader != null) {
                for (String h : corsRequestHeader.split(",")) {
                    h = h.trim();
                    allowedHeaders = allowedHeaders.concat(h).concat(",");
                }
            }
            if (req.isOptions()) {
                res.withHeader("Access-Control-Allow-Origin", "*");
                res.withHeader("Access-Control-Allow-Credentials", "true");
                res.withHeader("Access-Control-Allow-Methods", "GET, POST, PUT, PATCH, DELETE, OPTIONS");
                res.withHeader("Access-Control-Allow-Headers", allowedHeaders);
            } else {
                res.withHeader("Cache-Control", "no-store");
            }
            Path urlPath = url.getPath();
            for (int i = 0; i < urlPath.size(); ++i) {
                if (!urlPath.isVar(i) && !urlPath.isWildcard(i)) continue;
                throw ApiException.new400BadRequest("URL {} is malformed.", url);
            }
            if (url.toString().contains("/favicon.ico")) {
                res.withStatus("404 Not Found");
                res.withJson((JSNode)null);
                Chain i = chain;
                return i;
            }
            String xfp = req.getHeader("X-Forwarded-Proto");
            String xfh = req.getHeader("X-Forwarded-Host");
            if (xfp != null || xfh != null) {
                if (xfp != null) {
                    url.withProtocol(xfp);
                }
                if (xfh != null) {
                    url.withHost(xfh);
                }
            }
            if (Chain.getDepth() < 2) {
                Map<String, String> urlParams = req.getUrl().getParams();
                for (String key : urlParams.keySet()) {
                    List illegals;
                    if (key.indexOf("_") <= 0 || (illegals = Rql.parse((String)key, (String)((String)urlParams.get(key))).stream().filter(t -> !t.isLeaf() && t.getToken().startsWith("_")).collect(Collectors.toList())).size() <= 0) continue;
                    req.getUrl().clearParams(key);
                }
            }
            for (Action filter : this.filters) {
                Path path = req.getUrl().getPath().copy();
                Path match = filter.match(req.getMethod(), path);
                if (match == null) continue;
                chain.withAction(new Chain.ActionMatch(match, path, filter));
            }
            final Chain finalChain = chain;
            chain.withAction(new Chain.ActionMatch(null, null, new Action(){

                @Override
                public void run(Request req, Response res) throws ApiException {
                    Engine.this.service0(finalChain, req, res);
                }
            }));
            chain.go();
            Exception listenerEx = null;
            for (Api.ApiListener listener : this.getApiListeners(req)) {
                try {
                    listener.onAfterRequest(req, res);
                }
                catch (Exception ex) {
                    if (listenerEx != null) continue;
                    listenerEx = ex;
                }
            }
            if (listenerEx != null) {
                throw listenerEx;
            }
        }
        catch (Throwable ex) {
            boolean outError = req.isDebug();
            if (!outError) {
                boolean bl = outError = !(ex instanceof ApiException) || ((ApiException)ex).getStatusCode() >= 500;
            }
            if (outError) {
                ex.printStackTrace();
            }
            Chain.debug("Uncaught Exception: " + Utils.getShortCause((Throwable)ex), new Object[0]);
            JSNode json = Engine.buildErrorJson(ex);
            res.withStatus(json.getString((Object)"status"));
            res.withError(ex);
            res.withJson(json);
            for (Api.ApiListener listener : this.getApiListeners(req)) {
                try {
                    listener.onAfterError(req, res);
                }
                catch (Exception ex2) {
                    this.log.warn("Error notifying EngineListener.beforeError", ex);
                }
            }
        }
        finally {
            if (Chain.isRoot()) {
                Engine.exclude(req, res);
            }
            try {
                for (Api.ApiListener listener : this.getApiListeners(req)) {
                    try {
                        listener.onBeforeFinally(req, res);
                    }
                    catch (Exception ex) {
                        this.log.warn("Error notifying EngineListener.onFinally", (Throwable)ex);
                    }
                }
            }
            finally {
                if (chain != null) {
                    Chain.pop();
                }
                this.lastResponse = res;
            }
        }
        return chain;
    }

    void service0(Chain chain, Request req, Response res) throws ApiException {
        Url url = req.getUrl();
        if (!this.matchRequest(req)) {
            String requestUrl = req.getUrl().getOriginal();
            throw ApiException.new400BadRequest("No API or Endpoint was found matching your request '{}':'{}'", req.getMethod(), requestUrl);
        }
        if (req.isDebug()) {
            res.debug("", new Object[0]);
            res.debug("", new Object[0]);
            res.debug(">> request --------------", new Object[0]);
            res.debug(req.getMethod() + ": " + url, new Object[0]);
            String opString = req.getOp().toString();
            res.debug("OPERATION: " + opString, new Object[0]);
            for (Object key : req.getHeaders().keySet()) {
                res.debug((String)key + " " + Utils.implode((String)",", (Object[])new Object[]{req.getAllHeaders((String)key)}), new Object[0]);
            }
            res.debug("", new Object[0]);
            ArrayList actionNames = new ArrayList();
            for (Chain.ActionMatch am : req.getActionMatches()) {
                String name = am.action.getName();
                if (name == null) {
                    name = am.action.getClass().getSimpleName();
                }
                actionNames.add(name);
            }
            String msg = req.getMethod() + " " + url.getPath() + " [" + Utils.implode((String)",", (Object[])new Object[]{actionNames}) + "]";
            Chain.debug(msg, new Object[0]);
        }
        if (req.getApi() == null) {
            throw ApiException.new400BadRequest("No API found matching URL: '{}'", url);
        }
        if (req.getEndpoint() == null) {
            StringBuilder buff = new StringBuilder();
            for (Endpoint e : req.getApi().getEndpoints()) {
                if (e.isInternal()) continue;
                buff.append(e.toString()).append(" | ");
            }
            String orig = url.getOriginal();
            throw ApiException.new404NotFound("No Endpoint found matching '{}:{}' Valid endpoints are: {}", req.getMethod(), url.getOriginal(), buff.toString());
        }
        List<Chain.ActionMatch> actions = req.getActionMatches();
        if (actions.size() == 0) {
            throw ApiException.new404NotFound("No Actions are configured to handle your request.  Check your server configuration.", new Object[0]);
        }
        this.run(chain, actions);
    }

    void run(Chain chain, List<Chain.ActionMatch> actions) throws ApiException {
        chain.withActions(actions).go();
    }

    public boolean matchApi(Request req) {
        if (req.getApi() != null) {
            return true;
        }
        Path reqPath = req.getUrl().getPath();
        Path remainder = reqPath == null ? new Path() : reqPath.copy();
        Path serverPathMatch = null;
        Path serverPath = null;
        Server server = null;
        Server.ServerMatcher serverMatch = null;
        Api api = null;
        HashMap<String, String> pathParams = new HashMap<String, String>();
        for (Api a : this.getApis()) {
            for (Server serv : a.getServers()) {
                serverMatch = serv.match(req.getUrl());
                if (serverMatch == null) continue;
                server = serv;
                api = a;
                serverPath = serverMatch.getPath().extract(pathParams, remainder);
                break;
            }
            if (api == null) continue;
            break;
        }
        if (api != null && server != null) {
            req.withApi(api);
            req.withServer(server);
            req.withServerMatch(serverMatch);
            req.withServerPath(serverPath);
            req.withServerPathMatch(serverPathMatch);
            req.withPathParams(pathParams);
            req.withOperationPath(remainder);
            return true;
        }
        return false;
    }

    boolean matchRequest(Request req) {
        if (!this.matchApi(req)) {
            return false;
        }
        Api api = req.getApi();
        if (api == null) {
            return false;
        }
        HashMap<String, String> pathParams = new HashMap<String, String>();
        Path remainder = req.getOperationPath().copy();
        if (api != null) {
            for (Op op : api.getOps()) {
                Path actionPath;
                boolean matched = op.matches(req, remainder);
                if (!matched) continue;
                req.withOp(op);
                req.withEndpoint(op.getEndpoint());
                req.withDb(op.getDb());
                req.withCollection(op.getCollection());
                Path dbPath = op.getDbPathMatch() != null ? op.getDbPathMatch().extract(pathParams, remainder.copy()) : null;
                Path endpointPath = op.getEndpointPathMatch().extract(pathParams, remainder);
                Path collectionPath = op.getCollectionPathMatch() != null ? op.getCollectionPathMatch().extract(pathParams, remainder.copy()) : null;
                req.withEndpointPath(endpointPath);
                req.withActionPath(remainder);
                req.withDbPath(dbPath);
                req.withCollectionPath(collectionPath);
                req.withPathParams(pathParams);
                String method = req.getMethod();
                Path path = req.getPath();
                Path subpath = req.getSubpath();
                ArrayList<Chain.ActionMatch> actions = new ArrayList<Chain.ActionMatch>();
                for (Action action : req.getEndpoint().getActions()) {
                    actionPath = action.match(method, subpath);
                    if (actionPath == null) continue;
                    actions.add(new Chain.ActionMatch(actionPath, new Path(subpath), action));
                }
                for (Action action : req.getApi().getActions()) {
                    actionPath = action.match(method, path);
                    if (actionPath == null) continue;
                    actions.add(new Chain.ActionMatch(actionPath, new Path(path), action));
                }
                Collections.sort(actions);
                req.withActionMatches(actions);
                return true;
            }
        }
        return false;
    }

    public static JSNode buildErrorJson(Throwable ex) {
        String status = "500 Internal Server Error";
        String message = ex.getMessage();
        String error = Utils.getShortCause((Throwable)ex);
        if (ex instanceof ApiException) {
            ApiException apiEx = (ApiException)ex;
            status = apiEx.getStatus();
            message = apiEx.getMessage();
            if (message.indexOf("-") < 25) {
                message = message.substring(message.indexOf("-") + 1).trim();
            }
            if (apiEx.getStatusCode() < 500) {
                error = null;
            }
        }
        JSMap json = new JSMap(new Object[]{"status", status, "message", message});
        if (error != null) {
            json.put((Object)"error", (Object)error);
        }
        return json;
    }

    public boolean isStarted() {
        return this.started;
    }

    public Engine withEngineListener(EngineListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
        return this;
    }

    LinkedHashSet<Api.ApiListener> getApiListeners(Request req) {
        LinkedHashSet<Api.ApiListener> listeners = new LinkedHashSet<Api.ApiListener>();
        if (req.getApi() != null) {
            listeners.addAll(req.getApi().getApiListeners());
        }
        listeners.addAll(this.listeners);
        return listeners;
    }

    public List<Api> getApis() {
        return new ArrayList<Api>(this.apis);
    }

    public synchronized Api getApi(String apiName) {
        if (apiName == null) {
            return null;
        }
        for (Api api : this.apis) {
            if (!apiName.equalsIgnoreCase(api.getName())) continue;
            return api;
        }
        return null;
    }

    public synchronized Engine withApi(Api api) {
        if (this.apis.contains(api)) {
            return this;
        }
        if (api.isStarted() && api.getEngine() != null) {
            api.getEngine().removeApi(api);
        }
        ArrayList<Api> newList = new ArrayList<Api>(this.apis);
        Api existingApi = this.getApi(api.getName());
        if (existingApi != null && existingApi != api) {
            newList.remove(existingApi);
            newList.add(api);
        } else if (existingApi == null) {
            newList.add(api);
        }
        if (existingApi != api && this.isStarted()) {
            api.startup(this);
        }
        this.apis = newList;
        if (existingApi != null && existingApi != api) {
            existingApi.shutdown(this);
        }
        return this;
    }

    protected void startupApi(Api api) {
        if (this.started) {
            try {
                api.startup(this);
            }
            catch (Exception ex) {
                this.log.warn("Error starting api '" + api.getName() + "'", (Throwable)ex);
            }
            for (EngineListener listener : this.listeners) {
                try {
                    listener.onStartup(this, api);
                }
                catch (Exception ex) {
                    this.log.warn("Error starting api '" + api.getName() + "'", (Throwable)ex);
                }
            }
        }
    }

    public synchronized void removeApi(Api api) {
        ArrayList<Api> newList = new ArrayList<Api>(this.apis);
        newList.remove(api);
        this.apis = newList;
        this.shutdownApi(api);
    }

    protected void shutdownApi(Api api) {
        if (api.isStarted()) {
            try {
                api.shutdown(this);
            }
            catch (Exception ex) {
                this.log.warn("Error shutting down api '" + api.getName() + "'", (Throwable)ex);
            }
            for (EngineListener listener : this.listeners) {
                try {
                    listener.onShutdown(this, api);
                }
                catch (Exception ex) {
                    this.log.warn("Error shutting down api '" + api.getName() + "'", (Throwable)ex);
                }
            }
        }
    }

    public Engine withAllowHeaders(String allowHeaders) {
        this.corsAllowHeaders = allowHeaders;
        return this;
    }

    public Response getLastResponse() {
        return this.lastResponse;
    }

    public URL getResource(String name) {
        try {
            File file;
            URL url = this.getClass().getClassLoader().getResource(name);
            if (url == null && (file = new File(System.getProperty("user.dir"), name)).exists()) {
                url = file.toURI().toURL();
            }
            return url;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public Engine withConfigPath(String configPath) {
        this.configPath = configPath;
        return this;
    }

    public String getConfigProfile() {
        return this.configProfile;
    }

    public Engine withConfigProfile(String configProfile) {
        this.configProfile = configProfile;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Config getConfig() {
        if (this.config == null) {
            Engine engine = this;
            synchronized (engine) {
                if (this.config == null) {
                    this.config = Config.getConfig((String)"inversion", (String)this.getConfigPath(), (String)this.getConfigProfile(), (Object)this);
                }
            }
        }
        return this.config;
    }

    public Engine withConfig(Config config) {
        this.config = config;
        return this;
    }

    public Context getContext() {
        if (this.context == null) {
            this.context = new Context();
            Includer includer = this.context.getEncoder().getIncluder();
            this.context.withNamer((Namer)new InversionNamer());
            this.context.withCodec((Codec)new ToStringCodec(new Class[]{Path.class}));
            this.context.withCodec((Codec)new ToStringCodec(new Class[]{Rule.RuleMatcher.class}));
            this.context.withCodec((Codec)new ToStringCodec(new Class[]{JSNode.class}){

                public String toString(Object bean) {
                    return ((JSNode)bean).toString(false);
                }

                public Object fromString(Type type, String encoded) {
                    return JSParser.parseJson((String)encoded);
                }
            });
        }
        return this.context;
    }

    public Engine withContext(Context context) {
        this.context = context;
        return this;
    }

    public Engine withFilters(Action ... filters) {
        for (Action filter : filters) {
            if (filters == null || this.filters.contains(filter)) continue;
            this.filters.add(filter);
        }
        Collections.sort(this.filters);
        return this;
    }

    public List<Action> getFilters() {
        return Collections.unmodifiableList(this.filters);
    }

    protected static void exclude(Request req, Response res) {
        JSList data = res.data();
        if (data == null) {
            return;
        }
        Set includes = Engine.getXcludesSet(req.getUrl().getParam("include"));
        Set excludes = Engine.getXcludesSet(req.getUrl().getParam("exclude"));
        if (includes != null && includes.size() > 0 || excludes != null && excludes.size() > 0) {
            for (JSMap node : data.asMapList()) {
                Engine.exclude(node, includes, excludes, null);
            }
        }
    }

    protected static void exclude(JSMap node, Set<String> includes, Set<String> excludes, String path) {
        for (String key : new LinkedHashSet(node.keySet())) {
            String attrPath = ((String)(path != null ? path + "." + key : key)).toLowerCase();
            Object value = node.get((Object)key);
            if (Engine.exclude(attrPath, includes, excludes)) {
                node.remove((Object)key);
                continue;
            }
            if (!(value instanceof JSNode)) continue;
            if (value instanceof JSList) {
                JSList arr = (JSList)value;
                for (int i = 0; i < arr.size(); ++i) {
                    if (!(arr.get(i) instanceof JSMap)) continue;
                    Engine.exclude((JSMap)arr.get(i), includes, excludes, attrPath);
                }
                continue;
            }
            Engine.exclude((JSMap)value, includes, excludes, attrPath);
        }
    }

    protected static boolean exclude(String path, Set<String> includes, Set<String> excludes) {
        boolean exclude = false;
        if (includes != null && includes.size() > 0 && !Engine.find(includes, path, true)) {
            exclude = true;
        }
        if (excludes != null && excludes.size() > 0 && Engine.find(excludes, path, false)) {
            exclude = true;
        }
        return exclude;
    }

    protected static boolean find(Collection<String> paths, String path, boolean matchStart) {
        boolean found = false;
        if (paths.contains(path)) {
            found = true;
        } else {
            for (String param : paths) {
                if (matchStart && param.startsWith(path + ".")) {
                    found = true;
                    break;
                }
                if (!Utils.wildcardMatch((String)param, (String)path)) continue;
                found = true;
            }
        }
        return found;
    }

    static Set getXcludesSet(String str) {
        if (str == null) {
            return null;
        }
        LinkedHashSet<Object> set = new LinkedHashSet<Object>();
        for (String path : Utils.explode((String)",", (String[])new String[]{str.toLowerCase()})) {
            int pipe = path.indexOf(124);
            if (pipe > -1) {
                String prefix = "";
                String props = path;
                int dot = path.indexOf(46);
                if (dot > -1 && dot < pipe) {
                    prefix = path.substring(0, pipe);
                    prefix = prefix.substring(0, prefix.lastIndexOf(46) + 1);
                    props = path.substring(prefix.length());
                }
                for (String prop : Utils.explode((String)"\\|", (String[])new String[]{props})) {
                    set.add(prefix + prop);
                }
                continue;
            }
            set.add(path);
        }
        return set;
    }

    protected void autowire(Context context) {
        Api singleApi;
        if (context.getBeans(Api.class).size() == 0) {
            Api api = new Api();
            context.putBean("api", (Object)api);
        }
        for (Iterator api : context.getBeans(Api.class)) {
            if (this.getApis().contains(api)) continue;
            this.withApi((Api)((Object)api));
        }
        Api api = singleApi = this.getApis().size() == 1 ? this.getApis().get(0) : null;
        if (singleApi != null) {
            for (Db db : context.getBeans(Db.class)) {
                singleApi.withDb(db);
            }
            for (Endpoint ep : context.getBeans(Endpoint.class)) {
                singleApi.withEndpoint(ep);
            }
            if (singleApi.getEndpoints().size() == 0) {
                Endpoint ep = (Endpoint)new Endpoint().withName("endpoint");
                singleApi.withEndpoint(ep);
                context.putBean("endpoint", (Object)ep);
            }
            boolean assignToEndpoint = false;
            List endpoints = context.getBeans(Endpoint.class);
            if (endpoints.size() == 1 && ((Endpoint)endpoints.get(0)).getActions().size() == 0) {
                assignToEndpoint = true;
            }
            for (Object action : context.getBeans(Action.class)) {
                boolean assigned = false;
                for (Endpoint ep : singleApi.getEndpoints()) {
                    if (!ep.getActions().contains(action)) continue;
                    assigned = true;
                    break;
                }
                if (!assigned && this.getFilters().contains(action)) {
                    assigned = true;
                }
                if (!assigned && singleApi.getActions().contains(action)) {
                    assigned = true;
                }
                if (assigned) continue;
                if (assignToEndpoint) {
                    ((Endpoint)endpoints.get(0)).withAction((Action)action);
                    continue;
                }
                singleApi.withAction((Action)action);
            }
        }
        for (Api api2 : this.getApis()) {
            if (api2.getServers().size() == 0) {
                api2.withServer(new Server());
            }
            if (api2.getEndpoints().size() == 0) {
                Endpoint ep = new Endpoint();
                api2.withEndpoint(ep);
            }
            if (api2.getDbs().size() <= 0 || api2.getActions().size() != 0) continue;
            boolean hasAction = false;
            for (Endpoint ep : api2.getEndpoints()) {
                if (ep.getActions().size() <= 0) continue;
                hasAction = true;
                break;
            }
            if (hasAction) continue;
            DbAction dbAction = new DbAction();
            if (api2.getEndpoints().size() == 1) {
                api2.getEndpoints().get(0).withAction(dbAction);
                continue;
            }
            api2.withAction(dbAction);
        }
        for (Api api2 : this.getApis()) {
            for (Db db : api2.getDbs()) {
                db.startup(api2);
            }
        }
    }

    public static interface EngineListener
    extends Api.ApiListener {
        default public void onStartup(Engine engine) {
        }

        default public void onShutdown(Engine engine) {
        }
    }
}

