/*
 * Copyright 2016 Game Server Services, Inc. or its affiliates. All Rights
 * Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package io.gs2.log.request;

import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.JsonNode;
import io.gs2.core.control.Gs2BasicRequest;

@SuppressWarnings("serial")
@JsonIgnoreProperties(ignoreUnknown=true)
public class CountExecuteStampSheetLogRequest extends Gs2BasicRequest<CountExecuteStampSheetLogRequest> {
    private String namespaceName;
    private Boolean service;
    private Boolean method;
    private Boolean userId;
    private Boolean action;
    private Long begin;
    private Long end;
    private Boolean longTerm;
    private String pageToken;
    private Integer limit;

	public String getNamespaceName() {
		return namespaceName;
	}

	public void setNamespaceName(String namespaceName) {
		this.namespaceName = namespaceName;
	}

	public CountExecuteStampSheetLogRequest withNamespaceName(String namespaceName) {
		this.namespaceName = namespaceName;
		return this;
	}

	public Boolean getService() {
		return service;
	}

	public void setService(Boolean service) {
		this.service = service;
	}

	public CountExecuteStampSheetLogRequest withService(Boolean service) {
		this.service = service;
		return this;
	}

	public Boolean getMethod() {
		return method;
	}

	public void setMethod(Boolean method) {
		this.method = method;
	}

	public CountExecuteStampSheetLogRequest withMethod(Boolean method) {
		this.method = method;
		return this;
	}

	public Boolean getUserId() {
		return userId;
	}

	public void setUserId(Boolean userId) {
		this.userId = userId;
	}

	public CountExecuteStampSheetLogRequest withUserId(Boolean userId) {
		this.userId = userId;
		return this;
	}

	public Boolean getAction() {
		return action;
	}

	public void setAction(Boolean action) {
		this.action = action;
	}

	public CountExecuteStampSheetLogRequest withAction(Boolean action) {
		this.action = action;
		return this;
	}

	public Long getBegin() {
		return begin;
	}

	public void setBegin(Long begin) {
		this.begin = begin;
	}

	public CountExecuteStampSheetLogRequest withBegin(Long begin) {
		this.begin = begin;
		return this;
	}

	public Long getEnd() {
		return end;
	}

	public void setEnd(Long end) {
		this.end = end;
	}

	public CountExecuteStampSheetLogRequest withEnd(Long end) {
		this.end = end;
		return this;
	}

	public Boolean getLongTerm() {
		return longTerm;
	}

	public void setLongTerm(Boolean longTerm) {
		this.longTerm = longTerm;
	}

	public CountExecuteStampSheetLogRequest withLongTerm(Boolean longTerm) {
		this.longTerm = longTerm;
		return this;
	}

	public String getPageToken() {
		return pageToken;
	}

	public void setPageToken(String pageToken) {
		this.pageToken = pageToken;
	}

	public CountExecuteStampSheetLogRequest withPageToken(String pageToken) {
		this.pageToken = pageToken;
		return this;
	}

	public Integer getLimit() {
		return limit;
	}

	public void setLimit(Integer limit) {
		this.limit = limit;
	}

	public CountExecuteStampSheetLogRequest withLimit(Integer limit) {
		this.limit = limit;
		return this;
	}

    public static CountExecuteStampSheetLogRequest fromJson(JsonNode data) {
        if (data == null) {
            return null;
        }
        return new CountExecuteStampSheetLogRequest()
            .withNamespaceName(data.get("namespaceName") == null || data.get("namespaceName").isNull() ? null : data.get("namespaceName").asText())
            .withService(data.get("service") == null || data.get("service").isNull() ? null : data.get("service").booleanValue())
            .withMethod(data.get("method") == null || data.get("method").isNull() ? null : data.get("method").booleanValue())
            .withUserId(data.get("userId") == null || data.get("userId").isNull() ? null : data.get("userId").booleanValue())
            .withAction(data.get("action") == null || data.get("action").isNull() ? null : data.get("action").booleanValue())
            .withBegin(data.get("begin") == null || data.get("begin").isNull() ? null : data.get("begin").longValue())
            .withEnd(data.get("end") == null || data.get("end").isNull() ? null : data.get("end").longValue())
            .withLongTerm(data.get("longTerm") == null || data.get("longTerm").isNull() ? null : data.get("longTerm").booleanValue())
            .withPageToken(data.get("pageToken") == null || data.get("pageToken").isNull() ? null : data.get("pageToken").asText())
            .withLimit(data.get("limit") == null || data.get("limit").isNull() ? null : data.get("limit").intValue());
    }

    public JsonNode toJson() {
        return new ObjectMapper().valueToTree(
            new HashMap<String, Object>() {{
                put("namespaceName", getNamespaceName());
                put("service", getService());
                put("method", getMethod());
                put("userId", getUserId());
                put("action", getAction());
                put("begin", getBegin());
                put("end", getEnd());
                put("longTerm", getLongTerm());
                put("pageToken", getPageToken());
                put("limit", getLimit());
            }}
        );
    }
}