/*
 * Copyright 2016 Game Server Services, Inc. or its affiliates. All Rights
 * Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package io.gs2.jobQueue.request;

import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.JsonNode;
import io.gs2.core.control.Gs2BasicRequest;
import io.gs2.jobQueue.model.JobEntry;

@SuppressWarnings("serial")
@JsonIgnoreProperties(ignoreUnknown=true)
public class PushByUserIdRequest extends Gs2BasicRequest<PushByUserIdRequest> {
    private String namespaceName;
    private String userId;
    private List<JobEntry> jobs;

	public String getNamespaceName() {
		return namespaceName;
	}

	public void setNamespaceName(String namespaceName) {
		this.namespaceName = namespaceName;
	}

	public PushByUserIdRequest withNamespaceName(String namespaceName) {
		this.namespaceName = namespaceName;
		return this;
	}

	public String getUserId() {
		return userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	public PushByUserIdRequest withUserId(String userId) {
		this.userId = userId;
		return this;
	}

	public List<JobEntry> getJobs() {
		return jobs;
	}

	public void setJobs(List<JobEntry> jobs) {
		this.jobs = jobs;
	}

	public PushByUserIdRequest withJobs(List<JobEntry> jobs) {
		this.jobs = jobs;
		return this;
	}

    public static PushByUserIdRequest fromJson(JsonNode data) {
        if (data == null) {
            return null;
        }
        return new PushByUserIdRequest()
            .withNamespaceName(data.get("namespaceName") == null || data.get("namespaceName").isNull() ? null : data.get("namespaceName").asText())
            .withUserId(data.get("userId") == null || data.get("userId").isNull() ? null : data.get("userId").asText())
            .withJobs(data.get("jobs") == null || data.get("jobs").isNull() ? new ArrayList<JobEntry>() :
                StreamSupport.stream(Spliterators.spliteratorUnknownSize(data.get("jobs").elements(), Spliterator.NONNULL), false).map(item -> {
                    //noinspection Convert2MethodRef
                    return JobEntry.fromJson(item);
                }
            ).collect(Collectors.toList()));
    }

    public JsonNode toJson() {
        return new ObjectMapper().valueToTree(
            new HashMap<String, Object>() {{
                put("namespaceName", getNamespaceName());
                put("userId", getUserId());
                put("jobs", getJobs() == null ? new ArrayList<JobEntry>() :
                    getJobs().stream().map(item -> {
                        //noinspection Convert2MethodRef
                        return item.toJson();
                    }
                ).collect(Collectors.toList()));
            }}
        );
    }
}