/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.inventory.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.model.IModel;
import io.gs2.inventory.model.BigItemModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BigInventoryModel
implements IModel,
Serializable,
Comparable<BigInventoryModel> {
    private String inventoryModelId;
    private String name;
    private String metadata;
    private List<BigItemModel> bigItemModels;

    public String getInventoryModelId() {
        return this.inventoryModelId;
    }

    public void setInventoryModelId(String inventoryModelId) {
        this.inventoryModelId = inventoryModelId;
    }

    public BigInventoryModel withInventoryModelId(String inventoryModelId) {
        this.inventoryModelId = inventoryModelId;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BigInventoryModel withName(String name) {
        this.name = name;
        return this;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public BigInventoryModel withMetadata(String metadata) {
        this.metadata = metadata;
        return this;
    }

    public List<BigItemModel> getBigItemModels() {
        return this.bigItemModels;
    }

    public void setBigItemModels(List<BigItemModel> bigItemModels) {
        this.bigItemModels = bigItemModels;
    }

    public BigInventoryModel withBigItemModels(List<BigItemModel> bigItemModels) {
        this.bigItemModels = bigItemModels;
        return this;
    }

    public static BigInventoryModel fromJson(JsonNode data) {
        if (data == null) {
            return null;
        }
        return new BigInventoryModel().withInventoryModelId(data.get("inventoryModelId") == null || data.get("inventoryModelId").isNull() ? null : data.get("inventoryModelId").asText()).withName(data.get("name") == null || data.get("name").isNull() ? null : data.get("name").asText()).withMetadata(data.get("metadata") == null || data.get("metadata").isNull() ? null : data.get("metadata").asText()).withBigItemModels(data.get("bigItemModels") == null || data.get("bigItemModels").isNull() ? new ArrayList<BigItemModel>() : StreamSupport.stream(Spliterators.spliteratorUnknownSize(data.get("bigItemModels").elements(), 256), false).map(item -> BigItemModel.fromJson(item)).collect(Collectors.toList()));
    }

    public JsonNode toJson() {
        return new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
            {
                this.put("inventoryModelId", BigInventoryModel.this.getInventoryModelId());
                this.put("name", BigInventoryModel.this.getName());
                this.put("metadata", BigInventoryModel.this.getMetadata());
                this.put("bigItemModels", BigInventoryModel.this.getBigItemModels() == null ? new ArrayList() : BigInventoryModel.this.getBigItemModels().stream().map(item -> item.toJson()).collect(Collectors.toList()));
            }
        });
    }

    @Override
    public int compareTo(BigInventoryModel o) {
        return this.inventoryModelId.compareTo(o.inventoryModelId);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.inventoryModelId == null ? 0 : this.inventoryModelId.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.metadata == null ? 0 : this.metadata.hashCode());
        result = 31 * result + (this.bigItemModels == null ? 0 : this.bigItemModels.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        BigInventoryModel other = (BigInventoryModel)o;
        if (this.inventoryModelId == null) {
            return other.inventoryModelId == null;
        }
        if (!this.inventoryModelId.equals(other.inventoryModelId)) {
            return false;
        }
        if (this.name == null) {
            return other.name == null;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (this.metadata == null) {
            return other.metadata == null;
        }
        if (!this.metadata.equals(other.metadata)) {
            return false;
        }
        if (this.bigItemModels == null) {
            return other.bigItemModels == null;
        }
        return this.bigItemModels.equals(other.bigItemModels);
    }
}

