/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.distributor;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.AbstractGs2Client;
import io.gs2.core.model.AsyncAction;
import io.gs2.core.model.AsyncResult;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.core.net.Gs2RestSessionTask;
import io.gs2.core.net.HttpTask;
import io.gs2.core.util.EncodingUtil;
import io.gs2.distributor.request.CreateDistributorModelMasterRequest;
import io.gs2.distributor.request.CreateNamespaceRequest;
import io.gs2.distributor.request.DeleteDistributorModelMasterRequest;
import io.gs2.distributor.request.DeleteNamespaceRequest;
import io.gs2.distributor.request.DescribeDistributorModelMastersRequest;
import io.gs2.distributor.request.DescribeDistributorModelsRequest;
import io.gs2.distributor.request.DescribeNamespacesRequest;
import io.gs2.distributor.request.DistributeRequest;
import io.gs2.distributor.request.DistributeWithoutOverflowProcessRequest;
import io.gs2.distributor.request.ExportMasterRequest;
import io.gs2.distributor.request.GetCurrentDistributorMasterRequest;
import io.gs2.distributor.request.GetDistributorModelMasterRequest;
import io.gs2.distributor.request.GetDistributorModelRequest;
import io.gs2.distributor.request.GetNamespaceRequest;
import io.gs2.distributor.request.GetNamespaceStatusRequest;
import io.gs2.distributor.request.GetStampSheetResultByUserIdRequest;
import io.gs2.distributor.request.GetStampSheetResultRequest;
import io.gs2.distributor.request.RunStampSheetExpressRequest;
import io.gs2.distributor.request.RunStampSheetExpressWithoutNamespaceRequest;
import io.gs2.distributor.request.RunStampSheetRequest;
import io.gs2.distributor.request.RunStampSheetWithoutNamespaceRequest;
import io.gs2.distributor.request.RunStampTaskRequest;
import io.gs2.distributor.request.RunStampTaskWithoutNamespaceRequest;
import io.gs2.distributor.request.UpdateCurrentDistributorMasterFromGitHubRequest;
import io.gs2.distributor.request.UpdateCurrentDistributorMasterRequest;
import io.gs2.distributor.request.UpdateDistributorModelMasterRequest;
import io.gs2.distributor.request.UpdateNamespaceRequest;
import io.gs2.distributor.result.CreateDistributorModelMasterResult;
import io.gs2.distributor.result.CreateNamespaceResult;
import io.gs2.distributor.result.DeleteDistributorModelMasterResult;
import io.gs2.distributor.result.DeleteNamespaceResult;
import io.gs2.distributor.result.DescribeDistributorModelMastersResult;
import io.gs2.distributor.result.DescribeDistributorModelsResult;
import io.gs2.distributor.result.DescribeNamespacesResult;
import io.gs2.distributor.result.DistributeResult;
import io.gs2.distributor.result.DistributeWithoutOverflowProcessResult;
import io.gs2.distributor.result.ExportMasterResult;
import io.gs2.distributor.result.GetCurrentDistributorMasterResult;
import io.gs2.distributor.result.GetDistributorModelMasterResult;
import io.gs2.distributor.result.GetDistributorModelResult;
import io.gs2.distributor.result.GetNamespaceResult;
import io.gs2.distributor.result.GetNamespaceStatusResult;
import io.gs2.distributor.result.GetStampSheetResultByUserIdResult;
import io.gs2.distributor.result.GetStampSheetResultResult;
import io.gs2.distributor.result.RunStampSheetExpressResult;
import io.gs2.distributor.result.RunStampSheetExpressWithoutNamespaceResult;
import io.gs2.distributor.result.RunStampSheetResult;
import io.gs2.distributor.result.RunStampSheetWithoutNamespaceResult;
import io.gs2.distributor.result.RunStampTaskResult;
import io.gs2.distributor.result.RunStampTaskWithoutNamespaceResult;
import io.gs2.distributor.result.UpdateCurrentDistributorMasterFromGitHubResult;
import io.gs2.distributor.result.UpdateCurrentDistributorMasterResult;
import io.gs2.distributor.result.UpdateDistributorModelMasterResult;
import io.gs2.distributor.result.UpdateNamespaceResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.stream.Collectors;

public class Gs2DistributorRestClient
extends AbstractGs2Client<Gs2DistributorRestClient> {
    public Gs2DistributorRestClient(Gs2RestSession gs2RestSession) {
        super(gs2RestSession);
    }

    public void describeNamespacesAsync(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> callback) {
        DescribeNamespacesTask task = new DescribeNamespacesTask(request, callback);
        this.session.execute(task);
    }

    public DescribeNamespacesResult describeNamespaces(DescribeNamespacesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeNamespacesAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeNamespacesResult)resultAsyncResult[0].getResult();
    }

    public void createNamespaceAsync(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> callback) {
        CreateNamespaceTask task = new CreateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public CreateNamespaceResult createNamespace(CreateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceStatusAsync(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> callback) {
        GetNamespaceStatusTask task = new GetNamespaceStatusTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceStatusResult getNamespaceStatus(GetNamespaceStatusRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceStatusAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceStatusResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceAsync(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> callback) {
        GetNamespaceTask task = new GetNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceResult getNamespace(GetNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void updateNamespaceAsync(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> callback) {
        UpdateNamespaceTask task = new UpdateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public UpdateNamespaceResult updateNamespace(UpdateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void deleteNamespaceAsync(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> callback) {
        DeleteNamespaceTask task = new DeleteNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public DeleteNamespaceResult deleteNamespace(DeleteNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void describeDistributorModelMastersAsync(DescribeDistributorModelMastersRequest request, AsyncAction<AsyncResult<DescribeDistributorModelMastersResult>> callback) {
        DescribeDistributorModelMastersTask task = new DescribeDistributorModelMastersTask(request, callback);
        this.session.execute(task);
    }

    public DescribeDistributorModelMastersResult describeDistributorModelMasters(DescribeDistributorModelMastersRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeDistributorModelMastersAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeDistributorModelMastersResult)resultAsyncResult[0].getResult();
    }

    public void createDistributorModelMasterAsync(CreateDistributorModelMasterRequest request, AsyncAction<AsyncResult<CreateDistributorModelMasterResult>> callback) {
        CreateDistributorModelMasterTask task = new CreateDistributorModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public CreateDistributorModelMasterResult createDistributorModelMaster(CreateDistributorModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createDistributorModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateDistributorModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void getDistributorModelMasterAsync(GetDistributorModelMasterRequest request, AsyncAction<AsyncResult<GetDistributorModelMasterResult>> callback) {
        GetDistributorModelMasterTask task = new GetDistributorModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public GetDistributorModelMasterResult getDistributorModelMaster(GetDistributorModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getDistributorModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetDistributorModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateDistributorModelMasterAsync(UpdateDistributorModelMasterRequest request, AsyncAction<AsyncResult<UpdateDistributorModelMasterResult>> callback) {
        UpdateDistributorModelMasterTask task = new UpdateDistributorModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public UpdateDistributorModelMasterResult updateDistributorModelMaster(UpdateDistributorModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateDistributorModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateDistributorModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void deleteDistributorModelMasterAsync(DeleteDistributorModelMasterRequest request, AsyncAction<AsyncResult<DeleteDistributorModelMasterResult>> callback) {
        DeleteDistributorModelMasterTask task = new DeleteDistributorModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public DeleteDistributorModelMasterResult deleteDistributorModelMaster(DeleteDistributorModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteDistributorModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteDistributorModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void describeDistributorModelsAsync(DescribeDistributorModelsRequest request, AsyncAction<AsyncResult<DescribeDistributorModelsResult>> callback) {
        DescribeDistributorModelsTask task = new DescribeDistributorModelsTask(request, callback);
        this.session.execute(task);
    }

    public DescribeDistributorModelsResult describeDistributorModels(DescribeDistributorModelsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeDistributorModelsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeDistributorModelsResult)resultAsyncResult[0].getResult();
    }

    public void getDistributorModelAsync(GetDistributorModelRequest request, AsyncAction<AsyncResult<GetDistributorModelResult>> callback) {
        GetDistributorModelTask task = new GetDistributorModelTask(request, callback);
        this.session.execute(task);
    }

    public GetDistributorModelResult getDistributorModel(GetDistributorModelRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getDistributorModelAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetDistributorModelResult)resultAsyncResult[0].getResult();
    }

    public void exportMasterAsync(ExportMasterRequest request, AsyncAction<AsyncResult<ExportMasterResult>> callback) {
        ExportMasterTask task = new ExportMasterTask(request, callback);
        this.session.execute(task);
    }

    public ExportMasterResult exportMaster(ExportMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.exportMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ExportMasterResult)resultAsyncResult[0].getResult();
    }

    public void getCurrentDistributorMasterAsync(GetCurrentDistributorMasterRequest request, AsyncAction<AsyncResult<GetCurrentDistributorMasterResult>> callback) {
        GetCurrentDistributorMasterTask task = new GetCurrentDistributorMasterTask(request, callback);
        this.session.execute(task);
    }

    public GetCurrentDistributorMasterResult getCurrentDistributorMaster(GetCurrentDistributorMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getCurrentDistributorMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetCurrentDistributorMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateCurrentDistributorMasterAsync(UpdateCurrentDistributorMasterRequest request, AsyncAction<AsyncResult<UpdateCurrentDistributorMasterResult>> callback) {
        UpdateCurrentDistributorMasterTask task = new UpdateCurrentDistributorMasterTask(request, callback);
        this.session.execute(task);
    }

    public UpdateCurrentDistributorMasterResult updateCurrentDistributorMaster(UpdateCurrentDistributorMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateCurrentDistributorMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateCurrentDistributorMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateCurrentDistributorMasterFromGitHubAsync(UpdateCurrentDistributorMasterFromGitHubRequest request, AsyncAction<AsyncResult<UpdateCurrentDistributorMasterFromGitHubResult>> callback) {
        UpdateCurrentDistributorMasterFromGitHubTask task = new UpdateCurrentDistributorMasterFromGitHubTask(request, callback);
        this.session.execute(task);
    }

    public UpdateCurrentDistributorMasterFromGitHubResult updateCurrentDistributorMasterFromGitHub(UpdateCurrentDistributorMasterFromGitHubRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateCurrentDistributorMasterFromGitHubAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateCurrentDistributorMasterFromGitHubResult)resultAsyncResult[0].getResult();
    }

    public void distributeAsync(DistributeRequest request, AsyncAction<AsyncResult<DistributeResult>> callback) {
        DistributeTask task = new DistributeTask(request, callback);
        this.session.execute(task);
    }

    public DistributeResult distribute(DistributeRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.distributeAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DistributeResult)resultAsyncResult[0].getResult();
    }

    public void distributeWithoutOverflowProcessAsync(DistributeWithoutOverflowProcessRequest request, AsyncAction<AsyncResult<DistributeWithoutOverflowProcessResult>> callback) {
        DistributeWithoutOverflowProcessTask task = new DistributeWithoutOverflowProcessTask(request, callback);
        this.session.execute(task);
    }

    public DistributeWithoutOverflowProcessResult distributeWithoutOverflowProcess(DistributeWithoutOverflowProcessRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.distributeWithoutOverflowProcessAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DistributeWithoutOverflowProcessResult)resultAsyncResult[0].getResult();
    }

    public void runStampTaskAsync(RunStampTaskRequest request, AsyncAction<AsyncResult<RunStampTaskResult>> callback) {
        RunStampTaskTask task = new RunStampTaskTask(request, callback);
        this.session.execute(task);
    }

    public RunStampTaskResult runStampTask(RunStampTaskRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.runStampTaskAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (RunStampTaskResult)resultAsyncResult[0].getResult();
    }

    public void runStampSheetAsync(RunStampSheetRequest request, AsyncAction<AsyncResult<RunStampSheetResult>> callback) {
        RunStampSheetTask task = new RunStampSheetTask(request, callback);
        this.session.execute(task);
    }

    public RunStampSheetResult runStampSheet(RunStampSheetRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.runStampSheetAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (RunStampSheetResult)resultAsyncResult[0].getResult();
    }

    public void runStampSheetExpressAsync(RunStampSheetExpressRequest request, AsyncAction<AsyncResult<RunStampSheetExpressResult>> callback) {
        RunStampSheetExpressTask task = new RunStampSheetExpressTask(request, callback);
        this.session.execute(task);
    }

    public RunStampSheetExpressResult runStampSheetExpress(RunStampSheetExpressRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.runStampSheetExpressAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (RunStampSheetExpressResult)resultAsyncResult[0].getResult();
    }

    public void runStampTaskWithoutNamespaceAsync(RunStampTaskWithoutNamespaceRequest request, AsyncAction<AsyncResult<RunStampTaskWithoutNamespaceResult>> callback) {
        RunStampTaskWithoutNamespaceTask task = new RunStampTaskWithoutNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public RunStampTaskWithoutNamespaceResult runStampTaskWithoutNamespace(RunStampTaskWithoutNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.runStampTaskWithoutNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (RunStampTaskWithoutNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void runStampSheetWithoutNamespaceAsync(RunStampSheetWithoutNamespaceRequest request, AsyncAction<AsyncResult<RunStampSheetWithoutNamespaceResult>> callback) {
        RunStampSheetWithoutNamespaceTask task = new RunStampSheetWithoutNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public RunStampSheetWithoutNamespaceResult runStampSheetWithoutNamespace(RunStampSheetWithoutNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.runStampSheetWithoutNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (RunStampSheetWithoutNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void runStampSheetExpressWithoutNamespaceAsync(RunStampSheetExpressWithoutNamespaceRequest request, AsyncAction<AsyncResult<RunStampSheetExpressWithoutNamespaceResult>> callback) {
        RunStampSheetExpressWithoutNamespaceTask task = new RunStampSheetExpressWithoutNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public RunStampSheetExpressWithoutNamespaceResult runStampSheetExpressWithoutNamespace(RunStampSheetExpressWithoutNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.runStampSheetExpressWithoutNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (RunStampSheetExpressWithoutNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void getStampSheetResultAsync(GetStampSheetResultRequest request, AsyncAction<AsyncResult<GetStampSheetResultResult>> callback) {
        GetStampSheetResultTask task = new GetStampSheetResultTask(request, callback);
        this.session.execute(task);
    }

    public GetStampSheetResultResult getStampSheetResult(GetStampSheetResultRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getStampSheetResultAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetStampSheetResultResult)resultAsyncResult[0].getResult();
    }

    public void getStampSheetResultByUserIdAsync(GetStampSheetResultByUserIdRequest request, AsyncAction<AsyncResult<GetStampSheetResultByUserIdResult>> callback) {
        GetStampSheetResultByUserIdTask task = new GetStampSheetResultByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public GetStampSheetResultByUserIdResult getStampSheetResultByUserId(GetStampSheetResultByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getStampSheetResultByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetStampSheetResultByUserIdResult)resultAsyncResult[0].getResult();
    }

    class DescribeNamespacesTask
    extends Gs2RestSessionTask<DescribeNamespacesResult> {
        private DescribeNamespacesRequest request;

        public DescribeNamespacesTask(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> userCallback) {
            super((Gs2RestSession)Gs2DistributorRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeNamespacesResult parse(JsonNode data) {
            return DescribeNamespacesResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "distributor").replace("{region}", Gs2DistributorRestClient.this.session.getRegion().getName()) + "/";
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateNamespaceTask
    extends Gs2RestSessionTask<CreateNamespaceResult> {
        private CreateNamespaceRequest request;

        public CreateNamespaceTask(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2DistributorRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateNamespaceResult parse(JsonNode data) {
            return CreateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "distributor").replace("{region}", Gs2DistributorRestClient.this.session.getRegion().getName()) + "/";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateNamespaceTask.this.request.getName());
                    this.put("description", CreateNamespaceTask.this.request.getDescription());
                    this.put("assumeUserId", CreateNamespaceTask.this.request.getAssumeUserId());
                    this.put("autoRunStampSheetNotification", CreateNamespaceTask.this.request.getAutoRunStampSheetNotification() != null ? CreateNamespaceTask.this.request.getAutoRunStampSheetNotification().toJson() : null);
                    this.put("logSetting", CreateNamespaceTask.this.request.getLogSetting() != null ? CreateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("contextStack", CreateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceStatusTask
    extends Gs2RestSessionTask<GetNamespaceStatusResult> {
        private GetNamespaceStatusRequest request;

        public GetNamespaceStatusTask(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> userCallback) {
            super((Gs2RestSession)Gs2DistributorRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceStatusResult parse(JsonNode data) {
            return GetNamespaceStatusResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "distributor").replace("{region}", Gs2DistributorRestClient.this.session.getRegion().getName()) + "/{namespaceName}/status";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceTask
    extends Gs2RestSessionTask<GetNamespaceResult> {
        private GetNamespaceRequest request;

        public GetNamespaceTask(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2DistributorRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceResult parse(JsonNode data) {
            return GetNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "distributor").replace("{region}", Gs2DistributorRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateNamespaceTask
    extends Gs2RestSessionTask<UpdateNamespaceResult> {
        private UpdateNamespaceRequest request;

        public UpdateNamespaceTask(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2DistributorRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateNamespaceResult parse(JsonNode data) {
            return UpdateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "distributor").replace("{region}", Gs2DistributorRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateNamespaceTask.this.request.getDescription());
                    this.put("assumeUserId", UpdateNamespaceTask.this.request.getAssumeUserId());
                    this.put("autoRunStampSheetNotification", UpdateNamespaceTask.this.request.getAutoRunStampSheetNotification() != null ? UpdateNamespaceTask.this.request.getAutoRunStampSheetNotification().toJson() : null);
                    this.put("logSetting", UpdateNamespaceTask.this.request.getLogSetting() != null ? UpdateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("contextStack", UpdateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteNamespaceTask
    extends Gs2RestSessionTask<DeleteNamespaceResult> {
        private DeleteNamespaceRequest request;

        public DeleteNamespaceTask(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2DistributorRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteNamespaceResult parse(JsonNode data) {
            return DeleteNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "distributor").replace("{region}", Gs2DistributorRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeDistributorModelMastersTask
    extends Gs2RestSessionTask<DescribeDistributorModelMastersResult> {
        private DescribeDistributorModelMastersRequest request;

        public DescribeDistributorModelMastersTask(DescribeDistributorModelMastersRequest request, AsyncAction<AsyncResult<DescribeDistributorModelMastersResult>> userCallback) {
            super((Gs2RestSession)Gs2DistributorRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeDistributorModelMastersResult parse(JsonNode data) {
            return DescribeDistributorModelMastersResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "distributor").replace("{region}", Gs2DistributorRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/distributor";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateDistributorModelMasterTask
    extends Gs2RestSessionTask<CreateDistributorModelMasterResult> {
        private CreateDistributorModelMasterRequest request;

        public CreateDistributorModelMasterTask(CreateDistributorModelMasterRequest request, AsyncAction<AsyncResult<CreateDistributorModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2DistributorRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateDistributorModelMasterResult parse(JsonNode data) {
            return CreateDistributorModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "distributor").replace("{region}", Gs2DistributorRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/distributor";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateDistributorModelMasterTask.this.request.getName());
                    this.put("description", CreateDistributorModelMasterTask.this.request.getDescription());
                    this.put("metadata", CreateDistributorModelMasterTask.this.request.getMetadata());
                    this.put("inboxNamespaceId", CreateDistributorModelMasterTask.this.request.getInboxNamespaceId());
                    this.put("whiteListTargetIds", CreateDistributorModelMasterTask.this.request.getWhiteListTargetIds() == null ? new ArrayList() : CreateDistributorModelMasterTask.this.request.getWhiteListTargetIds().stream().map(item -> item).collect(Collectors.toList()));
                    this.put("contextStack", CreateDistributorModelMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetDistributorModelMasterTask
    extends Gs2RestSessionTask<GetDistributorModelMasterResult> {
        private GetDistributorModelMasterRequest request;

        public GetDistributorModelMasterTask(GetDistributorModelMasterRequest request, AsyncAction<AsyncResult<GetDistributorModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2DistributorRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetDistributorModelMasterResult parse(JsonNode data) {
            return GetDistributorModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "distributor").replace("{region}", Gs2DistributorRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/distributor/{distributorName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{distributorName}", this.request.getDistributorName() == null || this.request.getDistributorName().length() == 0 ? "null" : String.valueOf(this.request.getDistributorName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateDistributorModelMasterTask
    extends Gs2RestSessionTask<UpdateDistributorModelMasterResult> {
        private UpdateDistributorModelMasterRequest request;

        public UpdateDistributorModelMasterTask(UpdateDistributorModelMasterRequest request, AsyncAction<AsyncResult<UpdateDistributorModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2DistributorRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateDistributorModelMasterResult parse(JsonNode data) {
            return UpdateDistributorModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "distributor").replace("{region}", Gs2DistributorRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/distributor/{distributorName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{distributorName}", this.request.getDistributorName() == null || this.request.getDistributorName().length() == 0 ? "null" : String.valueOf(this.request.getDistributorName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateDistributorModelMasterTask.this.request.getDescription());
                    this.put("metadata", UpdateDistributorModelMasterTask.this.request.getMetadata());
                    this.put("inboxNamespaceId", UpdateDistributorModelMasterTask.this.request.getInboxNamespaceId());
                    this.put("whiteListTargetIds", UpdateDistributorModelMasterTask.this.request.getWhiteListTargetIds() == null ? new ArrayList() : UpdateDistributorModelMasterTask.this.request.getWhiteListTargetIds().stream().map(item -> item).collect(Collectors.toList()));
                    this.put("contextStack", UpdateDistributorModelMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteDistributorModelMasterTask
    extends Gs2RestSessionTask<DeleteDistributorModelMasterResult> {
        private DeleteDistributorModelMasterRequest request;

        public DeleteDistributorModelMasterTask(DeleteDistributorModelMasterRequest request, AsyncAction<AsyncResult<DeleteDistributorModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2DistributorRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteDistributorModelMasterResult parse(JsonNode data) {
            return DeleteDistributorModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "distributor").replace("{region}", Gs2DistributorRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/distributor/{distributorName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{distributorName}", this.request.getDistributorName() == null || this.request.getDistributorName().length() == 0 ? "null" : String.valueOf(this.request.getDistributorName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeDistributorModelsTask
    extends Gs2RestSessionTask<DescribeDistributorModelsResult> {
        private DescribeDistributorModelsRequest request;

        public DescribeDistributorModelsTask(DescribeDistributorModelsRequest request, AsyncAction<AsyncResult<DescribeDistributorModelsResult>> userCallback) {
            super((Gs2RestSession)Gs2DistributorRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeDistributorModelsResult parse(JsonNode data) {
            return DescribeDistributorModelsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "distributor").replace("{region}", Gs2DistributorRestClient.this.session.getRegion().getName()) + "/{namespaceName}/distributor";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetDistributorModelTask
    extends Gs2RestSessionTask<GetDistributorModelResult> {
        private GetDistributorModelRequest request;

        public GetDistributorModelTask(GetDistributorModelRequest request, AsyncAction<AsyncResult<GetDistributorModelResult>> userCallback) {
            super((Gs2RestSession)Gs2DistributorRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetDistributorModelResult parse(JsonNode data) {
            return GetDistributorModelResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "distributor").replace("{region}", Gs2DistributorRestClient.this.session.getRegion().getName()) + "/{namespaceName}/distributor/{distributorName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{distributorName}", this.request.getDistributorName() == null || this.request.getDistributorName().length() == 0 ? "null" : String.valueOf(this.request.getDistributorName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class ExportMasterTask
    extends Gs2RestSessionTask<ExportMasterResult> {
        private ExportMasterRequest request;

        public ExportMasterTask(ExportMasterRequest request, AsyncAction<AsyncResult<ExportMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2DistributorRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ExportMasterResult parse(JsonNode data) {
            return ExportMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "distributor").replace("{region}", Gs2DistributorRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/export";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetCurrentDistributorMasterTask
    extends Gs2RestSessionTask<GetCurrentDistributorMasterResult> {
        private GetCurrentDistributorMasterRequest request;

        public GetCurrentDistributorMasterTask(GetCurrentDistributorMasterRequest request, AsyncAction<AsyncResult<GetCurrentDistributorMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2DistributorRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetCurrentDistributorMasterResult parse(JsonNode data) {
            return GetCurrentDistributorMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "distributor").replace("{region}", Gs2DistributorRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateCurrentDistributorMasterTask
    extends Gs2RestSessionTask<UpdateCurrentDistributorMasterResult> {
        private UpdateCurrentDistributorMasterRequest request;

        public UpdateCurrentDistributorMasterTask(UpdateCurrentDistributorMasterRequest request, AsyncAction<AsyncResult<UpdateCurrentDistributorMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2DistributorRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateCurrentDistributorMasterResult parse(JsonNode data) {
            return UpdateCurrentDistributorMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "distributor").replace("{region}", Gs2DistributorRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("settings", UpdateCurrentDistributorMasterTask.this.request.getSettings());
                    this.put("contextStack", UpdateCurrentDistributorMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateCurrentDistributorMasterFromGitHubTask
    extends Gs2RestSessionTask<UpdateCurrentDistributorMasterFromGitHubResult> {
        private UpdateCurrentDistributorMasterFromGitHubRequest request;

        public UpdateCurrentDistributorMasterFromGitHubTask(UpdateCurrentDistributorMasterFromGitHubRequest request, AsyncAction<AsyncResult<UpdateCurrentDistributorMasterFromGitHubResult>> userCallback) {
            super((Gs2RestSession)Gs2DistributorRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateCurrentDistributorMasterFromGitHubResult parse(JsonNode data) {
            return UpdateCurrentDistributorMasterFromGitHubResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "distributor").replace("{region}", Gs2DistributorRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/from_git_hub";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("checkoutSetting", UpdateCurrentDistributorMasterFromGitHubTask.this.request.getCheckoutSetting() != null ? UpdateCurrentDistributorMasterFromGitHubTask.this.request.getCheckoutSetting().toJson() : null);
                    this.put("contextStack", UpdateCurrentDistributorMasterFromGitHubTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DistributeTask
    extends Gs2RestSessionTask<DistributeResult> {
        private DistributeRequest request;

        public DistributeTask(DistributeRequest request, AsyncAction<AsyncResult<DistributeResult>> userCallback) {
            super((Gs2RestSession)Gs2DistributorRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DistributeResult parse(JsonNode data) {
            return DistributeResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "distributor").replace("{region}", Gs2DistributorRestClient.this.session.getRegion().getName()) + "/{namespaceName}/distribute/{distributorName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{distributorName}", this.request.getDistributorName() == null || this.request.getDistributorName().length() == 0 ? "null" : String.valueOf(this.request.getDistributorName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("userId", DistributeTask.this.request.getUserId());
                    this.put("distributeResource", DistributeTask.this.request.getDistributeResource() != null ? DistributeTask.this.request.getDistributeResource().toJson() : null);
                    this.put("contextStack", DistributeTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getTimeOffsetToken() != null) {
                this.builder.setHeader("X-GS2-TIME-OFFSET-TOKEN", this.request.getTimeOffsetToken());
            }
            this.builder.build().send();
        }
    }

    class DistributeWithoutOverflowProcessTask
    extends Gs2RestSessionTask<DistributeWithoutOverflowProcessResult> {
        private DistributeWithoutOverflowProcessRequest request;

        public DistributeWithoutOverflowProcessTask(DistributeWithoutOverflowProcessRequest request, AsyncAction<AsyncResult<DistributeWithoutOverflowProcessResult>> userCallback) {
            super((Gs2RestSession)Gs2DistributorRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DistributeWithoutOverflowProcessResult parse(JsonNode data) {
            return DistributeWithoutOverflowProcessResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "distributor").replace("{region}", Gs2DistributorRestClient.this.session.getRegion().getName()) + "/distribute";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("userId", DistributeWithoutOverflowProcessTask.this.request.getUserId());
                    this.put("distributeResource", DistributeWithoutOverflowProcessTask.this.request.getDistributeResource() != null ? DistributeWithoutOverflowProcessTask.this.request.getDistributeResource().toJson() : null);
                    this.put("contextStack", DistributeWithoutOverflowProcessTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getTimeOffsetToken() != null) {
                this.builder.setHeader("X-GS2-TIME-OFFSET-TOKEN", this.request.getTimeOffsetToken());
            }
            this.builder.build().send();
        }
    }

    class RunStampTaskTask
    extends Gs2RestSessionTask<RunStampTaskResult> {
        private RunStampTaskRequest request;

        public RunStampTaskTask(RunStampTaskRequest request, AsyncAction<AsyncResult<RunStampTaskResult>> userCallback) {
            super((Gs2RestSession)Gs2DistributorRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public RunStampTaskResult parse(JsonNode data) {
            return RunStampTaskResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "distributor").replace("{region}", Gs2DistributorRestClient.this.session.getRegion().getName()) + "/{namespaceName}/distribute/stamp/task/run";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stampTask", RunStampTaskTask.this.request.getStampTask());
                    this.put("keyId", RunStampTaskTask.this.request.getKeyId());
                    this.put("contextStack", RunStampTaskTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class RunStampSheetTask
    extends Gs2RestSessionTask<RunStampSheetResult> {
        private RunStampSheetRequest request;

        public RunStampSheetTask(RunStampSheetRequest request, AsyncAction<AsyncResult<RunStampSheetResult>> userCallback) {
            super((Gs2RestSession)Gs2DistributorRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public RunStampSheetResult parse(JsonNode data) {
            return RunStampSheetResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "distributor").replace("{region}", Gs2DistributorRestClient.this.session.getRegion().getName()) + "/{namespaceName}/distribute/stamp/sheet/run";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stampSheet", RunStampSheetTask.this.request.getStampSheet());
                    this.put("keyId", RunStampSheetTask.this.request.getKeyId());
                    this.put("contextStack", RunStampSheetTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class RunStampSheetExpressTask
    extends Gs2RestSessionTask<RunStampSheetExpressResult> {
        private RunStampSheetExpressRequest request;

        public RunStampSheetExpressTask(RunStampSheetExpressRequest request, AsyncAction<AsyncResult<RunStampSheetExpressResult>> userCallback) {
            super((Gs2RestSession)Gs2DistributorRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public RunStampSheetExpressResult parse(JsonNode data) {
            return RunStampSheetExpressResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "distributor").replace("{region}", Gs2DistributorRestClient.this.session.getRegion().getName()) + "/{namespaceName}/distribute/stamp/run";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stampSheet", RunStampSheetExpressTask.this.request.getStampSheet());
                    this.put("keyId", RunStampSheetExpressTask.this.request.getKeyId());
                    this.put("contextStack", RunStampSheetExpressTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class RunStampTaskWithoutNamespaceTask
    extends Gs2RestSessionTask<RunStampTaskWithoutNamespaceResult> {
        private RunStampTaskWithoutNamespaceRequest request;

        public RunStampTaskWithoutNamespaceTask(RunStampTaskWithoutNamespaceRequest request, AsyncAction<AsyncResult<RunStampTaskWithoutNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2DistributorRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public RunStampTaskWithoutNamespaceResult parse(JsonNode data) {
            return RunStampTaskWithoutNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "distributor").replace("{region}", Gs2DistributorRestClient.this.session.getRegion().getName()) + "/stamp/task/run";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stampTask", RunStampTaskWithoutNamespaceTask.this.request.getStampTask());
                    this.put("keyId", RunStampTaskWithoutNamespaceTask.this.request.getKeyId());
                    this.put("contextStack", RunStampTaskWithoutNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class RunStampSheetWithoutNamespaceTask
    extends Gs2RestSessionTask<RunStampSheetWithoutNamespaceResult> {
        private RunStampSheetWithoutNamespaceRequest request;

        public RunStampSheetWithoutNamespaceTask(RunStampSheetWithoutNamespaceRequest request, AsyncAction<AsyncResult<RunStampSheetWithoutNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2DistributorRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public RunStampSheetWithoutNamespaceResult parse(JsonNode data) {
            return RunStampSheetWithoutNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "distributor").replace("{region}", Gs2DistributorRestClient.this.session.getRegion().getName()) + "/stamp/sheet/run";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stampSheet", RunStampSheetWithoutNamespaceTask.this.request.getStampSheet());
                    this.put("keyId", RunStampSheetWithoutNamespaceTask.this.request.getKeyId());
                    this.put("contextStack", RunStampSheetWithoutNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class RunStampSheetExpressWithoutNamespaceTask
    extends Gs2RestSessionTask<RunStampSheetExpressWithoutNamespaceResult> {
        private RunStampSheetExpressWithoutNamespaceRequest request;

        public RunStampSheetExpressWithoutNamespaceTask(RunStampSheetExpressWithoutNamespaceRequest request, AsyncAction<AsyncResult<RunStampSheetExpressWithoutNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2DistributorRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public RunStampSheetExpressWithoutNamespaceResult parse(JsonNode data) {
            return RunStampSheetExpressWithoutNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "distributor").replace("{region}", Gs2DistributorRestClient.this.session.getRegion().getName()) + "/stamp/run";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stampSheet", RunStampSheetExpressWithoutNamespaceTask.this.request.getStampSheet());
                    this.put("keyId", RunStampSheetExpressWithoutNamespaceTask.this.request.getKeyId());
                    this.put("contextStack", RunStampSheetExpressWithoutNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetStampSheetResultTask
    extends Gs2RestSessionTask<GetStampSheetResultResult> {
        private GetStampSheetResultRequest request;

        public GetStampSheetResultTask(GetStampSheetResultRequest request, AsyncAction<AsyncResult<GetStampSheetResultResult>> userCallback) {
            super((Gs2RestSession)Gs2DistributorRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetStampSheetResultResult parse(JsonNode data) {
            return GetStampSheetResultResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "distributor").replace("{region}", Gs2DistributorRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/stampSheet/{transactionId}/result";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{transactionId}", this.request.getTransactionId() == null || this.request.getTransactionId().length() == 0 ? "null" : String.valueOf(this.request.getTransactionId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class GetStampSheetResultByUserIdTask
    extends Gs2RestSessionTask<GetStampSheetResultByUserIdResult> {
        private GetStampSheetResultByUserIdRequest request;

        public GetStampSheetResultByUserIdTask(GetStampSheetResultByUserIdRequest request, AsyncAction<AsyncResult<GetStampSheetResultByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2DistributorRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetStampSheetResultByUserIdResult parse(JsonNode data) {
            return GetStampSheetResultByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "distributor").replace("{region}", Gs2DistributorRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/stampSheet/{transactionId}/result";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{transactionId}", this.request.getTransactionId() == null || this.request.getTransactionId().length() == 0 ? "null" : String.valueOf(this.request.getTransactionId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getTimeOffsetToken() != null) {
                this.builder.setHeader("X-GS2-TIME-OFFSET-TOKEN", this.request.getTimeOffsetToken());
            }
            this.builder.build().send();
        }
    }
}

