/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.account;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.account.request.AddBanRequest;
import io.gs2.account.request.AuthenticationRequest;
import io.gs2.account.request.CheckCleanUserDataByUserIdRequest;
import io.gs2.account.request.CheckDumpUserDataByUserIdRequest;
import io.gs2.account.request.CheckImportUserDataByUserIdRequest;
import io.gs2.account.request.CleanUserDataByUserIdRequest;
import io.gs2.account.request.CreateAccountRequest;
import io.gs2.account.request.CreateNamespaceRequest;
import io.gs2.account.request.CreateTakeOverByUserIdRequest;
import io.gs2.account.request.CreateTakeOverRequest;
import io.gs2.account.request.DeleteAccountRequest;
import io.gs2.account.request.DeleteDataOwnerByUserIdRequest;
import io.gs2.account.request.DeleteNamespaceRequest;
import io.gs2.account.request.DeleteTakeOverByUserIdRequest;
import io.gs2.account.request.DeleteTakeOverByUserIdentifierRequest;
import io.gs2.account.request.DeleteTakeOverRequest;
import io.gs2.account.request.DescribeAccountsRequest;
import io.gs2.account.request.DescribeNamespacesRequest;
import io.gs2.account.request.DescribeTakeOversByUserIdRequest;
import io.gs2.account.request.DescribeTakeOversRequest;
import io.gs2.account.request.DoTakeOverRequest;
import io.gs2.account.request.DumpUserDataByUserIdRequest;
import io.gs2.account.request.GetAccountRequest;
import io.gs2.account.request.GetDataOwnerByUserIdRequest;
import io.gs2.account.request.GetNamespaceRequest;
import io.gs2.account.request.GetNamespaceStatusRequest;
import io.gs2.account.request.GetTakeOverByUserIdRequest;
import io.gs2.account.request.GetTakeOverRequest;
import io.gs2.account.request.ImportUserDataByUserIdRequest;
import io.gs2.account.request.PrepareImportUserDataByUserIdRequest;
import io.gs2.account.request.RemoveBanRequest;
import io.gs2.account.request.UpdateBannedRequest;
import io.gs2.account.request.UpdateNamespaceRequest;
import io.gs2.account.request.UpdateTakeOverByUserIdRequest;
import io.gs2.account.request.UpdateTakeOverRequest;
import io.gs2.account.request.UpdateTimeOffsetRequest;
import io.gs2.account.result.AddBanResult;
import io.gs2.account.result.AuthenticationResult;
import io.gs2.account.result.CheckCleanUserDataByUserIdResult;
import io.gs2.account.result.CheckDumpUserDataByUserIdResult;
import io.gs2.account.result.CheckImportUserDataByUserIdResult;
import io.gs2.account.result.CleanUserDataByUserIdResult;
import io.gs2.account.result.CreateAccountResult;
import io.gs2.account.result.CreateNamespaceResult;
import io.gs2.account.result.CreateTakeOverByUserIdResult;
import io.gs2.account.result.CreateTakeOverResult;
import io.gs2.account.result.DeleteAccountResult;
import io.gs2.account.result.DeleteDataOwnerByUserIdResult;
import io.gs2.account.result.DeleteNamespaceResult;
import io.gs2.account.result.DeleteTakeOverByUserIdResult;
import io.gs2.account.result.DeleteTakeOverByUserIdentifierResult;
import io.gs2.account.result.DeleteTakeOverResult;
import io.gs2.account.result.DescribeAccountsResult;
import io.gs2.account.result.DescribeNamespacesResult;
import io.gs2.account.result.DescribeTakeOversByUserIdResult;
import io.gs2.account.result.DescribeTakeOversResult;
import io.gs2.account.result.DoTakeOverResult;
import io.gs2.account.result.DumpUserDataByUserIdResult;
import io.gs2.account.result.GetAccountResult;
import io.gs2.account.result.GetDataOwnerByUserIdResult;
import io.gs2.account.result.GetNamespaceResult;
import io.gs2.account.result.GetNamespaceStatusResult;
import io.gs2.account.result.GetTakeOverByUserIdResult;
import io.gs2.account.result.GetTakeOverResult;
import io.gs2.account.result.ImportUserDataByUserIdResult;
import io.gs2.account.result.PrepareImportUserDataByUserIdResult;
import io.gs2.account.result.RemoveBanResult;
import io.gs2.account.result.UpdateBannedResult;
import io.gs2.account.result.UpdateNamespaceResult;
import io.gs2.account.result.UpdateTakeOverByUserIdResult;
import io.gs2.account.result.UpdateTakeOverResult;
import io.gs2.account.result.UpdateTimeOffsetResult;
import io.gs2.core.AbstractGs2Client;
import io.gs2.core.model.AsyncAction;
import io.gs2.core.model.AsyncResult;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.core.net.Gs2RestSessionTask;
import io.gs2.core.net.HttpTask;
import io.gs2.core.util.EncodingUtil;
import java.util.ArrayList;
import java.util.HashMap;

public class Gs2AccountRestClient
extends AbstractGs2Client<Gs2AccountRestClient> {
    public Gs2AccountRestClient(Gs2RestSession gs2RestSession) {
        super(gs2RestSession);
    }

    public void describeNamespacesAsync(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> callback) {
        DescribeNamespacesTask task = new DescribeNamespacesTask(request, callback);
        this.session.execute(task);
    }

    public DescribeNamespacesResult describeNamespaces(DescribeNamespacesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeNamespacesAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeNamespacesResult)resultAsyncResult[0].getResult();
    }

    public void createNamespaceAsync(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> callback) {
        CreateNamespaceTask task = new CreateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public CreateNamespaceResult createNamespace(CreateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceStatusAsync(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> callback) {
        GetNamespaceStatusTask task = new GetNamespaceStatusTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceStatusResult getNamespaceStatus(GetNamespaceStatusRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceStatusAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceStatusResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceAsync(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> callback) {
        GetNamespaceTask task = new GetNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceResult getNamespace(GetNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void updateNamespaceAsync(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> callback) {
        UpdateNamespaceTask task = new UpdateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public UpdateNamespaceResult updateNamespace(UpdateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void deleteNamespaceAsync(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> callback) {
        DeleteNamespaceTask task = new DeleteNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public DeleteNamespaceResult deleteNamespace(DeleteNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void dumpUserDataByUserIdAsync(DumpUserDataByUserIdRequest request, AsyncAction<AsyncResult<DumpUserDataByUserIdResult>> callback) {
        DumpUserDataByUserIdTask task = new DumpUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DumpUserDataByUserIdResult dumpUserDataByUserId(DumpUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.dumpUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DumpUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void checkDumpUserDataByUserIdAsync(CheckDumpUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckDumpUserDataByUserIdResult>> callback) {
        CheckDumpUserDataByUserIdTask task = new CheckDumpUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CheckDumpUserDataByUserIdResult checkDumpUserDataByUserId(CheckDumpUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.checkDumpUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CheckDumpUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void cleanUserDataByUserIdAsync(CleanUserDataByUserIdRequest request, AsyncAction<AsyncResult<CleanUserDataByUserIdResult>> callback) {
        CleanUserDataByUserIdTask task = new CleanUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CleanUserDataByUserIdResult cleanUserDataByUserId(CleanUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.cleanUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CleanUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void checkCleanUserDataByUserIdAsync(CheckCleanUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckCleanUserDataByUserIdResult>> callback) {
        CheckCleanUserDataByUserIdTask task = new CheckCleanUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CheckCleanUserDataByUserIdResult checkCleanUserDataByUserId(CheckCleanUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.checkCleanUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CheckCleanUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void prepareImportUserDataByUserIdAsync(PrepareImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<PrepareImportUserDataByUserIdResult>> callback) {
        PrepareImportUserDataByUserIdTask task = new PrepareImportUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public PrepareImportUserDataByUserIdResult prepareImportUserDataByUserId(PrepareImportUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.prepareImportUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (PrepareImportUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void importUserDataByUserIdAsync(ImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<ImportUserDataByUserIdResult>> callback) {
        ImportUserDataByUserIdTask task = new ImportUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public ImportUserDataByUserIdResult importUserDataByUserId(ImportUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.importUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ImportUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void checkImportUserDataByUserIdAsync(CheckImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckImportUserDataByUserIdResult>> callback) {
        CheckImportUserDataByUserIdTask task = new CheckImportUserDataByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CheckImportUserDataByUserIdResult checkImportUserDataByUserId(CheckImportUserDataByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.checkImportUserDataByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CheckImportUserDataByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void describeAccountsAsync(DescribeAccountsRequest request, AsyncAction<AsyncResult<DescribeAccountsResult>> callback) {
        DescribeAccountsTask task = new DescribeAccountsTask(request, callback);
        this.session.execute(task);
    }

    public DescribeAccountsResult describeAccounts(DescribeAccountsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeAccountsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeAccountsResult)resultAsyncResult[0].getResult();
    }

    public void createAccountAsync(CreateAccountRequest request, AsyncAction<AsyncResult<CreateAccountResult>> callback) {
        CreateAccountTask task = new CreateAccountTask(request, callback);
        this.session.execute(task);
    }

    public CreateAccountResult createAccount(CreateAccountRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createAccountAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateAccountResult)resultAsyncResult[0].getResult();
    }

    public void updateTimeOffsetAsync(UpdateTimeOffsetRequest request, AsyncAction<AsyncResult<UpdateTimeOffsetResult>> callback) {
        UpdateTimeOffsetTask task = new UpdateTimeOffsetTask(request, callback);
        this.session.execute(task);
    }

    public UpdateTimeOffsetResult updateTimeOffset(UpdateTimeOffsetRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateTimeOffsetAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateTimeOffsetResult)resultAsyncResult[0].getResult();
    }

    public void updateBannedAsync(UpdateBannedRequest request, AsyncAction<AsyncResult<UpdateBannedResult>> callback) {
        UpdateBannedTask task = new UpdateBannedTask(request, callback);
        this.session.execute(task);
    }

    public UpdateBannedResult updateBanned(UpdateBannedRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateBannedAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateBannedResult)resultAsyncResult[0].getResult();
    }

    public void addBanAsync(AddBanRequest request, AsyncAction<AsyncResult<AddBanResult>> callback) {
        AddBanTask task = new AddBanTask(request, callback);
        this.session.execute(task);
    }

    public AddBanResult addBan(AddBanRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.addBanAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (AddBanResult)resultAsyncResult[0].getResult();
    }

    public void removeBanAsync(RemoveBanRequest request, AsyncAction<AsyncResult<RemoveBanResult>> callback) {
        RemoveBanTask task = new RemoveBanTask(request, callback);
        this.session.execute(task);
    }

    public RemoveBanResult removeBan(RemoveBanRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.removeBanAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (RemoveBanResult)resultAsyncResult[0].getResult();
    }

    public void getAccountAsync(GetAccountRequest request, AsyncAction<AsyncResult<GetAccountResult>> callback) {
        GetAccountTask task = new GetAccountTask(request, callback);
        this.session.execute(task);
    }

    public GetAccountResult getAccount(GetAccountRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getAccountAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetAccountResult)resultAsyncResult[0].getResult();
    }

    public void deleteAccountAsync(DeleteAccountRequest request, AsyncAction<AsyncResult<DeleteAccountResult>> callback) {
        DeleteAccountTask task = new DeleteAccountTask(request, callback);
        this.session.execute(task);
    }

    public DeleteAccountResult deleteAccount(DeleteAccountRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteAccountAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteAccountResult)resultAsyncResult[0].getResult();
    }

    public void authenticationAsync(AuthenticationRequest request, AsyncAction<AsyncResult<AuthenticationResult>> callback) {
        AuthenticationTask task = new AuthenticationTask(request, callback);
        this.session.execute(task);
    }

    public AuthenticationResult authentication(AuthenticationRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.authenticationAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (AuthenticationResult)resultAsyncResult[0].getResult();
    }

    public void describeTakeOversAsync(DescribeTakeOversRequest request, AsyncAction<AsyncResult<DescribeTakeOversResult>> callback) {
        DescribeTakeOversTask task = new DescribeTakeOversTask(request, callback);
        this.session.execute(task);
    }

    public DescribeTakeOversResult describeTakeOvers(DescribeTakeOversRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeTakeOversAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeTakeOversResult)resultAsyncResult[0].getResult();
    }

    public void describeTakeOversByUserIdAsync(DescribeTakeOversByUserIdRequest request, AsyncAction<AsyncResult<DescribeTakeOversByUserIdResult>> callback) {
        DescribeTakeOversByUserIdTask task = new DescribeTakeOversByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DescribeTakeOversByUserIdResult describeTakeOversByUserId(DescribeTakeOversByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeTakeOversByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeTakeOversByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void createTakeOverAsync(CreateTakeOverRequest request, AsyncAction<AsyncResult<CreateTakeOverResult>> callback) {
        CreateTakeOverTask task = new CreateTakeOverTask(request, callback);
        this.session.execute(task);
    }

    public CreateTakeOverResult createTakeOver(CreateTakeOverRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createTakeOverAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateTakeOverResult)resultAsyncResult[0].getResult();
    }

    public void createTakeOverByUserIdAsync(CreateTakeOverByUserIdRequest request, AsyncAction<AsyncResult<CreateTakeOverByUserIdResult>> callback) {
        CreateTakeOverByUserIdTask task = new CreateTakeOverByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CreateTakeOverByUserIdResult createTakeOverByUserId(CreateTakeOverByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createTakeOverByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateTakeOverByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void getTakeOverAsync(GetTakeOverRequest request, AsyncAction<AsyncResult<GetTakeOverResult>> callback) {
        GetTakeOverTask task = new GetTakeOverTask(request, callback);
        this.session.execute(task);
    }

    public GetTakeOverResult getTakeOver(GetTakeOverRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getTakeOverAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetTakeOverResult)resultAsyncResult[0].getResult();
    }

    public void getTakeOverByUserIdAsync(GetTakeOverByUserIdRequest request, AsyncAction<AsyncResult<GetTakeOverByUserIdResult>> callback) {
        GetTakeOverByUserIdTask task = new GetTakeOverByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public GetTakeOverByUserIdResult getTakeOverByUserId(GetTakeOverByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getTakeOverByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetTakeOverByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void updateTakeOverAsync(UpdateTakeOverRequest request, AsyncAction<AsyncResult<UpdateTakeOverResult>> callback) {
        UpdateTakeOverTask task = new UpdateTakeOverTask(request, callback);
        this.session.execute(task);
    }

    public UpdateTakeOverResult updateTakeOver(UpdateTakeOverRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateTakeOverAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateTakeOverResult)resultAsyncResult[0].getResult();
    }

    public void updateTakeOverByUserIdAsync(UpdateTakeOverByUserIdRequest request, AsyncAction<AsyncResult<UpdateTakeOverByUserIdResult>> callback) {
        UpdateTakeOverByUserIdTask task = new UpdateTakeOverByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public UpdateTakeOverByUserIdResult updateTakeOverByUserId(UpdateTakeOverByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateTakeOverByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateTakeOverByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void deleteTakeOverAsync(DeleteTakeOverRequest request, AsyncAction<AsyncResult<DeleteTakeOverResult>> callback) {
        DeleteTakeOverTask task = new DeleteTakeOverTask(request, callback);
        this.session.execute(task);
    }

    public DeleteTakeOverResult deleteTakeOver(DeleteTakeOverRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteTakeOverAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteTakeOverResult)resultAsyncResult[0].getResult();
    }

    public void deleteTakeOverByUserIdentifierAsync(DeleteTakeOverByUserIdentifierRequest request, AsyncAction<AsyncResult<DeleteTakeOverByUserIdentifierResult>> callback) {
        DeleteTakeOverByUserIdentifierTask task = new DeleteTakeOverByUserIdentifierTask(request, callback);
        this.session.execute(task);
    }

    public DeleteTakeOverByUserIdentifierResult deleteTakeOverByUserIdentifier(DeleteTakeOverByUserIdentifierRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteTakeOverByUserIdentifierAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteTakeOverByUserIdentifierResult)resultAsyncResult[0].getResult();
    }

    public void deleteTakeOverByUserIdAsync(DeleteTakeOverByUserIdRequest request, AsyncAction<AsyncResult<DeleteTakeOverByUserIdResult>> callback) {
        DeleteTakeOverByUserIdTask task = new DeleteTakeOverByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DeleteTakeOverByUserIdResult deleteTakeOverByUserId(DeleteTakeOverByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteTakeOverByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteTakeOverByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void doTakeOverAsync(DoTakeOverRequest request, AsyncAction<AsyncResult<DoTakeOverResult>> callback) {
        DoTakeOverTask task = new DoTakeOverTask(request, callback);
        this.session.execute(task);
    }

    public DoTakeOverResult doTakeOver(DoTakeOverRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.doTakeOverAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DoTakeOverResult)resultAsyncResult[0].getResult();
    }

    public void getDataOwnerByUserIdAsync(GetDataOwnerByUserIdRequest request, AsyncAction<AsyncResult<GetDataOwnerByUserIdResult>> callback) {
        GetDataOwnerByUserIdTask task = new GetDataOwnerByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public GetDataOwnerByUserIdResult getDataOwnerByUserId(GetDataOwnerByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getDataOwnerByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetDataOwnerByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void deleteDataOwnerByUserIdAsync(DeleteDataOwnerByUserIdRequest request, AsyncAction<AsyncResult<DeleteDataOwnerByUserIdResult>> callback) {
        DeleteDataOwnerByUserIdTask task = new DeleteDataOwnerByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DeleteDataOwnerByUserIdResult deleteDataOwnerByUserId(DeleteDataOwnerByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteDataOwnerByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteDataOwnerByUserIdResult)resultAsyncResult[0].getResult();
    }

    class DescribeNamespacesTask
    extends Gs2RestSessionTask<DescribeNamespacesResult> {
        private DescribeNamespacesRequest request;

        public DescribeNamespacesTask(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> userCallback) {
            super((Gs2RestSession)Gs2AccountRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeNamespacesResult parse(JsonNode data) {
            return DescribeNamespacesResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "account").replace("{region}", Gs2AccountRestClient.this.session.getRegion().getName()) + "/";
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateNamespaceTask
    extends Gs2RestSessionTask<CreateNamespaceResult> {
        private CreateNamespaceRequest request;

        public CreateNamespaceTask(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2AccountRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateNamespaceResult parse(JsonNode data) {
            return CreateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "account").replace("{region}", Gs2AccountRestClient.this.session.getRegion().getName()) + "/";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateNamespaceTask.this.request.getName());
                    this.put("description", CreateNamespaceTask.this.request.getDescription());
                    this.put("changePasswordIfTakeOver", CreateNamespaceTask.this.request.getChangePasswordIfTakeOver());
                    this.put("differentUserIdForLoginAndDataRetention", CreateNamespaceTask.this.request.getDifferentUserIdForLoginAndDataRetention());
                    this.put("createAccountScript", CreateNamespaceTask.this.request.getCreateAccountScript() != null ? CreateNamespaceTask.this.request.getCreateAccountScript().toJson() : null);
                    this.put("authenticationScript", CreateNamespaceTask.this.request.getAuthenticationScript() != null ? CreateNamespaceTask.this.request.getAuthenticationScript().toJson() : null);
                    this.put("createTakeOverScript", CreateNamespaceTask.this.request.getCreateTakeOverScript() != null ? CreateNamespaceTask.this.request.getCreateTakeOverScript().toJson() : null);
                    this.put("doTakeOverScript", CreateNamespaceTask.this.request.getDoTakeOverScript() != null ? CreateNamespaceTask.this.request.getDoTakeOverScript().toJson() : null);
                    this.put("logSetting", CreateNamespaceTask.this.request.getLogSetting() != null ? CreateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("contextStack", CreateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceStatusTask
    extends Gs2RestSessionTask<GetNamespaceStatusResult> {
        private GetNamespaceStatusRequest request;

        public GetNamespaceStatusTask(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> userCallback) {
            super((Gs2RestSession)Gs2AccountRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceStatusResult parse(JsonNode data) {
            return GetNamespaceStatusResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "account").replace("{region}", Gs2AccountRestClient.this.session.getRegion().getName()) + "/{namespaceName}/status";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceTask
    extends Gs2RestSessionTask<GetNamespaceResult> {
        private GetNamespaceRequest request;

        public GetNamespaceTask(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2AccountRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceResult parse(JsonNode data) {
            return GetNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "account").replace("{region}", Gs2AccountRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateNamespaceTask
    extends Gs2RestSessionTask<UpdateNamespaceResult> {
        private UpdateNamespaceRequest request;

        public UpdateNamespaceTask(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2AccountRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateNamespaceResult parse(JsonNode data) {
            return UpdateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "account").replace("{region}", Gs2AccountRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateNamespaceTask.this.request.getDescription());
                    this.put("changePasswordIfTakeOver", UpdateNamespaceTask.this.request.getChangePasswordIfTakeOver());
                    this.put("createAccountScript", UpdateNamespaceTask.this.request.getCreateAccountScript() != null ? UpdateNamespaceTask.this.request.getCreateAccountScript().toJson() : null);
                    this.put("authenticationScript", UpdateNamespaceTask.this.request.getAuthenticationScript() != null ? UpdateNamespaceTask.this.request.getAuthenticationScript().toJson() : null);
                    this.put("createTakeOverScript", UpdateNamespaceTask.this.request.getCreateTakeOverScript() != null ? UpdateNamespaceTask.this.request.getCreateTakeOverScript().toJson() : null);
                    this.put("doTakeOverScript", UpdateNamespaceTask.this.request.getDoTakeOverScript() != null ? UpdateNamespaceTask.this.request.getDoTakeOverScript().toJson() : null);
                    this.put("logSetting", UpdateNamespaceTask.this.request.getLogSetting() != null ? UpdateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("contextStack", UpdateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteNamespaceTask
    extends Gs2RestSessionTask<DeleteNamespaceResult> {
        private DeleteNamespaceRequest request;

        public DeleteNamespaceTask(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2AccountRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteNamespaceResult parse(JsonNode data) {
            return DeleteNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "account").replace("{region}", Gs2AccountRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DumpUserDataByUserIdTask
    extends Gs2RestSessionTask<DumpUserDataByUserIdResult> {
        private DumpUserDataByUserIdRequest request;

        public DumpUserDataByUserIdTask(DumpUserDataByUserIdRequest request, AsyncAction<AsyncResult<DumpUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2AccountRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DumpUserDataByUserIdResult parse(JsonNode data) {
            return DumpUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "account").replace("{region}", Gs2AccountRestClient.this.session.getRegion().getName()) + "/system/dump/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", DumpUserDataByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            if (this.request.getTimeOffsetToken() != null) {
                this.builder.setHeader("X-GS2-TIME-OFFSET-TOKEN", this.request.getTimeOffsetToken());
            }
            this.builder.build().send();
        }
    }

    class CheckDumpUserDataByUserIdTask
    extends Gs2RestSessionTask<CheckDumpUserDataByUserIdResult> {
        private CheckDumpUserDataByUserIdRequest request;

        public CheckDumpUserDataByUserIdTask(CheckDumpUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckDumpUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2AccountRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CheckDumpUserDataByUserIdResult parse(JsonNode data) {
            return CheckDumpUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "account").replace("{region}", Gs2AccountRestClient.this.session.getRegion().getName()) + "/system/dump/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            if (this.request.getTimeOffsetToken() != null) {
                this.builder.setHeader("X-GS2-TIME-OFFSET-TOKEN", this.request.getTimeOffsetToken());
            }
            this.builder.build().send();
        }
    }

    class CleanUserDataByUserIdTask
    extends Gs2RestSessionTask<CleanUserDataByUserIdResult> {
        private CleanUserDataByUserIdRequest request;

        public CleanUserDataByUserIdTask(CleanUserDataByUserIdRequest request, AsyncAction<AsyncResult<CleanUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2AccountRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CleanUserDataByUserIdResult parse(JsonNode data) {
            return CleanUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "account").replace("{region}", Gs2AccountRestClient.this.session.getRegion().getName()) + "/system/clean/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", CleanUserDataByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            if (this.request.getTimeOffsetToken() != null) {
                this.builder.setHeader("X-GS2-TIME-OFFSET-TOKEN", this.request.getTimeOffsetToken());
            }
            this.builder.build().send();
        }
    }

    class CheckCleanUserDataByUserIdTask
    extends Gs2RestSessionTask<CheckCleanUserDataByUserIdResult> {
        private CheckCleanUserDataByUserIdRequest request;

        public CheckCleanUserDataByUserIdTask(CheckCleanUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckCleanUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2AccountRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CheckCleanUserDataByUserIdResult parse(JsonNode data) {
            return CheckCleanUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "account").replace("{region}", Gs2AccountRestClient.this.session.getRegion().getName()) + "/system/clean/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            if (this.request.getTimeOffsetToken() != null) {
                this.builder.setHeader("X-GS2-TIME-OFFSET-TOKEN", this.request.getTimeOffsetToken());
            }
            this.builder.build().send();
        }
    }

    class PrepareImportUserDataByUserIdTask
    extends Gs2RestSessionTask<PrepareImportUserDataByUserIdResult> {
        private PrepareImportUserDataByUserIdRequest request;

        public PrepareImportUserDataByUserIdTask(PrepareImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<PrepareImportUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2AccountRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public PrepareImportUserDataByUserIdResult parse(JsonNode data) {
            return PrepareImportUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "account").replace("{region}", Gs2AccountRestClient.this.session.getRegion().getName()) + "/system/import/user/{userId}/prepare";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", PrepareImportUserDataByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            if (this.request.getTimeOffsetToken() != null) {
                this.builder.setHeader("X-GS2-TIME-OFFSET-TOKEN", this.request.getTimeOffsetToken());
            }
            this.builder.build().send();
        }
    }

    class ImportUserDataByUserIdTask
    extends Gs2RestSessionTask<ImportUserDataByUserIdResult> {
        private ImportUserDataByUserIdRequest request;

        public ImportUserDataByUserIdTask(ImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<ImportUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2AccountRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ImportUserDataByUserIdResult parse(JsonNode data) {
            return ImportUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "account").replace("{region}", Gs2AccountRestClient.this.session.getRegion().getName()) + "/system/import/user/{userId}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("uploadToken", ImportUserDataByUserIdTask.this.request.getUploadToken());
                    this.put("contextStack", ImportUserDataByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            if (this.request.getTimeOffsetToken() != null) {
                this.builder.setHeader("X-GS2-TIME-OFFSET-TOKEN", this.request.getTimeOffsetToken());
            }
            this.builder.build().send();
        }
    }

    class CheckImportUserDataByUserIdTask
    extends Gs2RestSessionTask<CheckImportUserDataByUserIdResult> {
        private CheckImportUserDataByUserIdRequest request;

        public CheckImportUserDataByUserIdTask(CheckImportUserDataByUserIdRequest request, AsyncAction<AsyncResult<CheckImportUserDataByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2AccountRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CheckImportUserDataByUserIdResult parse(JsonNode data) {
            return CheckImportUserDataByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "account").replace("{region}", Gs2AccountRestClient.this.session.getRegion().getName()) + "/system/import/user/{userId}/{uploadToken}";
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{uploadToken}", this.request.getUploadToken() == null || this.request.getUploadToken().length() == 0 ? "null" : String.valueOf(this.request.getUploadToken()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            if (this.request.getTimeOffsetToken() != null) {
                this.builder.setHeader("X-GS2-TIME-OFFSET-TOKEN", this.request.getTimeOffsetToken());
            }
            this.builder.build().send();
        }
    }

    class DescribeAccountsTask
    extends Gs2RestSessionTask<DescribeAccountsResult> {
        private DescribeAccountsRequest request;

        public DescribeAccountsTask(DescribeAccountsRequest request, AsyncAction<AsyncResult<DescribeAccountsResult>> userCallback) {
            super((Gs2RestSession)Gs2AccountRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeAccountsResult parse(JsonNode data) {
            return DescribeAccountsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "account").replace("{region}", Gs2AccountRestClient.this.session.getRegion().getName()) + "/{namespaceName}/account";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateAccountTask
    extends Gs2RestSessionTask<CreateAccountResult> {
        private CreateAccountRequest request;

        public CreateAccountTask(CreateAccountRequest request, AsyncAction<AsyncResult<CreateAccountResult>> userCallback) {
            super((Gs2RestSession)Gs2AccountRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateAccountResult parse(JsonNode data) {
            return CreateAccountResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "account").replace("{region}", Gs2AccountRestClient.this.session.getRegion().getName()) + "/{namespaceName}/account";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("contextStack", CreateAccountTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateTimeOffsetTask
    extends Gs2RestSessionTask<UpdateTimeOffsetResult> {
        private UpdateTimeOffsetRequest request;

        public UpdateTimeOffsetTask(UpdateTimeOffsetRequest request, AsyncAction<AsyncResult<UpdateTimeOffsetResult>> userCallback) {
            super((Gs2RestSession)Gs2AccountRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateTimeOffsetResult parse(JsonNode data) {
            return UpdateTimeOffsetResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "account").replace("{region}", Gs2AccountRestClient.this.session.getRegion().getName()) + "/{namespaceName}/account/{userId}/time_offset";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("timeOffset", UpdateTimeOffsetTask.this.request.getTimeOffset());
                    this.put("contextStack", UpdateTimeOffsetTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            if (this.request.getTimeOffsetToken() != null) {
                this.builder.setHeader("X-GS2-TIME-OFFSET-TOKEN", this.request.getTimeOffsetToken());
            }
            this.builder.build().send();
        }
    }

    class UpdateBannedTask
    extends Gs2RestSessionTask<UpdateBannedResult> {
        private UpdateBannedRequest request;

        public UpdateBannedTask(UpdateBannedRequest request, AsyncAction<AsyncResult<UpdateBannedResult>> userCallback) {
            super((Gs2RestSession)Gs2AccountRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateBannedResult parse(JsonNode data) {
            return UpdateBannedResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "account").replace("{region}", Gs2AccountRestClient.this.session.getRegion().getName()) + "/{namespaceName}/account/{userId}/banned";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("banned", UpdateBannedTask.this.request.getBanned());
                    this.put("contextStack", UpdateBannedTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            if (this.request.getTimeOffsetToken() != null) {
                this.builder.setHeader("X-GS2-TIME-OFFSET-TOKEN", this.request.getTimeOffsetToken());
            }
            this.builder.build().send();
        }
    }

    class AddBanTask
    extends Gs2RestSessionTask<AddBanResult> {
        private AddBanRequest request;

        public AddBanTask(AddBanRequest request, AsyncAction<AsyncResult<AddBanResult>> userCallback) {
            super((Gs2RestSession)Gs2AccountRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public AddBanResult parse(JsonNode data) {
            return AddBanResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "account").replace("{region}", Gs2AccountRestClient.this.session.getRegion().getName()) + "/{namespaceName}/account/{userId}/ban";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("banStatus", AddBanTask.this.request.getBanStatus() != null ? AddBanTask.this.request.getBanStatus().toJson() : null);
                    this.put("contextStack", AddBanTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            if (this.request.getTimeOffsetToken() != null) {
                this.builder.setHeader("X-GS2-TIME-OFFSET-TOKEN", this.request.getTimeOffsetToken());
            }
            this.builder.build().send();
        }
    }

    class RemoveBanTask
    extends Gs2RestSessionTask<RemoveBanResult> {
        private RemoveBanRequest request;

        public RemoveBanTask(RemoveBanRequest request, AsyncAction<AsyncResult<RemoveBanResult>> userCallback) {
            super((Gs2RestSession)Gs2AccountRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public RemoveBanResult parse(JsonNode data) {
            return RemoveBanResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "account").replace("{region}", Gs2AccountRestClient.this.session.getRegion().getName()) + "/{namespaceName}/account/{userId}/ban/{banStatusName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{banStatusName}", this.request.getBanStatusName() == null || this.request.getBanStatusName().length() == 0 ? "null" : String.valueOf(this.request.getBanStatusName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            if (this.request.getTimeOffsetToken() != null) {
                this.builder.setHeader("X-GS2-TIME-OFFSET-TOKEN", this.request.getTimeOffsetToken());
            }
            this.builder.build().send();
        }
    }

    class GetAccountTask
    extends Gs2RestSessionTask<GetAccountResult> {
        private GetAccountRequest request;

        public GetAccountTask(GetAccountRequest request, AsyncAction<AsyncResult<GetAccountResult>> userCallback) {
            super((Gs2RestSession)Gs2AccountRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetAccountResult parse(JsonNode data) {
            return GetAccountResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "account").replace("{region}", Gs2AccountRestClient.this.session.getRegion().getName()) + "/{namespaceName}/account/{userId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getTimeOffsetToken() != null) {
                this.builder.setHeader("X-GS2-TIME-OFFSET-TOKEN", this.request.getTimeOffsetToken());
            }
            this.builder.build().send();
        }
    }

    class DeleteAccountTask
    extends Gs2RestSessionTask<DeleteAccountResult> {
        private DeleteAccountRequest request;

        public DeleteAccountTask(DeleteAccountRequest request, AsyncAction<AsyncResult<DeleteAccountResult>> userCallback) {
            super((Gs2RestSession)Gs2AccountRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteAccountResult parse(JsonNode data) {
            return DeleteAccountResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "account").replace("{region}", Gs2AccountRestClient.this.session.getRegion().getName()) + "/{namespaceName}/account/{userId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            if (this.request.getTimeOffsetToken() != null) {
                this.builder.setHeader("X-GS2-TIME-OFFSET-TOKEN", this.request.getTimeOffsetToken());
            }
            this.builder.build().send();
        }
    }

    class AuthenticationTask
    extends Gs2RestSessionTask<AuthenticationResult> {
        private AuthenticationRequest request;

        public AuthenticationTask(AuthenticationRequest request, AsyncAction<AsyncResult<AuthenticationResult>> userCallback) {
            super((Gs2RestSession)Gs2AccountRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public AuthenticationResult parse(JsonNode data) {
            return AuthenticationResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "account").replace("{region}", Gs2AccountRestClient.this.session.getRegion().getName()) + "/{namespaceName}/account/{userId}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("keyId", AuthenticationTask.this.request.getKeyId());
                    this.put("password", AuthenticationTask.this.request.getPassword());
                    this.put("contextStack", AuthenticationTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            if (this.request.getTimeOffsetToken() != null) {
                this.builder.setHeader("X-GS2-TIME-OFFSET-TOKEN", this.request.getTimeOffsetToken());
            }
            this.builder.build().send();
        }
    }

    class DescribeTakeOversTask
    extends Gs2RestSessionTask<DescribeTakeOversResult> {
        private DescribeTakeOversRequest request;

        public DescribeTakeOversTask(DescribeTakeOversRequest request, AsyncAction<AsyncResult<DescribeTakeOversResult>> userCallback) {
            super((Gs2RestSession)Gs2AccountRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeTakeOversResult parse(JsonNode data) {
            return DescribeTakeOversResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "account").replace("{region}", Gs2AccountRestClient.this.session.getRegion().getName()) + "/{namespaceName}/account/me/takeover";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class DescribeTakeOversByUserIdTask
    extends Gs2RestSessionTask<DescribeTakeOversByUserIdResult> {
        private DescribeTakeOversByUserIdRequest request;

        public DescribeTakeOversByUserIdTask(DescribeTakeOversByUserIdRequest request, AsyncAction<AsyncResult<DescribeTakeOversByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2AccountRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeTakeOversByUserIdResult parse(JsonNode data) {
            return DescribeTakeOversByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "account").replace("{region}", Gs2AccountRestClient.this.session.getRegion().getName()) + "/{namespaceName}/account/{userId}/takeover";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getTimeOffsetToken() != null) {
                this.builder.setHeader("X-GS2-TIME-OFFSET-TOKEN", this.request.getTimeOffsetToken());
            }
            this.builder.build().send();
        }
    }

    class CreateTakeOverTask
    extends Gs2RestSessionTask<CreateTakeOverResult> {
        private CreateTakeOverRequest request;

        public CreateTakeOverTask(CreateTakeOverRequest request, AsyncAction<AsyncResult<CreateTakeOverResult>> userCallback) {
            super((Gs2RestSession)Gs2AccountRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateTakeOverResult parse(JsonNode data) {
            return CreateTakeOverResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "account").replace("{region}", Gs2AccountRestClient.this.session.getRegion().getName()) + "/{namespaceName}/account/me/takeover";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("type", CreateTakeOverTask.this.request.getType());
                    this.put("userIdentifier", CreateTakeOverTask.this.request.getUserIdentifier());
                    this.put("password", CreateTakeOverTask.this.request.getPassword());
                    this.put("contextStack", CreateTakeOverTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CreateTakeOverByUserIdTask
    extends Gs2RestSessionTask<CreateTakeOverByUserIdResult> {
        private CreateTakeOverByUserIdRequest request;

        public CreateTakeOverByUserIdTask(CreateTakeOverByUserIdRequest request, AsyncAction<AsyncResult<CreateTakeOverByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2AccountRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateTakeOverByUserIdResult parse(JsonNode data) {
            return CreateTakeOverByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "account").replace("{region}", Gs2AccountRestClient.this.session.getRegion().getName()) + "/{namespaceName}/account/{userId}/takeover";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("type", CreateTakeOverByUserIdTask.this.request.getType());
                    this.put("userIdentifier", CreateTakeOverByUserIdTask.this.request.getUserIdentifier());
                    this.put("password", CreateTakeOverByUserIdTask.this.request.getPassword());
                    this.put("contextStack", CreateTakeOverByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            if (this.request.getTimeOffsetToken() != null) {
                this.builder.setHeader("X-GS2-TIME-OFFSET-TOKEN", this.request.getTimeOffsetToken());
            }
            this.builder.build().send();
        }
    }

    class GetTakeOverTask
    extends Gs2RestSessionTask<GetTakeOverResult> {
        private GetTakeOverRequest request;

        public GetTakeOverTask(GetTakeOverRequest request, AsyncAction<AsyncResult<GetTakeOverResult>> userCallback) {
            super((Gs2RestSession)Gs2AccountRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetTakeOverResult parse(JsonNode data) {
            return GetTakeOverResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "account").replace("{region}", Gs2AccountRestClient.this.session.getRegion().getName()) + "/{namespaceName}/account/me/takeover/type/{type}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{type}", this.request.getType() == null ? "null" : String.valueOf(this.request.getType()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class GetTakeOverByUserIdTask
    extends Gs2RestSessionTask<GetTakeOverByUserIdResult> {
        private GetTakeOverByUserIdRequest request;

        public GetTakeOverByUserIdTask(GetTakeOverByUserIdRequest request, AsyncAction<AsyncResult<GetTakeOverByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2AccountRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetTakeOverByUserIdResult parse(JsonNode data) {
            return GetTakeOverByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "account").replace("{region}", Gs2AccountRestClient.this.session.getRegion().getName()) + "/{namespaceName}/account/{userId}/takeover/type/{type}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{type}", this.request.getType() == null ? "null" : String.valueOf(this.request.getType()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getTimeOffsetToken() != null) {
                this.builder.setHeader("X-GS2-TIME-OFFSET-TOKEN", this.request.getTimeOffsetToken());
            }
            this.builder.build().send();
        }
    }

    class UpdateTakeOverTask
    extends Gs2RestSessionTask<UpdateTakeOverResult> {
        private UpdateTakeOverRequest request;

        public UpdateTakeOverTask(UpdateTakeOverRequest request, AsyncAction<AsyncResult<UpdateTakeOverResult>> userCallback) {
            super((Gs2RestSession)Gs2AccountRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateTakeOverResult parse(JsonNode data) {
            return UpdateTakeOverResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "account").replace("{region}", Gs2AccountRestClient.this.session.getRegion().getName()) + "/{namespaceName}/account/me/takeover/type/{type}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{type}", this.request.getType() == null ? "null" : String.valueOf(this.request.getType()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("oldPassword", UpdateTakeOverTask.this.request.getOldPassword());
                    this.put("password", UpdateTakeOverTask.this.request.getPassword());
                    this.put("contextStack", UpdateTakeOverTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class UpdateTakeOverByUserIdTask
    extends Gs2RestSessionTask<UpdateTakeOverByUserIdResult> {
        private UpdateTakeOverByUserIdRequest request;

        public UpdateTakeOverByUserIdTask(UpdateTakeOverByUserIdRequest request, AsyncAction<AsyncResult<UpdateTakeOverByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2AccountRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateTakeOverByUserIdResult parse(JsonNode data) {
            return UpdateTakeOverByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "account").replace("{region}", Gs2AccountRestClient.this.session.getRegion().getName()) + "/{namespaceName}/account/{userId}/takeover/type/{type}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{type}", this.request.getType() == null ? "null" : String.valueOf(this.request.getType()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("oldPassword", UpdateTakeOverByUserIdTask.this.request.getOldPassword());
                    this.put("password", UpdateTakeOverByUserIdTask.this.request.getPassword());
                    this.put("contextStack", UpdateTakeOverByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            if (this.request.getTimeOffsetToken() != null) {
                this.builder.setHeader("X-GS2-TIME-OFFSET-TOKEN", this.request.getTimeOffsetToken());
            }
            this.builder.build().send();
        }
    }

    class DeleteTakeOverTask
    extends Gs2RestSessionTask<DeleteTakeOverResult> {
        private DeleteTakeOverRequest request;

        public DeleteTakeOverTask(DeleteTakeOverRequest request, AsyncAction<AsyncResult<DeleteTakeOverResult>> userCallback) {
            super((Gs2RestSession)Gs2AccountRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteTakeOverResult parse(JsonNode data) {
            return DeleteTakeOverResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "account").replace("{region}", Gs2AccountRestClient.this.session.getRegion().getName()) + "/{namespaceName}/account/me/takeover/type/{type}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{type}", this.request.getType() == null ? "null" : String.valueOf(this.request.getType()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getUserIdentifier() != null) {
                queryStrings.add("userIdentifier=" + EncodingUtil.urlEncode(String.valueOf(this.request.getUserIdentifier())));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DeleteTakeOverByUserIdentifierTask
    extends Gs2RestSessionTask<DeleteTakeOverByUserIdentifierResult> {
        private DeleteTakeOverByUserIdentifierRequest request;

        public DeleteTakeOverByUserIdentifierTask(DeleteTakeOverByUserIdentifierRequest request, AsyncAction<AsyncResult<DeleteTakeOverByUserIdentifierResult>> userCallback) {
            super((Gs2RestSession)Gs2AccountRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteTakeOverByUserIdentifierResult parse(JsonNode data) {
            return DeleteTakeOverByUserIdentifierResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "account").replace("{region}", Gs2AccountRestClient.this.session.getRegion().getName()) + "/{namespaceName}/takeover/type/{type}/userIdentifier/{userIdentifier}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{type}", this.request.getType() == null ? "null" : String.valueOf(this.request.getType()));
            url = url.replace("{userIdentifier}", this.request.getUserIdentifier() == null || this.request.getUserIdentifier().length() == 0 ? "null" : String.valueOf(this.request.getUserIdentifier()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DeleteTakeOverByUserIdTask
    extends Gs2RestSessionTask<DeleteTakeOverByUserIdResult> {
        private DeleteTakeOverByUserIdRequest request;

        public DeleteTakeOverByUserIdTask(DeleteTakeOverByUserIdRequest request, AsyncAction<AsyncResult<DeleteTakeOverByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2AccountRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteTakeOverByUserIdResult parse(JsonNode data) {
            return DeleteTakeOverByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "account").replace("{region}", Gs2AccountRestClient.this.session.getRegion().getName()) + "/{namespaceName}/account/{userId}/takeover/type/{type}/takeover";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{type}", this.request.getType() == null ? "null" : String.valueOf(this.request.getType()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            if (this.request.getTimeOffsetToken() != null) {
                this.builder.setHeader("X-GS2-TIME-OFFSET-TOKEN", this.request.getTimeOffsetToken());
            }
            this.builder.build().send();
        }
    }

    class DoTakeOverTask
    extends Gs2RestSessionTask<DoTakeOverResult> {
        private DoTakeOverRequest request;

        public DoTakeOverTask(DoTakeOverRequest request, AsyncAction<AsyncResult<DoTakeOverResult>> userCallback) {
            super((Gs2RestSession)Gs2AccountRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DoTakeOverResult parse(JsonNode data) {
            return DoTakeOverResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "account").replace("{region}", Gs2AccountRestClient.this.session.getRegion().getName()) + "/{namespaceName}/takeover/type/{type}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{type}", this.request.getType() == null ? "null" : String.valueOf(this.request.getType()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("userIdentifier", DoTakeOverTask.this.request.getUserIdentifier());
                    this.put("password", DoTakeOverTask.this.request.getPassword());
                    this.put("contextStack", DoTakeOverTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetDataOwnerByUserIdTask
    extends Gs2RestSessionTask<GetDataOwnerByUserIdResult> {
        private GetDataOwnerByUserIdRequest request;

        public GetDataOwnerByUserIdTask(GetDataOwnerByUserIdRequest request, AsyncAction<AsyncResult<GetDataOwnerByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2AccountRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetDataOwnerByUserIdResult parse(JsonNode data) {
            return GetDataOwnerByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "account").replace("{region}", Gs2AccountRestClient.this.session.getRegion().getName()) + "/{namespaceName}/account/{userId}/dataOwner";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getTimeOffsetToken() != null) {
                this.builder.setHeader("X-GS2-TIME-OFFSET-TOKEN", this.request.getTimeOffsetToken());
            }
            this.builder.build().send();
        }
    }

    class DeleteDataOwnerByUserIdTask
    extends Gs2RestSessionTask<DeleteDataOwnerByUserIdResult> {
        private DeleteDataOwnerByUserIdRequest request;

        public DeleteDataOwnerByUserIdTask(DeleteDataOwnerByUserIdRequest request, AsyncAction<AsyncResult<DeleteDataOwnerByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2AccountRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteDataOwnerByUserIdResult parse(JsonNode data) {
            return DeleteDataOwnerByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "account").replace("{region}", Gs2AccountRestClient.this.session.getRegion().getName()) + "/{namespaceName}/account/{userId}/dataOwner";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            if (this.request.getTimeOffsetToken() != null) {
                this.builder.setHeader("X-GS2-TIME-OFFSET-TOKEN", this.request.getTimeOffsetToken());
            }
            this.builder.build().send();
        }
    }
}

