/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.quest;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.AbstractGs2Client;
import io.gs2.core.model.AsyncAction;
import io.gs2.core.model.AsyncResult;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.core.net.Gs2RestSessionTask;
import io.gs2.core.net.HttpTask;
import io.gs2.core.util.EncodingUtil;
import io.gs2.quest.request.CreateNamespaceRequest;
import io.gs2.quest.request.CreateProgressByStampSheetRequest;
import io.gs2.quest.request.CreateProgressByUserIdRequest;
import io.gs2.quest.request.CreateQuestGroupModelMasterRequest;
import io.gs2.quest.request.CreateQuestModelMasterRequest;
import io.gs2.quest.request.DeleteCompletedQuestListByUserIdRequest;
import io.gs2.quest.request.DeleteNamespaceRequest;
import io.gs2.quest.request.DeleteProgressByStampTaskRequest;
import io.gs2.quest.request.DeleteProgressByUserIdRequest;
import io.gs2.quest.request.DeleteProgressRequest;
import io.gs2.quest.request.DeleteQuestGroupModelMasterRequest;
import io.gs2.quest.request.DeleteQuestModelMasterRequest;
import io.gs2.quest.request.DescribeCompletedQuestListsByUserIdRequest;
import io.gs2.quest.request.DescribeCompletedQuestListsRequest;
import io.gs2.quest.request.DescribeNamespacesRequest;
import io.gs2.quest.request.DescribeProgressesByUserIdRequest;
import io.gs2.quest.request.DescribeQuestGroupModelMastersRequest;
import io.gs2.quest.request.DescribeQuestGroupModelsRequest;
import io.gs2.quest.request.DescribeQuestModelMastersRequest;
import io.gs2.quest.request.DescribeQuestModelsRequest;
import io.gs2.quest.request.EndByUserIdRequest;
import io.gs2.quest.request.EndRequest;
import io.gs2.quest.request.ExportMasterRequest;
import io.gs2.quest.request.GetCompletedQuestListByUserIdRequest;
import io.gs2.quest.request.GetCompletedQuestListRequest;
import io.gs2.quest.request.GetCurrentQuestMasterRequest;
import io.gs2.quest.request.GetNamespaceRequest;
import io.gs2.quest.request.GetNamespaceStatusRequest;
import io.gs2.quest.request.GetProgressByUserIdRequest;
import io.gs2.quest.request.GetProgressRequest;
import io.gs2.quest.request.GetQuestGroupModelMasterRequest;
import io.gs2.quest.request.GetQuestGroupModelRequest;
import io.gs2.quest.request.GetQuestModelMasterRequest;
import io.gs2.quest.request.GetQuestModelRequest;
import io.gs2.quest.request.StartByUserIdRequest;
import io.gs2.quest.request.StartRequest;
import io.gs2.quest.request.UpdateCurrentQuestMasterFromGitHubRequest;
import io.gs2.quest.request.UpdateCurrentQuestMasterRequest;
import io.gs2.quest.request.UpdateNamespaceRequest;
import io.gs2.quest.request.UpdateQuestGroupModelMasterRequest;
import io.gs2.quest.request.UpdateQuestModelMasterRequest;
import io.gs2.quest.result.CreateNamespaceResult;
import io.gs2.quest.result.CreateProgressByStampSheetResult;
import io.gs2.quest.result.CreateProgressByUserIdResult;
import io.gs2.quest.result.CreateQuestGroupModelMasterResult;
import io.gs2.quest.result.CreateQuestModelMasterResult;
import io.gs2.quest.result.DeleteCompletedQuestListByUserIdResult;
import io.gs2.quest.result.DeleteNamespaceResult;
import io.gs2.quest.result.DeleteProgressByStampTaskResult;
import io.gs2.quest.result.DeleteProgressByUserIdResult;
import io.gs2.quest.result.DeleteProgressResult;
import io.gs2.quest.result.DeleteQuestGroupModelMasterResult;
import io.gs2.quest.result.DeleteQuestModelMasterResult;
import io.gs2.quest.result.DescribeCompletedQuestListsByUserIdResult;
import io.gs2.quest.result.DescribeCompletedQuestListsResult;
import io.gs2.quest.result.DescribeNamespacesResult;
import io.gs2.quest.result.DescribeProgressesByUserIdResult;
import io.gs2.quest.result.DescribeQuestGroupModelMastersResult;
import io.gs2.quest.result.DescribeQuestGroupModelsResult;
import io.gs2.quest.result.DescribeQuestModelMastersResult;
import io.gs2.quest.result.DescribeQuestModelsResult;
import io.gs2.quest.result.EndByUserIdResult;
import io.gs2.quest.result.EndResult;
import io.gs2.quest.result.ExportMasterResult;
import io.gs2.quest.result.GetCompletedQuestListByUserIdResult;
import io.gs2.quest.result.GetCompletedQuestListResult;
import io.gs2.quest.result.GetCurrentQuestMasterResult;
import io.gs2.quest.result.GetNamespaceResult;
import io.gs2.quest.result.GetNamespaceStatusResult;
import io.gs2.quest.result.GetProgressByUserIdResult;
import io.gs2.quest.result.GetProgressResult;
import io.gs2.quest.result.GetQuestGroupModelMasterResult;
import io.gs2.quest.result.GetQuestGroupModelResult;
import io.gs2.quest.result.GetQuestModelMasterResult;
import io.gs2.quest.result.GetQuestModelResult;
import io.gs2.quest.result.StartByUserIdResult;
import io.gs2.quest.result.StartResult;
import io.gs2.quest.result.UpdateCurrentQuestMasterFromGitHubResult;
import io.gs2.quest.result.UpdateCurrentQuestMasterResult;
import io.gs2.quest.result.UpdateNamespaceResult;
import io.gs2.quest.result.UpdateQuestGroupModelMasterResult;
import io.gs2.quest.result.UpdateQuestModelMasterResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.stream.Collectors;

public class Gs2QuestRestClient
extends AbstractGs2Client<Gs2QuestRestClient> {
    public Gs2QuestRestClient(Gs2RestSession gs2RestSession) {
        super(gs2RestSession);
    }

    public void describeNamespacesAsync(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> callback) {
        DescribeNamespacesTask task = new DescribeNamespacesTask(request, callback);
        this.session.execute(task);
    }

    public DescribeNamespacesResult describeNamespaces(DescribeNamespacesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeNamespacesAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeNamespacesResult)resultAsyncResult[0].getResult();
    }

    public void createNamespaceAsync(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> callback) {
        CreateNamespaceTask task = new CreateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public CreateNamespaceResult createNamespace(CreateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceStatusAsync(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> callback) {
        GetNamespaceStatusTask task = new GetNamespaceStatusTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceStatusResult getNamespaceStatus(GetNamespaceStatusRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceStatusAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceStatusResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceAsync(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> callback) {
        GetNamespaceTask task = new GetNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceResult getNamespace(GetNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void updateNamespaceAsync(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> callback) {
        UpdateNamespaceTask task = new UpdateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public UpdateNamespaceResult updateNamespace(UpdateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void deleteNamespaceAsync(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> callback) {
        DeleteNamespaceTask task = new DeleteNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public DeleteNamespaceResult deleteNamespace(DeleteNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void describeQuestGroupModelMastersAsync(DescribeQuestGroupModelMastersRequest request, AsyncAction<AsyncResult<DescribeQuestGroupModelMastersResult>> callback) {
        DescribeQuestGroupModelMastersTask task = new DescribeQuestGroupModelMastersTask(request, callback);
        this.session.execute(task);
    }

    public DescribeQuestGroupModelMastersResult describeQuestGroupModelMasters(DescribeQuestGroupModelMastersRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeQuestGroupModelMastersAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeQuestGroupModelMastersResult)resultAsyncResult[0].getResult();
    }

    public void createQuestGroupModelMasterAsync(CreateQuestGroupModelMasterRequest request, AsyncAction<AsyncResult<CreateQuestGroupModelMasterResult>> callback) {
        CreateQuestGroupModelMasterTask task = new CreateQuestGroupModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public CreateQuestGroupModelMasterResult createQuestGroupModelMaster(CreateQuestGroupModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createQuestGroupModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateQuestGroupModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void getQuestGroupModelMasterAsync(GetQuestGroupModelMasterRequest request, AsyncAction<AsyncResult<GetQuestGroupModelMasterResult>> callback) {
        GetQuestGroupModelMasterTask task = new GetQuestGroupModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public GetQuestGroupModelMasterResult getQuestGroupModelMaster(GetQuestGroupModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getQuestGroupModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetQuestGroupModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateQuestGroupModelMasterAsync(UpdateQuestGroupModelMasterRequest request, AsyncAction<AsyncResult<UpdateQuestGroupModelMasterResult>> callback) {
        UpdateQuestGroupModelMasterTask task = new UpdateQuestGroupModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public UpdateQuestGroupModelMasterResult updateQuestGroupModelMaster(UpdateQuestGroupModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateQuestGroupModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateQuestGroupModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void deleteQuestGroupModelMasterAsync(DeleteQuestGroupModelMasterRequest request, AsyncAction<AsyncResult<DeleteQuestGroupModelMasterResult>> callback) {
        DeleteQuestGroupModelMasterTask task = new DeleteQuestGroupModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public DeleteQuestGroupModelMasterResult deleteQuestGroupModelMaster(DeleteQuestGroupModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteQuestGroupModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteQuestGroupModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void describeQuestModelMastersAsync(DescribeQuestModelMastersRequest request, AsyncAction<AsyncResult<DescribeQuestModelMastersResult>> callback) {
        DescribeQuestModelMastersTask task = new DescribeQuestModelMastersTask(request, callback);
        this.session.execute(task);
    }

    public DescribeQuestModelMastersResult describeQuestModelMasters(DescribeQuestModelMastersRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeQuestModelMastersAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeQuestModelMastersResult)resultAsyncResult[0].getResult();
    }

    public void createQuestModelMasterAsync(CreateQuestModelMasterRequest request, AsyncAction<AsyncResult<CreateQuestModelMasterResult>> callback) {
        CreateQuestModelMasterTask task = new CreateQuestModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public CreateQuestModelMasterResult createQuestModelMaster(CreateQuestModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createQuestModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateQuestModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void getQuestModelMasterAsync(GetQuestModelMasterRequest request, AsyncAction<AsyncResult<GetQuestModelMasterResult>> callback) {
        GetQuestModelMasterTask task = new GetQuestModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public GetQuestModelMasterResult getQuestModelMaster(GetQuestModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getQuestModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetQuestModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateQuestModelMasterAsync(UpdateQuestModelMasterRequest request, AsyncAction<AsyncResult<UpdateQuestModelMasterResult>> callback) {
        UpdateQuestModelMasterTask task = new UpdateQuestModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public UpdateQuestModelMasterResult updateQuestModelMaster(UpdateQuestModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateQuestModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateQuestModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void deleteQuestModelMasterAsync(DeleteQuestModelMasterRequest request, AsyncAction<AsyncResult<DeleteQuestModelMasterResult>> callback) {
        DeleteQuestModelMasterTask task = new DeleteQuestModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public DeleteQuestModelMasterResult deleteQuestModelMaster(DeleteQuestModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteQuestModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteQuestModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void exportMasterAsync(ExportMasterRequest request, AsyncAction<AsyncResult<ExportMasterResult>> callback) {
        ExportMasterTask task = new ExportMasterTask(request, callback);
        this.session.execute(task);
    }

    public ExportMasterResult exportMaster(ExportMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.exportMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ExportMasterResult)resultAsyncResult[0].getResult();
    }

    public void getCurrentQuestMasterAsync(GetCurrentQuestMasterRequest request, AsyncAction<AsyncResult<GetCurrentQuestMasterResult>> callback) {
        GetCurrentQuestMasterTask task = new GetCurrentQuestMasterTask(request, callback);
        this.session.execute(task);
    }

    public GetCurrentQuestMasterResult getCurrentQuestMaster(GetCurrentQuestMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getCurrentQuestMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetCurrentQuestMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateCurrentQuestMasterAsync(UpdateCurrentQuestMasterRequest request, AsyncAction<AsyncResult<UpdateCurrentQuestMasterResult>> callback) {
        UpdateCurrentQuestMasterTask task = new UpdateCurrentQuestMasterTask(request, callback);
        this.session.execute(task);
    }

    public UpdateCurrentQuestMasterResult updateCurrentQuestMaster(UpdateCurrentQuestMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateCurrentQuestMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateCurrentQuestMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateCurrentQuestMasterFromGitHubAsync(UpdateCurrentQuestMasterFromGitHubRequest request, AsyncAction<AsyncResult<UpdateCurrentQuestMasterFromGitHubResult>> callback) {
        UpdateCurrentQuestMasterFromGitHubTask task = new UpdateCurrentQuestMasterFromGitHubTask(request, callback);
        this.session.execute(task);
    }

    public UpdateCurrentQuestMasterFromGitHubResult updateCurrentQuestMasterFromGitHub(UpdateCurrentQuestMasterFromGitHubRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateCurrentQuestMasterFromGitHubAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateCurrentQuestMasterFromGitHubResult)resultAsyncResult[0].getResult();
    }

    public void describeProgressesByUserIdAsync(DescribeProgressesByUserIdRequest request, AsyncAction<AsyncResult<DescribeProgressesByUserIdResult>> callback) {
        DescribeProgressesByUserIdTask task = new DescribeProgressesByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DescribeProgressesByUserIdResult describeProgressesByUserId(DescribeProgressesByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeProgressesByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeProgressesByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void createProgressByUserIdAsync(CreateProgressByUserIdRequest request, AsyncAction<AsyncResult<CreateProgressByUserIdResult>> callback) {
        CreateProgressByUserIdTask task = new CreateProgressByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CreateProgressByUserIdResult createProgressByUserId(CreateProgressByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createProgressByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateProgressByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void getProgressAsync(GetProgressRequest request, AsyncAction<AsyncResult<GetProgressResult>> callback) {
        GetProgressTask task = new GetProgressTask(request, callback);
        this.session.execute(task);
    }

    public GetProgressResult getProgress(GetProgressRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getProgressAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetProgressResult)resultAsyncResult[0].getResult();
    }

    public void getProgressByUserIdAsync(GetProgressByUserIdRequest request, AsyncAction<AsyncResult<GetProgressByUserIdResult>> callback) {
        GetProgressByUserIdTask task = new GetProgressByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public GetProgressByUserIdResult getProgressByUserId(GetProgressByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getProgressByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetProgressByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void startAsync(StartRequest request, AsyncAction<AsyncResult<StartResult>> callback) {
        StartTask task = new StartTask(request, callback);
        this.session.execute(task);
    }

    public StartResult start(StartRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.startAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (StartResult)resultAsyncResult[0].getResult();
    }

    public void startByUserIdAsync(StartByUserIdRequest request, AsyncAction<AsyncResult<StartByUserIdResult>> callback) {
        StartByUserIdTask task = new StartByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public StartByUserIdResult startByUserId(StartByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.startByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (StartByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void endAsync(EndRequest request, AsyncAction<AsyncResult<EndResult>> callback) {
        EndTask task = new EndTask(request, callback);
        this.session.execute(task);
    }

    public EndResult end(EndRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.endAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (EndResult)resultAsyncResult[0].getResult();
    }

    public void endByUserIdAsync(EndByUserIdRequest request, AsyncAction<AsyncResult<EndByUserIdResult>> callback) {
        EndByUserIdTask task = new EndByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public EndByUserIdResult endByUserId(EndByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.endByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (EndByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void deleteProgressAsync(DeleteProgressRequest request, AsyncAction<AsyncResult<DeleteProgressResult>> callback) {
        DeleteProgressTask task = new DeleteProgressTask(request, callback);
        this.session.execute(task);
    }

    public DeleteProgressResult deleteProgress(DeleteProgressRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteProgressAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteProgressResult)resultAsyncResult[0].getResult();
    }

    public void deleteProgressByUserIdAsync(DeleteProgressByUserIdRequest request, AsyncAction<AsyncResult<DeleteProgressByUserIdResult>> callback) {
        DeleteProgressByUserIdTask task = new DeleteProgressByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DeleteProgressByUserIdResult deleteProgressByUserId(DeleteProgressByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteProgressByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteProgressByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void createProgressByStampSheetAsync(CreateProgressByStampSheetRequest request, AsyncAction<AsyncResult<CreateProgressByStampSheetResult>> callback) {
        CreateProgressByStampSheetTask task = new CreateProgressByStampSheetTask(request, callback);
        this.session.execute(task);
    }

    public CreateProgressByStampSheetResult createProgressByStampSheet(CreateProgressByStampSheetRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createProgressByStampSheetAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateProgressByStampSheetResult)resultAsyncResult[0].getResult();
    }

    public void deleteProgressByStampTaskAsync(DeleteProgressByStampTaskRequest request, AsyncAction<AsyncResult<DeleteProgressByStampTaskResult>> callback) {
        DeleteProgressByStampTaskTask task = new DeleteProgressByStampTaskTask(request, callback);
        this.session.execute(task);
    }

    public DeleteProgressByStampTaskResult deleteProgressByStampTask(DeleteProgressByStampTaskRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteProgressByStampTaskAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteProgressByStampTaskResult)resultAsyncResult[0].getResult();
    }

    public void describeCompletedQuestListsAsync(DescribeCompletedQuestListsRequest request, AsyncAction<AsyncResult<DescribeCompletedQuestListsResult>> callback) {
        DescribeCompletedQuestListsTask task = new DescribeCompletedQuestListsTask(request, callback);
        this.session.execute(task);
    }

    public DescribeCompletedQuestListsResult describeCompletedQuestLists(DescribeCompletedQuestListsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeCompletedQuestListsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeCompletedQuestListsResult)resultAsyncResult[0].getResult();
    }

    public void describeCompletedQuestListsByUserIdAsync(DescribeCompletedQuestListsByUserIdRequest request, AsyncAction<AsyncResult<DescribeCompletedQuestListsByUserIdResult>> callback) {
        DescribeCompletedQuestListsByUserIdTask task = new DescribeCompletedQuestListsByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DescribeCompletedQuestListsByUserIdResult describeCompletedQuestListsByUserId(DescribeCompletedQuestListsByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeCompletedQuestListsByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeCompletedQuestListsByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void getCompletedQuestListAsync(GetCompletedQuestListRequest request, AsyncAction<AsyncResult<GetCompletedQuestListResult>> callback) {
        GetCompletedQuestListTask task = new GetCompletedQuestListTask(request, callback);
        this.session.execute(task);
    }

    public GetCompletedQuestListResult getCompletedQuestList(GetCompletedQuestListRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getCompletedQuestListAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetCompletedQuestListResult)resultAsyncResult[0].getResult();
    }

    public void getCompletedQuestListByUserIdAsync(GetCompletedQuestListByUserIdRequest request, AsyncAction<AsyncResult<GetCompletedQuestListByUserIdResult>> callback) {
        GetCompletedQuestListByUserIdTask task = new GetCompletedQuestListByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public GetCompletedQuestListByUserIdResult getCompletedQuestListByUserId(GetCompletedQuestListByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getCompletedQuestListByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetCompletedQuestListByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void deleteCompletedQuestListByUserIdAsync(DeleteCompletedQuestListByUserIdRequest request, AsyncAction<AsyncResult<DeleteCompletedQuestListByUserIdResult>> callback) {
        DeleteCompletedQuestListByUserIdTask task = new DeleteCompletedQuestListByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DeleteCompletedQuestListByUserIdResult deleteCompletedQuestListByUserId(DeleteCompletedQuestListByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteCompletedQuestListByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteCompletedQuestListByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void describeQuestGroupModelsAsync(DescribeQuestGroupModelsRequest request, AsyncAction<AsyncResult<DescribeQuestGroupModelsResult>> callback) {
        DescribeQuestGroupModelsTask task = new DescribeQuestGroupModelsTask(request, callback);
        this.session.execute(task);
    }

    public DescribeQuestGroupModelsResult describeQuestGroupModels(DescribeQuestGroupModelsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeQuestGroupModelsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeQuestGroupModelsResult)resultAsyncResult[0].getResult();
    }

    public void getQuestGroupModelAsync(GetQuestGroupModelRequest request, AsyncAction<AsyncResult<GetQuestGroupModelResult>> callback) {
        GetQuestGroupModelTask task = new GetQuestGroupModelTask(request, callback);
        this.session.execute(task);
    }

    public GetQuestGroupModelResult getQuestGroupModel(GetQuestGroupModelRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getQuestGroupModelAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetQuestGroupModelResult)resultAsyncResult[0].getResult();
    }

    public void describeQuestModelsAsync(DescribeQuestModelsRequest request, AsyncAction<AsyncResult<DescribeQuestModelsResult>> callback) {
        DescribeQuestModelsTask task = new DescribeQuestModelsTask(request, callback);
        this.session.execute(task);
    }

    public DescribeQuestModelsResult describeQuestModels(DescribeQuestModelsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeQuestModelsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeQuestModelsResult)resultAsyncResult[0].getResult();
    }

    public void getQuestModelAsync(GetQuestModelRequest request, AsyncAction<AsyncResult<GetQuestModelResult>> callback) {
        GetQuestModelTask task = new GetQuestModelTask(request, callback);
        this.session.execute(task);
    }

    public GetQuestModelResult getQuestModel(GetQuestModelRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getQuestModelAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetQuestModelResult)resultAsyncResult[0].getResult();
    }

    class DescribeNamespacesTask
    extends Gs2RestSessionTask<DescribeNamespacesResult> {
        private DescribeNamespacesRequest request;

        public DescribeNamespacesTask(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> userCallback) {
            super((Gs2RestSession)Gs2QuestRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeNamespacesResult parse(JsonNode data) {
            return DescribeNamespacesResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "quest").replace("{region}", Gs2QuestRestClient.this.session.getRegion().getName()) + "/";
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateNamespaceTask
    extends Gs2RestSessionTask<CreateNamespaceResult> {
        private CreateNamespaceRequest request;

        public CreateNamespaceTask(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2QuestRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateNamespaceResult parse(JsonNode data) {
            return CreateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "quest").replace("{region}", Gs2QuestRestClient.this.session.getRegion().getName()) + "/";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateNamespaceTask.this.request.getName());
                    this.put("description", CreateNamespaceTask.this.request.getDescription());
                    this.put("transactionSetting", CreateNamespaceTask.this.request.getTransactionSetting() != null ? CreateNamespaceTask.this.request.getTransactionSetting().toJson() : null);
                    this.put("startQuestScript", CreateNamespaceTask.this.request.getStartQuestScript() != null ? CreateNamespaceTask.this.request.getStartQuestScript().toJson() : null);
                    this.put("completeQuestScript", CreateNamespaceTask.this.request.getCompleteQuestScript() != null ? CreateNamespaceTask.this.request.getCompleteQuestScript().toJson() : null);
                    this.put("failedQuestScript", CreateNamespaceTask.this.request.getFailedQuestScript() != null ? CreateNamespaceTask.this.request.getFailedQuestScript().toJson() : null);
                    this.put("logSetting", CreateNamespaceTask.this.request.getLogSetting() != null ? CreateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("queueNamespaceId", CreateNamespaceTask.this.request.getQueueNamespaceId());
                    this.put("keyId", CreateNamespaceTask.this.request.getKeyId());
                    this.put("contextStack", CreateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceStatusTask
    extends Gs2RestSessionTask<GetNamespaceStatusResult> {
        private GetNamespaceStatusRequest request;

        public GetNamespaceStatusTask(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> userCallback) {
            super((Gs2RestSession)Gs2QuestRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceStatusResult parse(JsonNode data) {
            return GetNamespaceStatusResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "quest").replace("{region}", Gs2QuestRestClient.this.session.getRegion().getName()) + "/{namespaceName}/status";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceTask
    extends Gs2RestSessionTask<GetNamespaceResult> {
        private GetNamespaceRequest request;

        public GetNamespaceTask(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2QuestRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceResult parse(JsonNode data) {
            return GetNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "quest").replace("{region}", Gs2QuestRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateNamespaceTask
    extends Gs2RestSessionTask<UpdateNamespaceResult> {
        private UpdateNamespaceRequest request;

        public UpdateNamespaceTask(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2QuestRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateNamespaceResult parse(JsonNode data) {
            return UpdateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "quest").replace("{region}", Gs2QuestRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateNamespaceTask.this.request.getDescription());
                    this.put("transactionSetting", UpdateNamespaceTask.this.request.getTransactionSetting() != null ? UpdateNamespaceTask.this.request.getTransactionSetting().toJson() : null);
                    this.put("startQuestScript", UpdateNamespaceTask.this.request.getStartQuestScript() != null ? UpdateNamespaceTask.this.request.getStartQuestScript().toJson() : null);
                    this.put("completeQuestScript", UpdateNamespaceTask.this.request.getCompleteQuestScript() != null ? UpdateNamespaceTask.this.request.getCompleteQuestScript().toJson() : null);
                    this.put("failedQuestScript", UpdateNamespaceTask.this.request.getFailedQuestScript() != null ? UpdateNamespaceTask.this.request.getFailedQuestScript().toJson() : null);
                    this.put("logSetting", UpdateNamespaceTask.this.request.getLogSetting() != null ? UpdateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("queueNamespaceId", UpdateNamespaceTask.this.request.getQueueNamespaceId());
                    this.put("keyId", UpdateNamespaceTask.this.request.getKeyId());
                    this.put("contextStack", UpdateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteNamespaceTask
    extends Gs2RestSessionTask<DeleteNamespaceResult> {
        private DeleteNamespaceRequest request;

        public DeleteNamespaceTask(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2QuestRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteNamespaceResult parse(JsonNode data) {
            return DeleteNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "quest").replace("{region}", Gs2QuestRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeQuestGroupModelMastersTask
    extends Gs2RestSessionTask<DescribeQuestGroupModelMastersResult> {
        private DescribeQuestGroupModelMastersRequest request;

        public DescribeQuestGroupModelMastersTask(DescribeQuestGroupModelMastersRequest request, AsyncAction<AsyncResult<DescribeQuestGroupModelMastersResult>> userCallback) {
            super((Gs2RestSession)Gs2QuestRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeQuestGroupModelMastersResult parse(JsonNode data) {
            return DescribeQuestGroupModelMastersResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "quest").replace("{region}", Gs2QuestRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/group";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateQuestGroupModelMasterTask
    extends Gs2RestSessionTask<CreateQuestGroupModelMasterResult> {
        private CreateQuestGroupModelMasterRequest request;

        public CreateQuestGroupModelMasterTask(CreateQuestGroupModelMasterRequest request, AsyncAction<AsyncResult<CreateQuestGroupModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2QuestRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateQuestGroupModelMasterResult parse(JsonNode data) {
            return CreateQuestGroupModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "quest").replace("{region}", Gs2QuestRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/group";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateQuestGroupModelMasterTask.this.request.getName());
                    this.put("description", CreateQuestGroupModelMasterTask.this.request.getDescription());
                    this.put("metadata", CreateQuestGroupModelMasterTask.this.request.getMetadata());
                    this.put("challengePeriodEventId", CreateQuestGroupModelMasterTask.this.request.getChallengePeriodEventId());
                    this.put("contextStack", CreateQuestGroupModelMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetQuestGroupModelMasterTask
    extends Gs2RestSessionTask<GetQuestGroupModelMasterResult> {
        private GetQuestGroupModelMasterRequest request;

        public GetQuestGroupModelMasterTask(GetQuestGroupModelMasterRequest request, AsyncAction<AsyncResult<GetQuestGroupModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2QuestRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetQuestGroupModelMasterResult parse(JsonNode data) {
            return GetQuestGroupModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "quest").replace("{region}", Gs2QuestRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/group/{questGroupName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{questGroupName}", this.request.getQuestGroupName() == null || this.request.getQuestGroupName().length() == 0 ? "null" : String.valueOf(this.request.getQuestGroupName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateQuestGroupModelMasterTask
    extends Gs2RestSessionTask<UpdateQuestGroupModelMasterResult> {
        private UpdateQuestGroupModelMasterRequest request;

        public UpdateQuestGroupModelMasterTask(UpdateQuestGroupModelMasterRequest request, AsyncAction<AsyncResult<UpdateQuestGroupModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2QuestRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateQuestGroupModelMasterResult parse(JsonNode data) {
            return UpdateQuestGroupModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "quest").replace("{region}", Gs2QuestRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/group/{questGroupName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{questGroupName}", this.request.getQuestGroupName() == null || this.request.getQuestGroupName().length() == 0 ? "null" : String.valueOf(this.request.getQuestGroupName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateQuestGroupModelMasterTask.this.request.getDescription());
                    this.put("metadata", UpdateQuestGroupModelMasterTask.this.request.getMetadata());
                    this.put("challengePeriodEventId", UpdateQuestGroupModelMasterTask.this.request.getChallengePeriodEventId());
                    this.put("contextStack", UpdateQuestGroupModelMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteQuestGroupModelMasterTask
    extends Gs2RestSessionTask<DeleteQuestGroupModelMasterResult> {
        private DeleteQuestGroupModelMasterRequest request;

        public DeleteQuestGroupModelMasterTask(DeleteQuestGroupModelMasterRequest request, AsyncAction<AsyncResult<DeleteQuestGroupModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2QuestRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteQuestGroupModelMasterResult parse(JsonNode data) {
            return DeleteQuestGroupModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "quest").replace("{region}", Gs2QuestRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/group/{questGroupName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{questGroupName}", this.request.getQuestGroupName() == null || this.request.getQuestGroupName().length() == 0 ? "null" : String.valueOf(this.request.getQuestGroupName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeQuestModelMastersTask
    extends Gs2RestSessionTask<DescribeQuestModelMastersResult> {
        private DescribeQuestModelMastersRequest request;

        public DescribeQuestModelMastersTask(DescribeQuestModelMastersRequest request, AsyncAction<AsyncResult<DescribeQuestModelMastersResult>> userCallback) {
            super((Gs2RestSession)Gs2QuestRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeQuestModelMastersResult parse(JsonNode data) {
            return DescribeQuestModelMastersResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "quest").replace("{region}", Gs2QuestRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/group/{questGroupName}/quest";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{questGroupName}", this.request.getQuestGroupName() == null || this.request.getQuestGroupName().length() == 0 ? "null" : String.valueOf(this.request.getQuestGroupName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateQuestModelMasterTask
    extends Gs2RestSessionTask<CreateQuestModelMasterResult> {
        private CreateQuestModelMasterRequest request;

        public CreateQuestModelMasterTask(CreateQuestModelMasterRequest request, AsyncAction<AsyncResult<CreateQuestModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2QuestRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateQuestModelMasterResult parse(JsonNode data) {
            return CreateQuestModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "quest").replace("{region}", Gs2QuestRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/group/{questGroupName}/quest";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{questGroupName}", this.request.getQuestGroupName() == null || this.request.getQuestGroupName().length() == 0 ? "null" : String.valueOf(this.request.getQuestGroupName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateQuestModelMasterTask.this.request.getName());
                    this.put("description", CreateQuestModelMasterTask.this.request.getDescription());
                    this.put("metadata", CreateQuestModelMasterTask.this.request.getMetadata());
                    this.put("contents", CreateQuestModelMasterTask.this.request.getContents() == null ? new ArrayList() : CreateQuestModelMasterTask.this.request.getContents().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("challengePeriodEventId", CreateQuestModelMasterTask.this.request.getChallengePeriodEventId());
                    this.put("firstCompleteAcquireActions", CreateQuestModelMasterTask.this.request.getFirstCompleteAcquireActions() == null ? new ArrayList() : CreateQuestModelMasterTask.this.request.getFirstCompleteAcquireActions().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("consumeActions", CreateQuestModelMasterTask.this.request.getConsumeActions() == null ? new ArrayList() : CreateQuestModelMasterTask.this.request.getConsumeActions().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("failedAcquireActions", CreateQuestModelMasterTask.this.request.getFailedAcquireActions() == null ? new ArrayList() : CreateQuestModelMasterTask.this.request.getFailedAcquireActions().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("premiseQuestNames", CreateQuestModelMasterTask.this.request.getPremiseQuestNames() == null ? new ArrayList() : CreateQuestModelMasterTask.this.request.getPremiseQuestNames().stream().map(item -> item).collect(Collectors.toList()));
                    this.put("contextStack", CreateQuestModelMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetQuestModelMasterTask
    extends Gs2RestSessionTask<GetQuestModelMasterResult> {
        private GetQuestModelMasterRequest request;

        public GetQuestModelMasterTask(GetQuestModelMasterRequest request, AsyncAction<AsyncResult<GetQuestModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2QuestRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetQuestModelMasterResult parse(JsonNode data) {
            return GetQuestModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "quest").replace("{region}", Gs2QuestRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/group/{questGroupName}/quest/{questName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{questGroupName}", this.request.getQuestGroupName() == null || this.request.getQuestGroupName().length() == 0 ? "null" : String.valueOf(this.request.getQuestGroupName()));
            url = url.replace("{questName}", this.request.getQuestName() == null || this.request.getQuestName().length() == 0 ? "null" : String.valueOf(this.request.getQuestName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateQuestModelMasterTask
    extends Gs2RestSessionTask<UpdateQuestModelMasterResult> {
        private UpdateQuestModelMasterRequest request;

        public UpdateQuestModelMasterTask(UpdateQuestModelMasterRequest request, AsyncAction<AsyncResult<UpdateQuestModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2QuestRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateQuestModelMasterResult parse(JsonNode data) {
            return UpdateQuestModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "quest").replace("{region}", Gs2QuestRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/group/{questGroupName}/quest/{questName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{questGroupName}", this.request.getQuestGroupName() == null || this.request.getQuestGroupName().length() == 0 ? "null" : String.valueOf(this.request.getQuestGroupName()));
            url = url.replace("{questName}", this.request.getQuestName() == null || this.request.getQuestName().length() == 0 ? "null" : String.valueOf(this.request.getQuestName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateQuestModelMasterTask.this.request.getDescription());
                    this.put("metadata", UpdateQuestModelMasterTask.this.request.getMetadata());
                    this.put("contents", UpdateQuestModelMasterTask.this.request.getContents() == null ? new ArrayList() : UpdateQuestModelMasterTask.this.request.getContents().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("challengePeriodEventId", UpdateQuestModelMasterTask.this.request.getChallengePeriodEventId());
                    this.put("firstCompleteAcquireActions", UpdateQuestModelMasterTask.this.request.getFirstCompleteAcquireActions() == null ? new ArrayList() : UpdateQuestModelMasterTask.this.request.getFirstCompleteAcquireActions().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("consumeActions", UpdateQuestModelMasterTask.this.request.getConsumeActions() == null ? new ArrayList() : UpdateQuestModelMasterTask.this.request.getConsumeActions().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("failedAcquireActions", UpdateQuestModelMasterTask.this.request.getFailedAcquireActions() == null ? new ArrayList() : UpdateQuestModelMasterTask.this.request.getFailedAcquireActions().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("premiseQuestNames", UpdateQuestModelMasterTask.this.request.getPremiseQuestNames() == null ? new ArrayList() : UpdateQuestModelMasterTask.this.request.getPremiseQuestNames().stream().map(item -> item).collect(Collectors.toList()));
                    this.put("contextStack", UpdateQuestModelMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteQuestModelMasterTask
    extends Gs2RestSessionTask<DeleteQuestModelMasterResult> {
        private DeleteQuestModelMasterRequest request;

        public DeleteQuestModelMasterTask(DeleteQuestModelMasterRequest request, AsyncAction<AsyncResult<DeleteQuestModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2QuestRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteQuestModelMasterResult parse(JsonNode data) {
            return DeleteQuestModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "quest").replace("{region}", Gs2QuestRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/group/{questGroupName}/quest/{questName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{questGroupName}", this.request.getQuestGroupName() == null || this.request.getQuestGroupName().length() == 0 ? "null" : String.valueOf(this.request.getQuestGroupName()));
            url = url.replace("{questName}", this.request.getQuestName() == null || this.request.getQuestName().length() == 0 ? "null" : String.valueOf(this.request.getQuestName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class ExportMasterTask
    extends Gs2RestSessionTask<ExportMasterResult> {
        private ExportMasterRequest request;

        public ExportMasterTask(ExportMasterRequest request, AsyncAction<AsyncResult<ExportMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2QuestRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ExportMasterResult parse(JsonNode data) {
            return ExportMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "quest").replace("{region}", Gs2QuestRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/export";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetCurrentQuestMasterTask
    extends Gs2RestSessionTask<GetCurrentQuestMasterResult> {
        private GetCurrentQuestMasterRequest request;

        public GetCurrentQuestMasterTask(GetCurrentQuestMasterRequest request, AsyncAction<AsyncResult<GetCurrentQuestMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2QuestRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetCurrentQuestMasterResult parse(JsonNode data) {
            return GetCurrentQuestMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "quest").replace("{region}", Gs2QuestRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateCurrentQuestMasterTask
    extends Gs2RestSessionTask<UpdateCurrentQuestMasterResult> {
        private UpdateCurrentQuestMasterRequest request;

        public UpdateCurrentQuestMasterTask(UpdateCurrentQuestMasterRequest request, AsyncAction<AsyncResult<UpdateCurrentQuestMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2QuestRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateCurrentQuestMasterResult parse(JsonNode data) {
            return UpdateCurrentQuestMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "quest").replace("{region}", Gs2QuestRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("settings", UpdateCurrentQuestMasterTask.this.request.getSettings());
                    this.put("contextStack", UpdateCurrentQuestMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateCurrentQuestMasterFromGitHubTask
    extends Gs2RestSessionTask<UpdateCurrentQuestMasterFromGitHubResult> {
        private UpdateCurrentQuestMasterFromGitHubRequest request;

        public UpdateCurrentQuestMasterFromGitHubTask(UpdateCurrentQuestMasterFromGitHubRequest request, AsyncAction<AsyncResult<UpdateCurrentQuestMasterFromGitHubResult>> userCallback) {
            super((Gs2RestSession)Gs2QuestRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateCurrentQuestMasterFromGitHubResult parse(JsonNode data) {
            return UpdateCurrentQuestMasterFromGitHubResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "quest").replace("{region}", Gs2QuestRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/from_git_hub";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("checkoutSetting", UpdateCurrentQuestMasterFromGitHubTask.this.request.getCheckoutSetting() != null ? UpdateCurrentQuestMasterFromGitHubTask.this.request.getCheckoutSetting().toJson() : null);
                    this.put("contextStack", UpdateCurrentQuestMasterFromGitHubTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeProgressesByUserIdTask
    extends Gs2RestSessionTask<DescribeProgressesByUserIdResult> {
        private DescribeProgressesByUserIdRequest request;

        public DescribeProgressesByUserIdTask(DescribeProgressesByUserIdRequest request, AsyncAction<AsyncResult<DescribeProgressesByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2QuestRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeProgressesByUserIdResult parse(JsonNode data) {
            return DescribeProgressesByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "quest").replace("{region}", Gs2QuestRestClient.this.session.getRegion().getName()) + "/{namespaceName}/progress";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getUserId() != null) {
                queryStrings.add("userId=" + EncodingUtil.urlEncode(String.valueOf(this.request.getUserId())));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateProgressByUserIdTask
    extends Gs2RestSessionTask<CreateProgressByUserIdResult> {
        private CreateProgressByUserIdRequest request;

        public CreateProgressByUserIdTask(CreateProgressByUserIdRequest request, AsyncAction<AsyncResult<CreateProgressByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2QuestRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateProgressByUserIdResult parse(JsonNode data) {
            return CreateProgressByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "quest").replace("{region}", Gs2QuestRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/progress";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("questModelId", CreateProgressByUserIdTask.this.request.getQuestModelId());
                    this.put("force", CreateProgressByUserIdTask.this.request.getForce());
                    this.put("config", CreateProgressByUserIdTask.this.request.getConfig() == null ? new ArrayList() : CreateProgressByUserIdTask.this.request.getConfig().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", CreateProgressByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class GetProgressTask
    extends Gs2RestSessionTask<GetProgressResult> {
        private GetProgressRequest request;

        public GetProgressTask(GetProgressRequest request, AsyncAction<AsyncResult<GetProgressResult>> userCallback) {
            super((Gs2RestSession)Gs2QuestRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetProgressResult parse(JsonNode data) {
            return GetProgressResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "quest").replace("{region}", Gs2QuestRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/progress";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class GetProgressByUserIdTask
    extends Gs2RestSessionTask<GetProgressByUserIdResult> {
        private GetProgressByUserIdRequest request;

        public GetProgressByUserIdTask(GetProgressByUserIdRequest request, AsyncAction<AsyncResult<GetProgressByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2QuestRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetProgressByUserIdResult parse(JsonNode data) {
            return GetProgressByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "quest").replace("{region}", Gs2QuestRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/progress";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class StartTask
    extends Gs2RestSessionTask<StartResult> {
        private StartRequest request;

        public StartTask(StartRequest request, AsyncAction<AsyncResult<StartResult>> userCallback) {
            super((Gs2RestSession)Gs2QuestRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public StartResult parse(JsonNode data) {
            return StartResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "quest").replace("{region}", Gs2QuestRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/progress/group/{questGroupName}/quest/{questName}/start";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{questGroupName}", this.request.getQuestGroupName() == null || this.request.getQuestGroupName().length() == 0 ? "null" : String.valueOf(this.request.getQuestGroupName()));
            url = url.replace("{questName}", this.request.getQuestName() == null || this.request.getQuestName().length() == 0 ? "null" : String.valueOf(this.request.getQuestName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("force", StartTask.this.request.getForce());
                    this.put("config", StartTask.this.request.getConfig() == null ? new ArrayList() : StartTask.this.request.getConfig().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", StartTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class StartByUserIdTask
    extends Gs2RestSessionTask<StartByUserIdResult> {
        private StartByUserIdRequest request;

        public StartByUserIdTask(StartByUserIdRequest request, AsyncAction<AsyncResult<StartByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2QuestRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public StartByUserIdResult parse(JsonNode data) {
            return StartByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "quest").replace("{region}", Gs2QuestRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/progress/group/{questGroupName}/quest/{questName}/start";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{questGroupName}", this.request.getQuestGroupName() == null || this.request.getQuestGroupName().length() == 0 ? "null" : String.valueOf(this.request.getQuestGroupName()));
            url = url.replace("{questName}", this.request.getQuestName() == null || this.request.getQuestName().length() == 0 ? "null" : String.valueOf(this.request.getQuestName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("force", StartByUserIdTask.this.request.getForce());
                    this.put("config", StartByUserIdTask.this.request.getConfig() == null ? new ArrayList() : StartByUserIdTask.this.request.getConfig().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", StartByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class EndTask
    extends Gs2RestSessionTask<EndResult> {
        private EndRequest request;

        public EndTask(EndRequest request, AsyncAction<AsyncResult<EndResult>> userCallback) {
            super((Gs2RestSession)Gs2QuestRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public EndResult parse(JsonNode data) {
            return EndResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "quest").replace("{region}", Gs2QuestRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/progress/end";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("rewards", EndTask.this.request.getRewards() == null ? new ArrayList() : EndTask.this.request.getRewards().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("isComplete", EndTask.this.request.getIsComplete());
                    this.put("config", EndTask.this.request.getConfig() == null ? new ArrayList() : EndTask.this.request.getConfig().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", EndTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class EndByUserIdTask
    extends Gs2RestSessionTask<EndByUserIdResult> {
        private EndByUserIdRequest request;

        public EndByUserIdTask(EndByUserIdRequest request, AsyncAction<AsyncResult<EndByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2QuestRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public EndByUserIdResult parse(JsonNode data) {
            return EndByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "quest").replace("{region}", Gs2QuestRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/progress/end";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("rewards", EndByUserIdTask.this.request.getRewards() == null ? new ArrayList() : EndByUserIdTask.this.request.getRewards().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("isComplete", EndByUserIdTask.this.request.getIsComplete());
                    this.put("config", EndByUserIdTask.this.request.getConfig() == null ? new ArrayList() : EndByUserIdTask.this.request.getConfig().stream().map(item -> item.toJson()).collect(Collectors.toList()));
                    this.put("contextStack", EndByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DeleteProgressTask
    extends Gs2RestSessionTask<DeleteProgressResult> {
        private DeleteProgressRequest request;

        public DeleteProgressTask(DeleteProgressRequest request, AsyncAction<AsyncResult<DeleteProgressResult>> userCallback) {
            super((Gs2RestSession)Gs2QuestRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteProgressResult parse(JsonNode data) {
            return DeleteProgressResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "quest").replace("{region}", Gs2QuestRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/progress";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DeleteProgressByUserIdTask
    extends Gs2RestSessionTask<DeleteProgressByUserIdResult> {
        private DeleteProgressByUserIdRequest request;

        public DeleteProgressByUserIdTask(DeleteProgressByUserIdRequest request, AsyncAction<AsyncResult<DeleteProgressByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2QuestRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteProgressByUserIdResult parse(JsonNode data) {
            return DeleteProgressByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "quest").replace("{region}", Gs2QuestRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/progress";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CreateProgressByStampSheetTask
    extends Gs2RestSessionTask<CreateProgressByStampSheetResult> {
        private CreateProgressByStampSheetRequest request;

        public CreateProgressByStampSheetTask(CreateProgressByStampSheetRequest request, AsyncAction<AsyncResult<CreateProgressByStampSheetResult>> userCallback) {
            super((Gs2RestSession)Gs2QuestRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateProgressByStampSheetResult parse(JsonNode data) {
            return CreateProgressByStampSheetResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "quest").replace("{region}", Gs2QuestRestClient.this.session.getRegion().getName()) + "/stamp/progress/create";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stampSheet", CreateProgressByStampSheetTask.this.request.getStampSheet());
                    this.put("keyId", CreateProgressByStampSheetTask.this.request.getKeyId());
                    this.put("contextStack", CreateProgressByStampSheetTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteProgressByStampTaskTask
    extends Gs2RestSessionTask<DeleteProgressByStampTaskResult> {
        private DeleteProgressByStampTaskRequest request;

        public DeleteProgressByStampTaskTask(DeleteProgressByStampTaskRequest request, AsyncAction<AsyncResult<DeleteProgressByStampTaskResult>> userCallback) {
            super((Gs2RestSession)Gs2QuestRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteProgressByStampTaskResult parse(JsonNode data) {
            return DeleteProgressByStampTaskResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "quest").replace("{region}", Gs2QuestRestClient.this.session.getRegion().getName()) + "/stamp/progress/delete";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stampTask", DeleteProgressByStampTaskTask.this.request.getStampTask());
                    this.put("keyId", DeleteProgressByStampTaskTask.this.request.getKeyId());
                    this.put("contextStack", DeleteProgressByStampTaskTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeCompletedQuestListsTask
    extends Gs2RestSessionTask<DescribeCompletedQuestListsResult> {
        private DescribeCompletedQuestListsRequest request;

        public DescribeCompletedQuestListsTask(DescribeCompletedQuestListsRequest request, AsyncAction<AsyncResult<DescribeCompletedQuestListsResult>> userCallback) {
            super((Gs2RestSession)Gs2QuestRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeCompletedQuestListsResult parse(JsonNode data) {
            return DescribeCompletedQuestListsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "quest").replace("{region}", Gs2QuestRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/completed";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class DescribeCompletedQuestListsByUserIdTask
    extends Gs2RestSessionTask<DescribeCompletedQuestListsByUserIdResult> {
        private DescribeCompletedQuestListsByUserIdRequest request;

        public DescribeCompletedQuestListsByUserIdTask(DescribeCompletedQuestListsByUserIdRequest request, AsyncAction<AsyncResult<DescribeCompletedQuestListsByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2QuestRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeCompletedQuestListsByUserIdResult parse(JsonNode data) {
            return DescribeCompletedQuestListsByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "quest").replace("{region}", Gs2QuestRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/completed";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetCompletedQuestListTask
    extends Gs2RestSessionTask<GetCompletedQuestListResult> {
        private GetCompletedQuestListRequest request;

        public GetCompletedQuestListTask(GetCompletedQuestListRequest request, AsyncAction<AsyncResult<GetCompletedQuestListResult>> userCallback) {
            super((Gs2RestSession)Gs2QuestRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetCompletedQuestListResult parse(JsonNode data) {
            return GetCompletedQuestListResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "quest").replace("{region}", Gs2QuestRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/completed/group/{questGroupName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{questGroupName}", this.request.getQuestGroupName() == null || this.request.getQuestGroupName().length() == 0 ? "null" : String.valueOf(this.request.getQuestGroupName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class GetCompletedQuestListByUserIdTask
    extends Gs2RestSessionTask<GetCompletedQuestListByUserIdResult> {
        private GetCompletedQuestListByUserIdRequest request;

        public GetCompletedQuestListByUserIdTask(GetCompletedQuestListByUserIdRequest request, AsyncAction<AsyncResult<GetCompletedQuestListByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2QuestRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetCompletedQuestListByUserIdResult parse(JsonNode data) {
            return GetCompletedQuestListByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "quest").replace("{region}", Gs2QuestRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/completed/group/{questGroupName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{questGroupName}", this.request.getQuestGroupName() == null || this.request.getQuestGroupName().length() == 0 ? "null" : String.valueOf(this.request.getQuestGroupName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteCompletedQuestListByUserIdTask
    extends Gs2RestSessionTask<DeleteCompletedQuestListByUserIdResult> {
        private DeleteCompletedQuestListByUserIdRequest request;

        public DeleteCompletedQuestListByUserIdTask(DeleteCompletedQuestListByUserIdRequest request, AsyncAction<AsyncResult<DeleteCompletedQuestListByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2QuestRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteCompletedQuestListByUserIdResult parse(JsonNode data) {
            return DeleteCompletedQuestListByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "quest").replace("{region}", Gs2QuestRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/completed/group/{questGroupName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{questGroupName}", this.request.getQuestGroupName() == null || this.request.getQuestGroupName().length() == 0 ? "null" : String.valueOf(this.request.getQuestGroupName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DescribeQuestGroupModelsTask
    extends Gs2RestSessionTask<DescribeQuestGroupModelsResult> {
        private DescribeQuestGroupModelsRequest request;

        public DescribeQuestGroupModelsTask(DescribeQuestGroupModelsRequest request, AsyncAction<AsyncResult<DescribeQuestGroupModelsResult>> userCallback) {
            super((Gs2RestSession)Gs2QuestRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeQuestGroupModelsResult parse(JsonNode data) {
            return DescribeQuestGroupModelsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "quest").replace("{region}", Gs2QuestRestClient.this.session.getRegion().getName()) + "/{namespaceName}/group";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetQuestGroupModelTask
    extends Gs2RestSessionTask<GetQuestGroupModelResult> {
        private GetQuestGroupModelRequest request;

        public GetQuestGroupModelTask(GetQuestGroupModelRequest request, AsyncAction<AsyncResult<GetQuestGroupModelResult>> userCallback) {
            super((Gs2RestSession)Gs2QuestRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetQuestGroupModelResult parse(JsonNode data) {
            return GetQuestGroupModelResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "quest").replace("{region}", Gs2QuestRestClient.this.session.getRegion().getName()) + "/{namespaceName}/group/{questGroupName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{questGroupName}", this.request.getQuestGroupName() == null || this.request.getQuestGroupName().length() == 0 ? "null" : String.valueOf(this.request.getQuestGroupName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeQuestModelsTask
    extends Gs2RestSessionTask<DescribeQuestModelsResult> {
        private DescribeQuestModelsRequest request;

        public DescribeQuestModelsTask(DescribeQuestModelsRequest request, AsyncAction<AsyncResult<DescribeQuestModelsResult>> userCallback) {
            super((Gs2RestSession)Gs2QuestRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeQuestModelsResult parse(JsonNode data) {
            return DescribeQuestModelsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "quest").replace("{region}", Gs2QuestRestClient.this.session.getRegion().getName()) + "/{namespaceName}/group/{questGroupName}/quest";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{questGroupName}", this.request.getQuestGroupName() == null || this.request.getQuestGroupName().length() == 0 ? "null" : String.valueOf(this.request.getQuestGroupName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetQuestModelTask
    extends Gs2RestSessionTask<GetQuestModelResult> {
        private GetQuestModelRequest request;

        public GetQuestModelTask(GetQuestModelRequest request, AsyncAction<AsyncResult<GetQuestModelResult>> userCallback) {
            super((Gs2RestSession)Gs2QuestRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetQuestModelResult parse(JsonNode data) {
            return GetQuestModelResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "quest").replace("{region}", Gs2QuestRestClient.this.session.getRegion().getName()) + "/{namespaceName}/group/{questGroupName}/quest/{questName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{questGroupName}", this.request.getQuestGroupName() == null || this.request.getQuestGroupName().length() == 0 ? "null" : String.valueOf(this.request.getQuestGroupName()));
            url = url.replace("{questName}", this.request.getQuestName() == null || this.request.getQuestName().length() == 0 ? "null" : String.valueOf(this.request.getQuestName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }
}

