/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.lottery.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.model.IModel;
import io.gs2.lottery.model.Prize;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PrizeTable
implements IModel,
Serializable,
Comparable<PrizeTable> {
    private String prizeTableId;
    private String name;
    private String metadata;
    private List<Prize> prizes;

    public String getPrizeTableId() {
        return this.prizeTableId;
    }

    public void setPrizeTableId(String prizeTableId) {
        this.prizeTableId = prizeTableId;
    }

    public PrizeTable withPrizeTableId(String prizeTableId) {
        this.prizeTableId = prizeTableId;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PrizeTable withName(String name) {
        this.name = name;
        return this;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public PrizeTable withMetadata(String metadata) {
        this.metadata = metadata;
        return this;
    }

    public List<Prize> getPrizes() {
        return this.prizes;
    }

    public void setPrizes(List<Prize> prizes) {
        this.prizes = prizes;
    }

    public PrizeTable withPrizes(List<Prize> prizes) {
        this.prizes = prizes;
        return this;
    }

    public static PrizeTable fromJson(JsonNode data) {
        if (data == null) {
            return null;
        }
        return new PrizeTable().withPrizeTableId(data.get("prizeTableId") == null || data.get("prizeTableId").isNull() ? null : data.get("prizeTableId").asText()).withName(data.get("name") == null || data.get("name").isNull() ? null : data.get("name").asText()).withMetadata(data.get("metadata") == null || data.get("metadata").isNull() ? null : data.get("metadata").asText()).withPrizes(data.get("prizes") == null || data.get("prizes").isNull() ? new ArrayList<Prize>() : StreamSupport.stream(Spliterators.spliteratorUnknownSize(data.get("prizes").elements(), 256), false).map(item -> Prize.fromJson(item)).collect(Collectors.toList()));
    }

    public JsonNode toJson() {
        return new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
            {
                this.put("prizeTableId", PrizeTable.this.getPrizeTableId());
                this.put("name", PrizeTable.this.getName());
                this.put("metadata", PrizeTable.this.getMetadata());
                this.put("prizes", PrizeTable.this.getPrizes() == null ? new ArrayList() : PrizeTable.this.getPrizes().stream().map(item -> item.toJson()).collect(Collectors.toList()));
            }
        });
    }

    @Override
    public int compareTo(PrizeTable o) {
        return this.prizeTableId.compareTo(o.prizeTableId);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.prizeTableId == null ? 0 : this.prizeTableId.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.metadata == null ? 0 : this.metadata.hashCode());
        result = 31 * result + (this.prizes == null ? 0 : this.prizes.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        PrizeTable other = (PrizeTable)o;
        if (this.prizeTableId == null) {
            return other.prizeTableId == null;
        }
        if (!this.prizeTableId.equals(other.prizeTableId)) {
            return false;
        }
        if (this.name == null) {
            return other.name == null;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (this.metadata == null) {
            return other.metadata == null;
        }
        if (!this.metadata.equals(other.metadata)) {
            return false;
        }
        if (this.prizes == null) {
            return other.prizes == null;
        }
        return this.prizes.equals(other.prizes);
    }
}

