/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.limit;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.AbstractGs2Client;
import io.gs2.core.model.AsyncAction;
import io.gs2.core.model.AsyncResult;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.core.net.Gs2RestSessionTask;
import io.gs2.core.net.HttpTask;
import io.gs2.core.util.EncodingUtil;
import io.gs2.limit.request.CountDownByStampSheetRequest;
import io.gs2.limit.request.CountDownByUserIdRequest;
import io.gs2.limit.request.CountUpByStampTaskRequest;
import io.gs2.limit.request.CountUpByUserIdRequest;
import io.gs2.limit.request.CountUpRequest;
import io.gs2.limit.request.CreateLimitModelMasterRequest;
import io.gs2.limit.request.CreateNamespaceRequest;
import io.gs2.limit.request.DeleteByStampSheetRequest;
import io.gs2.limit.request.DeleteCounterByUserIdRequest;
import io.gs2.limit.request.DeleteLimitModelMasterRequest;
import io.gs2.limit.request.DeleteNamespaceRequest;
import io.gs2.limit.request.DescribeCountersByUserIdRequest;
import io.gs2.limit.request.DescribeCountersRequest;
import io.gs2.limit.request.DescribeLimitModelMastersRequest;
import io.gs2.limit.request.DescribeLimitModelsRequest;
import io.gs2.limit.request.DescribeNamespacesRequest;
import io.gs2.limit.request.ExportMasterRequest;
import io.gs2.limit.request.GetCounterByUserIdRequest;
import io.gs2.limit.request.GetCounterRequest;
import io.gs2.limit.request.GetCurrentLimitMasterRequest;
import io.gs2.limit.request.GetLimitModelMasterRequest;
import io.gs2.limit.request.GetLimitModelRequest;
import io.gs2.limit.request.GetNamespaceRequest;
import io.gs2.limit.request.GetNamespaceStatusRequest;
import io.gs2.limit.request.UpdateCurrentLimitMasterFromGitHubRequest;
import io.gs2.limit.request.UpdateCurrentLimitMasterRequest;
import io.gs2.limit.request.UpdateLimitModelMasterRequest;
import io.gs2.limit.request.UpdateNamespaceRequest;
import io.gs2.limit.result.CountDownByStampSheetResult;
import io.gs2.limit.result.CountDownByUserIdResult;
import io.gs2.limit.result.CountUpByStampTaskResult;
import io.gs2.limit.result.CountUpByUserIdResult;
import io.gs2.limit.result.CountUpResult;
import io.gs2.limit.result.CreateLimitModelMasterResult;
import io.gs2.limit.result.CreateNamespaceResult;
import io.gs2.limit.result.DeleteByStampSheetResult;
import io.gs2.limit.result.DeleteCounterByUserIdResult;
import io.gs2.limit.result.DeleteLimitModelMasterResult;
import io.gs2.limit.result.DeleteNamespaceResult;
import io.gs2.limit.result.DescribeCountersByUserIdResult;
import io.gs2.limit.result.DescribeCountersResult;
import io.gs2.limit.result.DescribeLimitModelMastersResult;
import io.gs2.limit.result.DescribeLimitModelsResult;
import io.gs2.limit.result.DescribeNamespacesResult;
import io.gs2.limit.result.ExportMasterResult;
import io.gs2.limit.result.GetCounterByUserIdResult;
import io.gs2.limit.result.GetCounterResult;
import io.gs2.limit.result.GetCurrentLimitMasterResult;
import io.gs2.limit.result.GetLimitModelMasterResult;
import io.gs2.limit.result.GetLimitModelResult;
import io.gs2.limit.result.GetNamespaceResult;
import io.gs2.limit.result.GetNamespaceStatusResult;
import io.gs2.limit.result.UpdateCurrentLimitMasterFromGitHubResult;
import io.gs2.limit.result.UpdateCurrentLimitMasterResult;
import io.gs2.limit.result.UpdateLimitModelMasterResult;
import io.gs2.limit.result.UpdateNamespaceResult;
import java.util.ArrayList;
import java.util.HashMap;

public class Gs2LimitRestClient
extends AbstractGs2Client<Gs2LimitRestClient> {
    public Gs2LimitRestClient(Gs2RestSession gs2RestSession) {
        super(gs2RestSession);
    }

    public void describeNamespacesAsync(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> callback) {
        DescribeNamespacesTask task = new DescribeNamespacesTask(request, callback);
        this.session.execute(task);
    }

    public DescribeNamespacesResult describeNamespaces(DescribeNamespacesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeNamespacesAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeNamespacesResult)resultAsyncResult[0].getResult();
    }

    public void createNamespaceAsync(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> callback) {
        CreateNamespaceTask task = new CreateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public CreateNamespaceResult createNamespace(CreateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceStatusAsync(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> callback) {
        GetNamespaceStatusTask task = new GetNamespaceStatusTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceStatusResult getNamespaceStatus(GetNamespaceStatusRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceStatusAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceStatusResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceAsync(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> callback) {
        GetNamespaceTask task = new GetNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceResult getNamespace(GetNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void updateNamespaceAsync(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> callback) {
        UpdateNamespaceTask task = new UpdateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public UpdateNamespaceResult updateNamespace(UpdateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void deleteNamespaceAsync(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> callback) {
        DeleteNamespaceTask task = new DeleteNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public DeleteNamespaceResult deleteNamespace(DeleteNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void describeCountersAsync(DescribeCountersRequest request, AsyncAction<AsyncResult<DescribeCountersResult>> callback) {
        DescribeCountersTask task = new DescribeCountersTask(request, callback);
        this.session.execute(task);
    }

    public DescribeCountersResult describeCounters(DescribeCountersRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeCountersAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeCountersResult)resultAsyncResult[0].getResult();
    }

    public void describeCountersByUserIdAsync(DescribeCountersByUserIdRequest request, AsyncAction<AsyncResult<DescribeCountersByUserIdResult>> callback) {
        DescribeCountersByUserIdTask task = new DescribeCountersByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DescribeCountersByUserIdResult describeCountersByUserId(DescribeCountersByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeCountersByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeCountersByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void getCounterAsync(GetCounterRequest request, AsyncAction<AsyncResult<GetCounterResult>> callback) {
        GetCounterTask task = new GetCounterTask(request, callback);
        this.session.execute(task);
    }

    public GetCounterResult getCounter(GetCounterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getCounterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetCounterResult)resultAsyncResult[0].getResult();
    }

    public void getCounterByUserIdAsync(GetCounterByUserIdRequest request, AsyncAction<AsyncResult<GetCounterByUserIdResult>> callback) {
        GetCounterByUserIdTask task = new GetCounterByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public GetCounterByUserIdResult getCounterByUserId(GetCounterByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getCounterByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetCounterByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void countUpAsync(CountUpRequest request, AsyncAction<AsyncResult<CountUpResult>> callback) {
        CountUpTask task = new CountUpTask(request, callback);
        this.session.execute(task);
    }

    public CountUpResult countUp(CountUpRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.countUpAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CountUpResult)resultAsyncResult[0].getResult();
    }

    public void countUpByUserIdAsync(CountUpByUserIdRequest request, AsyncAction<AsyncResult<CountUpByUserIdResult>> callback) {
        CountUpByUserIdTask task = new CountUpByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CountUpByUserIdResult countUpByUserId(CountUpByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.countUpByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CountUpByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void countDownByUserIdAsync(CountDownByUserIdRequest request, AsyncAction<AsyncResult<CountDownByUserIdResult>> callback) {
        CountDownByUserIdTask task = new CountDownByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public CountDownByUserIdResult countDownByUserId(CountDownByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.countDownByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CountDownByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void deleteCounterByUserIdAsync(DeleteCounterByUserIdRequest request, AsyncAction<AsyncResult<DeleteCounterByUserIdResult>> callback) {
        DeleteCounterByUserIdTask task = new DeleteCounterByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DeleteCounterByUserIdResult deleteCounterByUserId(DeleteCounterByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteCounterByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteCounterByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void countUpByStampTaskAsync(CountUpByStampTaskRequest request, AsyncAction<AsyncResult<CountUpByStampTaskResult>> callback) {
        CountUpByStampTaskTask task = new CountUpByStampTaskTask(request, callback);
        this.session.execute(task);
    }

    public CountUpByStampTaskResult countUpByStampTask(CountUpByStampTaskRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.countUpByStampTaskAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CountUpByStampTaskResult)resultAsyncResult[0].getResult();
    }

    public void countDownByStampSheetAsync(CountDownByStampSheetRequest request, AsyncAction<AsyncResult<CountDownByStampSheetResult>> callback) {
        CountDownByStampSheetTask task = new CountDownByStampSheetTask(request, callback);
        this.session.execute(task);
    }

    public CountDownByStampSheetResult countDownByStampSheet(CountDownByStampSheetRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.countDownByStampSheetAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CountDownByStampSheetResult)resultAsyncResult[0].getResult();
    }

    public void deleteByStampSheetAsync(DeleteByStampSheetRequest request, AsyncAction<AsyncResult<DeleteByStampSheetResult>> callback) {
        DeleteByStampSheetTask task = new DeleteByStampSheetTask(request, callback);
        this.session.execute(task);
    }

    public DeleteByStampSheetResult deleteByStampSheet(DeleteByStampSheetRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteByStampSheetAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteByStampSheetResult)resultAsyncResult[0].getResult();
    }

    public void describeLimitModelMastersAsync(DescribeLimitModelMastersRequest request, AsyncAction<AsyncResult<DescribeLimitModelMastersResult>> callback) {
        DescribeLimitModelMastersTask task = new DescribeLimitModelMastersTask(request, callback);
        this.session.execute(task);
    }

    public DescribeLimitModelMastersResult describeLimitModelMasters(DescribeLimitModelMastersRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeLimitModelMastersAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeLimitModelMastersResult)resultAsyncResult[0].getResult();
    }

    public void createLimitModelMasterAsync(CreateLimitModelMasterRequest request, AsyncAction<AsyncResult<CreateLimitModelMasterResult>> callback) {
        CreateLimitModelMasterTask task = new CreateLimitModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public CreateLimitModelMasterResult createLimitModelMaster(CreateLimitModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createLimitModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateLimitModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void getLimitModelMasterAsync(GetLimitModelMasterRequest request, AsyncAction<AsyncResult<GetLimitModelMasterResult>> callback) {
        GetLimitModelMasterTask task = new GetLimitModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public GetLimitModelMasterResult getLimitModelMaster(GetLimitModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getLimitModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetLimitModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateLimitModelMasterAsync(UpdateLimitModelMasterRequest request, AsyncAction<AsyncResult<UpdateLimitModelMasterResult>> callback) {
        UpdateLimitModelMasterTask task = new UpdateLimitModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public UpdateLimitModelMasterResult updateLimitModelMaster(UpdateLimitModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateLimitModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateLimitModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void deleteLimitModelMasterAsync(DeleteLimitModelMasterRequest request, AsyncAction<AsyncResult<DeleteLimitModelMasterResult>> callback) {
        DeleteLimitModelMasterTask task = new DeleteLimitModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public DeleteLimitModelMasterResult deleteLimitModelMaster(DeleteLimitModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteLimitModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteLimitModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void exportMasterAsync(ExportMasterRequest request, AsyncAction<AsyncResult<ExportMasterResult>> callback) {
        ExportMasterTask task = new ExportMasterTask(request, callback);
        this.session.execute(task);
    }

    public ExportMasterResult exportMaster(ExportMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.exportMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ExportMasterResult)resultAsyncResult[0].getResult();
    }

    public void getCurrentLimitMasterAsync(GetCurrentLimitMasterRequest request, AsyncAction<AsyncResult<GetCurrentLimitMasterResult>> callback) {
        GetCurrentLimitMasterTask task = new GetCurrentLimitMasterTask(request, callback);
        this.session.execute(task);
    }

    public GetCurrentLimitMasterResult getCurrentLimitMaster(GetCurrentLimitMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getCurrentLimitMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetCurrentLimitMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateCurrentLimitMasterAsync(UpdateCurrentLimitMasterRequest request, AsyncAction<AsyncResult<UpdateCurrentLimitMasterResult>> callback) {
        UpdateCurrentLimitMasterTask task = new UpdateCurrentLimitMasterTask(request, callback);
        this.session.execute(task);
    }

    public UpdateCurrentLimitMasterResult updateCurrentLimitMaster(UpdateCurrentLimitMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateCurrentLimitMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateCurrentLimitMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateCurrentLimitMasterFromGitHubAsync(UpdateCurrentLimitMasterFromGitHubRequest request, AsyncAction<AsyncResult<UpdateCurrentLimitMasterFromGitHubResult>> callback) {
        UpdateCurrentLimitMasterFromGitHubTask task = new UpdateCurrentLimitMasterFromGitHubTask(request, callback);
        this.session.execute(task);
    }

    public UpdateCurrentLimitMasterFromGitHubResult updateCurrentLimitMasterFromGitHub(UpdateCurrentLimitMasterFromGitHubRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateCurrentLimitMasterFromGitHubAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateCurrentLimitMasterFromGitHubResult)resultAsyncResult[0].getResult();
    }

    public void describeLimitModelsAsync(DescribeLimitModelsRequest request, AsyncAction<AsyncResult<DescribeLimitModelsResult>> callback) {
        DescribeLimitModelsTask task = new DescribeLimitModelsTask(request, callback);
        this.session.execute(task);
    }

    public DescribeLimitModelsResult describeLimitModels(DescribeLimitModelsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeLimitModelsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeLimitModelsResult)resultAsyncResult[0].getResult();
    }

    public void getLimitModelAsync(GetLimitModelRequest request, AsyncAction<AsyncResult<GetLimitModelResult>> callback) {
        GetLimitModelTask task = new GetLimitModelTask(request, callback);
        this.session.execute(task);
    }

    public GetLimitModelResult getLimitModel(GetLimitModelRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getLimitModelAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetLimitModelResult)resultAsyncResult[0].getResult();
    }

    class DescribeNamespacesTask
    extends Gs2RestSessionTask<DescribeNamespacesResult> {
        private DescribeNamespacesRequest request;

        public DescribeNamespacesTask(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> userCallback) {
            super((Gs2RestSession)Gs2LimitRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeNamespacesResult parse(JsonNode data) {
            return DescribeNamespacesResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "limit").replace("{region}", Gs2LimitRestClient.this.session.getRegion().getName()) + "/";
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateNamespaceTask
    extends Gs2RestSessionTask<CreateNamespaceResult> {
        private CreateNamespaceRequest request;

        public CreateNamespaceTask(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2LimitRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateNamespaceResult parse(JsonNode data) {
            return CreateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "limit").replace("{region}", Gs2LimitRestClient.this.session.getRegion().getName()) + "/";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateNamespaceTask.this.request.getName());
                    this.put("description", CreateNamespaceTask.this.request.getDescription());
                    this.put("logSetting", CreateNamespaceTask.this.request.getLogSetting() != null ? CreateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("contextStack", CreateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceStatusTask
    extends Gs2RestSessionTask<GetNamespaceStatusResult> {
        private GetNamespaceStatusRequest request;

        public GetNamespaceStatusTask(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> userCallback) {
            super((Gs2RestSession)Gs2LimitRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceStatusResult parse(JsonNode data) {
            return GetNamespaceStatusResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "limit").replace("{region}", Gs2LimitRestClient.this.session.getRegion().getName()) + "/{namespaceName}/status";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceTask
    extends Gs2RestSessionTask<GetNamespaceResult> {
        private GetNamespaceRequest request;

        public GetNamespaceTask(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2LimitRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceResult parse(JsonNode data) {
            return GetNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "limit").replace("{region}", Gs2LimitRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateNamespaceTask
    extends Gs2RestSessionTask<UpdateNamespaceResult> {
        private UpdateNamespaceRequest request;

        public UpdateNamespaceTask(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2LimitRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateNamespaceResult parse(JsonNode data) {
            return UpdateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "limit").replace("{region}", Gs2LimitRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateNamespaceTask.this.request.getDescription());
                    this.put("logSetting", UpdateNamespaceTask.this.request.getLogSetting() != null ? UpdateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("contextStack", UpdateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteNamespaceTask
    extends Gs2RestSessionTask<DeleteNamespaceResult> {
        private DeleteNamespaceRequest request;

        public DeleteNamespaceTask(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2LimitRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteNamespaceResult parse(JsonNode data) {
            return DeleteNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "limit").replace("{region}", Gs2LimitRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeCountersTask
    extends Gs2RestSessionTask<DescribeCountersResult> {
        private DescribeCountersRequest request;

        public DescribeCountersTask(DescribeCountersRequest request, AsyncAction<AsyncResult<DescribeCountersResult>> userCallback) {
            super((Gs2RestSession)Gs2LimitRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeCountersResult parse(JsonNode data) {
            return DescribeCountersResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "limit").replace("{region}", Gs2LimitRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/counter";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getLimitName() != null) {
                queryStrings.add("limitName=" + EncodingUtil.urlEncode(String.valueOf(this.request.getLimitName())));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class DescribeCountersByUserIdTask
    extends Gs2RestSessionTask<DescribeCountersByUserIdResult> {
        private DescribeCountersByUserIdRequest request;

        public DescribeCountersByUserIdTask(DescribeCountersByUserIdRequest request, AsyncAction<AsyncResult<DescribeCountersByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2LimitRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeCountersByUserIdResult parse(JsonNode data) {
            return DescribeCountersByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "limit").replace("{region}", Gs2LimitRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/counter";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getLimitName() != null) {
                queryStrings.add("limitName=" + EncodingUtil.urlEncode(String.valueOf(this.request.getLimitName())));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetCounterTask
    extends Gs2RestSessionTask<GetCounterResult> {
        private GetCounterRequest request;

        public GetCounterTask(GetCounterRequest request, AsyncAction<AsyncResult<GetCounterResult>> userCallback) {
            super((Gs2RestSession)Gs2LimitRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetCounterResult parse(JsonNode data) {
            return GetCounterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "limit").replace("{region}", Gs2LimitRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/counter/{limitName}/{counterName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{limitName}", this.request.getLimitName() == null || this.request.getLimitName().length() == 0 ? "null" : String.valueOf(this.request.getLimitName()));
            url = url.replace("{counterName}", this.request.getCounterName() == null || this.request.getCounterName().length() == 0 ? "null" : String.valueOf(this.request.getCounterName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class GetCounterByUserIdTask
    extends Gs2RestSessionTask<GetCounterByUserIdResult> {
        private GetCounterByUserIdRequest request;

        public GetCounterByUserIdTask(GetCounterByUserIdRequest request, AsyncAction<AsyncResult<GetCounterByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2LimitRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetCounterByUserIdResult parse(JsonNode data) {
            return GetCounterByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "limit").replace("{region}", Gs2LimitRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/counter/{limitName}/{counterName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{limitName}", this.request.getLimitName() == null || this.request.getLimitName().length() == 0 ? "null" : String.valueOf(this.request.getLimitName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{counterName}", this.request.getCounterName() == null || this.request.getCounterName().length() == 0 ? "null" : String.valueOf(this.request.getCounterName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CountUpTask
    extends Gs2RestSessionTask<CountUpResult> {
        private CountUpRequest request;

        public CountUpTask(CountUpRequest request, AsyncAction<AsyncResult<CountUpResult>> userCallback) {
            super((Gs2RestSession)Gs2LimitRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CountUpResult parse(JsonNode data) {
            return CountUpResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "limit").replace("{region}", Gs2LimitRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/counter/{limitName}/{counterName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{limitName}", this.request.getLimitName() == null || this.request.getLimitName().length() == 0 ? "null" : String.valueOf(this.request.getLimitName()));
            url = url.replace("{counterName}", this.request.getCounterName() == null || this.request.getCounterName().length() == 0 ? "null" : String.valueOf(this.request.getCounterName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("countUpValue", CountUpTask.this.request.getCountUpValue());
                    this.put("maxValue", CountUpTask.this.request.getMaxValue());
                    this.put("contextStack", CountUpTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CountUpByUserIdTask
    extends Gs2RestSessionTask<CountUpByUserIdResult> {
        private CountUpByUserIdRequest request;

        public CountUpByUserIdTask(CountUpByUserIdRequest request, AsyncAction<AsyncResult<CountUpByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2LimitRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CountUpByUserIdResult parse(JsonNode data) {
            return CountUpByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "limit").replace("{region}", Gs2LimitRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/counter/{limitName}/{counterName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{limitName}", this.request.getLimitName() == null || this.request.getLimitName().length() == 0 ? "null" : String.valueOf(this.request.getLimitName()));
            url = url.replace("{counterName}", this.request.getCounterName() == null || this.request.getCounterName().length() == 0 ? "null" : String.valueOf(this.request.getCounterName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("countUpValue", CountUpByUserIdTask.this.request.getCountUpValue());
                    this.put("maxValue", CountUpByUserIdTask.this.request.getMaxValue());
                    this.put("contextStack", CountUpByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CountDownByUserIdTask
    extends Gs2RestSessionTask<CountDownByUserIdResult> {
        private CountDownByUserIdRequest request;

        public CountDownByUserIdTask(CountDownByUserIdRequest request, AsyncAction<AsyncResult<CountDownByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2LimitRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CountDownByUserIdResult parse(JsonNode data) {
            return CountDownByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "limit").replace("{region}", Gs2LimitRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/counter/{limitName}/{counterName}/decrease";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{limitName}", this.request.getLimitName() == null || this.request.getLimitName().length() == 0 ? "null" : String.valueOf(this.request.getLimitName()));
            url = url.replace("{counterName}", this.request.getCounterName() == null || this.request.getCounterName().length() == 0 ? "null" : String.valueOf(this.request.getCounterName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("countDownValue", CountDownByUserIdTask.this.request.getCountDownValue());
                    this.put("contextStack", CountDownByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DeleteCounterByUserIdTask
    extends Gs2RestSessionTask<DeleteCounterByUserIdResult> {
        private DeleteCounterByUserIdRequest request;

        public DeleteCounterByUserIdTask(DeleteCounterByUserIdRequest request, AsyncAction<AsyncResult<DeleteCounterByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2LimitRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteCounterByUserIdResult parse(JsonNode data) {
            return DeleteCounterByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "limit").replace("{region}", Gs2LimitRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/counter/{limitName}/{counterName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{limitName}", this.request.getLimitName() == null || this.request.getLimitName().length() == 0 ? "null" : String.valueOf(this.request.getLimitName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{counterName}", this.request.getCounterName() == null || this.request.getCounterName().length() == 0 ? "null" : String.valueOf(this.request.getCounterName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class CountUpByStampTaskTask
    extends Gs2RestSessionTask<CountUpByStampTaskResult> {
        private CountUpByStampTaskRequest request;

        public CountUpByStampTaskTask(CountUpByStampTaskRequest request, AsyncAction<AsyncResult<CountUpByStampTaskResult>> userCallback) {
            super((Gs2RestSession)Gs2LimitRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CountUpByStampTaskResult parse(JsonNode data) {
            return CountUpByStampTaskResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "limit").replace("{region}", Gs2LimitRestClient.this.session.getRegion().getName()) + "/stamp/counter/increase";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stampTask", CountUpByStampTaskTask.this.request.getStampTask());
                    this.put("keyId", CountUpByStampTaskTask.this.request.getKeyId());
                    this.put("contextStack", CountUpByStampTaskTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CountDownByStampSheetTask
    extends Gs2RestSessionTask<CountDownByStampSheetResult> {
        private CountDownByStampSheetRequest request;

        public CountDownByStampSheetTask(CountDownByStampSheetRequest request, AsyncAction<AsyncResult<CountDownByStampSheetResult>> userCallback) {
            super((Gs2RestSession)Gs2LimitRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CountDownByStampSheetResult parse(JsonNode data) {
            return CountDownByStampSheetResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "limit").replace("{region}", Gs2LimitRestClient.this.session.getRegion().getName()) + "/stamp/counter/decrease";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stampSheet", CountDownByStampSheetTask.this.request.getStampSheet());
                    this.put("keyId", CountDownByStampSheetTask.this.request.getKeyId());
                    this.put("contextStack", CountDownByStampSheetTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteByStampSheetTask
    extends Gs2RestSessionTask<DeleteByStampSheetResult> {
        private DeleteByStampSheetRequest request;

        public DeleteByStampSheetTask(DeleteByStampSheetRequest request, AsyncAction<AsyncResult<DeleteByStampSheetResult>> userCallback) {
            super((Gs2RestSession)Gs2LimitRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteByStampSheetResult parse(JsonNode data) {
            return DeleteByStampSheetResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "limit").replace("{region}", Gs2LimitRestClient.this.session.getRegion().getName()) + "/stamp/counter/delete";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stampSheet", DeleteByStampSheetTask.this.request.getStampSheet());
                    this.put("keyId", DeleteByStampSheetTask.this.request.getKeyId());
                    this.put("contextStack", DeleteByStampSheetTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeLimitModelMastersTask
    extends Gs2RestSessionTask<DescribeLimitModelMastersResult> {
        private DescribeLimitModelMastersRequest request;

        public DescribeLimitModelMastersTask(DescribeLimitModelMastersRequest request, AsyncAction<AsyncResult<DescribeLimitModelMastersResult>> userCallback) {
            super((Gs2RestSession)Gs2LimitRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeLimitModelMastersResult parse(JsonNode data) {
            return DescribeLimitModelMastersResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "limit").replace("{region}", Gs2LimitRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/limit";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateLimitModelMasterTask
    extends Gs2RestSessionTask<CreateLimitModelMasterResult> {
        private CreateLimitModelMasterRequest request;

        public CreateLimitModelMasterTask(CreateLimitModelMasterRequest request, AsyncAction<AsyncResult<CreateLimitModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2LimitRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateLimitModelMasterResult parse(JsonNode data) {
            return CreateLimitModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "limit").replace("{region}", Gs2LimitRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/limit";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateLimitModelMasterTask.this.request.getName());
                    this.put("description", CreateLimitModelMasterTask.this.request.getDescription());
                    this.put("metadata", CreateLimitModelMasterTask.this.request.getMetadata());
                    this.put("resetType", CreateLimitModelMasterTask.this.request.getResetType());
                    this.put("resetDayOfMonth", CreateLimitModelMasterTask.this.request.getResetDayOfMonth());
                    this.put("resetDayOfWeek", CreateLimitModelMasterTask.this.request.getResetDayOfWeek());
                    this.put("resetHour", CreateLimitModelMasterTask.this.request.getResetHour());
                    this.put("contextStack", CreateLimitModelMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetLimitModelMasterTask
    extends Gs2RestSessionTask<GetLimitModelMasterResult> {
        private GetLimitModelMasterRequest request;

        public GetLimitModelMasterTask(GetLimitModelMasterRequest request, AsyncAction<AsyncResult<GetLimitModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2LimitRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetLimitModelMasterResult parse(JsonNode data) {
            return GetLimitModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "limit").replace("{region}", Gs2LimitRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/limit/{limitName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{limitName}", this.request.getLimitName() == null || this.request.getLimitName().length() == 0 ? "null" : String.valueOf(this.request.getLimitName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateLimitModelMasterTask
    extends Gs2RestSessionTask<UpdateLimitModelMasterResult> {
        private UpdateLimitModelMasterRequest request;

        public UpdateLimitModelMasterTask(UpdateLimitModelMasterRequest request, AsyncAction<AsyncResult<UpdateLimitModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2LimitRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateLimitModelMasterResult parse(JsonNode data) {
            return UpdateLimitModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "limit").replace("{region}", Gs2LimitRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/limit/{limitName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{limitName}", this.request.getLimitName() == null || this.request.getLimitName().length() == 0 ? "null" : String.valueOf(this.request.getLimitName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateLimitModelMasterTask.this.request.getDescription());
                    this.put("metadata", UpdateLimitModelMasterTask.this.request.getMetadata());
                    this.put("resetType", UpdateLimitModelMasterTask.this.request.getResetType());
                    this.put("resetDayOfMonth", UpdateLimitModelMasterTask.this.request.getResetDayOfMonth());
                    this.put("resetDayOfWeek", UpdateLimitModelMasterTask.this.request.getResetDayOfWeek());
                    this.put("resetHour", UpdateLimitModelMasterTask.this.request.getResetHour());
                    this.put("contextStack", UpdateLimitModelMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteLimitModelMasterTask
    extends Gs2RestSessionTask<DeleteLimitModelMasterResult> {
        private DeleteLimitModelMasterRequest request;

        public DeleteLimitModelMasterTask(DeleteLimitModelMasterRequest request, AsyncAction<AsyncResult<DeleteLimitModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2LimitRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteLimitModelMasterResult parse(JsonNode data) {
            return DeleteLimitModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "limit").replace("{region}", Gs2LimitRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/limit/{limitName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{limitName}", this.request.getLimitName() == null || this.request.getLimitName().length() == 0 ? "null" : String.valueOf(this.request.getLimitName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class ExportMasterTask
    extends Gs2RestSessionTask<ExportMasterResult> {
        private ExportMasterRequest request;

        public ExportMasterTask(ExportMasterRequest request, AsyncAction<AsyncResult<ExportMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2LimitRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ExportMasterResult parse(JsonNode data) {
            return ExportMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "limit").replace("{region}", Gs2LimitRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/export";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetCurrentLimitMasterTask
    extends Gs2RestSessionTask<GetCurrentLimitMasterResult> {
        private GetCurrentLimitMasterRequest request;

        public GetCurrentLimitMasterTask(GetCurrentLimitMasterRequest request, AsyncAction<AsyncResult<GetCurrentLimitMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2LimitRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetCurrentLimitMasterResult parse(JsonNode data) {
            return GetCurrentLimitMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "limit").replace("{region}", Gs2LimitRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateCurrentLimitMasterTask
    extends Gs2RestSessionTask<UpdateCurrentLimitMasterResult> {
        private UpdateCurrentLimitMasterRequest request;

        public UpdateCurrentLimitMasterTask(UpdateCurrentLimitMasterRequest request, AsyncAction<AsyncResult<UpdateCurrentLimitMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2LimitRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateCurrentLimitMasterResult parse(JsonNode data) {
            return UpdateCurrentLimitMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "limit").replace("{region}", Gs2LimitRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("settings", UpdateCurrentLimitMasterTask.this.request.getSettings());
                    this.put("contextStack", UpdateCurrentLimitMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateCurrentLimitMasterFromGitHubTask
    extends Gs2RestSessionTask<UpdateCurrentLimitMasterFromGitHubResult> {
        private UpdateCurrentLimitMasterFromGitHubRequest request;

        public UpdateCurrentLimitMasterFromGitHubTask(UpdateCurrentLimitMasterFromGitHubRequest request, AsyncAction<AsyncResult<UpdateCurrentLimitMasterFromGitHubResult>> userCallback) {
            super((Gs2RestSession)Gs2LimitRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateCurrentLimitMasterFromGitHubResult parse(JsonNode data) {
            return UpdateCurrentLimitMasterFromGitHubResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "limit").replace("{region}", Gs2LimitRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/from_git_hub";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("checkoutSetting", UpdateCurrentLimitMasterFromGitHubTask.this.request.getCheckoutSetting() != null ? UpdateCurrentLimitMasterFromGitHubTask.this.request.getCheckoutSetting().toJson() : null);
                    this.put("contextStack", UpdateCurrentLimitMasterFromGitHubTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeLimitModelsTask
    extends Gs2RestSessionTask<DescribeLimitModelsResult> {
        private DescribeLimitModelsRequest request;

        public DescribeLimitModelsTask(DescribeLimitModelsRequest request, AsyncAction<AsyncResult<DescribeLimitModelsResult>> userCallback) {
            super((Gs2RestSession)Gs2LimitRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeLimitModelsResult parse(JsonNode data) {
            return DescribeLimitModelsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "limit").replace("{region}", Gs2LimitRestClient.this.session.getRegion().getName()) + "/{namespaceName}/limit";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetLimitModelTask
    extends Gs2RestSessionTask<GetLimitModelResult> {
        private GetLimitModelRequest request;

        public GetLimitModelTask(GetLimitModelRequest request, AsyncAction<AsyncResult<GetLimitModelResult>> userCallback) {
            super((Gs2RestSession)Gs2LimitRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetLimitModelResult parse(JsonNode data) {
            return GetLimitModelResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "limit").replace("{region}", Gs2LimitRestClient.this.session.getRegion().getName()) + "/{namespaceName}/limit/{limitName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{limitName}", this.request.getLimitName() == null || this.request.getLimitName().length() == 0 ? "null" : String.valueOf(this.request.getLimitName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }
}

