/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.dictionary;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.core.AbstractGs2Client;
import io.gs2.core.model.AsyncAction;
import io.gs2.core.model.AsyncResult;
import io.gs2.core.net.Gs2RestSession;
import io.gs2.core.net.Gs2RestSessionTask;
import io.gs2.core.net.HttpTask;
import io.gs2.core.util.EncodingUtil;
import io.gs2.dictionary.request.AddEntriesByStampSheetRequest;
import io.gs2.dictionary.request.AddEntriesByUserIdRequest;
import io.gs2.dictionary.request.CreateEntryModelMasterRequest;
import io.gs2.dictionary.request.CreateNamespaceRequest;
import io.gs2.dictionary.request.DeleteEntriesByStampTaskRequest;
import io.gs2.dictionary.request.DeleteEntriesByUserIdRequest;
import io.gs2.dictionary.request.DeleteEntryModelMasterRequest;
import io.gs2.dictionary.request.DeleteNamespaceRequest;
import io.gs2.dictionary.request.DescribeEntriesByUserIdRequest;
import io.gs2.dictionary.request.DescribeEntriesRequest;
import io.gs2.dictionary.request.DescribeEntryModelMastersRequest;
import io.gs2.dictionary.request.DescribeEntryModelsRequest;
import io.gs2.dictionary.request.DescribeNamespacesRequest;
import io.gs2.dictionary.request.ExportMasterRequest;
import io.gs2.dictionary.request.GetCurrentEntryMasterRequest;
import io.gs2.dictionary.request.GetEntryByUserIdRequest;
import io.gs2.dictionary.request.GetEntryModelMasterRequest;
import io.gs2.dictionary.request.GetEntryModelRequest;
import io.gs2.dictionary.request.GetEntryRequest;
import io.gs2.dictionary.request.GetEntryWithSignatureByUserIdRequest;
import io.gs2.dictionary.request.GetEntryWithSignatureRequest;
import io.gs2.dictionary.request.GetNamespaceRequest;
import io.gs2.dictionary.request.GetNamespaceStatusRequest;
import io.gs2.dictionary.request.ResetByUserIdRequest;
import io.gs2.dictionary.request.UpdateCurrentEntryMasterFromGitHubRequest;
import io.gs2.dictionary.request.UpdateCurrentEntryMasterRequest;
import io.gs2.dictionary.request.UpdateEntryModelMasterRequest;
import io.gs2.dictionary.request.UpdateNamespaceRequest;
import io.gs2.dictionary.result.AddEntriesByStampSheetResult;
import io.gs2.dictionary.result.AddEntriesByUserIdResult;
import io.gs2.dictionary.result.CreateEntryModelMasterResult;
import io.gs2.dictionary.result.CreateNamespaceResult;
import io.gs2.dictionary.result.DeleteEntriesByStampTaskResult;
import io.gs2.dictionary.result.DeleteEntriesByUserIdResult;
import io.gs2.dictionary.result.DeleteEntryModelMasterResult;
import io.gs2.dictionary.result.DeleteNamespaceResult;
import io.gs2.dictionary.result.DescribeEntriesByUserIdResult;
import io.gs2.dictionary.result.DescribeEntriesResult;
import io.gs2.dictionary.result.DescribeEntryModelMastersResult;
import io.gs2.dictionary.result.DescribeEntryModelsResult;
import io.gs2.dictionary.result.DescribeNamespacesResult;
import io.gs2.dictionary.result.ExportMasterResult;
import io.gs2.dictionary.result.GetCurrentEntryMasterResult;
import io.gs2.dictionary.result.GetEntryByUserIdResult;
import io.gs2.dictionary.result.GetEntryModelMasterResult;
import io.gs2.dictionary.result.GetEntryModelResult;
import io.gs2.dictionary.result.GetEntryResult;
import io.gs2.dictionary.result.GetEntryWithSignatureByUserIdResult;
import io.gs2.dictionary.result.GetEntryWithSignatureResult;
import io.gs2.dictionary.result.GetNamespaceResult;
import io.gs2.dictionary.result.GetNamespaceStatusResult;
import io.gs2.dictionary.result.ResetByUserIdResult;
import io.gs2.dictionary.result.UpdateCurrentEntryMasterFromGitHubResult;
import io.gs2.dictionary.result.UpdateCurrentEntryMasterResult;
import io.gs2.dictionary.result.UpdateEntryModelMasterResult;
import io.gs2.dictionary.result.UpdateNamespaceResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.stream.Collectors;

public class Gs2DictionaryRestClient
extends AbstractGs2Client<Gs2DictionaryRestClient> {
    public Gs2DictionaryRestClient(Gs2RestSession gs2RestSession) {
        super(gs2RestSession);
    }

    public void describeNamespacesAsync(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> callback) {
        DescribeNamespacesTask task = new DescribeNamespacesTask(request, callback);
        this.session.execute(task);
    }

    public DescribeNamespacesResult describeNamespaces(DescribeNamespacesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeNamespacesAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeNamespacesResult)resultAsyncResult[0].getResult();
    }

    public void createNamespaceAsync(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> callback) {
        CreateNamespaceTask task = new CreateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public CreateNamespaceResult createNamespace(CreateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceStatusAsync(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> callback) {
        GetNamespaceStatusTask task = new GetNamespaceStatusTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceStatusResult getNamespaceStatus(GetNamespaceStatusRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceStatusAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceStatusResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceAsync(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> callback) {
        GetNamespaceTask task = new GetNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public GetNamespaceResult getNamespace(GetNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void updateNamespaceAsync(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> callback) {
        UpdateNamespaceTask task = new UpdateNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public UpdateNamespaceResult updateNamespace(UpdateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void deleteNamespaceAsync(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> callback) {
        DeleteNamespaceTask task = new DeleteNamespaceTask(request, callback);
        this.session.execute(task);
    }

    public DeleteNamespaceResult deleteNamespace(DeleteNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteNamespaceAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void describeEntryModelsAsync(DescribeEntryModelsRequest request, AsyncAction<AsyncResult<DescribeEntryModelsResult>> callback) {
        DescribeEntryModelsTask task = new DescribeEntryModelsTask(request, callback);
        this.session.execute(task);
    }

    public DescribeEntryModelsResult describeEntryModels(DescribeEntryModelsRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeEntryModelsAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeEntryModelsResult)resultAsyncResult[0].getResult();
    }

    public void getEntryModelAsync(GetEntryModelRequest request, AsyncAction<AsyncResult<GetEntryModelResult>> callback) {
        GetEntryModelTask task = new GetEntryModelTask(request, callback);
        this.session.execute(task);
    }

    public GetEntryModelResult getEntryModel(GetEntryModelRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getEntryModelAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetEntryModelResult)resultAsyncResult[0].getResult();
    }

    public void describeEntryModelMastersAsync(DescribeEntryModelMastersRequest request, AsyncAction<AsyncResult<DescribeEntryModelMastersResult>> callback) {
        DescribeEntryModelMastersTask task = new DescribeEntryModelMastersTask(request, callback);
        this.session.execute(task);
    }

    public DescribeEntryModelMastersResult describeEntryModelMasters(DescribeEntryModelMastersRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeEntryModelMastersAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeEntryModelMastersResult)resultAsyncResult[0].getResult();
    }

    public void createEntryModelMasterAsync(CreateEntryModelMasterRequest request, AsyncAction<AsyncResult<CreateEntryModelMasterResult>> callback) {
        CreateEntryModelMasterTask task = new CreateEntryModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public CreateEntryModelMasterResult createEntryModelMaster(CreateEntryModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createEntryModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateEntryModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void getEntryModelMasterAsync(GetEntryModelMasterRequest request, AsyncAction<AsyncResult<GetEntryModelMasterResult>> callback) {
        GetEntryModelMasterTask task = new GetEntryModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public GetEntryModelMasterResult getEntryModelMaster(GetEntryModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getEntryModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetEntryModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateEntryModelMasterAsync(UpdateEntryModelMasterRequest request, AsyncAction<AsyncResult<UpdateEntryModelMasterResult>> callback) {
        UpdateEntryModelMasterTask task = new UpdateEntryModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public UpdateEntryModelMasterResult updateEntryModelMaster(UpdateEntryModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateEntryModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateEntryModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void deleteEntryModelMasterAsync(DeleteEntryModelMasterRequest request, AsyncAction<AsyncResult<DeleteEntryModelMasterResult>> callback) {
        DeleteEntryModelMasterTask task = new DeleteEntryModelMasterTask(request, callback);
        this.session.execute(task);
    }

    public DeleteEntryModelMasterResult deleteEntryModelMaster(DeleteEntryModelMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteEntryModelMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteEntryModelMasterResult)resultAsyncResult[0].getResult();
    }

    public void describeEntriesAsync(DescribeEntriesRequest request, AsyncAction<AsyncResult<DescribeEntriesResult>> callback) {
        DescribeEntriesTask task = new DescribeEntriesTask(request, callback);
        this.session.execute(task);
    }

    public DescribeEntriesResult describeEntries(DescribeEntriesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeEntriesAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeEntriesResult)resultAsyncResult[0].getResult();
    }

    public void describeEntriesByUserIdAsync(DescribeEntriesByUserIdRequest request, AsyncAction<AsyncResult<DescribeEntriesByUserIdResult>> callback) {
        DescribeEntriesByUserIdTask task = new DescribeEntriesByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DescribeEntriesByUserIdResult describeEntriesByUserId(DescribeEntriesByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeEntriesByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeEntriesByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void addEntriesByUserIdAsync(AddEntriesByUserIdRequest request, AsyncAction<AsyncResult<AddEntriesByUserIdResult>> callback) {
        AddEntriesByUserIdTask task = new AddEntriesByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public AddEntriesByUserIdResult addEntriesByUserId(AddEntriesByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.addEntriesByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (AddEntriesByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void getEntryAsync(GetEntryRequest request, AsyncAction<AsyncResult<GetEntryResult>> callback) {
        GetEntryTask task = new GetEntryTask(request, callback);
        this.session.execute(task);
    }

    public GetEntryResult getEntry(GetEntryRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getEntryAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetEntryResult)resultAsyncResult[0].getResult();
    }

    public void getEntryByUserIdAsync(GetEntryByUserIdRequest request, AsyncAction<AsyncResult<GetEntryByUserIdResult>> callback) {
        GetEntryByUserIdTask task = new GetEntryByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public GetEntryByUserIdResult getEntryByUserId(GetEntryByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getEntryByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetEntryByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void getEntryWithSignatureAsync(GetEntryWithSignatureRequest request, AsyncAction<AsyncResult<GetEntryWithSignatureResult>> callback) {
        GetEntryWithSignatureTask task = new GetEntryWithSignatureTask(request, callback);
        this.session.execute(task);
    }

    public GetEntryWithSignatureResult getEntryWithSignature(GetEntryWithSignatureRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getEntryWithSignatureAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetEntryWithSignatureResult)resultAsyncResult[0].getResult();
    }

    public void getEntryWithSignatureByUserIdAsync(GetEntryWithSignatureByUserIdRequest request, AsyncAction<AsyncResult<GetEntryWithSignatureByUserIdResult>> callback) {
        GetEntryWithSignatureByUserIdTask task = new GetEntryWithSignatureByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public GetEntryWithSignatureByUserIdResult getEntryWithSignatureByUserId(GetEntryWithSignatureByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getEntryWithSignatureByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetEntryWithSignatureByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void resetByUserIdAsync(ResetByUserIdRequest request, AsyncAction<AsyncResult<ResetByUserIdResult>> callback) {
        ResetByUserIdTask task = new ResetByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public ResetByUserIdResult resetByUserId(ResetByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.resetByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ResetByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void deleteEntriesByUserIdAsync(DeleteEntriesByUserIdRequest request, AsyncAction<AsyncResult<DeleteEntriesByUserIdResult>> callback) {
        DeleteEntriesByUserIdTask task = new DeleteEntriesByUserIdTask(request, callback);
        this.session.execute(task);
    }

    public DeleteEntriesByUserIdResult deleteEntriesByUserId(DeleteEntriesByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteEntriesByUserIdAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteEntriesByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void addEntriesByStampSheetAsync(AddEntriesByStampSheetRequest request, AsyncAction<AsyncResult<AddEntriesByStampSheetResult>> callback) {
        AddEntriesByStampSheetTask task = new AddEntriesByStampSheetTask(request, callback);
        this.session.execute(task);
    }

    public AddEntriesByStampSheetResult addEntriesByStampSheet(AddEntriesByStampSheetRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.addEntriesByStampSheetAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (AddEntriesByStampSheetResult)resultAsyncResult[0].getResult();
    }

    public void deleteEntriesByStampTaskAsync(DeleteEntriesByStampTaskRequest request, AsyncAction<AsyncResult<DeleteEntriesByStampTaskResult>> callback) {
        DeleteEntriesByStampTaskTask task = new DeleteEntriesByStampTaskTask(request, callback);
        this.session.execute(task);
    }

    public DeleteEntriesByStampTaskResult deleteEntriesByStampTask(DeleteEntriesByStampTaskRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteEntriesByStampTaskAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteEntriesByStampTaskResult)resultAsyncResult[0].getResult();
    }

    public void exportMasterAsync(ExportMasterRequest request, AsyncAction<AsyncResult<ExportMasterResult>> callback) {
        ExportMasterTask task = new ExportMasterTask(request, callback);
        this.session.execute(task);
    }

    public ExportMasterResult exportMaster(ExportMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.exportMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ExportMasterResult)resultAsyncResult[0].getResult();
    }

    public void getCurrentEntryMasterAsync(GetCurrentEntryMasterRequest request, AsyncAction<AsyncResult<GetCurrentEntryMasterResult>> callback) {
        GetCurrentEntryMasterTask task = new GetCurrentEntryMasterTask(request, callback);
        this.session.execute(task);
    }

    public GetCurrentEntryMasterResult getCurrentEntryMaster(GetCurrentEntryMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getCurrentEntryMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetCurrentEntryMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateCurrentEntryMasterAsync(UpdateCurrentEntryMasterRequest request, AsyncAction<AsyncResult<UpdateCurrentEntryMasterResult>> callback) {
        UpdateCurrentEntryMasterTask task = new UpdateCurrentEntryMasterTask(request, callback);
        this.session.execute(task);
    }

    public UpdateCurrentEntryMasterResult updateCurrentEntryMaster(UpdateCurrentEntryMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateCurrentEntryMasterAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateCurrentEntryMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateCurrentEntryMasterFromGitHubAsync(UpdateCurrentEntryMasterFromGitHubRequest request, AsyncAction<AsyncResult<UpdateCurrentEntryMasterFromGitHubResult>> callback) {
        UpdateCurrentEntryMasterFromGitHubTask task = new UpdateCurrentEntryMasterFromGitHubTask(request, callback);
        this.session.execute(task);
    }

    public UpdateCurrentEntryMasterFromGitHubResult updateCurrentEntryMasterFromGitHub(UpdateCurrentEntryMasterFromGitHubRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateCurrentEntryMasterFromGitHubAsync(request, result -> {
            resultAsyncResult[0] = result;
        });
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateCurrentEntryMasterFromGitHubResult)resultAsyncResult[0].getResult();
    }

    class DescribeNamespacesTask
    extends Gs2RestSessionTask<DescribeNamespacesResult> {
        private DescribeNamespacesRequest request;

        public DescribeNamespacesTask(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> userCallback) {
            super((Gs2RestSession)Gs2DictionaryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeNamespacesResult parse(JsonNode data) {
            return DescribeNamespacesResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "dictionary").replace("{region}", Gs2DictionaryRestClient.this.session.getRegion().getName()) + "/";
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateNamespaceTask
    extends Gs2RestSessionTask<CreateNamespaceResult> {
        private CreateNamespaceRequest request;

        public CreateNamespaceTask(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2DictionaryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateNamespaceResult parse(JsonNode data) {
            return CreateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "dictionary").replace("{region}", Gs2DictionaryRestClient.this.session.getRegion().getName()) + "/";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateNamespaceTask.this.request.getName());
                    this.put("description", CreateNamespaceTask.this.request.getDescription());
                    this.put("entryScript", CreateNamespaceTask.this.request.getEntryScript() != null ? CreateNamespaceTask.this.request.getEntryScript().toJson() : null);
                    this.put("duplicateEntryScript", CreateNamespaceTask.this.request.getDuplicateEntryScript() != null ? CreateNamespaceTask.this.request.getDuplicateEntryScript().toJson() : null);
                    this.put("logSetting", CreateNamespaceTask.this.request.getLogSetting() != null ? CreateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("contextStack", CreateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceStatusTask
    extends Gs2RestSessionTask<GetNamespaceStatusResult> {
        private GetNamespaceStatusRequest request;

        public GetNamespaceStatusTask(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> userCallback) {
            super((Gs2RestSession)Gs2DictionaryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceStatusResult parse(JsonNode data) {
            return GetNamespaceStatusResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "dictionary").replace("{region}", Gs2DictionaryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/status";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceTask
    extends Gs2RestSessionTask<GetNamespaceResult> {
        private GetNamespaceRequest request;

        public GetNamespaceTask(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2DictionaryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetNamespaceResult parse(JsonNode data) {
            return GetNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "dictionary").replace("{region}", Gs2DictionaryRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateNamespaceTask
    extends Gs2RestSessionTask<UpdateNamespaceResult> {
        private UpdateNamespaceRequest request;

        public UpdateNamespaceTask(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2DictionaryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateNamespaceResult parse(JsonNode data) {
            return UpdateNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "dictionary").replace("{region}", Gs2DictionaryRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateNamespaceTask.this.request.getDescription());
                    this.put("entryScript", UpdateNamespaceTask.this.request.getEntryScript() != null ? UpdateNamespaceTask.this.request.getEntryScript().toJson() : null);
                    this.put("duplicateEntryScript", UpdateNamespaceTask.this.request.getDuplicateEntryScript() != null ? UpdateNamespaceTask.this.request.getDuplicateEntryScript().toJson() : null);
                    this.put("logSetting", UpdateNamespaceTask.this.request.getLogSetting() != null ? UpdateNamespaceTask.this.request.getLogSetting().toJson() : null);
                    this.put("contextStack", UpdateNamespaceTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteNamespaceTask
    extends Gs2RestSessionTask<DeleteNamespaceResult> {
        private DeleteNamespaceRequest request;

        public DeleteNamespaceTask(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> userCallback) {
            super((Gs2RestSession)Gs2DictionaryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteNamespaceResult parse(JsonNode data) {
            return DeleteNamespaceResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "dictionary").replace("{region}", Gs2DictionaryRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeEntryModelsTask
    extends Gs2RestSessionTask<DescribeEntryModelsResult> {
        private DescribeEntryModelsRequest request;

        public DescribeEntryModelsTask(DescribeEntryModelsRequest request, AsyncAction<AsyncResult<DescribeEntryModelsResult>> userCallback) {
            super((Gs2RestSession)Gs2DictionaryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeEntryModelsResult parse(JsonNode data) {
            return DescribeEntryModelsResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "dictionary").replace("{region}", Gs2DictionaryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/model";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetEntryModelTask
    extends Gs2RestSessionTask<GetEntryModelResult> {
        private GetEntryModelRequest request;

        public GetEntryModelTask(GetEntryModelRequest request, AsyncAction<AsyncResult<GetEntryModelResult>> userCallback) {
            super((Gs2RestSession)Gs2DictionaryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetEntryModelResult parse(JsonNode data) {
            return GetEntryModelResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "dictionary").replace("{region}", Gs2DictionaryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/model/{entryName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{entryName}", this.request.getEntryName() == null || this.request.getEntryName().length() == 0 ? "null" : String.valueOf(this.request.getEntryName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeEntryModelMastersTask
    extends Gs2RestSessionTask<DescribeEntryModelMastersResult> {
        private DescribeEntryModelMastersRequest request;

        public DescribeEntryModelMastersTask(DescribeEntryModelMastersRequest request, AsyncAction<AsyncResult<DescribeEntryModelMastersResult>> userCallback) {
            super((Gs2RestSession)Gs2DictionaryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeEntryModelMastersResult parse(JsonNode data) {
            return DescribeEntryModelMastersResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "dictionary").replace("{region}", Gs2DictionaryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/model";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateEntryModelMasterTask
    extends Gs2RestSessionTask<CreateEntryModelMasterResult> {
        private CreateEntryModelMasterRequest request;

        public CreateEntryModelMasterTask(CreateEntryModelMasterRequest request, AsyncAction<AsyncResult<CreateEntryModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2DictionaryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public CreateEntryModelMasterResult parse(JsonNode data) {
            return CreateEntryModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "dictionary").replace("{region}", Gs2DictionaryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/model";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("name", CreateEntryModelMasterTask.this.request.getName());
                    this.put("description", CreateEntryModelMasterTask.this.request.getDescription());
                    this.put("metadata", CreateEntryModelMasterTask.this.request.getMetadata());
                    this.put("contextStack", CreateEntryModelMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetEntryModelMasterTask
    extends Gs2RestSessionTask<GetEntryModelMasterResult> {
        private GetEntryModelMasterRequest request;

        public GetEntryModelMasterTask(GetEntryModelMasterRequest request, AsyncAction<AsyncResult<GetEntryModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2DictionaryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetEntryModelMasterResult parse(JsonNode data) {
            return GetEntryModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "dictionary").replace("{region}", Gs2DictionaryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/model/{entryName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{entryName}", this.request.getEntryName() == null || this.request.getEntryName().length() == 0 ? "null" : String.valueOf(this.request.getEntryName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateEntryModelMasterTask
    extends Gs2RestSessionTask<UpdateEntryModelMasterResult> {
        private UpdateEntryModelMasterRequest request;

        public UpdateEntryModelMasterTask(UpdateEntryModelMasterRequest request, AsyncAction<AsyncResult<UpdateEntryModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2DictionaryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateEntryModelMasterResult parse(JsonNode data) {
            return UpdateEntryModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "dictionary").replace("{region}", Gs2DictionaryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/model/{entryName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{entryName}", this.request.getEntryName() == null || this.request.getEntryName().length() == 0 ? "null" : String.valueOf(this.request.getEntryName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("description", UpdateEntryModelMasterTask.this.request.getDescription());
                    this.put("metadata", UpdateEntryModelMasterTask.this.request.getMetadata());
                    this.put("contextStack", UpdateEntryModelMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteEntryModelMasterTask
    extends Gs2RestSessionTask<DeleteEntryModelMasterResult> {
        private DeleteEntryModelMasterRequest request;

        public DeleteEntryModelMasterTask(DeleteEntryModelMasterRequest request, AsyncAction<AsyncResult<DeleteEntryModelMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2DictionaryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteEntryModelMasterResult parse(JsonNode data) {
            return DeleteEntryModelMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "dictionary").replace("{region}", Gs2DictionaryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/model/{entryName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{entryName}", this.request.getEntryName() == null || this.request.getEntryName().length() == 0 ? "null" : String.valueOf(this.request.getEntryName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeEntriesTask
    extends Gs2RestSessionTask<DescribeEntriesResult> {
        private DescribeEntriesRequest request;

        public DescribeEntriesTask(DescribeEntriesRequest request, AsyncAction<AsyncResult<DescribeEntriesResult>> userCallback) {
            super((Gs2RestSession)Gs2DictionaryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeEntriesResult parse(JsonNode data) {
            return DescribeEntriesResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "dictionary").replace("{region}", Gs2DictionaryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/entry";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class DescribeEntriesByUserIdTask
    extends Gs2RestSessionTask<DescribeEntriesByUserIdResult> {
        private DescribeEntriesByUserIdRequest request;

        public DescribeEntriesByUserIdTask(DescribeEntriesByUserIdRequest request, AsyncAction<AsyncResult<DescribeEntriesByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2DictionaryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DescribeEntriesByUserIdResult parse(JsonNode data) {
            return DescribeEntriesByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "dictionary").replace("{region}", Gs2DictionaryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/entry";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode(String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class AddEntriesByUserIdTask
    extends Gs2RestSessionTask<AddEntriesByUserIdResult> {
        private AddEntriesByUserIdRequest request;

        public AddEntriesByUserIdTask(AddEntriesByUserIdRequest request, AsyncAction<AsyncResult<AddEntriesByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2DictionaryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public AddEntriesByUserIdResult parse(JsonNode data) {
            return AddEntriesByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "dictionary").replace("{region}", Gs2DictionaryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/entry";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("entryModelNames", AddEntriesByUserIdTask.this.request.getEntryModelNames() == null ? new ArrayList() : AddEntriesByUserIdTask.this.request.getEntryModelNames().stream().map(item -> item).collect(Collectors.toList()));
                    this.put("contextStack", AddEntriesByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class GetEntryTask
    extends Gs2RestSessionTask<GetEntryResult> {
        private GetEntryRequest request;

        public GetEntryTask(GetEntryRequest request, AsyncAction<AsyncResult<GetEntryResult>> userCallback) {
            super((Gs2RestSession)Gs2DictionaryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetEntryResult parse(JsonNode data) {
            return GetEntryResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "dictionary").replace("{region}", Gs2DictionaryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/entry/{entryModelName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{entryModelName}", this.request.getEntryModelName() == null || this.request.getEntryModelName().length() == 0 ? "null" : String.valueOf(this.request.getEntryModelName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class GetEntryByUserIdTask
    extends Gs2RestSessionTask<GetEntryByUserIdResult> {
        private GetEntryByUserIdRequest request;

        public GetEntryByUserIdTask(GetEntryByUserIdRequest request, AsyncAction<AsyncResult<GetEntryByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2DictionaryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetEntryByUserIdResult parse(JsonNode data) {
            return GetEntryByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "dictionary").replace("{region}", Gs2DictionaryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/entry/{entryModelName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{entryModelName}", this.request.getEntryModelName() == null || this.request.getEntryModelName().length() == 0 ? "null" : String.valueOf(this.request.getEntryModelName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetEntryWithSignatureTask
    extends Gs2RestSessionTask<GetEntryWithSignatureResult> {
        private GetEntryWithSignatureRequest request;

        public GetEntryWithSignatureTask(GetEntryWithSignatureRequest request, AsyncAction<AsyncResult<GetEntryWithSignatureResult>> userCallback) {
            super((Gs2RestSession)Gs2DictionaryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetEntryWithSignatureResult parse(JsonNode data) {
            return GetEntryWithSignatureResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "dictionary").replace("{region}", Gs2DictionaryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/entry/{entryModelName}/signature";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{entryModelName}", this.request.getEntryModelName() == null || this.request.getEntryModelName().length() == 0 ? "null" : String.valueOf(this.request.getEntryModelName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getKeyId() != null) {
                queryStrings.add("keyId=" + EncodingUtil.urlEncode(String.valueOf(this.request.getKeyId())));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            this.builder.build().send();
        }
    }

    class GetEntryWithSignatureByUserIdTask
    extends Gs2RestSessionTask<GetEntryWithSignatureByUserIdResult> {
        private GetEntryWithSignatureByUserIdRequest request;

        public GetEntryWithSignatureByUserIdTask(GetEntryWithSignatureByUserIdRequest request, AsyncAction<AsyncResult<GetEntryWithSignatureByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2DictionaryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetEntryWithSignatureByUserIdResult parse(JsonNode data) {
            return GetEntryWithSignatureByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "dictionary").replace("{region}", Gs2DictionaryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/entry/{entryModelName}/signature";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            url = url.replace("{entryModelName}", this.request.getEntryModelName() == null || this.request.getEntryModelName().length() == 0 ? "null" : String.valueOf(this.request.getEntryModelName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            if (this.request.getKeyId() != null) {
                queryStrings.add("keyId=" + EncodingUtil.urlEncode(String.valueOf(this.request.getKeyId())));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class ResetByUserIdTask
    extends Gs2RestSessionTask<ResetByUserIdResult> {
        private ResetByUserIdRequest request;

        public ResetByUserIdTask(ResetByUserIdRequest request, AsyncAction<AsyncResult<ResetByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2DictionaryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ResetByUserIdResult parse(JsonNode data) {
            return ResetByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "dictionary").replace("{region}", Gs2DictionaryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/entry";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DeleteEntriesByUserIdTask
    extends Gs2RestSessionTask<DeleteEntriesByUserIdResult> {
        private DeleteEntriesByUserIdRequest request;

        public DeleteEntriesByUserIdTask(DeleteEntriesByUserIdRequest request, AsyncAction<AsyncResult<DeleteEntriesByUserIdResult>> userCallback) {
            super((Gs2RestSession)Gs2DictionaryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteEntriesByUserIdResult parse(JsonNode data) {
            return DeleteEntriesByUserIdResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "dictionary").replace("{region}", Gs2DictionaryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/entry/delete";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("entryModelNames", DeleteEntriesByUserIdTask.this.request.getEntryModelNames() == null ? new ArrayList() : DeleteEntriesByUserIdTask.this.request.getEntryModelNames().stream().map(item -> item).collect(Collectors.toList()));
                    this.put("contextStack", DeleteEntriesByUserIdTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class AddEntriesByStampSheetTask
    extends Gs2RestSessionTask<AddEntriesByStampSheetResult> {
        private AddEntriesByStampSheetRequest request;

        public AddEntriesByStampSheetTask(AddEntriesByStampSheetRequest request, AsyncAction<AsyncResult<AddEntriesByStampSheetResult>> userCallback) {
            super((Gs2RestSession)Gs2DictionaryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public AddEntriesByStampSheetResult parse(JsonNode data) {
            return AddEntriesByStampSheetResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "dictionary").replace("{region}", Gs2DictionaryRestClient.this.session.getRegion().getName()) + "/stamp/entry/add";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stampSheet", AddEntriesByStampSheetTask.this.request.getStampSheet());
                    this.put("keyId", AddEntriesByStampSheetTask.this.request.getKeyId());
                    this.put("contextStack", AddEntriesByStampSheetTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteEntriesByStampTaskTask
    extends Gs2RestSessionTask<DeleteEntriesByStampTaskResult> {
        private DeleteEntriesByStampTaskRequest request;

        public DeleteEntriesByStampTaskTask(DeleteEntriesByStampTaskRequest request, AsyncAction<AsyncResult<DeleteEntriesByStampTaskResult>> userCallback) {
            super((Gs2RestSession)Gs2DictionaryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public DeleteEntriesByStampTaskResult parse(JsonNode data) {
            return DeleteEntriesByStampTaskResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "dictionary").replace("{region}", Gs2DictionaryRestClient.this.session.getRegion().getName()) + "/stamp/entry/delete";
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("stampTask", DeleteEntriesByStampTaskTask.this.request.getStampTask());
                    this.put("keyId", DeleteEntriesByStampTaskTask.this.request.getKeyId());
                    this.put("contextStack", DeleteEntriesByStampTaskTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class ExportMasterTask
    extends Gs2RestSessionTask<ExportMasterResult> {
        private ExportMasterRequest request;

        public ExportMasterTask(ExportMasterRequest request, AsyncAction<AsyncResult<ExportMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2DictionaryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public ExportMasterResult parse(JsonNode data) {
            return ExportMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "dictionary").replace("{region}", Gs2DictionaryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/export";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetCurrentEntryMasterTask
    extends Gs2RestSessionTask<GetCurrentEntryMasterResult> {
        private GetCurrentEntryMasterRequest request;

        public GetCurrentEntryMasterTask(GetCurrentEntryMasterRequest request, AsyncAction<AsyncResult<GetCurrentEntryMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2DictionaryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public GetCurrentEntryMasterResult parse(JsonNode data) {
            return GetCurrentEntryMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "dictionary").replace("{region}", Gs2DictionaryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode(this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateCurrentEntryMasterTask
    extends Gs2RestSessionTask<UpdateCurrentEntryMasterResult> {
        private UpdateCurrentEntryMasterRequest request;

        public UpdateCurrentEntryMasterTask(UpdateCurrentEntryMasterRequest request, AsyncAction<AsyncResult<UpdateCurrentEntryMasterResult>> userCallback) {
            super((Gs2RestSession)Gs2DictionaryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateCurrentEntryMasterResult parse(JsonNode data) {
            return UpdateCurrentEntryMasterResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "dictionary").replace("{region}", Gs2DictionaryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("settings", UpdateCurrentEntryMasterTask.this.request.getSettings());
                    this.put("contextStack", UpdateCurrentEntryMasterTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateCurrentEntryMasterFromGitHubTask
    extends Gs2RestSessionTask<UpdateCurrentEntryMasterFromGitHubResult> {
        private UpdateCurrentEntryMasterFromGitHubRequest request;

        public UpdateCurrentEntryMasterFromGitHubTask(UpdateCurrentEntryMasterFromGitHubRequest request, AsyncAction<AsyncResult<UpdateCurrentEntryMasterFromGitHubResult>> userCallback) {
            super((Gs2RestSession)Gs2DictionaryRestClient.this.session, userCallback);
            this.request = request;
        }

        @Override
        public UpdateCurrentEntryMasterFromGitHubResult parse(JsonNode data) {
            return UpdateCurrentEntryMasterFromGitHubResult.fromJson(data);
        }

        @Override
        protected void executeImpl() {
            String url = Gs2RestSession.EndpointHost.replace("{service}", "dictionary").replace("{region}", Gs2DictionaryRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/from_git_hub";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            this.builder.setBody(new ObjectMapper().valueToTree((Object)new HashMap<String, Object>(){
                {
                    this.put("checkoutSetting", UpdateCurrentEntryMasterFromGitHubTask.this.request.getCheckoutSetting() != null ? UpdateCurrentEntryMasterFromGitHubTask.this.request.getCheckoutSetting().toJson() : null);
                    this.put("contextStack", UpdateCurrentEntryMasterFromGitHubTask.this.request.getContextStack());
                }
            }).toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler(this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }
}

