/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.variable;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.gs2.AbstractGs2Client;
import io.gs2.model.IGs2Credential;
import io.gs2.variable.control.DeleteMyVariableRequest;
import io.gs2.variable.control.DeleteVariableRequest;
import io.gs2.variable.control.GetMyVariableRequest;
import io.gs2.variable.control.GetMyVariableResult;
import io.gs2.variable.control.GetVariableRequest;
import io.gs2.variable.control.GetVariableResult;
import io.gs2.variable.control.SetMyVariableRequest;
import io.gs2.variable.control.SetMyVariableResult;
import io.gs2.variable.control.SetVariableRequest;
import io.gs2.variable.control.SetVariableResult;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;

public class Gs2VariableClient
extends AbstractGs2Client<Gs2VariableClient> {
    public static String ENDPOINT = "variable";

    public Gs2VariableClient(IGs2Credential credential) {
        super(credential);
    }

    public void deleteMyVariable(DeleteMyVariableRequest request) {
        String url = "https://{service}.{region}.gs2.io/variable/" + (request.getVariableName() == null ? "null" : request.getVariableName()) + "";
        HttpDelete delete = this.createHttpDelete(url, this.credential, ENDPOINT, "Gs2Variable", "DeleteMyVariable");
        delete.setHeader("X-GS2-ACCESS-TOKEN", request.getAccessToken());
        this.doRequest((HttpUriRequest)delete, null);
    }

    public void deleteVariable(DeleteVariableRequest request) {
        String url = "https://{service}.{region}.gs2.io/user/" + (request.getUserId() == null ? "null" : request.getUserId()) + "/variable/" + (request.getVariableName() == null ? "null" : request.getVariableName()) + "";
        HttpDelete delete = this.createHttpDelete(url, this.credential, ENDPOINT, "Gs2Variable", "DeleteVariable");
        this.doRequest((HttpUriRequest)delete, null);
    }

    public GetMyVariableResult getMyVariable(GetMyVariableRequest request) {
        String url = "https://{service}.{region}.gs2.io/variable/" + (request.getVariableName() == null ? "null" : request.getVariableName()) + "";
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Variable", "GetMyVariable");
        get.setHeader("X-GS2-ACCESS-TOKEN", request.getAccessToken());
        return (GetMyVariableResult)this.doRequest((HttpUriRequest)get, GetMyVariableResult.class);
    }

    public GetVariableResult getVariable(GetVariableRequest request) {
        String url = "https://{service}.{region}.gs2.io/user/" + (request.getUserId() == null ? "null" : request.getUserId()) + "/variable/" + (request.getVariableName() == null ? "null" : request.getVariableName()) + "";
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Variable", "GetVariable");
        return (GetVariableResult)this.doRequest((HttpUriRequest)get, GetVariableResult.class);
    }

    public SetMyVariableResult setMyVariable(SetMyVariableRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("value", request.getValue()).put("ttl", request.getTtl());
        HttpPut put = this.createHttpPut("https://{service}.{region}.gs2.io/variable/" + (request.getVariableName() == null ? "null" : request.getVariableName()) + "", this.credential, ENDPOINT, "Gs2Variable", "SetMyVariable", body.toString());
        put.setHeader("X-GS2-ACCESS-TOKEN", request.getAccessToken());
        return (SetMyVariableResult)this.doRequest((HttpUriRequest)put, SetMyVariableResult.class);
    }

    public SetVariableResult setVariable(SetVariableRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("value", request.getValue()).put("ttl", request.getTtl());
        HttpPut put = this.createHttpPut("https://{service}.{region}.gs2.io/user/" + (request.getUserId() == null ? "null" : request.getUserId()) + "/variable/" + (request.getVariableName() == null ? "null" : request.getVariableName()) + "", this.credential, ENDPOINT, "Gs2Variable", "SetVariable", body.toString());
        return (SetVariableResult)this.doRequest((HttpUriRequest)put, SetVariableResult.class);
    }
}

