/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.variable;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.gs2.AbstractGs2Client;
import io.gs2.model.IGs2Credential;
import io.gs2.variable.control.DeleteMyVariableRequest;
import io.gs2.variable.control.DeleteVariableRequest;
import io.gs2.variable.control.GetMyVariableRequest;
import io.gs2.variable.control.GetMyVariableResult;
import io.gs2.variable.control.GetVariableRequest;
import io.gs2.variable.control.GetVariableResult;
import io.gs2.variable.control.SetMyVariableRequest;
import io.gs2.variable.control.SetMyVariableResult;
import io.gs2.variable.control.SetVariableRequest;
import io.gs2.variable.control.SetVariableResult;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;

public class Gs2VariableClient
extends AbstractGs2Client<Gs2VariableClient> {
    public static String ENDPOINT = "variable";

    public Gs2VariableClient(IGs2Credential credential) {
        super(credential);
    }

    public SetVariableResult setVariable(SetVariableRequest request) {
        if (request.getUserId() == null || request.getVariableName() == null) {
            throw new NullPointerException();
        }
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("value", request.getValue()).put("ttl", String.valueOf(request.getTtl()));
        HttpPut put = this.createHttpPut("https://{service}.{region}.gs2.io/user/" + request.getUserId() + "/variable/" + request.getVariableName(), this.credential, ENDPOINT, "Gs2Variable", "SetVariable", body.toString());
        return (SetVariableResult)this.doRequest((HttpUriRequest)put, SetVariableResult.class);
    }

    public GetVariableResult getVariable(GetVariableRequest request) {
        if (request.getUserId() == null || request.getVariableName() == null) {
            throw new NullPointerException();
        }
        HttpGet get = this.createHttpGet("https://{service}.{region}.gs2.io/user/" + request.getUserId() + "/variable/" + request.getVariableName(), this.credential, ENDPOINT, "Gs2Variable", "GetVariable");
        return (GetVariableResult)this.doRequest((HttpUriRequest)get, GetVariableResult.class);
    }

    public void deleteVariable(DeleteVariableRequest request) {
        if (request.getUserId() == null || request.getVariableName() == null) {
            throw new NullPointerException();
        }
        HttpDelete delete = this.createHttpDelete("https://{service}.{region}.gs2.io/user/" + request.getUserId() + "/variable/" + request.getVariableName(), this.credential, ENDPOINT, "Gs2Variable", "DeleteVariable");
        this.doRequest((HttpUriRequest)delete, null);
    }

    public SetMyVariableResult setMyVariable(SetMyVariableRequest request) {
        if (request.getVariableName() == null) {
            throw new NullPointerException();
        }
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("value", request.getValue()).put("ttl", String.valueOf(request.getTtl()));
        HttpPut put = this.createHttpPut("https://{service}.{region}.gs2.io/variable/" + request.getVariableName(), this.credential, ENDPOINT, "Gs2Variable", "SetMyVariable", body.toString());
        put.setHeader("X-GS2-ACCESS-TOKEN", request.getAccessToken());
        return (SetMyVariableResult)this.doRequest((HttpUriRequest)put, SetMyVariableResult.class);
    }

    public GetMyVariableResult getMyVariable(GetMyVariableRequest request) {
        if (request.getVariableName() == null) {
            throw new NullPointerException();
        }
        HttpGet get = this.createHttpGet("https://{service}.{region}.gs2.io/variable/" + request.getVariableName(), this.credential, ENDPOINT, "Gs2Variable", "GetMyVariable");
        get.setHeader("X-GS2-ACCESS-TOKEN", request.getAccessToken());
        return (GetMyVariableResult)this.doRequest((HttpUriRequest)get, GetMyVariableResult.class);
    }

    public void deleteMyVariable(DeleteMyVariableRequest request) {
        if (request.getVariableName() == null) {
            throw new NullPointerException();
        }
        HttpDelete delete = this.createHttpDelete("https://{service}.{region}.gs2.io/variable/" + request.getVariableName(), this.credential, ENDPOINT, "Gs2Variable", "DeleteMyVariable");
        delete.setHeader("X-GS2-ACCESS-TOKEN", request.getAccessToken());
        this.doRequest((HttpUriRequest)delete, null);
    }
}

