/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.showcase.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.gs2.model.IModel;
import io.gs2.showcase.model.DisplayItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Showcase
implements IModel,
Serializable,
Comparable<Showcase> {
    protected String name;
    protected String metadata;
    protected List<DisplayItem> displayItems;
    protected String salesPeriodEventId;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Showcase withName(String name) {
        this.name = name;
        return this;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public Showcase withMetadata(String metadata) {
        this.metadata = metadata;
        return this;
    }

    public List<DisplayItem> getDisplayItems() {
        return this.displayItems;
    }

    public void setDisplayItems(List<DisplayItem> displayItems) {
        this.displayItems = displayItems;
    }

    public Showcase withDisplayItems(List<DisplayItem> displayItems) {
        this.displayItems = displayItems;
        return this;
    }

    public String getSalesPeriodEventId() {
        return this.salesPeriodEventId;
    }

    public void setSalesPeriodEventId(String salesPeriodEventId) {
        this.salesPeriodEventId = salesPeriodEventId;
    }

    public Showcase withSalesPeriodEventId(String salesPeriodEventId) {
        this.salesPeriodEventId = salesPeriodEventId;
        return this;
    }

    public ObjectNode toJson() {
        ArrayList<ObjectNode> displayItems = new ArrayList<ObjectNode>();
        if (this.displayItems != null) {
            for (DisplayItem item : this.displayItems) {
                displayItems.add(item.toJson());
            }
        }
        ObjectNode body_ = JsonNodeFactory.instance.objectNode().put("name", this.getName()).put("metadata", this.getMetadata()).put("salesPeriodEventId", this.getSalesPeriodEventId());
        body_.set("displayItems", (JsonNode)JsonNodeFactory.instance.arrayNode().addAll(displayItems));
        return body_;
    }

    @Override
    public int compareTo(Showcase o) {
        return this.name.compareTo(o.name);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.metadata == null ? 0 : this.metadata.hashCode());
        result = 31 * result + (this.displayItems == null ? 0 : this.displayItems.hashCode());
        result = 31 * result + (this.salesPeriodEventId == null ? 0 : this.salesPeriodEventId.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Showcase other = (Showcase)o;
        if (this.name == null) {
            return other.name == null;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (this.metadata == null) {
            return other.metadata == null;
        }
        if (!this.metadata.equals(other.metadata)) {
            return false;
        }
        if (this.displayItems == null) {
            return other.displayItems == null;
        }
        if (!this.displayItems.equals(other.displayItems)) {
            return false;
        }
        if (this.salesPeriodEventId == null) {
            return other.salesPeriodEventId == null;
        }
        return this.salesPeriodEventId.equals(other.salesPeriodEventId);
    }
}

