/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.showcase.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.gs2.model.IModel;
import io.gs2.showcase.model.AcquireAction;
import io.gs2.showcase.model.ConsumeAction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SalesItem
implements IModel,
Serializable,
Comparable<SalesItem> {
    protected String name;
    protected String metadata;
    protected List<ConsumeAction> consumeActions;
    protected List<AcquireAction> acquireActions;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SalesItem withName(String name) {
        this.name = name;
        return this;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public SalesItem withMetadata(String metadata) {
        this.metadata = metadata;
        return this;
    }

    public List<ConsumeAction> getConsumeActions() {
        return this.consumeActions;
    }

    public void setConsumeActions(List<ConsumeAction> consumeActions) {
        this.consumeActions = consumeActions;
    }

    public SalesItem withConsumeActions(List<ConsumeAction> consumeActions) {
        this.consumeActions = consumeActions;
        return this;
    }

    public List<AcquireAction> getAcquireActions() {
        return this.acquireActions;
    }

    public void setAcquireActions(List<AcquireAction> acquireActions) {
        this.acquireActions = acquireActions;
    }

    public SalesItem withAcquireActions(List<AcquireAction> acquireActions) {
        this.acquireActions = acquireActions;
        return this;
    }

    public ObjectNode toJson() {
        ArrayList<ObjectNode> consumeActions = new ArrayList<ObjectNode>();
        if (this.consumeActions != null) {
            for (ConsumeAction consumeAction : this.consumeActions) {
                consumeActions.add(consumeAction.toJson());
            }
        }
        ArrayList<ObjectNode> acquireActions = new ArrayList<ObjectNode>();
        if (this.acquireActions != null) {
            for (AcquireAction item : this.acquireActions) {
                acquireActions.add(item.toJson());
            }
        }
        ObjectNode objectNode = JsonNodeFactory.instance.objectNode().put("name", this.getName()).put("metadata", this.getMetadata());
        objectNode.set("consumeActions", (JsonNode)JsonNodeFactory.instance.arrayNode().addAll(consumeActions));
        objectNode.set("acquireActions", (JsonNode)JsonNodeFactory.instance.arrayNode().addAll(acquireActions));
        return objectNode;
    }

    @Override
    public int compareTo(SalesItem o) {
        return this.name.compareTo(o.name);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.metadata == null ? 0 : this.metadata.hashCode());
        result = 31 * result + (this.consumeActions == null ? 0 : this.consumeActions.hashCode());
        result = 31 * result + (this.acquireActions == null ? 0 : this.acquireActions.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        SalesItem other = (SalesItem)o;
        if (this.name == null) {
            return other.name == null;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (this.metadata == null) {
            return other.metadata == null;
        }
        if (!this.metadata.equals(other.metadata)) {
            return false;
        }
        if (this.consumeActions == null) {
            return other.consumeActions == null;
        }
        if (!this.consumeActions.equals(other.consumeActions)) {
            return false;
        }
        if (this.acquireActions == null) {
            return other.acquireActions == null;
        }
        return this.acquireActions.equals(other.acquireActions);
    }
}

