/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.showcase;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gs2.AbstractGs2Client;
import io.gs2.model.AsyncAction;
import io.gs2.model.AsyncResult;
import io.gs2.net.Gs2RestSession;
import io.gs2.net.Gs2RestSessionTask;
import io.gs2.net.Gs2Session;
import io.gs2.net.Gs2SessionTask;
import io.gs2.net.HttpTask;
import io.gs2.net.IResponseHandler;
import io.gs2.showcase.model.AcquireAction;
import io.gs2.showcase.model.Config;
import io.gs2.showcase.model.ConsumeAction;
import io.gs2.showcase.model.DisplayItemMaster;
import io.gs2.showcase.request.BuyByUserIdRequest;
import io.gs2.showcase.request.BuyRequest;
import io.gs2.showcase.request.CreateNamespaceRequest;
import io.gs2.showcase.request.CreateSalesItemGroupMasterRequest;
import io.gs2.showcase.request.CreateSalesItemMasterRequest;
import io.gs2.showcase.request.CreateShowcaseMasterRequest;
import io.gs2.showcase.request.DeleteNamespaceRequest;
import io.gs2.showcase.request.DeleteSalesItemGroupMasterRequest;
import io.gs2.showcase.request.DeleteSalesItemMasterRequest;
import io.gs2.showcase.request.DeleteShowcaseMasterRequest;
import io.gs2.showcase.request.DescribeNamespacesRequest;
import io.gs2.showcase.request.DescribeSalesItemGroupMastersRequest;
import io.gs2.showcase.request.DescribeSalesItemMastersRequest;
import io.gs2.showcase.request.DescribeShowcaseMastersRequest;
import io.gs2.showcase.request.DescribeShowcasesByUserIdRequest;
import io.gs2.showcase.request.DescribeShowcasesRequest;
import io.gs2.showcase.request.ExportMasterRequest;
import io.gs2.showcase.request.GetCurrentShowcaseMasterRequest;
import io.gs2.showcase.request.GetNamespaceRequest;
import io.gs2.showcase.request.GetNamespaceStatusRequest;
import io.gs2.showcase.request.GetSalesItemGroupMasterRequest;
import io.gs2.showcase.request.GetSalesItemMasterRequest;
import io.gs2.showcase.request.GetShowcaseByUserIdRequest;
import io.gs2.showcase.request.GetShowcaseMasterRequest;
import io.gs2.showcase.request.GetShowcaseRequest;
import io.gs2.showcase.request.UpdateCurrentShowcaseMasterRequest;
import io.gs2.showcase.request.UpdateNamespaceRequest;
import io.gs2.showcase.request.UpdateSalesItemGroupMasterRequest;
import io.gs2.showcase.request.UpdateSalesItemMasterRequest;
import io.gs2.showcase.request.UpdateShowcaseMasterRequest;
import io.gs2.showcase.result.BuyByUserIdResult;
import io.gs2.showcase.result.BuyResult;
import io.gs2.showcase.result.CreateNamespaceResult;
import io.gs2.showcase.result.CreateSalesItemGroupMasterResult;
import io.gs2.showcase.result.CreateSalesItemMasterResult;
import io.gs2.showcase.result.CreateShowcaseMasterResult;
import io.gs2.showcase.result.DeleteNamespaceResult;
import io.gs2.showcase.result.DeleteSalesItemGroupMasterResult;
import io.gs2.showcase.result.DeleteSalesItemMasterResult;
import io.gs2.showcase.result.DeleteShowcaseMasterResult;
import io.gs2.showcase.result.DescribeNamespacesResult;
import io.gs2.showcase.result.DescribeSalesItemGroupMastersResult;
import io.gs2.showcase.result.DescribeSalesItemMastersResult;
import io.gs2.showcase.result.DescribeShowcaseMastersResult;
import io.gs2.showcase.result.DescribeShowcasesByUserIdResult;
import io.gs2.showcase.result.DescribeShowcasesResult;
import io.gs2.showcase.result.ExportMasterResult;
import io.gs2.showcase.result.GetCurrentShowcaseMasterResult;
import io.gs2.showcase.result.GetNamespaceResult;
import io.gs2.showcase.result.GetNamespaceStatusResult;
import io.gs2.showcase.result.GetSalesItemGroupMasterResult;
import io.gs2.showcase.result.GetSalesItemMasterResult;
import io.gs2.showcase.result.GetShowcaseByUserIdResult;
import io.gs2.showcase.result.GetShowcaseMasterResult;
import io.gs2.showcase.result.GetShowcaseResult;
import io.gs2.showcase.result.UpdateCurrentShowcaseMasterResult;
import io.gs2.showcase.result.UpdateNamespaceResult;
import io.gs2.showcase.result.UpdateSalesItemGroupMasterResult;
import io.gs2.showcase.result.UpdateSalesItemMasterResult;
import io.gs2.showcase.result.UpdateShowcaseMasterResult;
import io.gs2.util.EncodingUtil;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public class Gs2ShowcaseRestClient
extends AbstractGs2Client<Gs2ShowcaseRestClient> {
    public Gs2ShowcaseRestClient(Gs2RestSession gs2RestSession) {
        super((Gs2Session)gs2RestSession);
    }

    public void describeNamespacesAsync(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> callback) {
        DescribeNamespacesTask task = new DescribeNamespacesTask(request, callback, DescribeNamespacesResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public DescribeNamespacesResult describeNamespaces(DescribeNamespacesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeNamespacesAsync(request, (AsyncAction<AsyncResult<DescribeNamespacesResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeNamespacesResult)resultAsyncResult[0].getResult();
    }

    public void createNamespaceAsync(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> callback) {
        CreateNamespaceTask task = new CreateNamespaceTask(request, callback, CreateNamespaceResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public CreateNamespaceResult createNamespace(CreateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createNamespaceAsync(request, (AsyncAction<AsyncResult<CreateNamespaceResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceStatusAsync(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> callback) {
        GetNamespaceStatusTask task = new GetNamespaceStatusTask(request, callback, GetNamespaceStatusResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public GetNamespaceStatusResult getNamespaceStatus(GetNamespaceStatusRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceStatusAsync(request, (AsyncAction<AsyncResult<GetNamespaceStatusResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceStatusResult)resultAsyncResult[0].getResult();
    }

    public void getNamespaceAsync(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> callback) {
        GetNamespaceTask task = new GetNamespaceTask(request, callback, GetNamespaceResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public GetNamespaceResult getNamespace(GetNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getNamespaceAsync(request, (AsyncAction<AsyncResult<GetNamespaceResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void updateNamespaceAsync(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> callback) {
        UpdateNamespaceTask task = new UpdateNamespaceTask(request, callback, UpdateNamespaceResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public UpdateNamespaceResult updateNamespace(UpdateNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateNamespaceAsync(request, (AsyncAction<AsyncResult<UpdateNamespaceResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void deleteNamespaceAsync(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> callback) {
        DeleteNamespaceTask task = new DeleteNamespaceTask(request, callback, DeleteNamespaceResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public DeleteNamespaceResult deleteNamespace(DeleteNamespaceRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteNamespaceAsync(request, (AsyncAction<AsyncResult<DeleteNamespaceResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteNamespaceResult)resultAsyncResult[0].getResult();
    }

    public void describeSalesItemMastersAsync(DescribeSalesItemMastersRequest request, AsyncAction<AsyncResult<DescribeSalesItemMastersResult>> callback) {
        DescribeSalesItemMastersTask task = new DescribeSalesItemMastersTask(request, callback, DescribeSalesItemMastersResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public DescribeSalesItemMastersResult describeSalesItemMasters(DescribeSalesItemMastersRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeSalesItemMastersAsync(request, (AsyncAction<AsyncResult<DescribeSalesItemMastersResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeSalesItemMastersResult)resultAsyncResult[0].getResult();
    }

    public void createSalesItemMasterAsync(CreateSalesItemMasterRequest request, AsyncAction<AsyncResult<CreateSalesItemMasterResult>> callback) {
        CreateSalesItemMasterTask task = new CreateSalesItemMasterTask(request, callback, CreateSalesItemMasterResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public CreateSalesItemMasterResult createSalesItemMaster(CreateSalesItemMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createSalesItemMasterAsync(request, (AsyncAction<AsyncResult<CreateSalesItemMasterResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateSalesItemMasterResult)resultAsyncResult[0].getResult();
    }

    public void getSalesItemMasterAsync(GetSalesItemMasterRequest request, AsyncAction<AsyncResult<GetSalesItemMasterResult>> callback) {
        GetSalesItemMasterTask task = new GetSalesItemMasterTask(request, callback, GetSalesItemMasterResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public GetSalesItemMasterResult getSalesItemMaster(GetSalesItemMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getSalesItemMasterAsync(request, (AsyncAction<AsyncResult<GetSalesItemMasterResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetSalesItemMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateSalesItemMasterAsync(UpdateSalesItemMasterRequest request, AsyncAction<AsyncResult<UpdateSalesItemMasterResult>> callback) {
        UpdateSalesItemMasterTask task = new UpdateSalesItemMasterTask(request, callback, UpdateSalesItemMasterResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public UpdateSalesItemMasterResult updateSalesItemMaster(UpdateSalesItemMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateSalesItemMasterAsync(request, (AsyncAction<AsyncResult<UpdateSalesItemMasterResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateSalesItemMasterResult)resultAsyncResult[0].getResult();
    }

    public void deleteSalesItemMasterAsync(DeleteSalesItemMasterRequest request, AsyncAction<AsyncResult<DeleteSalesItemMasterResult>> callback) {
        DeleteSalesItemMasterTask task = new DeleteSalesItemMasterTask(request, callback, DeleteSalesItemMasterResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public DeleteSalesItemMasterResult deleteSalesItemMaster(DeleteSalesItemMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteSalesItemMasterAsync(request, (AsyncAction<AsyncResult<DeleteSalesItemMasterResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteSalesItemMasterResult)resultAsyncResult[0].getResult();
    }

    public void describeSalesItemGroupMastersAsync(DescribeSalesItemGroupMastersRequest request, AsyncAction<AsyncResult<DescribeSalesItemGroupMastersResult>> callback) {
        DescribeSalesItemGroupMastersTask task = new DescribeSalesItemGroupMastersTask(request, callback, DescribeSalesItemGroupMastersResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public DescribeSalesItemGroupMastersResult describeSalesItemGroupMasters(DescribeSalesItemGroupMastersRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeSalesItemGroupMastersAsync(request, (AsyncAction<AsyncResult<DescribeSalesItemGroupMastersResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeSalesItemGroupMastersResult)resultAsyncResult[0].getResult();
    }

    public void createSalesItemGroupMasterAsync(CreateSalesItemGroupMasterRequest request, AsyncAction<AsyncResult<CreateSalesItemGroupMasterResult>> callback) {
        CreateSalesItemGroupMasterTask task = new CreateSalesItemGroupMasterTask(request, callback, CreateSalesItemGroupMasterResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public CreateSalesItemGroupMasterResult createSalesItemGroupMaster(CreateSalesItemGroupMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createSalesItemGroupMasterAsync(request, (AsyncAction<AsyncResult<CreateSalesItemGroupMasterResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateSalesItemGroupMasterResult)resultAsyncResult[0].getResult();
    }

    public void getSalesItemGroupMasterAsync(GetSalesItemGroupMasterRequest request, AsyncAction<AsyncResult<GetSalesItemGroupMasterResult>> callback) {
        GetSalesItemGroupMasterTask task = new GetSalesItemGroupMasterTask(request, callback, GetSalesItemGroupMasterResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public GetSalesItemGroupMasterResult getSalesItemGroupMaster(GetSalesItemGroupMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getSalesItemGroupMasterAsync(request, (AsyncAction<AsyncResult<GetSalesItemGroupMasterResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetSalesItemGroupMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateSalesItemGroupMasterAsync(UpdateSalesItemGroupMasterRequest request, AsyncAction<AsyncResult<UpdateSalesItemGroupMasterResult>> callback) {
        UpdateSalesItemGroupMasterTask task = new UpdateSalesItemGroupMasterTask(request, callback, UpdateSalesItemGroupMasterResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public UpdateSalesItemGroupMasterResult updateSalesItemGroupMaster(UpdateSalesItemGroupMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateSalesItemGroupMasterAsync(request, (AsyncAction<AsyncResult<UpdateSalesItemGroupMasterResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateSalesItemGroupMasterResult)resultAsyncResult[0].getResult();
    }

    public void deleteSalesItemGroupMasterAsync(DeleteSalesItemGroupMasterRequest request, AsyncAction<AsyncResult<DeleteSalesItemGroupMasterResult>> callback) {
        DeleteSalesItemGroupMasterTask task = new DeleteSalesItemGroupMasterTask(request, callback, DeleteSalesItemGroupMasterResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public DeleteSalesItemGroupMasterResult deleteSalesItemGroupMaster(DeleteSalesItemGroupMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteSalesItemGroupMasterAsync(request, (AsyncAction<AsyncResult<DeleteSalesItemGroupMasterResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteSalesItemGroupMasterResult)resultAsyncResult[0].getResult();
    }

    public void describeShowcaseMastersAsync(DescribeShowcaseMastersRequest request, AsyncAction<AsyncResult<DescribeShowcaseMastersResult>> callback) {
        DescribeShowcaseMastersTask task = new DescribeShowcaseMastersTask(request, callback, DescribeShowcaseMastersResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public DescribeShowcaseMastersResult describeShowcaseMasters(DescribeShowcaseMastersRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeShowcaseMastersAsync(request, (AsyncAction<AsyncResult<DescribeShowcaseMastersResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeShowcaseMastersResult)resultAsyncResult[0].getResult();
    }

    public void createShowcaseMasterAsync(CreateShowcaseMasterRequest request, AsyncAction<AsyncResult<CreateShowcaseMasterResult>> callback) {
        CreateShowcaseMasterTask task = new CreateShowcaseMasterTask(request, callback, CreateShowcaseMasterResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public CreateShowcaseMasterResult createShowcaseMaster(CreateShowcaseMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.createShowcaseMasterAsync(request, (AsyncAction<AsyncResult<CreateShowcaseMasterResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (CreateShowcaseMasterResult)resultAsyncResult[0].getResult();
    }

    public void getShowcaseMasterAsync(GetShowcaseMasterRequest request, AsyncAction<AsyncResult<GetShowcaseMasterResult>> callback) {
        GetShowcaseMasterTask task = new GetShowcaseMasterTask(request, callback, GetShowcaseMasterResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public GetShowcaseMasterResult getShowcaseMaster(GetShowcaseMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getShowcaseMasterAsync(request, (AsyncAction<AsyncResult<GetShowcaseMasterResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetShowcaseMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateShowcaseMasterAsync(UpdateShowcaseMasterRequest request, AsyncAction<AsyncResult<UpdateShowcaseMasterResult>> callback) {
        UpdateShowcaseMasterTask task = new UpdateShowcaseMasterTask(request, callback, UpdateShowcaseMasterResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public UpdateShowcaseMasterResult updateShowcaseMaster(UpdateShowcaseMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateShowcaseMasterAsync(request, (AsyncAction<AsyncResult<UpdateShowcaseMasterResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateShowcaseMasterResult)resultAsyncResult[0].getResult();
    }

    public void deleteShowcaseMasterAsync(DeleteShowcaseMasterRequest request, AsyncAction<AsyncResult<DeleteShowcaseMasterResult>> callback) {
        DeleteShowcaseMasterTask task = new DeleteShowcaseMasterTask(request, callback, DeleteShowcaseMasterResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public DeleteShowcaseMasterResult deleteShowcaseMaster(DeleteShowcaseMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.deleteShowcaseMasterAsync(request, (AsyncAction<AsyncResult<DeleteShowcaseMasterResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DeleteShowcaseMasterResult)resultAsyncResult[0].getResult();
    }

    public void exportMasterAsync(ExportMasterRequest request, AsyncAction<AsyncResult<ExportMasterResult>> callback) {
        ExportMasterTask task = new ExportMasterTask(request, callback, ExportMasterResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public ExportMasterResult exportMaster(ExportMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.exportMasterAsync(request, (AsyncAction<AsyncResult<ExportMasterResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (ExportMasterResult)resultAsyncResult[0].getResult();
    }

    public void getCurrentShowcaseMasterAsync(GetCurrentShowcaseMasterRequest request, AsyncAction<AsyncResult<GetCurrentShowcaseMasterResult>> callback) {
        GetCurrentShowcaseMasterTask task = new GetCurrentShowcaseMasterTask(request, callback, GetCurrentShowcaseMasterResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public GetCurrentShowcaseMasterResult getCurrentShowcaseMaster(GetCurrentShowcaseMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getCurrentShowcaseMasterAsync(request, (AsyncAction<AsyncResult<GetCurrentShowcaseMasterResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetCurrentShowcaseMasterResult)resultAsyncResult[0].getResult();
    }

    public void updateCurrentShowcaseMasterAsync(UpdateCurrentShowcaseMasterRequest request, AsyncAction<AsyncResult<UpdateCurrentShowcaseMasterResult>> callback) {
        UpdateCurrentShowcaseMasterTask task = new UpdateCurrentShowcaseMasterTask(request, callback, UpdateCurrentShowcaseMasterResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public UpdateCurrentShowcaseMasterResult updateCurrentShowcaseMaster(UpdateCurrentShowcaseMasterRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.updateCurrentShowcaseMasterAsync(request, (AsyncAction<AsyncResult<UpdateCurrentShowcaseMasterResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (UpdateCurrentShowcaseMasterResult)resultAsyncResult[0].getResult();
    }

    public void describeShowcasesAsync(DescribeShowcasesRequest request, AsyncAction<AsyncResult<DescribeShowcasesResult>> callback) {
        DescribeShowcasesTask task = new DescribeShowcasesTask(request, callback, DescribeShowcasesResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public DescribeShowcasesResult describeShowcases(DescribeShowcasesRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeShowcasesAsync(request, (AsyncAction<AsyncResult<DescribeShowcasesResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeShowcasesResult)resultAsyncResult[0].getResult();
    }

    public void describeShowcasesByUserIdAsync(DescribeShowcasesByUserIdRequest request, AsyncAction<AsyncResult<DescribeShowcasesByUserIdResult>> callback) {
        DescribeShowcasesByUserIdTask task = new DescribeShowcasesByUserIdTask(request, callback, DescribeShowcasesByUserIdResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public DescribeShowcasesByUserIdResult describeShowcasesByUserId(DescribeShowcasesByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.describeShowcasesByUserIdAsync(request, (AsyncAction<AsyncResult<DescribeShowcasesByUserIdResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (DescribeShowcasesByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void getShowcaseAsync(GetShowcaseRequest request, AsyncAction<AsyncResult<GetShowcaseResult>> callback) {
        GetShowcaseTask task = new GetShowcaseTask(request, callback, GetShowcaseResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public GetShowcaseResult getShowcase(GetShowcaseRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getShowcaseAsync(request, (AsyncAction<AsyncResult<GetShowcaseResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetShowcaseResult)resultAsyncResult[0].getResult();
    }

    public void getShowcaseByUserIdAsync(GetShowcaseByUserIdRequest request, AsyncAction<AsyncResult<GetShowcaseByUserIdResult>> callback) {
        GetShowcaseByUserIdTask task = new GetShowcaseByUserIdTask(request, callback, GetShowcaseByUserIdResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public GetShowcaseByUserIdResult getShowcaseByUserId(GetShowcaseByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.getShowcaseByUserIdAsync(request, (AsyncAction<AsyncResult<GetShowcaseByUserIdResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (GetShowcaseByUserIdResult)resultAsyncResult[0].getResult();
    }

    public void buyAsync(BuyRequest request, AsyncAction<AsyncResult<BuyResult>> callback) {
        BuyTask task = new BuyTask(request, callback, BuyResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public BuyResult buy(BuyRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.buyAsync(request, (AsyncAction<AsyncResult<BuyResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (BuyResult)resultAsyncResult[0].getResult();
    }

    public void buyByUserIdAsync(BuyByUserIdRequest request, AsyncAction<AsyncResult<BuyByUserIdResult>> callback) {
        BuyByUserIdTask task = new BuyByUserIdTask(request, callback, BuyByUserIdResult.class);
        this.session.execute((Gs2SessionTask)task);
    }

    public BuyByUserIdResult buyByUserId(BuyByUserIdRequest request) {
        AsyncResult[] resultAsyncResult = new AsyncResult[]{null};
        this.buyByUserIdAsync(request, (AsyncAction<AsyncResult<BuyByUserIdResult>>)((AsyncAction)result -> {
            resultAsyncResult[0] = result;
        }));
        while (resultAsyncResult[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (resultAsyncResult[0].getError() != null) {
            throw resultAsyncResult[0].getError();
        }
        return (BuyByUserIdResult)resultAsyncResult[0].getResult();
    }

    class BuyByUserIdTask
    extends Gs2RestSessionTask<BuyByUserIdResult> {
        private BuyByUserIdRequest request;

        public BuyByUserIdTask(BuyByUserIdRequest request, AsyncAction<AsyncResult<BuyByUserIdResult>> userCallback, Class<BuyByUserIdResult> clazz) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/showcase/{showcaseName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{showcaseName}", this.request.getShowcaseName() == null || this.request.getShowcaseName().length() == 0 ? "null" : String.valueOf(this.request.getShowcaseName()));
            url = url.replace("{displayItemId}", this.request.getDisplayItemId() == null || this.request.getDisplayItemId().length() == 0 ? "null" : String.valueOf(this.request.getDisplayItemId()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ObjectMapper mapper = new ObjectMapper();
            JSONObject json = new JSONObject();
            if (this.request.getConfig() != null) {
                JSONArray array = new JSONArray();
                for (Config item : this.request.getConfig()) {
                    try {
                        array.put((Object)new JSONObject(mapper.writeValueAsString((Object)item)));
                    }
                    catch (JsonProcessingException e) {
                        throw new RuntimeException(e);
                    }
                }
                json.put("config", (Object)array);
            }
            if (this.request.getContextStack() != null) {
                json.put("contextStack", (Object)this.request.getContextStack());
            }
            this.builder.setBody(json.toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class BuyTask
    extends Gs2RestSessionTask<BuyResult> {
        private BuyRequest request;

        public BuyTask(BuyRequest request, AsyncAction<AsyncResult<BuyResult>> userCallback, Class<BuyResult> clazz) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/showcase/{showcaseName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{showcaseName}", this.request.getShowcaseName() == null || this.request.getShowcaseName().length() == 0 ? "null" : String.valueOf(this.request.getShowcaseName()));
            url = url.replace("{displayItemId}", this.request.getDisplayItemId() == null || this.request.getDisplayItemId().length() == 0 ? "null" : String.valueOf(this.request.getDisplayItemId()));
            ObjectMapper mapper = new ObjectMapper();
            JSONObject json = new JSONObject();
            if (this.request.getConfig() != null) {
                JSONArray array = new JSONArray();
                for (Config item : this.request.getConfig()) {
                    try {
                        array.put((Object)new JSONObject(mapper.writeValueAsString((Object)item)));
                    }
                    catch (JsonProcessingException e) {
                        throw new RuntimeException(e);
                    }
                }
                json.put("config", (Object)array);
            }
            if (this.request.getContextStack() != null) {
                json.put("contextStack", (Object)this.request.getContextStack());
            }
            this.builder.setBody(json.toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class GetShowcaseByUserIdTask
    extends Gs2RestSessionTask<GetShowcaseByUserIdResult> {
        private GetShowcaseByUserIdRequest request;

        public GetShowcaseByUserIdTask(GetShowcaseByUserIdRequest request, AsyncAction<AsyncResult<GetShowcaseByUserIdResult>> userCallback, Class<GetShowcaseByUserIdResult> clazz) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/showcase/{showcaseName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{showcaseName}", this.request.getShowcaseName() == null || this.request.getShowcaseName().length() == 0 ? "null" : String.valueOf(this.request.getShowcaseName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode((String)this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class GetShowcaseTask
    extends Gs2RestSessionTask<GetShowcaseResult> {
        private GetShowcaseRequest request;

        public GetShowcaseTask(GetShowcaseRequest request, AsyncAction<AsyncResult<GetShowcaseResult>> userCallback, Class<GetShowcaseResult> clazz) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/showcase/{showcaseName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{showcaseName}", this.request.getShowcaseName() == null || this.request.getShowcaseName().length() == 0 ? "null" : String.valueOf(this.request.getShowcaseName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode((String)this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DescribeShowcasesByUserIdTask
    extends Gs2RestSessionTask<DescribeShowcasesByUserIdResult> {
        private DescribeShowcasesByUserIdRequest request;

        public DescribeShowcasesByUserIdTask(DescribeShowcasesByUserIdRequest request, AsyncAction<AsyncResult<DescribeShowcasesByUserIdResult>> userCallback, Class<DescribeShowcasesByUserIdResult> clazz) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/{userId}/showcase";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{userId}", this.request.getUserId() == null || this.request.getUserId().length() == 0 ? "null" : String.valueOf(this.request.getUserId()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode((String)this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class DescribeShowcasesTask
    extends Gs2RestSessionTask<DescribeShowcasesResult> {
        private DescribeShowcasesRequest request;

        public DescribeShowcasesTask(DescribeShowcasesRequest request, AsyncAction<AsyncResult<DescribeShowcasesResult>> userCallback, Class<DescribeShowcasesResult> clazz) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/user/me/showcase";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode((String)this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            if (this.request.getAccessToken() != null) {
                this.builder.setHeader("X-GS2-ACCESS-TOKEN", this.request.getAccessToken());
            }
            if (this.request.getDuplicationAvoider() != null) {
                this.builder.setHeader("X-GS2-DUPLICATION-AVOIDER", this.request.getDuplicationAvoider());
            }
            this.builder.build().send();
        }
    }

    class UpdateCurrentShowcaseMasterTask
    extends Gs2RestSessionTask<UpdateCurrentShowcaseMasterResult> {
        private UpdateCurrentShowcaseMasterRequest request;

        public UpdateCurrentShowcaseMasterTask(UpdateCurrentShowcaseMasterRequest request, AsyncAction<AsyncResult<UpdateCurrentShowcaseMasterResult>> userCallback, Class<UpdateCurrentShowcaseMasterResult> clazz) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ObjectMapper mapper = new ObjectMapper();
            JSONObject json = new JSONObject();
            if (this.request.getSettings() != null) {
                json.put("settings", (Object)this.request.getSettings());
            }
            if (this.request.getContextStack() != null) {
                json.put("contextStack", (Object)this.request.getContextStack());
            }
            this.builder.setBody(json.toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetCurrentShowcaseMasterTask
    extends Gs2RestSessionTask<GetCurrentShowcaseMasterResult> {
        private GetCurrentShowcaseMasterRequest request;

        public GetCurrentShowcaseMasterTask(GetCurrentShowcaseMasterRequest request, AsyncAction<AsyncResult<GetCurrentShowcaseMasterResult>> userCallback, Class<GetCurrentShowcaseMasterResult> clazz) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode((String)this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class ExportMasterTask
    extends Gs2RestSessionTask<ExportMasterResult> {
        private ExportMasterRequest request;

        public ExportMasterTask(ExportMasterRequest request, AsyncAction<AsyncResult<ExportMasterResult>> userCallback, Class<ExportMasterResult> clazz) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/export";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode((String)this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteShowcaseMasterTask
    extends Gs2RestSessionTask<DeleteShowcaseMasterResult> {
        private DeleteShowcaseMasterRequest request;

        public DeleteShowcaseMasterTask(DeleteShowcaseMasterRequest request, AsyncAction<AsyncResult<DeleteShowcaseMasterResult>> userCallback, Class<DeleteShowcaseMasterResult> clazz) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/showcase/{showcaseName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{showcaseName}", this.request.getShowcaseName() == null || this.request.getShowcaseName().length() == 0 ? "null" : String.valueOf(this.request.getShowcaseName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode((String)this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateShowcaseMasterTask
    extends Gs2RestSessionTask<UpdateShowcaseMasterResult> {
        private UpdateShowcaseMasterRequest request;

        public UpdateShowcaseMasterTask(UpdateShowcaseMasterRequest request, AsyncAction<AsyncResult<UpdateShowcaseMasterResult>> userCallback, Class<UpdateShowcaseMasterResult> clazz) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/showcase/{showcaseName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{showcaseName}", this.request.getShowcaseName() == null || this.request.getShowcaseName().length() == 0 ? "null" : String.valueOf(this.request.getShowcaseName()));
            ObjectMapper mapper = new ObjectMapper();
            JSONObject json = new JSONObject();
            if (this.request.getDescription() != null) {
                json.put("description", (Object)this.request.getDescription());
            }
            if (this.request.getMetadata() != null) {
                json.put("metadata", (Object)this.request.getMetadata());
            }
            if (this.request.getDisplayItems() != null) {
                JSONArray array = new JSONArray();
                for (DisplayItemMaster item : this.request.getDisplayItems()) {
                    try {
                        array.put((Object)new JSONObject(mapper.writeValueAsString((Object)item)));
                    }
                    catch (JsonProcessingException e) {
                        throw new RuntimeException(e);
                    }
                }
                json.put("displayItems", (Object)array);
            }
            if (this.request.getSalesPeriodEventId() != null) {
                json.put("salesPeriodEventId", (Object)this.request.getSalesPeriodEventId());
            }
            if (this.request.getContextStack() != null) {
                json.put("contextStack", (Object)this.request.getContextStack());
            }
            this.builder.setBody(json.toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetShowcaseMasterTask
    extends Gs2RestSessionTask<GetShowcaseMasterResult> {
        private GetShowcaseMasterRequest request;

        public GetShowcaseMasterTask(GetShowcaseMasterRequest request, AsyncAction<AsyncResult<GetShowcaseMasterResult>> userCallback, Class<GetShowcaseMasterResult> clazz) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/showcase/{showcaseName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{showcaseName}", this.request.getShowcaseName() == null || this.request.getShowcaseName().length() == 0 ? "null" : String.valueOf(this.request.getShowcaseName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode((String)this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateShowcaseMasterTask
    extends Gs2RestSessionTask<CreateShowcaseMasterResult> {
        private CreateShowcaseMasterRequest request;

        public CreateShowcaseMasterTask(CreateShowcaseMasterRequest request, AsyncAction<AsyncResult<CreateShowcaseMasterResult>> userCallback, Class<CreateShowcaseMasterResult> clazz) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/showcase";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ObjectMapper mapper = new ObjectMapper();
            JSONObject json = new JSONObject();
            if (this.request.getName() != null) {
                json.put("name", (Object)this.request.getName());
            }
            if (this.request.getDescription() != null) {
                json.put("description", (Object)this.request.getDescription());
            }
            if (this.request.getMetadata() != null) {
                json.put("metadata", (Object)this.request.getMetadata());
            }
            if (this.request.getDisplayItems() != null) {
                JSONArray array = new JSONArray();
                for (DisplayItemMaster item : this.request.getDisplayItems()) {
                    try {
                        array.put((Object)new JSONObject(mapper.writeValueAsString((Object)item)));
                    }
                    catch (JsonProcessingException e) {
                        throw new RuntimeException(e);
                    }
                }
                json.put("displayItems", (Object)array);
            }
            if (this.request.getSalesPeriodEventId() != null) {
                json.put("salesPeriodEventId", (Object)this.request.getSalesPeriodEventId());
            }
            if (this.request.getContextStack() != null) {
                json.put("contextStack", (Object)this.request.getContextStack());
            }
            this.builder.setBody(json.toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeShowcaseMastersTask
    extends Gs2RestSessionTask<DescribeShowcaseMastersResult> {
        private DescribeShowcaseMastersRequest request;

        public DescribeShowcaseMastersTask(DescribeShowcaseMastersRequest request, AsyncAction<AsyncResult<DescribeShowcaseMastersResult>> userCallback, Class<DescribeShowcaseMastersResult> clazz) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/showcase";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode((String)this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode((String)String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteSalesItemGroupMasterTask
    extends Gs2RestSessionTask<DeleteSalesItemGroupMasterResult> {
        private DeleteSalesItemGroupMasterRequest request;

        public DeleteSalesItemGroupMasterTask(DeleteSalesItemGroupMasterRequest request, AsyncAction<AsyncResult<DeleteSalesItemGroupMasterResult>> userCallback, Class<DeleteSalesItemGroupMasterResult> clazz) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/group/{salesItemGroupName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{salesItemGroupName}", this.request.getSalesItemGroupName() == null || this.request.getSalesItemGroupName().length() == 0 ? "null" : String.valueOf(this.request.getSalesItemGroupName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode((String)this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateSalesItemGroupMasterTask
    extends Gs2RestSessionTask<UpdateSalesItemGroupMasterResult> {
        private UpdateSalesItemGroupMasterRequest request;

        public UpdateSalesItemGroupMasterTask(UpdateSalesItemGroupMasterRequest request, AsyncAction<AsyncResult<UpdateSalesItemGroupMasterResult>> userCallback, Class<UpdateSalesItemGroupMasterResult> clazz) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/group/{salesItemGroupName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{salesItemGroupName}", this.request.getSalesItemGroupName() == null || this.request.getSalesItemGroupName().length() == 0 ? "null" : String.valueOf(this.request.getSalesItemGroupName()));
            ObjectMapper mapper = new ObjectMapper();
            JSONObject json = new JSONObject();
            if (this.request.getDescription() != null) {
                json.put("description", (Object)this.request.getDescription());
            }
            if (this.request.getMetadata() != null) {
                json.put("metadata", (Object)this.request.getMetadata());
            }
            if (this.request.getSalesItemNames() != null) {
                JSONArray array = new JSONArray();
                for (String item : this.request.getSalesItemNames()) {
                    array.put((Object)item);
                }
                json.put("salesItemNames", (Object)array);
            }
            if (this.request.getContextStack() != null) {
                json.put("contextStack", (Object)this.request.getContextStack());
            }
            this.builder.setBody(json.toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetSalesItemGroupMasterTask
    extends Gs2RestSessionTask<GetSalesItemGroupMasterResult> {
        private GetSalesItemGroupMasterRequest request;

        public GetSalesItemGroupMasterTask(GetSalesItemGroupMasterRequest request, AsyncAction<AsyncResult<GetSalesItemGroupMasterResult>> userCallback, Class<GetSalesItemGroupMasterResult> clazz) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/group/{salesItemGroupName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{salesItemGroupName}", this.request.getSalesItemGroupName() == null || this.request.getSalesItemGroupName().length() == 0 ? "null" : String.valueOf(this.request.getSalesItemGroupName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode((String)this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateSalesItemGroupMasterTask
    extends Gs2RestSessionTask<CreateSalesItemGroupMasterResult> {
        private CreateSalesItemGroupMasterRequest request;

        public CreateSalesItemGroupMasterTask(CreateSalesItemGroupMasterRequest request, AsyncAction<AsyncResult<CreateSalesItemGroupMasterResult>> userCallback, Class<CreateSalesItemGroupMasterResult> clazz) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/group";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ObjectMapper mapper = new ObjectMapper();
            JSONObject json = new JSONObject();
            if (this.request.getName() != null) {
                json.put("name", (Object)this.request.getName());
            }
            if (this.request.getDescription() != null) {
                json.put("description", (Object)this.request.getDescription());
            }
            if (this.request.getMetadata() != null) {
                json.put("metadata", (Object)this.request.getMetadata());
            }
            if (this.request.getSalesItemNames() != null) {
                JSONArray array = new JSONArray();
                for (String item : this.request.getSalesItemNames()) {
                    array.put((Object)item);
                }
                json.put("salesItemNames", (Object)array);
            }
            if (this.request.getContextStack() != null) {
                json.put("contextStack", (Object)this.request.getContextStack());
            }
            this.builder.setBody(json.toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeSalesItemGroupMastersTask
    extends Gs2RestSessionTask<DescribeSalesItemGroupMastersResult> {
        private DescribeSalesItemGroupMastersRequest request;

        public DescribeSalesItemGroupMastersTask(DescribeSalesItemGroupMastersRequest request, AsyncAction<AsyncResult<DescribeSalesItemGroupMastersResult>> userCallback, Class<DescribeSalesItemGroupMastersResult> clazz) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/group";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode((String)this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode((String)String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteSalesItemMasterTask
    extends Gs2RestSessionTask<DeleteSalesItemMasterResult> {
        private DeleteSalesItemMasterRequest request;

        public DeleteSalesItemMasterTask(DeleteSalesItemMasterRequest request, AsyncAction<AsyncResult<DeleteSalesItemMasterResult>> userCallback, Class<DeleteSalesItemMasterResult> clazz) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/salesItem/{salesItemName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{salesItemName}", this.request.getSalesItemName() == null || this.request.getSalesItemName().length() == 0 ? "null" : String.valueOf(this.request.getSalesItemName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode((String)this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateSalesItemMasterTask
    extends Gs2RestSessionTask<UpdateSalesItemMasterResult> {
        private UpdateSalesItemMasterRequest request;

        public UpdateSalesItemMasterTask(UpdateSalesItemMasterRequest request, AsyncAction<AsyncResult<UpdateSalesItemMasterResult>> userCallback, Class<UpdateSalesItemMasterResult> clazz) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            JSONArray array;
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/salesItem/{salesItemName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{salesItemName}", this.request.getSalesItemName() == null || this.request.getSalesItemName().length() == 0 ? "null" : String.valueOf(this.request.getSalesItemName()));
            ObjectMapper mapper = new ObjectMapper();
            JSONObject json = new JSONObject();
            if (this.request.getDescription() != null) {
                json.put("description", (Object)this.request.getDescription());
            }
            if (this.request.getMetadata() != null) {
                json.put("metadata", (Object)this.request.getMetadata());
            }
            if (this.request.getConsumeActions() != null) {
                array = new JSONArray();
                for (ConsumeAction consumeAction : this.request.getConsumeActions()) {
                    try {
                        array.put((Object)new JSONObject(mapper.writeValueAsString((Object)consumeAction)));
                    }
                    catch (JsonProcessingException e) {
                        throw new RuntimeException(e);
                    }
                }
                json.put("consumeActions", (Object)array);
            }
            if (this.request.getAcquireActions() != null) {
                array = new JSONArray();
                for (AcquireAction acquireAction : this.request.getAcquireActions()) {
                    try {
                        array.put((Object)new JSONObject(mapper.writeValueAsString((Object)acquireAction)));
                    }
                    catch (JsonProcessingException e) {
                        throw new RuntimeException(e);
                    }
                }
                json.put("acquireActions", (Object)array);
            }
            if (this.request.getContextStack() != null) {
                json.put("contextStack", (Object)this.request.getContextStack());
            }
            this.builder.setBody(json.toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetSalesItemMasterTask
    extends Gs2RestSessionTask<GetSalesItemMasterResult> {
        private GetSalesItemMasterRequest request;

        public GetSalesItemMasterTask(GetSalesItemMasterRequest request, AsyncAction<AsyncResult<GetSalesItemMasterResult>> userCallback, Class<GetSalesItemMasterResult> clazz) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/salesItem/{salesItemName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            url = url.replace("{salesItemName}", this.request.getSalesItemName() == null || this.request.getSalesItemName().length() == 0 ? "null" : String.valueOf(this.request.getSalesItemName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode((String)this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateSalesItemMasterTask
    extends Gs2RestSessionTask<CreateSalesItemMasterResult> {
        private CreateSalesItemMasterRequest request;

        public CreateSalesItemMasterTask(CreateSalesItemMasterRequest request, AsyncAction<AsyncResult<CreateSalesItemMasterResult>> userCallback, Class<CreateSalesItemMasterResult> clazz) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            JSONArray array;
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/salesItem";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ObjectMapper mapper = new ObjectMapper();
            JSONObject json = new JSONObject();
            if (this.request.getName() != null) {
                json.put("name", (Object)this.request.getName());
            }
            if (this.request.getDescription() != null) {
                json.put("description", (Object)this.request.getDescription());
            }
            if (this.request.getMetadata() != null) {
                json.put("metadata", (Object)this.request.getMetadata());
            }
            if (this.request.getConsumeActions() != null) {
                array = new JSONArray();
                for (ConsumeAction consumeAction : this.request.getConsumeActions()) {
                    try {
                        array.put((Object)new JSONObject(mapper.writeValueAsString((Object)consumeAction)));
                    }
                    catch (JsonProcessingException e) {
                        throw new RuntimeException(e);
                    }
                }
                json.put("consumeActions", (Object)array);
            }
            if (this.request.getAcquireActions() != null) {
                array = new JSONArray();
                for (AcquireAction acquireAction : this.request.getAcquireActions()) {
                    try {
                        array.put((Object)new JSONObject(mapper.writeValueAsString((Object)acquireAction)));
                    }
                    catch (JsonProcessingException e) {
                        throw new RuntimeException(e);
                    }
                }
                json.put("acquireActions", (Object)array);
            }
            if (this.request.getContextStack() != null) {
                json.put("contextStack", (Object)this.request.getContextStack());
            }
            this.builder.setBody(json.toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeSalesItemMastersTask
    extends Gs2RestSessionTask<DescribeSalesItemMastersResult> {
        private DescribeSalesItemMastersRequest request;

        public DescribeSalesItemMastersTask(DescribeSalesItemMastersRequest request, AsyncAction<AsyncResult<DescribeSalesItemMastersResult>> userCallback, Class<DescribeSalesItemMastersResult> clazz) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/master/salesItem";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode((String)this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode((String)String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DeleteNamespaceTask
    extends Gs2RestSessionTask<DeleteNamespaceResult> {
        private DeleteNamespaceRequest request;

        public DeleteNamespaceTask(DeleteNamespaceRequest request, AsyncAction<AsyncResult<DeleteNamespaceResult>> userCallback, Class<DeleteNamespaceResult> clazz) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode((String)this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.DELETE).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class UpdateNamespaceTask
    extends Gs2RestSessionTask<UpdateNamespaceResult> {
        private UpdateNamespaceRequest request;

        public UpdateNamespaceTask(UpdateNamespaceRequest request, AsyncAction<AsyncResult<UpdateNamespaceResult>> userCallback, Class<UpdateNamespaceResult> clazz) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ObjectMapper mapper = new ObjectMapper();
            JSONObject json = new JSONObject();
            if (this.request.getDescription() != null) {
                json.put("description", (Object)this.request.getDescription());
            }
            if (this.request.getQueueNamespaceId() != null) {
                json.put("queueNamespaceId", (Object)this.request.getQueueNamespaceId());
            }
            if (this.request.getKeyId() != null) {
                json.put("keyId", (Object)this.request.getKeyId());
            }
            if (this.request.getContextStack() != null) {
                json.put("contextStack", (Object)this.request.getContextStack());
            }
            this.builder.setBody(json.toString().getBytes());
            this.builder.setMethod(HttpTask.Method.PUT).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceTask
    extends Gs2RestSessionTask<GetNamespaceResult> {
        private GetNamespaceRequest request;

        public GetNamespaceTask(GetNamespaceRequest request, AsyncAction<AsyncResult<GetNamespaceResult>> userCallback, Class<GetNamespaceResult> clazz) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode((String)this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class GetNamespaceStatusTask
    extends Gs2RestSessionTask<GetNamespaceStatusResult> {
        private GetNamespaceStatusRequest request;

        public GetNamespaceStatusTask(GetNamespaceStatusRequest request, AsyncAction<AsyncResult<GetNamespaceStatusResult>> userCallback, Class<GetNamespaceStatusResult> clazz) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/{namespaceName}/status";
            url = url.replace("{namespaceName}", this.request.getNamespaceName() == null || this.request.getNamespaceName().length() == 0 ? "null" : String.valueOf(this.request.getNamespaceName()));
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode((String)this.request.getContextStack()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class CreateNamespaceTask
    extends Gs2RestSessionTask<CreateNamespaceResult> {
        private CreateNamespaceRequest request;

        public CreateNamespaceTask(CreateNamespaceRequest request, AsyncAction<AsyncResult<CreateNamespaceResult>> userCallback, Class<CreateNamespaceResult> clazz) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/";
            ObjectMapper mapper = new ObjectMapper();
            JSONObject json = new JSONObject();
            if (this.request.getName() != null) {
                json.put("name", (Object)this.request.getName());
            }
            if (this.request.getDescription() != null) {
                json.put("description", (Object)this.request.getDescription());
            }
            if (this.request.getQueueNamespaceId() != null) {
                json.put("queueNamespaceId", (Object)this.request.getQueueNamespaceId());
            }
            if (this.request.getKeyId() != null) {
                json.put("keyId", (Object)this.request.getKeyId());
            }
            if (this.request.getContextStack() != null) {
                json.put("contextStack", (Object)this.request.getContextStack());
            }
            this.builder.setBody(json.toString().getBytes());
            this.builder.setMethod(HttpTask.Method.POST).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }

    class DescribeNamespacesTask
    extends Gs2RestSessionTask<DescribeNamespacesResult> {
        private DescribeNamespacesRequest request;

        public DescribeNamespacesTask(DescribeNamespacesRequest request, AsyncAction<AsyncResult<DescribeNamespacesResult>> userCallback, Class<DescribeNamespacesResult> clazz) {
            super((Gs2RestSession)Gs2ShowcaseRestClient.this.session, userCallback, clazz);
            this.request = request;
        }

        protected void executeImpl() {
            String url = "https://{service}.{region}.gen2.gs2io.com".replace("{service}", "showcase").replace("{region}", Gs2ShowcaseRestClient.this.session.getRegion().getName()) + "/";
            ArrayList<String> queryStrings = new ArrayList<String>();
            if (this.request.getContextStack() != null) {
                queryStrings.add("contextStack=" + EncodingUtil.urlEncode((String)this.request.getContextStack()));
            }
            if (this.request.getPageToken() != null) {
                queryStrings.add("pageToken=" + EncodingUtil.urlEncode((String)String.valueOf(this.request.getPageToken())));
            }
            if (this.request.getLimit() != null) {
                queryStrings.add("limit=" + String.valueOf(this.request.getLimit()));
            }
            url = url + "?" + String.join((CharSequence)"&", queryStrings);
            this.builder.setMethod(HttpTask.Method.GET).setUrl(url).setHeader("Content-Type", "application/json").setHttpResponseHandler((IResponseHandler)this);
            if (this.request.getRequestId() != null) {
                this.builder.setHeader("X-GS2-REQUEST-ID", this.request.getRequestId());
            }
            this.builder.build().send();
        }
    }
}

