/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.inGamePushNotification;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.gs2.AbstractGs2Client;
import io.gs2.inGamePushNotification.control.CreateCertificateRequest;
import io.gs2.inGamePushNotification.control.CreateCertificateResult;
import io.gs2.inGamePushNotification.control.CreateGameRequest;
import io.gs2.inGamePushNotification.control.CreateGameResult;
import io.gs2.inGamePushNotification.control.DeleteCertificateRequest;
import io.gs2.inGamePushNotification.control.DeleteGameRequest;
import io.gs2.inGamePushNotification.control.DescribeGameRequest;
import io.gs2.inGamePushNotification.control.DescribeGameResult;
import io.gs2.inGamePushNotification.control.DescribeServiceClassRequest;
import io.gs2.inGamePushNotification.control.DescribeServiceClassResult;
import io.gs2.inGamePushNotification.control.DescribeStatusRequest;
import io.gs2.inGamePushNotification.control.DescribeStatusResult;
import io.gs2.inGamePushNotification.control.GetGameRequest;
import io.gs2.inGamePushNotification.control.GetGameResult;
import io.gs2.inGamePushNotification.control.GetGameStatusRequest;
import io.gs2.inGamePushNotification.control.GetGameStatusResult;
import io.gs2.inGamePushNotification.control.GetMqttHostRequest;
import io.gs2.inGamePushNotification.control.GetMqttHostResult;
import io.gs2.inGamePushNotification.control.GetWebSocketHostRequest;
import io.gs2.inGamePushNotification.control.GetWebSocketHostResult;
import io.gs2.inGamePushNotification.control.PublishRequest;
import io.gs2.inGamePushNotification.control.PublishResult;
import io.gs2.inGamePushNotification.control.SetFirebaseTokenRequest;
import io.gs2.inGamePushNotification.control.SetFirebaseTokenResult;
import io.gs2.inGamePushNotification.control.UpdateGameRequest;
import io.gs2.inGamePushNotification.control.UpdateGameResult;
import io.gs2.model.IGs2Credential;
import io.gs2.util.EncodingUtil;
import java.util.ArrayList;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;

public class Gs2InGamePushNotificationClient
extends AbstractGs2Client<Gs2InGamePushNotificationClient> {
    public static String ENDPOINT = "inGamePushNotification";

    public Gs2InGamePushNotificationClient(IGs2Credential credential) {
        super(credential);
    }

    public DescribeServiceClassResult describeServiceClass(DescribeServiceClassRequest request) {
        String url = "https://{service}.{region}.gs2.io/game/serviceClass";
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2InGamePushNotification", "DescribeServiceClass");
        return (DescribeServiceClassResult)this.doRequest((HttpUriRequest)get, DescribeServiceClassResult.class);
    }

    public GetMqttHostResult getMqttHost(GetMqttHostRequest request) {
        String url = "https://{service}.{region}.gs2.io/game/" + (request.getGameName() == null ? "null" : EncodingUtil.urlEncode((String)request.getGameName())) + "/server/mqtt";
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2InGamePushNotification", "GetMqttHost");
        get.setHeader("X-GS2-ACCESS-TOKEN", request.getAccessToken());
        return (GetMqttHostResult)this.doRequest((HttpUriRequest)get, GetMqttHostResult.class);
    }

    public GetWebSocketHostResult getWebSocketHost(GetWebSocketHostRequest request) {
        String url = "https://{service}.{region}.gs2.io/game/" + (request.getGameName() == null ? "null" : EncodingUtil.urlEncode((String)request.getGameName())) + "/server/webSocket";
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2InGamePushNotification", "GetWebSocketHost");
        get.setHeader("X-GS2-ACCESS-TOKEN", request.getAccessToken());
        return (GetWebSocketHostResult)this.doRequest((HttpUriRequest)get, GetWebSocketHostResult.class);
    }

    public SetFirebaseTokenResult setFirebaseToken(SetFirebaseTokenRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("token", request.getToken());
        HttpPut put = this.createHttpPut("https://{service}.{region}.gs2.io/game/" + (request.getGameName() == null ? "null" : EncodingUtil.urlEncode((String)request.getGameName())) + "/user", this.credential, ENDPOINT, "Gs2InGamePushNotification", "SetFirebaseToken", body.toString());
        put.setHeader("X-GS2-ACCESS-TOKEN", request.getAccessToken());
        return (SetFirebaseTokenResult)this.doRequest((HttpUriRequest)put, SetFirebaseTokenResult.class);
    }

    public DescribeStatusResult describeStatus(DescribeStatusRequest request) {
        String url = "https://{service}.{region}.gs2.io/game/" + (request.getGameName() == null ? "null" : EncodingUtil.urlEncode((String)request.getGameName())) + "/user";
        ArrayList<BasicNameValuePair> queryString = new ArrayList<BasicNameValuePair>();
        if (request.getPageToken() != null) {
            queryString.add(new BasicNameValuePair("pageToken", String.valueOf(request.getPageToken())));
        }
        if (request.getLimit() != null) {
            queryString.add(new BasicNameValuePair("limit", String.valueOf(request.getLimit())));
        }
        if (queryString.size() > 0) {
            url = url + "?" + URLEncodedUtils.format(queryString, (String)"UTF-8");
        }
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2InGamePushNotification", "DescribeStatus");
        return (DescribeStatusResult)this.doRequest((HttpUriRequest)get, DescribeStatusResult.class);
    }

    public PublishResult publish(PublishRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("body", request.getBody()).put("enableOfflineTransfer", request.getEnableOfflineTransfer()).put("subject", request.getSubject());
        if (request.getOfflineTransferSound() != null) {
            body.put("offlineTransferSound", request.getOfflineTransferSound());
        }
        HttpPost post = this.createHttpPost("https://{service}.{region}.gs2.io/game/" + (request.getGameName() == null ? "null" : EncodingUtil.urlEncode((String)request.getGameName())) + "/user/" + (request.getUserId() == null ? "null" : EncodingUtil.urlEncode((String)request.getUserId())) + "", this.credential, ENDPOINT, "Gs2InGamePushNotification", "Publish", body.toString());
        return (PublishResult)this.doRequest((HttpUriRequest)post, PublishResult.class);
    }

    public CreateGameResult createGame(CreateGameRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("serviceClass", request.getServiceClass()).put("name", request.getName()).put("offlineTransfer", request.getOfflineTransfer());
        if (request.getNotificationFirebaseServerKey() != null) {
            body.put("notificationFirebaseServerKey", request.getNotificationFirebaseServerKey());
        }
        if (request.getNotificationUrl() != null) {
            body.put("notificationUrl", request.getNotificationUrl());
        }
        if (request.getDescription() != null) {
            body.put("description", request.getDescription());
        }
        HttpPost post = this.createHttpPost("https://{service}.{region}.gs2.io/game", this.credential, ENDPOINT, "Gs2InGamePushNotification", "CreateGame", body.toString());
        return (CreateGameResult)this.doRequest((HttpUriRequest)post, CreateGameResult.class);
    }

    public DescribeGameResult describeGame(DescribeGameRequest request) {
        String url = "https://{service}.{region}.gs2.io/game";
        ArrayList<BasicNameValuePair> queryString = new ArrayList<BasicNameValuePair>();
        if (request.getPageToken() != null) {
            queryString.add(new BasicNameValuePair("pageToken", String.valueOf(request.getPageToken())));
        }
        if (request.getLimit() != null) {
            queryString.add(new BasicNameValuePair("limit", String.valueOf(request.getLimit())));
        }
        if (queryString.size() > 0) {
            url = url + "?" + URLEncodedUtils.format(queryString, (String)"UTF-8");
        }
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2InGamePushNotification", "DescribeGame");
        return (DescribeGameResult)this.doRequest((HttpUriRequest)get, DescribeGameResult.class);
    }

    public GetGameStatusResult getGameStatus(GetGameStatusRequest request) {
        String url = "https://{service}.{region}.gs2.io/game/" + (request.getGameName() == null ? "null" : EncodingUtil.urlEncode((String)request.getGameName())) + "/status";
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2InGamePushNotification", "GetGameStatus");
        return (GetGameStatusResult)this.doRequest((HttpUriRequest)get, GetGameStatusResult.class);
    }

    public CreateCertificateResult createCertificate(CreateCertificateRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode();
        HttpPost post = this.createHttpPost("https://{service}.{region}.gs2.io/game/" + (request.getGameName() == null ? "null" : EncodingUtil.urlEncode((String)request.getGameName())) + "/certificate", this.credential, ENDPOINT, "Gs2InGamePushNotification", "CreateCertificate", body.toString());
        post.setHeader("X-GS2-ACCESS-TOKEN", request.getAccessToken());
        return (CreateCertificateResult)this.doRequest((HttpUriRequest)post, CreateCertificateResult.class);
    }

    public void deleteCertificate(DeleteCertificateRequest request) {
        HttpDelete delete = this.createHttpDelete("https://{service}.{region}.gs2.io/game/" + (request.getGameName() == null ? "null" : EncodingUtil.urlEncode((String)request.getGameName())) + "/certificate", this.credential, ENDPOINT, "Gs2InGamePushNotification", "DeleteCertificate");
        delete.setHeader("X-GS2-ACCESS-TOKEN", request.getAccessToken());
        this.doRequest((HttpUriRequest)delete, null);
    }

    public UpdateGameResult updateGame(UpdateGameRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("serviceClass", request.getServiceClass()).put("offlineTransfer", request.getOfflineTransfer());
        if (request.getNotificationUrl() != null) {
            body.put("notificationUrl", request.getNotificationUrl());
        }
        if (request.getNotificationFirebaseServerKey() != null) {
            body.put("notificationFirebaseServerKey", request.getNotificationFirebaseServerKey());
        }
        if (request.getDescription() != null) {
            body.put("description", request.getDescription());
        }
        HttpPut put = this.createHttpPut("https://{service}.{region}.gs2.io/game/" + (request.getGameName() == null ? "null" : EncodingUtil.urlEncode((String)request.getGameName())) + "", this.credential, ENDPOINT, "Gs2InGamePushNotification", "UpdateGame", body.toString());
        return (UpdateGameResult)this.doRequest((HttpUriRequest)put, UpdateGameResult.class);
    }

    public GetGameResult getGame(GetGameRequest request) {
        String url = "https://{service}.{region}.gs2.io/game/" + (request.getGameName() == null ? "null" : EncodingUtil.urlEncode((String)request.getGameName())) + "";
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2InGamePushNotification", "GetGame");
        return (GetGameResult)this.doRequest((HttpUriRequest)get, GetGameResult.class);
    }

    public void deleteGame(DeleteGameRequest request) {
        HttpDelete delete = this.createHttpDelete("https://{service}.{region}.gs2.io/game/" + (request.getGameName() == null ? "null" : EncodingUtil.urlEncode((String)request.getGameName())) + "", this.credential, ENDPOINT, "Gs2InGamePushNotification", "DeleteGame");
        this.doRequest((HttpUriRequest)delete, null);
    }
}

