/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.gold;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.gs2.AbstractGs2Client;
import io.gs2.gold.control.CreateGoldMasterRequest;
import io.gs2.gold.control.CreateGoldMasterResult;
import io.gs2.gold.control.CreateGoldPoolRequest;
import io.gs2.gold.control.CreateGoldPoolResult;
import io.gs2.gold.control.DeleteGoldMasterRequest;
import io.gs2.gold.control.DeleteGoldPoolRequest;
import io.gs2.gold.control.DeleteWalletByUserIdRequest;
import io.gs2.gold.control.DepositIntoWalletByStampSheetRequest;
import io.gs2.gold.control.DepositIntoWalletByStampSheetResult;
import io.gs2.gold.control.DepositIntoWalletByUserIdRequest;
import io.gs2.gold.control.DepositIntoWalletByUserIdResult;
import io.gs2.gold.control.DepositIntoWalletRequest;
import io.gs2.gold.control.DepositIntoWalletResult;
import io.gs2.gold.control.DescribeGoldMasterRequest;
import io.gs2.gold.control.DescribeGoldMasterResult;
import io.gs2.gold.control.DescribeGoldPoolRequest;
import io.gs2.gold.control.DescribeGoldPoolResult;
import io.gs2.gold.control.DescribeServiceClassRequest;
import io.gs2.gold.control.DescribeServiceClassResult;
import io.gs2.gold.control.DescribeWalletByUserIdRequest;
import io.gs2.gold.control.DescribeWalletByUserIdResult;
import io.gs2.gold.control.DescribeWalletRequest;
import io.gs2.gold.control.DescribeWalletResult;
import io.gs2.gold.control.ExportMasterRequest;
import io.gs2.gold.control.ExportMasterResult;
import io.gs2.gold.control.GetCurrentGoldMasterRequest;
import io.gs2.gold.control.GetCurrentGoldMasterResult;
import io.gs2.gold.control.GetGoldMasterRequest;
import io.gs2.gold.control.GetGoldMasterResult;
import io.gs2.gold.control.GetGoldPoolRequest;
import io.gs2.gold.control.GetGoldPoolResult;
import io.gs2.gold.control.GetGoldPoolStatusRequest;
import io.gs2.gold.control.GetGoldPoolStatusResult;
import io.gs2.gold.control.GetWalletByUserIdRequest;
import io.gs2.gold.control.GetWalletByUserIdResult;
import io.gs2.gold.control.GetWalletRequest;
import io.gs2.gold.control.GetWalletResult;
import io.gs2.gold.control.GetWalletSettingsRequest;
import io.gs2.gold.control.GetWalletSettingsResult;
import io.gs2.gold.control.SetLatestGainRequest;
import io.gs2.gold.control.SetLatestGainResult;
import io.gs2.gold.control.UpdateCurrentGoldMasterRequest;
import io.gs2.gold.control.UpdateCurrentGoldMasterResult;
import io.gs2.gold.control.UpdateGoldMasterRequest;
import io.gs2.gold.control.UpdateGoldMasterResult;
import io.gs2.gold.control.UpdateGoldPoolRequest;
import io.gs2.gold.control.UpdateGoldPoolResult;
import io.gs2.gold.control.WithdrawFromWalletByStampTaskRequest;
import io.gs2.gold.control.WithdrawFromWalletByStampTaskResult;
import io.gs2.gold.control.WithdrawFromWalletByUserIdRequest;
import io.gs2.gold.control.WithdrawFromWalletByUserIdResult;
import io.gs2.gold.control.WithdrawFromWalletRequest;
import io.gs2.gold.control.WithdrawFromWalletResult;
import io.gs2.model.IGs2Credential;
import io.gs2.model.Region;
import java.util.ArrayList;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;

public class Gs2GoldClient
extends AbstractGs2Client<Gs2GoldClient> {
    public static String ENDPOINT = "gold";

    public Gs2GoldClient(IGs2Credential credential) {
        super(credential);
    }

    public Gs2GoldClient(IGs2Credential credential, Region region) {
        super(credential, region);
    }

    public Gs2GoldClient(IGs2Credential credential, String region) {
        super(credential, region);
    }

    public GetCurrentGoldMasterResult getCurrentGoldMaster(GetCurrentGoldMasterRequest request) {
        String url = "https://{service}.{region}.gs2io.com/goldPool/" + (request.getGoldPoolName() == null || request.getGoldPoolName().equals("") ? "null" : request.getGoldPoolName()) + "/gold/master";
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Gold", "GetCurrentGoldMaster");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (GetCurrentGoldMasterResult)this.doRequest((HttpUriRequest)get, GetCurrentGoldMasterResult.class);
    }

    public UpdateCurrentGoldMasterResult updateCurrentGoldMaster(UpdateCurrentGoldMasterRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("settings", request.getSettings());
        HttpPost post = this.createHttpPost("https://{service}.{region}.gs2io.com/goldPool/" + (request.getGoldPoolName() == null || request.getGoldPoolName().equals("") ? "null" : request.getGoldPoolName()) + "/gold/master", this.credential, ENDPOINT, "Gs2Gold", "UpdateCurrentGoldMaster", body.toString());
        if (request.getRequestId() != null) {
            post.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (UpdateCurrentGoldMasterResult)this.doRequest((HttpUriRequest)post, UpdateCurrentGoldMasterResult.class);
    }

    public CreateGoldMasterResult createGoldMaster(CreateGoldMasterRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("name", request.getName());
        if (request.getMeta() != null) {
            body.put("meta", request.getMeta());
        }
        if (request.getBalanceMax() != null) {
            body.put("balanceMax", request.getBalanceMax());
        }
        if (request.getResetType() != null) {
            body.put("resetType", request.getResetType());
        }
        if (request.getResetDayOfMonth() != null) {
            body.put("resetDayOfMonth", request.getResetDayOfMonth());
        }
        if (request.getResetDayOfWeek() != null) {
            body.put("resetDayOfWeek", request.getResetDayOfWeek());
        }
        if (request.getResetHour() != null) {
            body.put("resetHour", request.getResetHour());
        }
        if (request.getLatestGainMax() != null) {
            body.put("latestGainMax", request.getLatestGainMax());
        }
        if (request.getCreateWalletTriggerScript() != null) {
            body.put("createWalletTriggerScript", request.getCreateWalletTriggerScript());
        }
        if (request.getCreateWalletDoneTriggerScript() != null) {
            body.put("createWalletDoneTriggerScript", request.getCreateWalletDoneTriggerScript());
        }
        if (request.getDepositIntoWalletTriggerScript() != null) {
            body.put("depositIntoWalletTriggerScript", request.getDepositIntoWalletTriggerScript());
        }
        if (request.getDepositIntoWalletDoneTriggerScript() != null) {
            body.put("depositIntoWalletDoneTriggerScript", request.getDepositIntoWalletDoneTriggerScript());
        }
        if (request.getWithdrawFromWalletTriggerScript() != null) {
            body.put("withdrawFromWalletTriggerScript", request.getWithdrawFromWalletTriggerScript());
        }
        if (request.getWithdrawFromWalletDoneTriggerScript() != null) {
            body.put("withdrawFromWalletDoneTriggerScript", request.getWithdrawFromWalletDoneTriggerScript());
        }
        HttpPost post = this.createHttpPost("https://{service}.{region}.gs2io.com/goldPool/" + (request.getGoldPoolName() == null || request.getGoldPoolName().equals("") ? "null" : request.getGoldPoolName()) + "/master/gold", this.credential, ENDPOINT, "Gs2Gold", "CreateGoldMaster", body.toString());
        if (request.getRequestId() != null) {
            post.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (CreateGoldMasterResult)this.doRequest((HttpUriRequest)post, CreateGoldMasterResult.class);
    }

    public void deleteGoldMaster(DeleteGoldMasterRequest request) {
        String url = "https://{service}.{region}.gs2io.com/goldPool/" + (request.getGoldPoolName() == null || request.getGoldPoolName().equals("") ? "null" : request.getGoldPoolName()) + "/master/gold/" + (request.getGoldName() == null || request.getGoldName().equals("") ? "null" : request.getGoldName()) + "";
        HttpDelete delete = this.createHttpDelete(url, this.credential, ENDPOINT, "Gs2Gold", "DeleteGoldMaster");
        if (request.getRequestId() != null) {
            delete.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        this.doRequest((HttpUriRequest)delete, null);
    }

    public DescribeGoldMasterResult describeGoldMaster(DescribeGoldMasterRequest request) {
        String url = "https://{service}.{region}.gs2io.com/goldPool/" + (request.getGoldPoolName() == null || request.getGoldPoolName().equals("") ? "null" : request.getGoldPoolName()) + "/master/gold";
        ArrayList<BasicNameValuePair> queryString = new ArrayList<BasicNameValuePair>();
        if (request.getPageToken() != null) {
            queryString.add(new BasicNameValuePair("pageToken", String.valueOf(request.getPageToken())));
        }
        if (request.getLimit() != null) {
            queryString.add(new BasicNameValuePair("limit", String.valueOf(request.getLimit())));
        }
        if (queryString.size() > 0) {
            url = url + "?" + URLEncodedUtils.format(queryString, (String)"UTF-8");
        }
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Gold", "DescribeGoldMaster");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (DescribeGoldMasterResult)this.doRequest((HttpUriRequest)get, DescribeGoldMasterResult.class);
    }

    public GetGoldMasterResult getGoldMaster(GetGoldMasterRequest request) {
        String url = "https://{service}.{region}.gs2io.com/goldPool/" + (request.getGoldPoolName() == null || request.getGoldPoolName().equals("") ? "null" : request.getGoldPoolName()) + "/master/gold/" + (request.getGoldName() == null || request.getGoldName().equals("") ? "null" : request.getGoldName()) + "";
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Gold", "GetGoldMaster");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (GetGoldMasterResult)this.doRequest((HttpUriRequest)get, GetGoldMasterResult.class);
    }

    public UpdateGoldMasterResult updateGoldMaster(UpdateGoldMasterRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode();
        if (request.getMeta() != null) {
            body.put("meta", request.getMeta());
        }
        if (request.getBalanceMax() != null) {
            body.put("balanceMax", request.getBalanceMax());
        }
        if (request.getResetType() != null) {
            body.put("resetType", request.getResetType());
        }
        if (request.getResetDayOfMonth() != null) {
            body.put("resetDayOfMonth", request.getResetDayOfMonth());
        }
        if (request.getResetDayOfWeek() != null) {
            body.put("resetDayOfWeek", request.getResetDayOfWeek());
        }
        if (request.getResetHour() != null) {
            body.put("resetHour", request.getResetHour());
        }
        if (request.getLatestGainMax() != null) {
            body.put("latestGainMax", request.getLatestGainMax());
        }
        if (request.getCreateWalletTriggerScript() != null) {
            body.put("createWalletTriggerScript", request.getCreateWalletTriggerScript());
        }
        if (request.getCreateWalletDoneTriggerScript() != null) {
            body.put("createWalletDoneTriggerScript", request.getCreateWalletDoneTriggerScript());
        }
        if (request.getDepositIntoWalletTriggerScript() != null) {
            body.put("depositIntoWalletTriggerScript", request.getDepositIntoWalletTriggerScript());
        }
        if (request.getDepositIntoWalletDoneTriggerScript() != null) {
            body.put("depositIntoWalletDoneTriggerScript", request.getDepositIntoWalletDoneTriggerScript());
        }
        if (request.getWithdrawFromWalletTriggerScript() != null) {
            body.put("withdrawFromWalletTriggerScript", request.getWithdrawFromWalletTriggerScript());
        }
        if (request.getWithdrawFromWalletDoneTriggerScript() != null) {
            body.put("withdrawFromWalletDoneTriggerScript", request.getWithdrawFromWalletDoneTriggerScript());
        }
        HttpPut put = this.createHttpPut("https://{service}.{region}.gs2io.com/goldPool/" + (request.getGoldPoolName() == null || request.getGoldPoolName().equals("") ? "null" : request.getGoldPoolName()) + "/master/gold/" + (request.getGoldName() == null || request.getGoldName().equals("") ? "null" : request.getGoldName()) + "", this.credential, ENDPOINT, "Gs2Gold", "UpdateGoldMaster", body.toString());
        if (request.getRequestId() != null) {
            put.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (UpdateGoldMasterResult)this.doRequest((HttpUriRequest)put, UpdateGoldMasterResult.class);
    }

    public CreateGoldPoolResult createGoldPool(CreateGoldPoolRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("name", request.getName()).put("serviceClass", request.getServiceClass());
        if (request.getDescription() != null) {
            body.put("description", request.getDescription());
        }
        if (request.getCreateWalletTriggerScript() != null) {
            body.put("createWalletTriggerScript", request.getCreateWalletTriggerScript());
        }
        if (request.getCreateWalletDoneTriggerScript() != null) {
            body.put("createWalletDoneTriggerScript", request.getCreateWalletDoneTriggerScript());
        }
        if (request.getDepositIntoWalletTriggerScript() != null) {
            body.put("depositIntoWalletTriggerScript", request.getDepositIntoWalletTriggerScript());
        }
        if (request.getDepositIntoWalletDoneTriggerScript() != null) {
            body.put("depositIntoWalletDoneTriggerScript", request.getDepositIntoWalletDoneTriggerScript());
        }
        if (request.getWithdrawFromWalletTriggerScript() != null) {
            body.put("withdrawFromWalletTriggerScript", request.getWithdrawFromWalletTriggerScript());
        }
        if (request.getWithdrawFromWalletDoneTriggerScript() != null) {
            body.put("withdrawFromWalletDoneTriggerScript", request.getWithdrawFromWalletDoneTriggerScript());
        }
        HttpPost post = this.createHttpPost("https://{service}.{region}.gs2io.com/goldPool", this.credential, ENDPOINT, "Gs2Gold", "CreateGold", body.toString());
        if (request.getRequestId() != null) {
            post.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (CreateGoldPoolResult)this.doRequest((HttpUriRequest)post, CreateGoldPoolResult.class);
    }

    public void deleteGoldPool(DeleteGoldPoolRequest request) {
        String url = "https://{service}.{region}.gs2io.com/goldPool/" + (request.getGoldPoolName() == null || request.getGoldPoolName().equals("") ? "null" : request.getGoldPoolName()) + "";
        HttpDelete delete = this.createHttpDelete(url, this.credential, ENDPOINT, "Gs2Gold", "DeleteGoldPool");
        if (request.getRequestId() != null) {
            delete.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        this.doRequest((HttpUriRequest)delete, null);
    }

    public DescribeGoldPoolResult describeGoldPool(DescribeGoldPoolRequest request) {
        String url = "https://{service}.{region}.gs2io.com/goldPool";
        ArrayList<BasicNameValuePair> queryString = new ArrayList<BasicNameValuePair>();
        if (request.getPageToken() != null) {
            queryString.add(new BasicNameValuePair("pageToken", String.valueOf(request.getPageToken())));
        }
        if (request.getLimit() != null) {
            queryString.add(new BasicNameValuePair("limit", String.valueOf(request.getLimit())));
        }
        if (queryString.size() > 0) {
            url = url + "?" + URLEncodedUtils.format(queryString, (String)"UTF-8");
        }
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Gold", "DescribeGoldPool");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (DescribeGoldPoolResult)this.doRequest((HttpUriRequest)get, DescribeGoldPoolResult.class);
    }

    public DescribeServiceClassResult describeServiceClass(DescribeServiceClassRequest request) {
        String url = "https://{service}.{region}.gs2io.com/goldPool/serviceClass";
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Gold", "DescribeServiceClass");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (DescribeServiceClassResult)this.doRequest((HttpUriRequest)get, DescribeServiceClassResult.class);
    }

    public GetGoldPoolResult getGoldPool(GetGoldPoolRequest request) {
        String url = "https://{service}.{region}.gs2io.com/goldPool/" + (request.getGoldPoolName() == null || request.getGoldPoolName().equals("") ? "null" : request.getGoldPoolName()) + "";
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Gold", "GetGoldPool");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (GetGoldPoolResult)this.doRequest((HttpUriRequest)get, GetGoldPoolResult.class);
    }

    public GetGoldPoolStatusResult getGoldPoolStatus(GetGoldPoolStatusRequest request) {
        String url = "https://{service}.{region}.gs2io.com/goldPool/" + (request.getGoldPoolName() == null || request.getGoldPoolName().equals("") ? "null" : request.getGoldPoolName()) + "/status";
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Gold", "GetGoldPoolStatus");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (GetGoldPoolStatusResult)this.doRequest((HttpUriRequest)get, GetGoldPoolStatusResult.class);
    }

    public UpdateGoldPoolResult updateGoldPool(UpdateGoldPoolRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("serviceClass", request.getServiceClass());
        if (request.getDescription() != null) {
            body.put("description", request.getDescription());
        }
        if (request.getCreateWalletTriggerScript() != null) {
            body.put("createWalletTriggerScript", request.getCreateWalletTriggerScript());
        }
        if (request.getCreateWalletDoneTriggerScript() != null) {
            body.put("createWalletDoneTriggerScript", request.getCreateWalletDoneTriggerScript());
        }
        if (request.getDepositIntoWalletTriggerScript() != null) {
            body.put("depositIntoWalletTriggerScript", request.getDepositIntoWalletTriggerScript());
        }
        if (request.getDepositIntoWalletDoneTriggerScript() != null) {
            body.put("depositIntoWalletDoneTriggerScript", request.getDepositIntoWalletDoneTriggerScript());
        }
        if (request.getWithdrawFromWalletTriggerScript() != null) {
            body.put("withdrawFromWalletTriggerScript", request.getWithdrawFromWalletTriggerScript());
        }
        if (request.getWithdrawFromWalletDoneTriggerScript() != null) {
            body.put("withdrawFromWalletDoneTriggerScript", request.getWithdrawFromWalletDoneTriggerScript());
        }
        HttpPut put = this.createHttpPut("https://{service}.{region}.gs2io.com/goldPool/" + (request.getGoldPoolName() == null || request.getGoldPoolName().equals("") ? "null" : request.getGoldPoolName()) + "", this.credential, ENDPOINT, "Gs2Gold", "UpdateGoldPool", body.toString());
        if (request.getRequestId() != null) {
            put.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (UpdateGoldPoolResult)this.doRequest((HttpUriRequest)put, UpdateGoldPoolResult.class);
    }

    public ExportMasterResult exportMaster(ExportMasterRequest request) {
        String url = "https://{service}.{region}.gs2io.com/goldPool/" + (request.getGoldPoolName() == null || request.getGoldPoolName().equals("") ? "null" : request.getGoldPoolName()) + "/master";
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Gold", "ExportMaster");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (ExportMasterResult)this.doRequest((HttpUriRequest)get, ExportMasterResult.class);
    }

    public GetWalletSettingsResult getWalletSettings(GetWalletSettingsRequest request) {
        String url = "https://{service}.{region}.gs2io.com/goldPool/" + (request.getGoldPoolName() == null || request.getGoldPoolName().equals("") ? "null" : request.getGoldPoolName()) + "/gold/" + (request.getGoldName() == null || request.getGoldName().equals("") ? "null" : request.getGoldName()) + "/wallet/settings";
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Gold", "GetWalletSettings");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (GetWalletSettingsResult)this.doRequest((HttpUriRequest)get, GetWalletSettingsResult.class);
    }

    public void deleteWalletByUserId(DeleteWalletByUserIdRequest request) {
        String url = "https://{service}.{region}.gs2io.com/goldPool/" + (request.getGoldPoolName() == null || request.getGoldPoolName().equals("") ? "null" : request.getGoldPoolName()) + "/gold/" + (request.getGoldName() == null || request.getGoldName().equals("") ? "null" : request.getGoldName()) + "/wallet/user/" + (request.getUserId() == null || request.getUserId().equals("") ? "null" : request.getUserId()) + "";
        HttpDelete delete = this.createHttpDelete(url, this.credential, ENDPOINT, "Gs2Gold", "DeleteWalletByUserId");
        if (request.getRequestId() != null) {
            delete.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        this.doRequest((HttpUriRequest)delete, null);
    }

    public DepositIntoWalletResult depositIntoWallet(DepositIntoWalletRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("value", request.getValue());
        if (request.getContext() != null) {
            body.put("context", request.getContext());
        }
        HttpPost post = this.createHttpPost("https://{service}.{region}.gs2io.com/goldPool/" + (request.getGoldPoolName() == null || request.getGoldPoolName().equals("") ? "null" : request.getGoldPoolName()) + "/gold/" + (request.getGoldName() == null || request.getGoldName().equals("") ? "null" : request.getGoldName()) + "/wallet/user/self/action/deposit", this.credential, ENDPOINT, "Gs2Gold", "DepositIntoWallet", body.toString());
        if (request.getRequestId() != null) {
            post.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        post.setHeader("X-GS2-ACCESS-TOKEN", request.getAccessToken());
        return (DepositIntoWalletResult)this.doRequest((HttpUriRequest)post, DepositIntoWalletResult.class);
    }

    public DepositIntoWalletByStampSheetResult depositIntoWalletByStampSheet(DepositIntoWalletByStampSheetRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("sheet", request.getSheet()).put("keyName", request.getKeyName());
        HttpPost post = this.createHttpPost("https://{service}.{region}.gs2io.com/wallet/action/deposit", this.credential, ENDPOINT, "Gs2Gold", "DepositIntoWalletByStampSheet", body.toString());
        if (request.getRequestId() != null) {
            post.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        post.setHeader("X-GS2-ACCESS-TOKEN", request.getAccessToken());
        return (DepositIntoWalletByStampSheetResult)this.doRequest((HttpUriRequest)post, DepositIntoWalletByStampSheetResult.class);
    }

    public DepositIntoWalletByUserIdResult depositIntoWalletByUserId(DepositIntoWalletByUserIdRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("value", request.getValue());
        if (request.getContext() != null) {
            body.put("context", request.getContext());
        }
        HttpPost post = this.createHttpPost("https://{service}.{region}.gs2io.com/goldPool/" + (request.getGoldPoolName() == null || request.getGoldPoolName().equals("") ? "null" : request.getGoldPoolName()) + "/gold/" + (request.getGoldName() == null || request.getGoldName().equals("") ? "null" : request.getGoldName()) + "/wallet/user/" + (request.getUserId() == null || request.getUserId().equals("") ? "null" : request.getUserId()) + "/action/deposit", this.credential, ENDPOINT, "Gs2Gold", "DepositIntoWalletByUserId", body.toString());
        if (request.getRequestId() != null) {
            post.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (DepositIntoWalletByUserIdResult)this.doRequest((HttpUriRequest)post, DepositIntoWalletByUserIdResult.class);
    }

    public DescribeWalletResult describeWallet(DescribeWalletRequest request) {
        String url = "https://{service}.{region}.gs2io.com/goldPool/" + (request.getGoldPoolName() == null || request.getGoldPoolName().equals("") ? "null" : request.getGoldPoolName()) + "/gold";
        ArrayList<BasicNameValuePair> queryString = new ArrayList<BasicNameValuePair>();
        if (request.getPageToken() != null) {
            queryString.add(new BasicNameValuePair("pageToken", String.valueOf(request.getPageToken())));
        }
        if (request.getLimit() != null) {
            queryString.add(new BasicNameValuePair("limit", String.valueOf(request.getLimit())));
        }
        if (queryString.size() > 0) {
            url = url + "?" + URLEncodedUtils.format(queryString, (String)"UTF-8");
        }
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Gold", "DescribeWallet");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        get.setHeader("X-GS2-ACCESS-TOKEN", request.getAccessToken());
        return (DescribeWalletResult)this.doRequest((HttpUriRequest)get, DescribeWalletResult.class);
    }

    public DescribeWalletByUserIdResult describeWalletByUserId(DescribeWalletByUserIdRequest request) {
        String url = "https://{service}.{region}.gs2io.com/goldPool/" + (request.getGoldPoolName() == null || request.getGoldPoolName().equals("") ? "null" : request.getGoldPoolName()) + "/gold/user/" + (request.getUserId() == null || request.getUserId().equals("") ? "null" : request.getUserId()) + "";
        ArrayList<BasicNameValuePair> queryString = new ArrayList<BasicNameValuePair>();
        if (request.getPageToken() != null) {
            queryString.add(new BasicNameValuePair("pageToken", String.valueOf(request.getPageToken())));
        }
        if (request.getLimit() != null) {
            queryString.add(new BasicNameValuePair("limit", String.valueOf(request.getLimit())));
        }
        if (queryString.size() > 0) {
            url = url + "?" + URLEncodedUtils.format(queryString, (String)"UTF-8");
        }
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Gold", "DescribeWalletByUserId");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (DescribeWalletByUserIdResult)this.doRequest((HttpUriRequest)get, DescribeWalletByUserIdResult.class);
    }

    public GetWalletResult getWallet(GetWalletRequest request) {
        String url = "https://{service}.{region}.gs2io.com/goldPool/" + (request.getGoldPoolName() == null || request.getGoldPoolName().equals("") ? "null" : request.getGoldPoolName()) + "/gold/" + (request.getGoldName() == null || request.getGoldName().equals("") ? "null" : request.getGoldName()) + "/wallet/user/self";
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Gold", "GetWallet");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        get.setHeader("X-GS2-ACCESS-TOKEN", request.getAccessToken());
        return (GetWalletResult)this.doRequest((HttpUriRequest)get, GetWalletResult.class);
    }

    public GetWalletByUserIdResult getWalletByUserId(GetWalletByUserIdRequest request) {
        String url = "https://{service}.{region}.gs2io.com/goldPool/" + (request.getGoldPoolName() == null || request.getGoldPoolName().equals("") ? "null" : request.getGoldPoolName()) + "/gold/" + (request.getGoldName() == null || request.getGoldName().equals("") ? "null" : request.getGoldName()) + "/wallet/user/" + (request.getUserId() == null || request.getUserId().equals("") ? "null" : request.getUserId()) + "";
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Gold", "GetWalletByUserId");
        if (request.getRequestId() != null) {
            get.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (GetWalletByUserIdResult)this.doRequest((HttpUriRequest)get, GetWalletByUserIdResult.class);
    }

    public SetLatestGainResult setLatestGain(SetLatestGainRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("value", request.getValue());
        HttpPost post = this.createHttpPost("https://{service}.{region}.gs2io.com/goldPool/" + (request.getGoldPoolName() == null || request.getGoldPoolName().equals("") ? "null" : request.getGoldPoolName()) + "/gold/" + (request.getGoldName() == null || request.getGoldName().equals("") ? "null" : request.getGoldName()) + "/wallet/user/" + (request.getUserId() == null || request.getUserId().equals("") ? "null" : request.getUserId()) + "/action/set", this.credential, ENDPOINT, "Gs2Gold", "SetLatestGain", body.toString());
        if (request.getRequestId() != null) {
            post.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (SetLatestGainResult)this.doRequest((HttpUriRequest)post, SetLatestGainResult.class);
    }

    public WithdrawFromWalletResult withdrawFromWallet(WithdrawFromWalletRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("value", request.getValue());
        if (request.getContext() != null) {
            body.put("context", request.getContext());
        }
        HttpPost post = this.createHttpPost("https://{service}.{region}.gs2io.com/goldPool/" + (request.getGoldPoolName() == null || request.getGoldPoolName().equals("") ? "null" : request.getGoldPoolName()) + "/gold/" + (request.getGoldName() == null || request.getGoldName().equals("") ? "null" : request.getGoldName()) + "/wallet/user/self/action/withdraw", this.credential, ENDPOINT, "Gs2Gold", "WithdrawFromWallet", body.toString());
        if (request.getRequestId() != null) {
            post.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        post.setHeader("X-GS2-ACCESS-TOKEN", request.getAccessToken());
        return (WithdrawFromWalletResult)this.doRequest((HttpUriRequest)post, WithdrawFromWalletResult.class);
    }

    public WithdrawFromWalletByStampTaskResult withdrawFromWalletByStampTask(WithdrawFromWalletByStampTaskRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("task", request.getTask()).put("keyName", request.getKeyName()).put("transactionId", request.getTransactionId());
        HttpPost post = this.createHttpPost("https://{service}.{region}.gs2io.com/wallet/action/withdraw", this.credential, ENDPOINT, "Gs2Gold", "WithdrawFromWalletByStampTask", body.toString());
        if (request.getRequestId() != null) {
            post.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        post.setHeader("X-GS2-ACCESS-TOKEN", request.getAccessToken());
        return (WithdrawFromWalletByStampTaskResult)this.doRequest((HttpUriRequest)post, WithdrawFromWalletByStampTaskResult.class);
    }

    public WithdrawFromWalletByUserIdResult withdrawFromWalletByUserId(WithdrawFromWalletByUserIdRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("value", request.getValue());
        if (request.getContext() != null) {
            body.put("context", request.getContext());
        }
        HttpPost post = this.createHttpPost("https://{service}.{region}.gs2io.com/goldPool/" + (request.getGoldPoolName() == null || request.getGoldPoolName().equals("") ? "null" : request.getGoldPoolName()) + "/gold/" + (request.getGoldName() == null || request.getGoldName().equals("") ? "null" : request.getGoldName()) + "/wallet/user/" + (request.getUserId() == null || request.getUserId().equals("") ? "null" : request.getUserId()) + "/action/withdraw", this.credential, ENDPOINT, "Gs2Gold", "WithdrawFromWalletByUserId", body.toString());
        if (request.getRequestId() != null) {
            post.setHeader("X-GS2-REQUEST-ID", request.getRequestId());
        }
        return (WithdrawFromWalletByUserIdResult)this.doRequest((HttpUriRequest)post, WithdrawFromWalletByUserIdResult.class);
    }
}

