/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.chat;

import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.gs2.AbstractGs2Client;
import io.gs2.chat.control.CheckEstimateScanByteByAllRoomRequest;
import io.gs2.chat.control.CheckEstimateScanByteByAllRoomResult;
import io.gs2.chat.control.CheckEstimateScanByteByRoomRequest;
import io.gs2.chat.control.CheckEstimateScanByteByRoomResult;
import io.gs2.chat.control.CreateLobbyRequest;
import io.gs2.chat.control.CreateLobbyResult;
import io.gs2.chat.control.CreateMySubscribeRequest;
import io.gs2.chat.control.CreateMySubscribeResult;
import io.gs2.chat.control.CreateRoomRequest;
import io.gs2.chat.control.CreateRoomResult;
import io.gs2.chat.control.CreateSubscribeRequest;
import io.gs2.chat.control.CreateSubscribeResult;
import io.gs2.chat.control.DeleteLobbyRequest;
import io.gs2.chat.control.DeleteMySubscribeRequest;
import io.gs2.chat.control.DeleteRoomRequest;
import io.gs2.chat.control.DeleteSubscribeRequest;
import io.gs2.chat.control.DescribeLobbyRequest;
import io.gs2.chat.control.DescribeLobbyResult;
import io.gs2.chat.control.DescribeMessageNoAuthRequest;
import io.gs2.chat.control.DescribeMessageNoAuthResult;
import io.gs2.chat.control.DescribeMessageRequest;
import io.gs2.chat.control.DescribeMessageResult;
import io.gs2.chat.control.DescribeMySubscribeRequest;
import io.gs2.chat.control.DescribeMySubscribeResult;
import io.gs2.chat.control.DescribeRoomRequest;
import io.gs2.chat.control.DescribeRoomResult;
import io.gs2.chat.control.DescribeServiceClassRequest;
import io.gs2.chat.control.DescribeServiceClassResult;
import io.gs2.chat.control.DescribeSubscribeByRoomIdRequest;
import io.gs2.chat.control.DescribeSubscribeByRoomIdResult;
import io.gs2.chat.control.DescribeSubscribeByUserIdRequest;
import io.gs2.chat.control.DescribeSubscribeByUserIdResult;
import io.gs2.chat.control.GetLobbyRequest;
import io.gs2.chat.control.GetLobbyResult;
import io.gs2.chat.control.GetLobbyStatusRequest;
import io.gs2.chat.control.GetLobbyStatusResult;
import io.gs2.chat.control.GetMySubscribeRequest;
import io.gs2.chat.control.GetMySubscribeResult;
import io.gs2.chat.control.GetRoomRequest;
import io.gs2.chat.control.GetRoomResult;
import io.gs2.chat.control.GetSubscribeRequest;
import io.gs2.chat.control.GetSubscribeResult;
import io.gs2.chat.control.SearchLogByAllRoomRequest;
import io.gs2.chat.control.SearchLogByAllRoomResult;
import io.gs2.chat.control.SearchLogByRoomRequest;
import io.gs2.chat.control.SearchLogByRoomResult;
import io.gs2.chat.control.SendMessageNoAuthRequest;
import io.gs2.chat.control.SendMessageNoAuthResult;
import io.gs2.chat.control.SendMessageRequest;
import io.gs2.chat.control.SendMessageResult;
import io.gs2.chat.control.UpdateLobbyRequest;
import io.gs2.chat.control.UpdateLobbyResult;
import io.gs2.model.IGs2Credential;
import java.util.ArrayList;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;

public class Gs2ChatClient
extends AbstractGs2Client<Gs2ChatClient> {
    public static String ENDPOINT = "chat";

    public Gs2ChatClient(IGs2Credential credential) {
        super(credential);
    }

    public CheckEstimateScanByteByAllRoomResult checkEstimateScanByteByAllRoom(CheckEstimateScanByteByAllRoomRequest request) {
        String url = "https://{service}.{region}.gs2.io/lobby/" + (request.getLobbyName() == null ? "null" : request.getLobbyName()) + "/log/estimate";
        ArrayList<BasicNameValuePair> queryString = new ArrayList<BasicNameValuePair>();
        if (request.getUserId() != null) {
            queryString.add(new BasicNameValuePair("userId", String.valueOf(request.getUserId())));
        }
        if (request.getMessage() != null) {
            queryString.add(new BasicNameValuePair("message", String.valueOf(request.getMessage())));
        }
        if (request.getMeta() != null) {
            queryString.add(new BasicNameValuePair("meta", String.valueOf(request.getMeta())));
        }
        if (request.getBegin() != null) {
            queryString.add(new BasicNameValuePair("begin", String.valueOf(request.getBegin())));
        }
        if (request.getEnd() != null) {
            queryString.add(new BasicNameValuePair("end", String.valueOf(request.getEnd())));
        }
        if (request.getPageToken() != null) {
            queryString.add(new BasicNameValuePair("pageToken", String.valueOf(request.getPageToken())));
        }
        if (request.getLimit() != null) {
            queryString.add(new BasicNameValuePair("limit", String.valueOf(request.getLimit())));
        }
        if (queryString.size() > 0) {
            url = url + "?" + URLEncodedUtils.format(queryString, (String)"UTF-8");
        }
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Chat", "CheckEstimateScanByte");
        return (CheckEstimateScanByteByAllRoomResult)this.doRequest((HttpUriRequest)get, CheckEstimateScanByteByAllRoomResult.class);
    }

    public CheckEstimateScanByteByRoomResult checkEstimateScanByteByRoom(CheckEstimateScanByteByRoomRequest request) {
        String url = "https://{service}.{region}.gs2.io/lobby/" + (request.getLobbyName() == null ? "null" : request.getLobbyName()) + "/room/" + (request.getRoomId() == null ? "null" : request.getRoomId()) + "/log/estimate";
        ArrayList<BasicNameValuePair> queryString = new ArrayList<BasicNameValuePair>();
        if (request.getUserId() != null) {
            queryString.add(new BasicNameValuePair("userId", String.valueOf(request.getUserId())));
        }
        if (request.getMessage() != null) {
            queryString.add(new BasicNameValuePair("message", String.valueOf(request.getMessage())));
        }
        if (request.getMeta() != null) {
            queryString.add(new BasicNameValuePair("meta", String.valueOf(request.getMeta())));
        }
        if (request.getBegin() != null) {
            queryString.add(new BasicNameValuePair("begin", String.valueOf(request.getBegin())));
        }
        if (request.getEnd() != null) {
            queryString.add(new BasicNameValuePair("end", String.valueOf(request.getEnd())));
        }
        if (request.getPageToken() != null) {
            queryString.add(new BasicNameValuePair("pageToken", String.valueOf(request.getPageToken())));
        }
        if (request.getLimit() != null) {
            queryString.add(new BasicNameValuePair("limit", String.valueOf(request.getLimit())));
        }
        if (queryString.size() > 0) {
            url = url + "?" + URLEncodedUtils.format(queryString, (String)"UTF-8");
        }
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Chat", "CheckEstimateScanByte");
        return (CheckEstimateScanByteByRoomResult)this.doRequest((HttpUriRequest)get, CheckEstimateScanByteByRoomResult.class);
    }

    public CreateLobbyResult createLobby(CreateLobbyRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("name", request.getName()).put("serviceClass", request.getServiceClass()).put("notificationType", request.getNotificationType());
        if (request.getNotificationGameName() != null) {
            body.put("notificationGameName", request.getNotificationGameName());
        }
        if (request.getNotificationUrl() != null) {
            body.put("notificationUrl", request.getNotificationUrl());
        }
        if (request.getDescription() != null) {
            body.put("description", request.getDescription());
        }
        HttpPost post = this.createHttpPost("https://{service}.{region}.gs2.io/lobby", this.credential, ENDPOINT, "Gs2Chat", "CreateLobby", body.toString());
        return (CreateLobbyResult)this.doRequest((HttpUriRequest)post, CreateLobbyResult.class);
    }

    public CreateMySubscribeResult createMySubscribe(CreateMySubscribeRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode();
        if (request.getEnableOfflineTransfer() != null) {
            body.put("enableOfflineTransfer", request.getEnableOfflineTransfer());
        }
        if (request.getPassword() != null) {
            body.put("password", request.getPassword());
        }
        if (request.getOfflineTransferSound() != null) {
            body.put("offlineTransferSound", request.getOfflineTransferSound());
        }
        HttpPost post = this.createHttpPost("https://{service}.{region}.gs2.io/lobby/" + (request.getLobbyName() == null ? "null" : request.getLobbyName()) + "/room/" + (request.getRoomId() == null ? "null" : request.getRoomId()) + "/subscribe", this.credential, ENDPOINT, "Gs2Chat", "CreateMySubscribe", body.toString());
        post.setHeader("X-GS2-ACCESS-TOKEN", request.getAccessToken());
        return (CreateMySubscribeResult)this.doRequest((HttpUriRequest)post, CreateMySubscribeResult.class);
    }

    public CreateRoomResult createRoom(CreateRoomRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode();
        if (request.getRoomId() != null) {
            body.put("roomId", request.getRoomId());
        }
        if (request.getPassword() != null) {
            body.put("password", request.getPassword());
        }
        if (request.getAllowUserIds() != null) {
            body.put("allowUserIds", request.getAllowUserIds());
        }
        HttpPost post = this.createHttpPost("https://{service}.{region}.gs2.io/lobby/" + (request.getLobbyName() == null ? "null" : request.getLobbyName()) + "/room", this.credential, ENDPOINT, "Gs2Chat", "CreateRoom", body.toString());
        return (CreateRoomResult)this.doRequest((HttpUriRequest)post, CreateRoomResult.class);
    }

    public CreateSubscribeResult createSubscribe(CreateSubscribeRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode();
        if (request.getEnableOfflineTransfer() != null) {
            body.put("enableOfflineTransfer", request.getEnableOfflineTransfer());
        }
        if (request.getPassword() != null) {
            body.put("password", request.getPassword());
        }
        if (request.getOfflineTransferSound() != null) {
            body.put("offlineTransferSound", request.getOfflineTransferSound());
        }
        HttpPost post = this.createHttpPost("https://{service}.{region}.gs2.io/lobby/" + (request.getLobbyName() == null ? "null" : request.getLobbyName()) + "/room/" + (request.getRoomId() == null ? "null" : request.getRoomId()) + "/user/" + (request.getUserId() == null ? "null" : request.getUserId()) + "/subscribe", this.credential, ENDPOINT, "Gs2Chat", "CreateSubscribe", body.toString());
        return (CreateSubscribeResult)this.doRequest((HttpUriRequest)post, CreateSubscribeResult.class);
    }

    public void deleteLobby(DeleteLobbyRequest request) {
        String url = "https://{service}.{region}.gs2.io/lobby/" + (request.getLobbyName() == null ? "null" : request.getLobbyName()) + "";
        HttpDelete delete = this.createHttpDelete(url, this.credential, ENDPOINT, "Gs2Chat", "DeleteLobby");
        this.doRequest((HttpUriRequest)delete, null);
    }

    public void deleteMySubscribe(DeleteMySubscribeRequest request) {
        String url = "https://{service}.{region}.gs2.io/lobby/" + (request.getLobbyName() == null ? "null" : request.getLobbyName()) + "/room/" + (request.getRoomId() == null ? "null" : request.getRoomId()) + "/user/self/subscribe";
        HttpDelete delete = this.createHttpDelete(url, this.credential, ENDPOINT, "Gs2Chat", "DeleteMySubscribe");
        delete.setHeader("X-GS2-ACCESS-TOKEN", request.getAccessToken());
        this.doRequest((HttpUriRequest)delete, null);
    }

    public void deleteRoom(DeleteRoomRequest request) {
        String url = "https://{service}.{region}.gs2.io/lobby/" + (request.getLobbyName() == null ? "null" : request.getLobbyName()) + "/room/" + (request.getRoomId() == null ? "null" : request.getRoomId()) + "";
        HttpDelete delete = this.createHttpDelete(url, this.credential, ENDPOINT, "Gs2Chat", "DeleteRoom");
        this.doRequest((HttpUriRequest)delete, null);
    }

    public void deleteSubscribe(DeleteSubscribeRequest request) {
        String url = "https://{service}.{region}.gs2.io/lobby/" + (request.getLobbyName() == null ? "null" : request.getLobbyName()) + "/room/" + (request.getRoomId() == null ? "null" : request.getRoomId()) + "/user/" + (request.getUserId() == null ? "null" : request.getUserId()) + "/subscribe";
        HttpDelete delete = this.createHttpDelete(url, this.credential, ENDPOINT, "Gs2Chat", "DeleteSubscribe");
        this.doRequest((HttpUriRequest)delete, null);
    }

    public DescribeLobbyResult describeLobby(DescribeLobbyRequest request) {
        String url = "https://{service}.{region}.gs2.io/lobby";
        ArrayList<BasicNameValuePair> queryString = new ArrayList<BasicNameValuePair>();
        if (request.getPageToken() != null) {
            queryString.add(new BasicNameValuePair("pageToken", String.valueOf(request.getPageToken())));
        }
        if (request.getLimit() != null) {
            queryString.add(new BasicNameValuePair("limit", String.valueOf(request.getLimit())));
        }
        if (queryString.size() > 0) {
            url = url + "?" + URLEncodedUtils.format(queryString, (String)"UTF-8");
        }
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Chat", "DescribeLobby");
        return (DescribeLobbyResult)this.doRequest((HttpUriRequest)get, DescribeLobbyResult.class);
    }

    public DescribeMessageResult describeMessage(DescribeMessageRequest request) {
        String url = "https://{service}.{region}.gs2.io/lobby/" + (request.getLobbyName() == null ? "null" : request.getLobbyName()) + "/room/" + (request.getRoomId() == null ? "null" : request.getRoomId()) + "/message";
        ArrayList<BasicNameValuePair> queryString = new ArrayList<BasicNameValuePair>();
        if (request.getPassword() != null) {
            queryString.add(new BasicNameValuePair("password", String.valueOf(request.getPassword())));
        }
        if (request.getStartAt() != null) {
            queryString.add(new BasicNameValuePair("startAt", String.valueOf(request.getStartAt())));
        }
        if (request.getLimit() != null) {
            queryString.add(new BasicNameValuePair("limit", String.valueOf(request.getLimit())));
        }
        if (queryString.size() > 0) {
            url = url + "?" + URLEncodedUtils.format(queryString, (String)"UTF-8");
        }
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Chat", "DescribeMessage");
        get.setHeader("X-GS2-ACCESS-TOKEN", request.getAccessToken());
        return (DescribeMessageResult)this.doRequest((HttpUriRequest)get, DescribeMessageResult.class);
    }

    public DescribeMessageNoAuthResult describeMessageNoAuth(DescribeMessageNoAuthRequest request) {
        String url = "https://{service}.{region}.gs2.io/lobby/" + (request.getLobbyName() == null ? "null" : request.getLobbyName()) + "/room/" + (request.getRoomId() == null ? "null" : request.getRoomId()) + "/message/force";
        ArrayList<BasicNameValuePair> queryString = new ArrayList<BasicNameValuePair>();
        if (request.getStartAt() != null) {
            queryString.add(new BasicNameValuePair("startAt", String.valueOf(request.getStartAt())));
        }
        if (request.getLimit() != null) {
            queryString.add(new BasicNameValuePair("limit", String.valueOf(request.getLimit())));
        }
        if (queryString.size() > 0) {
            url = url + "?" + URLEncodedUtils.format(queryString, (String)"UTF-8");
        }
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Chat", "DescribeMessageNoAuth");
        return (DescribeMessageNoAuthResult)this.doRequest((HttpUriRequest)get, DescribeMessageNoAuthResult.class);
    }

    public DescribeMySubscribeResult describeMySubscribe(DescribeMySubscribeRequest request) {
        String url = "https://{service}.{region}.gs2.io/lobby/" + (request.getLobbyName() == null ? "null" : request.getLobbyName()) + "/user/subscribe";
        ArrayList<BasicNameValuePair> queryString = new ArrayList<BasicNameValuePair>();
        if (request.getPageToken() != null) {
            queryString.add(new BasicNameValuePair("pageToken", String.valueOf(request.getPageToken())));
        }
        if (request.getLimit() != null) {
            queryString.add(new BasicNameValuePair("limit", String.valueOf(request.getLimit())));
        }
        if (queryString.size() > 0) {
            url = url + "?" + URLEncodedUtils.format(queryString, (String)"UTF-8");
        }
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Chat", "DescribeMySubscribe");
        get.setHeader("X-GS2-ACCESS-TOKEN", request.getAccessToken());
        return (DescribeMySubscribeResult)this.doRequest((HttpUriRequest)get, DescribeMySubscribeResult.class);
    }

    public DescribeRoomResult describeRoom(DescribeRoomRequest request) {
        String url = "https://{service}.{region}.gs2.io/lobby/" + (request.getLobbyName() == null ? "null" : request.getLobbyName()) + "/room";
        ArrayList<BasicNameValuePair> queryString = new ArrayList<BasicNameValuePair>();
        if (request.getPageToken() != null) {
            queryString.add(new BasicNameValuePair("pageToken", String.valueOf(request.getPageToken())));
        }
        if (request.getLimit() != null) {
            queryString.add(new BasicNameValuePair("limit", String.valueOf(request.getLimit())));
        }
        if (queryString.size() > 0) {
            url = url + "?" + URLEncodedUtils.format(queryString, (String)"UTF-8");
        }
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Chat", "DescribeRoom");
        return (DescribeRoomResult)this.doRequest((HttpUriRequest)get, DescribeRoomResult.class);
    }

    public DescribeServiceClassResult describeServiceClass(DescribeServiceClassRequest request) {
        String url = "https://{service}.{region}.gs2.io/lobby/serviceClass";
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Chat", "DescribeServiceClass");
        return (DescribeServiceClassResult)this.doRequest((HttpUriRequest)get, DescribeServiceClassResult.class);
    }

    public DescribeSubscribeByRoomIdResult describeSubscribeByRoomId(DescribeSubscribeByRoomIdRequest request) {
        String url = "https://{service}.{region}.gs2.io/lobby/" + (request.getLobbyName() == null ? "null" : request.getLobbyName()) + "/room/" + (request.getRoomId() == null ? "null" : request.getRoomId()) + "/subscribe";
        ArrayList<BasicNameValuePair> queryString = new ArrayList<BasicNameValuePair>();
        if (request.getPageToken() != null) {
            queryString.add(new BasicNameValuePair("pageToken", String.valueOf(request.getPageToken())));
        }
        if (request.getLimit() != null) {
            queryString.add(new BasicNameValuePair("limit", String.valueOf(request.getLimit())));
        }
        if (queryString.size() > 0) {
            url = url + "?" + URLEncodedUtils.format(queryString, (String)"UTF-8");
        }
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Chat", "DescribeSubscribeByRoomId");
        return (DescribeSubscribeByRoomIdResult)this.doRequest((HttpUriRequest)get, DescribeSubscribeByRoomIdResult.class);
    }

    public DescribeSubscribeByUserIdResult describeSubscribeByUserId(DescribeSubscribeByUserIdRequest request) {
        String url = "https://{service}.{region}.gs2.io/lobby/" + (request.getLobbyName() == null ? "null" : request.getLobbyName()) + "/user/" + (request.getUserId() == null ? "null" : request.getUserId()) + "/subscribe";
        ArrayList<BasicNameValuePair> queryString = new ArrayList<BasicNameValuePair>();
        if (request.getPageToken() != null) {
            queryString.add(new BasicNameValuePair("pageToken", String.valueOf(request.getPageToken())));
        }
        if (request.getLimit() != null) {
            queryString.add(new BasicNameValuePair("limit", String.valueOf(request.getLimit())));
        }
        if (queryString.size() > 0) {
            url = url + "?" + URLEncodedUtils.format(queryString, (String)"UTF-8");
        }
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Chat", "DescribeSubscribeByUserId");
        return (DescribeSubscribeByUserIdResult)this.doRequest((HttpUriRequest)get, DescribeSubscribeByUserIdResult.class);
    }

    public GetLobbyResult getLobby(GetLobbyRequest request) {
        String url = "https://{service}.{region}.gs2.io/lobby/" + (request.getLobbyName() == null ? "null" : request.getLobbyName()) + "";
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Chat", "GetLobby");
        return (GetLobbyResult)this.doRequest((HttpUriRequest)get, GetLobbyResult.class);
    }

    public GetLobbyStatusResult getLobbyStatus(GetLobbyStatusRequest request) {
        String url = "https://{service}.{region}.gs2.io/lobby/" + (request.getLobbyName() == null ? "null" : request.getLobbyName()) + "/status";
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Chat", "GetLobbyStatus");
        return (GetLobbyStatusResult)this.doRequest((HttpUriRequest)get, GetLobbyStatusResult.class);
    }

    public GetMySubscribeResult getMySubscribe(GetMySubscribeRequest request) {
        String url = "https://{service}.{region}.gs2.io/lobby/" + (request.getLobbyName() == null ? "null" : request.getLobbyName()) + "/room/" + (request.getRoomId() == null ? "null" : request.getRoomId()) + "/user/self/subscribe";
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Chat", "GetMySubscribe");
        get.setHeader("X-GS2-ACCESS-TOKEN", request.getAccessToken());
        return (GetMySubscribeResult)this.doRequest((HttpUriRequest)get, GetMySubscribeResult.class);
    }

    public GetRoomResult getRoom(GetRoomRequest request) {
        String url = "https://{service}.{region}.gs2.io/lobby/" + (request.getLobbyName() == null ? "null" : request.getLobbyName()) + "/room/" + (request.getRoomId() == null ? "null" : request.getRoomId()) + "";
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Chat", "GetRoom");
        return (GetRoomResult)this.doRequest((HttpUriRequest)get, GetRoomResult.class);
    }

    public GetSubscribeResult getSubscribe(GetSubscribeRequest request) {
        String url = "https://{service}.{region}.gs2.io/lobby/" + (request.getLobbyName() == null ? "null" : request.getLobbyName()) + "/room/" + (request.getRoomId() == null ? "null" : request.getRoomId()) + "/user/" + (request.getUserId() == null ? "null" : request.getUserId()) + "/subscribe";
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Chat", "GetSubscribe");
        return (GetSubscribeResult)this.doRequest((HttpUriRequest)get, GetSubscribeResult.class);
    }

    public SearchLogByAllRoomResult searchLogByAllRoom(SearchLogByAllRoomRequest request) {
        String url = "https://{service}.{region}.gs2.io/lobby/" + (request.getLobbyName() == null ? "null" : request.getLobbyName()) + "/log";
        ArrayList<BasicNameValuePair> queryString = new ArrayList<BasicNameValuePair>();
        if (request.getUserId() != null) {
            queryString.add(new BasicNameValuePair("userId", String.valueOf(request.getUserId())));
        }
        if (request.getMessage() != null) {
            queryString.add(new BasicNameValuePair("message", String.valueOf(request.getMessage())));
        }
        if (request.getMeta() != null) {
            queryString.add(new BasicNameValuePair("meta", String.valueOf(request.getMeta())));
        }
        if (request.getBegin() != null) {
            queryString.add(new BasicNameValuePair("begin", String.valueOf(request.getBegin())));
        }
        if (request.getEnd() != null) {
            queryString.add(new BasicNameValuePair("end", String.valueOf(request.getEnd())));
        }
        if (request.getPageToken() != null) {
            queryString.add(new BasicNameValuePair("pageToken", String.valueOf(request.getPageToken())));
        }
        if (request.getLimit() != null) {
            queryString.add(new BasicNameValuePair("limit", String.valueOf(request.getLimit())));
        }
        if (queryString.size() > 0) {
            url = url + "?" + URLEncodedUtils.format(queryString, (String)"UTF-8");
        }
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Chat", "SearchLogByAllRoom");
        return (SearchLogByAllRoomResult)this.doRequest((HttpUriRequest)get, SearchLogByAllRoomResult.class);
    }

    public SearchLogByRoomResult searchLogByRoom(SearchLogByRoomRequest request) {
        String url = "https://{service}.{region}.gs2.io/lobby/" + (request.getLobbyName() == null ? "null" : request.getLobbyName()) + "/room/" + (request.getRoomId() == null ? "null" : request.getRoomId()) + "/log";
        ArrayList<BasicNameValuePair> queryString = new ArrayList<BasicNameValuePair>();
        if (request.getUserId() != null) {
            queryString.add(new BasicNameValuePair("userId", String.valueOf(request.getUserId())));
        }
        if (request.getMessage() != null) {
            queryString.add(new BasicNameValuePair("message", String.valueOf(request.getMessage())));
        }
        if (request.getMeta() != null) {
            queryString.add(new BasicNameValuePair("meta", String.valueOf(request.getMeta())));
        }
        if (request.getBegin() != null) {
            queryString.add(new BasicNameValuePair("begin", String.valueOf(request.getBegin())));
        }
        if (request.getEnd() != null) {
            queryString.add(new BasicNameValuePair("end", String.valueOf(request.getEnd())));
        }
        if (request.getPageToken() != null) {
            queryString.add(new BasicNameValuePair("pageToken", String.valueOf(request.getPageToken())));
        }
        if (request.getLimit() != null) {
            queryString.add(new BasicNameValuePair("limit", String.valueOf(request.getLimit())));
        }
        if (queryString.size() > 0) {
            url = url + "?" + URLEncodedUtils.format(queryString, (String)"UTF-8");
        }
        HttpGet get = this.createHttpGet(url, this.credential, ENDPOINT, "Gs2Chat", "SearchLogByRoom");
        return (SearchLogByRoomResult)this.doRequest((HttpUriRequest)get, SearchLogByRoomResult.class);
    }

    public SendMessageResult sendMessage(SendMessageRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("message", request.getMessage());
        if (request.getPassword() != null) {
            body.put("password", request.getPassword());
        }
        if (request.getMeta() != null) {
            body.put("meta", request.getMeta());
        }
        HttpPost post = this.createHttpPost("https://{service}.{region}.gs2.io/lobby/" + (request.getLobbyName() == null ? "null" : request.getLobbyName()) + "/room/" + (request.getRoomId() == null ? "null" : request.getRoomId()) + "/message", this.credential, ENDPOINT, "Gs2Chat", "SendMessage", body.toString());
        post.setHeader("X-GS2-ACCESS-TOKEN", request.getAccessToken());
        return (SendMessageResult)this.doRequest((HttpUriRequest)post, SendMessageResult.class);
    }

    public SendMessageNoAuthResult sendMessageNoAuth(SendMessageNoAuthRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("message", request.getMessage()).put("userId", request.getUserId());
        if (request.getMeta() != null) {
            body.put("meta", request.getMeta());
        }
        HttpPost post = this.createHttpPost("https://{service}.{region}.gs2.io/lobby/" + (request.getLobbyName() == null ? "null" : request.getLobbyName()) + "/room/" + (request.getRoomId() == null ? "null" : request.getRoomId()) + "/message/force", this.credential, ENDPOINT, "Gs2Chat", "SendMessageNoAuth", body.toString());
        return (SendMessageNoAuthResult)this.doRequest((HttpUriRequest)post, SendMessageNoAuthResult.class);
    }

    public UpdateLobbyResult updateLobby(UpdateLobbyRequest request) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("notificationType", request.getNotificationType()).put("serviceClass", request.getServiceClass());
        if (request.getDescription() != null) {
            body.put("description", request.getDescription());
        }
        if (request.getNotificationGameName() != null) {
            body.put("notificationGameName", request.getNotificationGameName());
        }
        if (request.getNotificationUrl() != null) {
            body.put("notificationUrl", request.getNotificationUrl());
        }
        HttpPut put = this.createHttpPut("https://{service}.{region}.gs2.io/lobby/" + (request.getLobbyName() == null ? "null" : request.getLobbyName()) + "", this.credential, ENDPOINT, "Gs2Chat", "UpdateLobby", body.toString());
        return (UpdateLobbyResult)this.doRequest((HttpUriRequest)put, UpdateLobbyResult.class);
    }
}

