/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.cdk.skillTree.model;

import io.gs2.cdk.core.func.GetAttr;
import io.gs2.cdk.core.model.CdkResource;
import io.gs2.cdk.core.model.LogSetting;
import io.gs2.cdk.core.model.ScriptSetting;
import io.gs2.cdk.core.model.Stack;
import io.gs2.cdk.core.model.TransactionSetting;
import io.gs2.cdk.skillTree.model.CurrentMasterData;
import io.gs2.cdk.skillTree.model.NodeModel;
import io.gs2.cdk.skillTree.model.options.NamespaceOptions;
import io.gs2.cdk.skillTree.ref.NamespaceRef;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Namespace
extends CdkResource {
    private Stack stack;
    private String name;
    private String description = null;
    private TransactionSetting transactionSetting = null;
    private ScriptSetting releaseScript = null;
    private ScriptSetting restrainScript = null;
    private LogSetting logSetting = null;

    public Namespace(Stack stack, String name, NamespaceOptions options) {
        super("SkillTree_Namespace_" + name);
        this.stack = stack;
        this.name = name;
        this.description = options.description;
        this.transactionSetting = options.transactionSetting;
        this.releaseScript = options.releaseScript;
        this.restrainScript = options.restrainScript;
        this.logSetting = options.logSetting;
        stack.addResource(this);
    }

    public Namespace(Stack stack, String name) {
        super("SkillTree_Namespace_" + name);
        this.stack = stack;
        this.name = name;
        stack.addResource(this);
    }

    public String alternateKeys() {
        return "name";
    }

    @Override
    public String resourceType() {
        return "GS2::SkillTree::Namespace";
    }

    @Override
    public Map<String, Object> properties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (this.name != null) {
            properties.put("Name", this.name);
        }
        if (this.description != null) {
            properties.put("Description", this.description);
        }
        if (this.transactionSetting != null) {
            properties.put("TransactionSetting", this.transactionSetting.properties());
        }
        if (this.releaseScript != null) {
            properties.put("ReleaseScript", this.releaseScript.properties());
        }
        if (this.restrainScript != null) {
            properties.put("RestrainScript", this.restrainScript.properties());
        }
        if (this.logSetting != null) {
            properties.put("LogSetting", this.logSetting.properties());
        }
        return properties;
    }

    public NamespaceRef ref() {
        return new NamespaceRef(this.name);
    }

    public GetAttr getAttrNamespaceId() {
        return new GetAttr(this, "Item.NamespaceId", null);
    }

    public Namespace masterData(List<NodeModel> nodeModels) {
        new CurrentMasterData(this.stack, this.name, nodeModels).addDependsOn(this);
        return this;
    }
}

