/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.cdk.script.model;

import io.gs2.cdk.core.func.GetAttr;
import io.gs2.cdk.core.model.CdkResource;
import io.gs2.cdk.core.model.Stack;
import io.gs2.cdk.script.model.options.ScriptOptions;
import io.gs2.cdk.script.ref.ScriptRef;
import java.util.HashMap;
import java.util.Map;

public class Script
extends CdkResource {
    private Stack stack;
    private String namespaceName;
    private String name;
    private String script;
    private String description = null;

    public Script(Stack stack, String namespaceName, String name, String script, ScriptOptions options) {
        super("Script_Script_" + name);
        this.stack = stack;
        this.namespaceName = namespaceName;
        this.name = name;
        this.script = script;
        this.description = options.description;
        stack.addResource(this);
    }

    public Script(Stack stack, String namespaceName, String name, String script) {
        super("Script_Script_" + name);
        this.stack = stack;
        this.namespaceName = namespaceName;
        this.name = name;
        this.script = script;
        stack.addResource(this);
    }

    public String alternateKeys() {
        return "name";
    }

    @Override
    public String resourceType() {
        return "GS2::Script::Script";
    }

    @Override
    public Map<String, Object> properties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (this.namespaceName != null) {
            properties.put("NamespaceName", this.namespaceName);
        }
        if (this.name != null) {
            properties.put("Name", this.name);
        }
        if (this.description != null) {
            properties.put("Description", this.description);
        }
        if (this.script != null) {
            properties.put("Script", this.script);
        }
        return properties;
    }

    public ScriptRef ref() {
        return new ScriptRef(this.namespaceName, this.name);
    }

    public GetAttr getAttrScriptId() {
        return new GetAttr(this, "Item.ScriptId", null);
    }
}

