/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.cdk.lottery.model;

import io.gs2.cdk.lottery.model.enums.LotteryModelMethod;
import io.gs2.cdk.lottery.model.enums.LotteryModelMode;
import io.gs2.cdk.lottery.model.options.LotteryModelMethodIsPrizeTableOptions;
import io.gs2.cdk.lottery.model.options.LotteryModelMethodIsScriptOptions;
import io.gs2.cdk.lottery.model.options.LotteryModelOptions;
import java.util.HashMap;
import java.util.Map;

public class LotteryModel {
    private String name;
    private LotteryModelMode mode;
    private LotteryModelMethod method;
    private String metadata = null;
    private String prizeTableName = null;
    private String choicePrizeTableScriptId = null;

    public LotteryModel(String name, LotteryModelMode mode, LotteryModelMethod method, LotteryModelOptions options) {
        this.name = name;
        this.mode = mode;
        this.method = method;
        this.metadata = options.metadata;
        this.prizeTableName = options.prizeTableName;
        this.choicePrizeTableScriptId = options.choicePrizeTableScriptId;
    }

    public LotteryModel(String name, LotteryModelMode mode, LotteryModelMethod method) {
        this.name = name;
        this.mode = mode;
        this.method = method;
    }

    public static LotteryModel methodIsPrizeTable(String name, LotteryModelMode mode, String prizeTableName, LotteryModelMethodIsPrizeTableOptions options) {
        return new LotteryModel(name, mode, LotteryModelMethod.PRIZE_TABLE, new LotteryModelOptions().withPrizeTableName(prizeTableName).withMetadata(options.metadata));
    }

    public static LotteryModel methodIsPrizeTable(String name, LotteryModelMode mode, String prizeTableName) {
        return new LotteryModel(name, mode, LotteryModelMethod.PRIZE_TABLE);
    }

    public static LotteryModel methodIsScript(String name, LotteryModelMode mode, String choicePrizeTableScriptId, LotteryModelMethodIsScriptOptions options) {
        return new LotteryModel(name, mode, LotteryModelMethod.SCRIPT, new LotteryModelOptions().withChoicePrizeTableScriptId(choicePrizeTableScriptId).withMetadata(options.metadata));
    }

    public static LotteryModel methodIsScript(String name, LotteryModelMode mode, String choicePrizeTableScriptId) {
        return new LotteryModel(name, mode, LotteryModelMethod.SCRIPT);
    }

    public Map<String, Object> properties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (this.name != null) {
            properties.put("name", this.name);
        }
        if (this.metadata != null) {
            properties.put("metadata", this.metadata);
        }
        if (this.mode != null) {
            properties.put("mode", this.mode.toString());
        }
        if (this.method != null) {
            properties.put("method", this.method.toString());
        }
        if (this.prizeTableName != null) {
            properties.put("prizeTableName", this.prizeTableName);
        }
        if (this.choicePrizeTableScriptId != null) {
            properties.put("choicePrizeTableScriptId", this.choicePrizeTableScriptId);
        }
        return properties;
    }
}

