/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.cdk.inventory.model;

import io.gs2.cdk.core.model.CdkResource;
import io.gs2.cdk.core.model.Stack;
import io.gs2.cdk.inventory.model.BigInventoryModel;
import io.gs2.cdk.inventory.model.InventoryModel;
import io.gs2.cdk.inventory.model.SimpleInventoryModel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CurrentMasterData
extends CdkResource {
    private String version = "2019-02-05";
    private String namespaceName;
    private List<InventoryModel> inventoryModels;
    private List<SimpleInventoryModel> simpleInventoryModels;
    private List<BigInventoryModel> bigInventoryModels;

    public CurrentMasterData(Stack stack, String namespaceName, List<InventoryModel> inventoryModels, List<SimpleInventoryModel> simpleInventoryModels, List<BigInventoryModel> bigInventoryModels) {
        super("Inventory_CurrentItemModelMaster_" + namespaceName);
        this.namespaceName = namespaceName;
        this.inventoryModels = inventoryModels;
        this.simpleInventoryModels = simpleInventoryModels;
        this.bigInventoryModels = bigInventoryModels;
        stack.addResource(this);
    }

    public String alternateKeys() {
        return this.namespaceName;
    }

    @Override
    public String resourceType() {
        return "GS2::Inventory::CurrentItemModelMaster";
    }

    @Override
    public Map<String, Object> properties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("version", this.version);
        if (this.inventoryModels != null) {
            settings.put("inventoryModels", this.inventoryModels.stream().map(v -> v.properties()).collect(Collectors.toList()));
        }
        if (this.simpleInventoryModels != null) {
            settings.put("simpleInventoryModels", this.simpleInventoryModels.stream().map(v -> v.properties()).collect(Collectors.toList()));
        }
        if (this.bigInventoryModels != null) {
            settings.put("bigInventoryModels", this.bigInventoryModels.stream().map(v -> v.properties()).collect(Collectors.toList()));
        }
        if (this.namespaceName != null) {
            properties.put("NamespaceName", this.namespaceName);
        }
        if (settings != null) {
            properties.put("Settings", settings);
        }
        return properties;
    }
}

