/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.cdk.identifier.model;

import io.gs2.cdk.core.func.GetAttr;
import io.gs2.cdk.core.model.CdkResource;
import io.gs2.cdk.core.model.Stack;
import io.gs2.cdk.identifier.model.AttachSecurityPolicy;
import io.gs2.cdk.identifier.model.Identifier;
import io.gs2.cdk.identifier.model.SecurityPolicy;
import io.gs2.cdk.identifier.model.options.UserOptions;
import io.gs2.cdk.identifier.ref.UserRef;
import java.util.HashMap;
import java.util.Map;

public class User
extends CdkResource {
    private Stack stack;
    private String name;
    private String description = null;

    public User(Stack stack, String name, UserOptions options) {
        super("Identifier_User_" + name);
        this.stack = stack;
        this.name = name;
        this.description = options.description;
        stack.addResource(this);
    }

    public User(Stack stack, String name) {
        super("Identifier_User_" + name);
        this.stack = stack;
        this.name = name;
        stack.addResource(this);
    }

    public String alternateKeys() {
        return "name";
    }

    @Override
    public String resourceType() {
        return "GS2::Identifier::User";
    }

    @Override
    public Map<String, Object> properties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (this.name != null) {
            properties.put("Name", this.name);
        }
        if (this.description != null) {
            properties.put("Description", this.description);
        }
        return properties;
    }

    public UserRef ref() {
        return new UserRef(this.name);
    }

    public User attach(SecurityPolicy securityPolicy) {
        new AttachSecurityPolicy(this.stack, this.name, securityPolicy.getAttrSecurityPolicyId().str()).addDependsOn(this).addDependsOn(securityPolicy);
        return this;
    }

    public User attachGrn(String securityPolicyGrn) {
        new AttachSecurityPolicy(this.stack, this.name, securityPolicyGrn).addDependsOn(this);
        return this;
    }

    public Identifier identifier() {
        Identifier identifier = new Identifier(this.stack, this.name);
        identifier.addDependsOn(this);
        return identifier;
    }

    public GetAttr getAttrUserId() {
        return new GetAttr(this, "Item.UserId", null);
    }
}

