/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.cdk.identifier.model;

import io.gs2.cdk.core.func.GetAttr;
import io.gs2.cdk.core.model.CdkResource;
import io.gs2.cdk.core.model.Stack;
import io.gs2.cdk.identifier.model.Policy;
import io.gs2.cdk.identifier.model.options.SecurityPolicyOptions;
import io.gs2.cdk.identifier.ref.SecurityPolicyRef;
import java.util.HashMap;
import java.util.Map;

public class SecurityPolicy
extends CdkResource {
    private Stack stack;
    private String name;
    private Policy policy;
    private String description = null;

    public SecurityPolicy(Stack stack, String name, Policy policy, SecurityPolicyOptions options) {
        super("Identifier_SecurityPolicy_" + name);
        this.stack = stack;
        this.name = name;
        this.policy = policy;
        this.description = options.description;
        stack.addResource(this);
    }

    public SecurityPolicy(Stack stack, String name, Policy policy) {
        super("Identifier_SecurityPolicy_" + name);
        this.stack = stack;
        this.name = name;
        this.policy = policy;
        stack.addResource(this);
    }

    public String alternateKeys() {
        return "name";
    }

    @Override
    public String resourceType() {
        return "GS2::Identifier::SecurityPolicy";
    }

    @Override
    public Map<String, Object> properties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (this.name != null) {
            properties.put("Name", this.name);
        }
        if (this.description != null) {
            properties.put("Description", this.description);
        }
        if (this.policy != null) {
            properties.put("Policy", this.policy.properties());
        }
        return properties;
    }

    public SecurityPolicyRef ref() {
        return new SecurityPolicyRef(this.name);
    }

    public static String applicationAccessGrn() {
        return "grn:gs2::system:identifier:securityPolicy:ApplicationAccess";
    }

    public GetAttr getAttrSecurityPolicyId() {
        return new GetAttr(this, "Item.SecurityPolicyId", null);
    }
}

