/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.cdk.formation.model;

import io.gs2.cdk.formation.model.SlotModel;
import io.gs2.cdk.formation.model.options.FormModelOptions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class FormModel {
    private String name;
    private List<SlotModel> slots;
    private String metadata = null;

    public FormModel(String name, List<SlotModel> slots, FormModelOptions options) {
        this.name = name;
        this.slots = slots;
        this.metadata = options.metadata;
    }

    public FormModel(String name, List<SlotModel> slots) {
        this.name = name;
        this.slots = slots;
    }

    public Map<String, Object> properties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (this.name != null) {
            properties.put("name", this.name);
        }
        if (this.metadata != null) {
            properties.put("metadata", this.metadata);
        }
        if (this.slots != null) {
            properties.put("slots", this.slots.stream().map(v -> v.properties()).collect(Collectors.toList()));
        }
        return properties;
    }
}

