/*
 * Decompiled with CFR 0.152.
 */
package io.gs2.cdk.exchange.model;

import io.gs2.cdk.core.model.CdkResource;
import io.gs2.cdk.core.model.Stack;
import io.gs2.cdk.exchange.model.IncrementalRateModel;
import io.gs2.cdk.exchange.model.RateModel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CurrentMasterData
extends CdkResource {
    private String version = "2019-08-19";
    private String namespaceName;
    private List<RateModel> rateModels;
    private List<IncrementalRateModel> incrementalRateModels;

    public CurrentMasterData(Stack stack, String namespaceName, List<RateModel> rateModels, List<IncrementalRateModel> incrementalRateModels) {
        super("Exchange_CurrentRateMaster_" + namespaceName);
        this.namespaceName = namespaceName;
        this.rateModels = rateModels;
        this.incrementalRateModels = incrementalRateModels;
        stack.addResource(this);
    }

    public String alternateKeys() {
        return this.namespaceName;
    }

    @Override
    public String resourceType() {
        return "GS2::Exchange::CurrentRateMaster";
    }

    @Override
    public Map<String, Object> properties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        HashMap<String, Object> settings = new HashMap<String, Object>();
        settings.put("version", this.version);
        if (this.rateModels != null) {
            settings.put("rateModels", this.rateModels.stream().map(v -> v.properties()).collect(Collectors.toList()));
        }
        if (this.incrementalRateModels != null) {
            settings.put("incrementalRateModels", this.incrementalRateModels.stream().map(v -> v.properties()).collect(Collectors.toList()));
        }
        if (this.namespaceName != null) {
            properties.put("NamespaceName", this.namespaceName);
        }
        if (settings != null) {
            properties.put("Settings", settings);
        }
        return properties;
    }
}

