/*
 * Copyright 2016- Game Server Services, Inc. or its affiliates. All Rights
 * Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package io.gs2.cdk.distributor.model.options;

import java.util.HashMap;
import java.util.Map;
import java.util.List;
import java.util.stream.Collectors;

public class DistributorModelOptions {
    public String metadata;
    public String inboxNamespaceId;
    public List<String> whiteListTargetIds;
    
    public DistributorModelOptions withMetadata(
        String metadata
    ) {
        this.metadata = metadata;
        return this;
    }
    
    public DistributorModelOptions withInboxNamespaceId(
        String inboxNamespaceId
    ) {
        this.inboxNamespaceId = inboxNamespaceId;
        return this;
    }
    
    public DistributorModelOptions withWhiteListTargetIds(
        List<String> whiteListTargetIds
    ) {
        this.whiteListTargetIds = whiteListTargetIds;
        return this;
    }
}

