/*
 * Copyright 2016- Game Server Services, Inc. or its affiliates. All Rights
 * Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package io.gs2.cdk.distributor.model;
import io.gs2.cdk.distributor.model.options.DistributorModelOptions;
import java.util.HashMap;
import java.util.Map;
import java.util.List;
import java.util.stream.Collectors;

public class DistributorModel {
    private String name;
    private String metadata = null;
    private String inboxNamespaceId = null;
    private List<String> whiteListTargetIds = null;

    public DistributorModel(
        String name,
        DistributorModelOptions options
    ) {
        this.name = name;
        this.metadata = options.metadata;
        this.inboxNamespaceId = options.inboxNamespaceId;
        this.whiteListTargetIds = options.whiteListTargetIds;
    }
    public DistributorModel(
        String name
    ) {
        this.name = name;
    }

    public Map<String, Object> properties(
    ) {
        var properties = new HashMap<String, Object>();

        if (this.name != null) {
            properties.put("name", this.name);
        }
        if (this.metadata != null) {
            properties.put("metadata", this.metadata);
        }
        if (this.inboxNamespaceId != null) {
            properties.put("inboxNamespaceId", this.inboxNamespaceId);
        }
        if (this.whiteListTargetIds != null) {
            properties.put("whiteListTargetIds", this.whiteListTargetIds);
        }

        return properties;
    }
}
