/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.gcp.observability.logging;

import com.google.cloud.MonitoredResource;
import com.google.cloud.logging.LogEntry;
import com.google.cloud.logging.Logging;
import com.google.cloud.logging.LoggingOptions;
import com.google.cloud.logging.Payload;
import com.google.cloud.logging.Severity;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.grpc.Internal;
import io.grpc.gcp.observability.logging.Sink;
import io.grpc.internal.JsonParser;
import io.grpc.observabilitylog.v1.GrpcLogRecord;
import java.io.IOException;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

@Internal
public class GcpLogSink
implements Sink {
    private final Logger logger = Logger.getLogger(GcpLogSink.class.getName());
    private static final String DEFAULT_LOG_NAME = "microservices.googleapis.com%2Fobservability%2Fgrpc";
    private static final Severity DEFAULT_LOG_LEVEL = Severity.DEBUG;
    private static final String K8S_MONITORED_RESOURCE_TYPE = "k8s_container";
    private static final Set<String> kubernetesResourceLabelSet = ImmutableSet.of((Object)"project_id", (Object)"location", (Object)"cluster_name", (Object)"namespace_name", (Object)"pod_name", (Object)"container_name", (Object[])new String[0]);
    private final String projectId;
    private final Map<String, String> customTags;
    private final MonitoredResource kubernetesResource;
    private volatile Logging gcpLoggingClient;
    private final Collection<String> servicesToExclude;

    @VisibleForTesting
    GcpLogSink(Logging loggingClient, String projectId, Map<String, String> locationTags, Map<String, String> customTags, Collection<String> servicesToExclude) {
        this(projectId, locationTags, customTags, servicesToExclude);
        this.gcpLoggingClient = loggingClient;
    }

    public GcpLogSink(String projectId, Map<String, String> locationTags, Map<String, String> customTags, Collection<String> servicesToExclude) {
        this.projectId = projectId;
        this.customTags = GcpLogSink.getCustomTags(customTags, locationTags, projectId);
        this.kubernetesResource = GcpLogSink.getResource(locationTags);
        this.servicesToExclude = (Collection)Preconditions.checkNotNull(servicesToExclude, (Object)"servicesToExclude");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(GrpcLogRecord logProto) {
        if (this.gcpLoggingClient == null) {
            GcpLogSink gcpLogSink = this;
            synchronized (gcpLogSink) {
                if (this.gcpLoggingClient == null) {
                    this.gcpLoggingClient = this.createLoggingClient();
                }
            }
        }
        if (this.servicesToExclude.contains(logProto.getServiceName())) {
            return;
        }
        try {
            GrpcLogRecord.EventType eventType = logProto.getType();
            Map<String, Object> logProtoMap = this.protoToMapConverter(logProto);
            LogEntry.Builder grpcLogEntryBuilder = LogEntry.newBuilder((Payload)Payload.JsonPayload.of(logProtoMap)).setSeverity(DEFAULT_LOG_LEVEL).setLogName(DEFAULT_LOG_NAME).setResource(this.kubernetesResource).setTimestamp(Instant.now());
            if (!this.customTags.isEmpty()) {
                grpcLogEntryBuilder.setLabels(this.customTags);
            }
            LogEntry grpcLogEntry = grpcLogEntryBuilder.build();
            GcpLogSink gcpLogSink = this;
            synchronized (gcpLogSink) {
                this.logger.log(Level.FINEST, "Writing gRPC event : {0} to Cloud Logging", (Object)eventType);
                this.gcpLoggingClient.write(Collections.singleton(grpcLogEntry), new Logging.WriteOption[0]);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Caught exception while writing to Cloud Logging", e);
        }
    }

    Logging createLoggingClient() {
        LoggingOptions.Builder builder = LoggingOptions.newBuilder();
        if (!Strings.isNullOrEmpty((String)this.projectId)) {
            builder.setProjectId(this.projectId);
        }
        return (Logging)builder.build().getService();
    }

    @VisibleForTesting
    static Map<String, String> getCustomTags(Map<String, String> customTags, Map<String, String> locationTags, String projectId) {
        ImmutableMap.Builder tagsBuilder = ImmutableMap.builder();
        String sourceProjectId = locationTags.get("project_id");
        if (!(Strings.isNullOrEmpty((String)projectId) || Strings.isNullOrEmpty((String)sourceProjectId) || Objects.equals(sourceProjectId, projectId))) {
            tagsBuilder.put((Object)"source_project_id", (Object)sourceProjectId);
        }
        if (customTags != null) {
            tagsBuilder.putAll(customTags);
        }
        return tagsBuilder.buildOrThrow();
    }

    @VisibleForTesting
    static MonitoredResource getResource(Map<String, String> resourceTags) {
        MonitoredResource.Builder builder = MonitoredResource.newBuilder((String)K8S_MONITORED_RESOURCE_TYPE);
        if (resourceTags != null && !resourceTags.isEmpty()) {
            for (Map.Entry<String, String> entry : resourceTags.entrySet()) {
                String resourceKey = entry.getKey();
                if (!kubernetesResourceLabelSet.contains(resourceKey)) continue;
                builder.addLabel(resourceKey, entry.getValue());
            }
        }
        return builder.build();
    }

    private Map<String, Object> protoToMapConverter(GrpcLogRecord logProto) throws IOException {
        JsonFormat.Printer printer = JsonFormat.printer();
        String recordJson = printer.print((MessageOrBuilder)logProto);
        return (Map)JsonParser.parse((String)recordJson);
    }

    @Override
    public synchronized void close() {
        if (this.gcpLoggingClient == null) {
            this.logger.log(Level.WARNING, "Attempt to close after GcpLogSink is closed.");
            return;
        }
        try {
            this.gcpLoggingClient.close();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Caught exception while closing", e);
        }
    }
}

