/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.gcp.observability;

import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.util.Strings;
import com.google.auth.http.HttpTransportFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import io.grpc.gcp.observability.MetadataConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Scanner;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

final class GlobalLocationTags {
    private static final Logger logger = Logger.getLogger(GlobalLocationTags.class.getName());
    private final Map<String, String> locationTags;

    GlobalLocationTags() {
        ImmutableMap.Builder locationTagsBuilder = ImmutableMap.builder();
        GlobalLocationTags.populate((ImmutableMap.Builder<String, String>)locationTagsBuilder);
        this.locationTags = locationTagsBuilder.buildOrThrow();
    }

    private static String applyTrim(String value) {
        if (!Strings.isNullOrEmpty((String)value)) {
            value = value.trim();
        }
        return value;
    }

    Map<String, String> getLocationTags() {
        return this.locationTags;
    }

    @VisibleForTesting
    static void populateFromMetadataServer(ImmutableMap.Builder<String, String> locationTags) {
        MetadataConfig metadataConfig = new MetadataConfig(new DefaultHttpTransportFactory());
        metadataConfig.init();
        locationTags.putAll(metadataConfig.getAllValues());
    }

    @VisibleForTesting
    static void populateFromKubernetesValues(ImmutableMap.Builder<String, String> locationTags, String namespaceFile, String hostnameFile, String cgroupFile) {
        GlobalLocationTags.populateFromFileContents(locationTags, "namespace_name", namespaceFile, GlobalLocationTags::applyTrim);
        GlobalLocationTags.populateFromFileContents(locationTags, "pod_name", hostnameFile, GlobalLocationTags::applyTrim);
        GlobalLocationTags.populateFromFileContents(locationTags, "container_id", cgroupFile, value -> GlobalLocationTags.getContainerIdFromFileContents(value));
    }

    @VisibleForTesting
    static void populateFromFileContents(ImmutableMap.Builder<String, String> locationTags, String key, String filePath, Function<String, String> parser) {
        String value = parser.apply(GlobalLocationTags.readFileContents(filePath));
        if (value != null) {
            locationTags.put((Object)key, (Object)value);
        }
    }

    @VisibleForTesting
    static String getContainerIdFromFileContents(String value) {
        if (value != null) {
            try (Scanner scanner = new Scanner(value);){
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine();
                    String[] tokens = line.split(":");
                    if (tokens.length != 3 || !tokens[2].startsWith("/kubepods/burstable/") || (tokens = tokens[2].split("/")).length != 5) continue;
                    String string = tokens[4];
                    return string;
                }
            }
        }
        return null;
    }

    private static String readFileContents(String file) {
        Path fileName = Paths.get(file, new String[0]);
        if (Files.isReadable(fileName)) {
            try {
                byte[] bytes = Files.readAllBytes(fileName);
                return new String(bytes, Charsets.US_ASCII);
            }
            catch (IOException e) {
                logger.log(Level.FINE, "Reading file:" + file, e);
            }
        } else {
            logger.log(Level.FINE, "File:" + file + " is not readable (or missing?)");
        }
        return null;
    }

    static void populate(ImmutableMap.Builder<String, String> locationTags) {
        GlobalLocationTags.populateFromMetadataServer(locationTags);
        GlobalLocationTags.populateFromKubernetesValues(locationTags, "/var/run/secrets/kubernetes.io/serviceaccount/namespace", "/etc/hostname", "/proc/self/cgroup");
    }

    private static class DefaultHttpTransportFactory
    implements HttpTransportFactory {
        private static final HttpTransport netHttpTransport = new NetHttpTransport();

        private DefaultHttpTransportFactory() {
        }

        public HttpTransport create() {
            return netHttpTransport;
        }
    }
}

