/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.querybean.generator;

import io.ebean.querybean.generator.Append;
import io.ebean.querybean.generator.KotlinLangAdapter;
import io.ebean.querybean.generator.ProcessingContext;
import io.ebean.querybean.generator.PropertyMeta;
import io.ebean.querybean.generator.PropertyType;
import io.ebean.querybean.generator.Util;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

class SimpleQueryBeanWriter {
    private static final String[] javaTypes = new String[]{"java.lang.String", "java.lang.Integer", "java.lang.Long", "java.lang.Double", "java.lang.Float", "java.lang.Short", "java.lang.Boolean", "java.lang.Byte", "java.lang.Char"};
    private static final String[] kotlinTypes = new String[]{"kotlin.String", "kotlin.Int", "kotlin.Long", "kotlin.Double", "kotlin.Float", "kotlin.Short", "kotlin.Boolean", "kotlin.Byte", "kotlin.Char"};
    private static final Set<String> kotlinBlackListedImports = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("?", "extends", "java.util.ArrayList", "java.util.HashMap", "java.util.HashSet", "java.util.LinkedHashMap", "java.util.LinkedHashSet", "java.util.List", "java.util.Map", "java.util.Set")));
    private final Set<String> importTypes = new TreeSet<String>();
    private final List<PropertyMeta> properties = new ArrayList<PropertyMeta>();
    private final TypeElement element;
    private final TypeElement implementsInterface;
    private String implementsInterfaceFullName;
    private String implementsInterfaceShortName;
    private final ProcessingContext processingContext;
    private final boolean isEntity;
    private final boolean embeddable;
    private final String dbName;
    private final String beanFullName;
    private final KotlinLangAdapter langAdapter = new KotlinLangAdapter();
    private boolean writingEmbeddedBean;
    private final String generatedSourcesDir;
    private String destPackage;
    private String shortName;
    private final String shortInnerName;
    private final String origShortName;
    private Append writer;

    SimpleQueryBeanWriter(TypeElement element, ProcessingContext processingContext) {
        this.generatedSourcesDir = processingContext.generatedSourcesDir();
        this.element = element;
        this.processingContext = processingContext;
        this.beanFullName = element.getQualifiedName().toString();
        boolean nested = element.getNestingKind().isNested();
        this.destPackage = Util.packageOf(nested, this.beanFullName) + ".query";
        String sn = Util.shortName(nested, this.beanFullName);
        this.shortInnerName = Util.shortName(false, sn);
        this.origShortName = this.shortName = sn.replace(".", "_");
        this.isEntity = processingContext.isEntity(element);
        this.embeddable = processingContext.isEmbeddable(element);
        this.dbName = this.findDbName();
        this.implementsInterface = this.initInterface(element);
    }

    private TypeElement initInterface(TypeElement element) {
        for (TypeMirror typeMirror : element.getInterfaces()) {
            TypeElement e = (TypeElement)this.processingContext.asElement(typeMirror);
            String name = e.getQualifiedName().toString();
            if (name.startsWith("java") || name.startsWith("io.ebean")) continue;
            return e;
        }
        return null;
    }

    private String findDbName() {
        return this.processingContext.findDbName(this.element);
    }

    private static String kotlinInnerType(String fullType) {
        return fullType.replace('$', '_');
    }

    private void gatherPropertyDetails() {
        if (this.implementsInterface != null) {
            this.implementsInterfaceFullName = this.implementsInterface.getQualifiedName().toString();
            boolean nested = this.implementsInterface.getNestingKind().isNested();
            this.implementsInterfaceShortName = Util.shortName(nested, this.implementsInterfaceFullName);
        }
        this.addClassProperties();
    }

    private void addClassProperties() {
        for (VariableElement field : this.processingContext.allFields(this.element)) {
            PropertyType type = this.processingContext.getPropertyType(field);
            if (type == null) continue;
            type.addImports(this.importTypes);
            this.properties.add(new PropertyMeta(field.getSimpleName().toString(), type));
        }
    }

    void writeBean() throws IOException {
        this.gatherPropertyDetails();
        this.translateKotlinImportTypes();
        if (this.isEmbeddable()) {
            this.processingContext.addEntity(this.beanFullName, this.dbName);
            this.writeEmbeddedBean();
        } else if (this.isEntity()) {
            this.processingContext.addEntity(this.beanFullName, this.dbName);
            this.writer = new Append(this.createFileWriter());
            this.writePackage();
            this.writeImports();
            this.writeClass();
            this.writeAlias();
            this.writeFields(false);
            this.writeConstructors();
            this.writeClassEnd();
            this.writer.close();
        }
    }

    private void translateKotlinImportTypes() {
        for (int i = 0; i < javaTypes.length; ++i) {
            if (!this.importTypes.remove(javaTypes[i])) continue;
            this.importTypes.add(kotlinTypes[i]);
        }
        this.importTypes.removeAll(kotlinBlackListedImports);
    }

    private boolean isEntity() {
        return this.isEntity;
    }

    private boolean isEmbeddable() {
        return this.embeddable;
    }

    void writeEmbeddedBean() throws IOException {
        this.writingEmbeddedBean = true;
        this.writer = new Append(this.createFileWriter());
        this.writePackage();
        this.writeImports();
        this.writeClass();
        this.writeEmbeddedAssoc();
        this.writeClassEnd();
        this.writer.close();
    }

    private void writeConstructors() {
        this.langAdapter.rootBeanConstructor(this.writer, this.shortName, this.dbName, this.beanFullName);
        this.writeAssocClasses();
    }

    private void writeFields(boolean assocBeans) {
        String padding = assocBeans ? "  " : "";
        for (PropertyMeta property : this.properties) {
            String typeDefn = SimpleQueryBeanWriter.toKotlinType(property.getTypeDefn(this.shortName, assocBeans));
            this.writer.append("%s  lateinit var %s: %s", padding, property.getName(), SimpleQueryBeanWriter.kotlinInnerType(typeDefn)).eol();
        }
        this.writer.eol();
    }

    private static String toKotlinType(String type) {
        return type.replace("? extends Object", "Any").replace(",Integer>", ",Int>");
    }

    private void writeClass() {
        if (this.writingEmbeddedBean) {
            this.writer.append("/**").eol();
            this.writer.append(" * Association query bean for %s.", this.shortName).eol();
            this.writer.append(" * ").eol();
            this.writer.append(" * THIS IS A GENERATED OBJECT, DO NOT MODIFY THIS CLASS.").eol();
            this.writer.append(" */").eol();
            this.writer.append("@io.ebean.typequery.Generated(\"io.ebean.querybean.kotlin-generator\")").eol();
            this.writer.append("class Q%s {", this.shortName).eol();
        } else {
            this.writer.append("/**").eol();
            this.writer.append(" * Query bean for %s.", this.shortName).eol();
            this.writer.append(" * ").eol();
            this.writer.append(" * THIS IS A GENERATED OBJECT, DO NOT MODIFY THIS CLASS.").eol();
            this.writer.append(" */").eol();
            this.writer.append("@io.ebean.typequery.Generated(\"io.ebean.querybean.kotlin-generator\")").eol();
            this.writer.append("@io.ebean.typequery.TypeQueryBean(\"v1\")").eol();
            this.writer.append("class Q%s : io.ebean.typequery.QueryBean<%s, Q%s> {", this.shortName, this.beanFullName, this.shortName).eol();
        }
        this.writer.eol();
    }

    private void writeAlias() {
        this.langAdapter.alias(this.writer, this.shortName, this.beanFullName);
    }

    private void writeClassEnd() {
        this.writer.append("}").eol();
    }

    private void writeImports() {
        for (String importType : this.importTypes) {
            this.writer.append("import %s;", SimpleQueryBeanWriter.kotlinInnerType(importType)).eol();
        }
        this.writer.eol();
    }

    private void writePackage() {
        this.writer.append("package %s;", this.destPackage).eol().eol();
    }

    private Writer createFileWriter() throws IOException {
        String relPath = this.destPackage.replace('.', '/');
        File absDir = new File(this.generatedSourcesDir, relPath);
        if (!absDir.exists() && !absDir.mkdirs()) {
            this.processingContext.logNote("failed to create directories for:" + absDir.getAbsolutePath(), new Object[0]);
        }
        String fullPath = relPath + "/Q" + this.shortName + ".kt";
        File absFile = new File(this.generatedSourcesDir, fullPath);
        return new FileWriter(absFile);
    }

    private void writeEmbeddedAssoc() {
        this.writer.append("  @io.ebean.typequery.Generated(\"io.ebean.querybean.generator\") @io.ebean.typequery.TypeQueryBean(\"v1\")").eol();
        this.writer.append("  class Assoc<R> : io.ebean.typequery.TQAssoc<%s,R> {", this.beanFullName).eol().eol();
        this.writeFields(true);
        this.writer.append("    constructor(name: String, root: R) : super(name, root)").eol();
        this.writer.append("    constructor(name: String, root: R, prefix: String) : super(name, root, prefix)").eol();
        this.writer.append("  }").eol().eol();
    }

    private void writeAssocClasses() {
        this.writer.append("  @io.ebean.typequery.Generated(\"io.ebean.querybean.generator\") @io.ebean.typequery.TypeQueryBean(\"v1\")").eol();
        this.writer.append("  abstract class Assoc<R> : io.ebean.typequery.TQAssocBean<%s, R, Q%s> {", this.beanFullName, this.shortName).eol();
        this.writeFields(true);
        this.writer.append("    protected constructor(name: String, root: R) : super(name, root)").eol();
        this.writer.append("    protected constructor(name: String, root: R, prefix: String) : super(name, root, prefix)").eol();
        this.writer.append("  }").eol().eol();
        this.writer.append("  @io.ebean.typequery.Generated(\"io.ebean.querybean.generator\") @io.ebean.typequery.TypeQueryBean(\"v1\")").eol();
        this.writer.append("  class AssocOne<R> : Assoc<R> {").eol();
        this.writer.append("    constructor(name: String, root: R) : super(name, root)").eol();
        this.writer.append("    constructor(name: String, root: R, prefix: String) : super(name, root, prefix)").eol();
        this.writer.append("  }").eol().eol();
        this.writer.append("  @io.ebean.typequery.Generated(\"io.ebean.querybean.generator\") @io.ebean.typequery.TypeQueryBean(\"v1\")").eol();
        this.writer.append("  class AssocMany<R> : Assoc<R>, io.ebean.typequery.TQAssocMany<%s, R, Q%s> {", this.beanFullName, this.shortName).eol();
        this.writer.append("    constructor(name: String, root: R) : super(name, root)").eol();
        this.writer.append("    constructor(name: String, root: R, prefix: String) : super(name, root, prefix)").eol();
        this.writer.eol();
        this.writer.append("    override fun filterMany(apply: java.util.function.Consumer<Q%s>): R {", this.shortName).eol();
        this.writer.append("      val list: io.ebean.ExpressionList<%s> = _newExpressionList<%s>()", this.beanFullName, this.beanFullName).eol();
        this.writer.append("      apply.accept(Q%s(list))", this.shortName).eol();
        this.writer.append("      return _filterMany(list)").eol();
        this.writer.append("    }").eol().eol();
        this.writer.append("    override fun filterMany(filter: io.ebean.ExpressionList<%s>): R {", this.beanFullName).eol();
        this.writer.append("      return _filterMany(filter)").eol();
        this.writer.append("    }").eol().eol();
        this.writer.append("    override fun filterManyRaw(rawExpressions: String, vararg params: Any): R {").eol();
        this.writer.append("      return _filterManyRaw(rawExpressions, *params)").eol();
        this.writer.append("    }").eol().eol();
        this.writer.append("    override fun isEmpty(): R {").eol();
        this.writer.append("      return _isEmpty() ").eol();
        this.writer.append("    }").eol().eol();
        this.writer.append("    override fun isNotEmpty(): R {").eol();
        this.writer.append("      return _isNotEmpty() ").eol();
        this.writer.append("    }").eol().eol();
        this.writer.append("  }").eol();
    }
}

