/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.querybean.generator;

import io.ebean.querybean.generator.Append;
import io.ebean.querybean.generator.KotlinLangAdapter;
import io.ebean.querybean.generator.LangAdapter;
import io.ebean.querybean.generator.ProcessingContext;
import io.ebean.querybean.generator.PropertyMeta;
import io.ebean.querybean.generator.PropertyType;
import io.ebean.querybean.generator.Util;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

class SimpleQueryBeanWriter {
    private static final String[] javaTypes = new String[]{"java.lang.String", "java.lang.Integer", "java.lang.Long", "java.lang.Double", "java.lang.Float", "java.lang.Short", "java.lang.Boolean", "java.lang.Byte", "java.lang.Char"};
    private static final String[] kotlinTypes = new String[]{"kotlin.String", "kotlin.Int", "kotlin.Long", "kotlin.Double", "kotlin.Float", "kotlin.Short", "kotlin.Boolean", "kotlin.Byte", "kotlin.Char"};
    private static final Set<String> kotlinBlackListedImports = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("java.util.ArrayList", "java.util.HashMap", "java.util.HashSet", "java.util.LinkedHashMap", "java.util.LinkedHashSet", "java.util.List", "java.util.Map", "java.util.Set")));
    private final Set<String> importTypes = new TreeSet<String>();
    private final List<PropertyMeta> properties = new ArrayList<PropertyMeta>();
    private final TypeElement element;
    private final TypeElement implementsInterface;
    private String implementsInterfaceFullName;
    private String implementsInterfaceShortName;
    private final ProcessingContext processingContext;
    private final boolean isEntity;
    private final boolean embeddable;
    private final String dbName;
    private final String beanFullName;
    private final LangAdapter langAdapter = new KotlinLangAdapter();
    private boolean writingAssocBean;
    private final String generatedSourcesDir;
    private String destPackage;
    private String origDestPackage;
    private String shortName;
    private final String shortInnerName;
    private final String origShortName;
    private Append writer;

    SimpleQueryBeanWriter(TypeElement element, ProcessingContext processingContext) {
        this.generatedSourcesDir = processingContext.generatedSourcesDir();
        this.element = element;
        this.processingContext = processingContext;
        this.beanFullName = element.getQualifiedName().toString();
        boolean nested = element.getNestingKind().isNested();
        this.destPackage = Util.packageOf(nested, this.beanFullName) + ".query";
        String sn = Util.shortName(nested, this.beanFullName);
        this.shortInnerName = Util.shortName(false, sn);
        this.origShortName = this.shortName = sn.replace(".", "");
        this.isEntity = processingContext.isEntity(element);
        this.embeddable = processingContext.isEmbeddable(element);
        this.dbName = this.findDbName();
        this.implementsInterface = this.initInterface(element);
    }

    private TypeElement initInterface(TypeElement element) {
        for (TypeMirror typeMirror : element.getInterfaces()) {
            TypeElement e = (TypeElement)this.processingContext.asElement(typeMirror);
            String name = e.getQualifiedName().toString();
            if (name.startsWith("java") || name.startsWith("io.ebean")) continue;
            return e;
        }
        return null;
    }

    private String findDbName() {
        return this.processingContext.findDbName(this.element);
    }

    private LangAdapter lang() {
        return this.langAdapter;
    }

    private void gatherPropertyDetails() {
        this.importTypes.add("io.ebean.typequery.Generated");
        this.importTypes.add(this.beanFullName);
        this.importTypes.add("io.ebean.typequery.TQRootBean");
        this.importTypes.add("io.ebean.typequery.TypeQueryBean");
        this.importTypes.add("io.ebean.Database");
        this.importTypes.add("io.ebean.FetchGroup");
        this.importTypes.add("io.ebean.Query");
        this.importTypes.add("io.ebean.Transaction");
        if (this.implementsInterface != null) {
            this.implementsInterfaceFullName = this.implementsInterface.getQualifiedName().toString();
            boolean nested = this.implementsInterface.getNestingKind().isNested();
            this.implementsInterfaceShortName = Util.shortName(nested, this.implementsInterfaceFullName);
        }
        if (this.dbName != null) {
            this.importTypes.add("io.ebean.DB");
        }
        this.addClassProperties();
    }

    private void addClassProperties() {
        for (VariableElement field : this.processingContext.allFields(this.element)) {
            PropertyType type = this.processingContext.getPropertyType(field);
            if (type == null) continue;
            type.addImports(this.importTypes);
            this.properties.add(new PropertyMeta(field.getSimpleName().toString(), type));
        }
    }

    void writeRootBean() throws IOException {
        this.gatherPropertyDetails();
        if (this.isEmbeddable()) {
            this.processingContext.addEntity(this.beanFullName, this.dbName);
        } else if (this.isEntity()) {
            this.processingContext.addEntity(this.beanFullName, this.dbName);
            this.writer = new Append(this.createFileWriter());
            this.translateKotlinImportTypes();
            this.writePackage();
            this.writeImports();
            this.writeClass();
            this.writeAlias();
            this.writeFields();
            this.writeConstructors();
            this.writeClassEnd();
            this.writer.close();
        }
    }

    private void translateKotlinImportTypes() {
        for (int i = 0; i < javaTypes.length; ++i) {
            if (!this.importTypes.remove(javaTypes[i])) continue;
            this.importTypes.add(kotlinTypes[i]);
        }
        this.importTypes.removeAll(kotlinBlackListedImports);
    }

    private boolean isEntity() {
        return this.isEntity;
    }

    private boolean isEmbeddable() {
        return this.embeddable;
    }

    void writeAssocBean() throws IOException {
        this.writingAssocBean = true;
        this.origDestPackage = this.destPackage;
        this.destPackage = this.destPackage + ".assoc";
        this.shortName = "Assoc" + this.shortName;
        this.prepareAssocBeanImports();
        this.writer = new Append(this.createFileWriter());
        this.writePackage();
        this.writeImports();
        this.writeClass();
        this.writeFields();
        this.writeConstructors();
        this.writeClassEnd();
        this.writer.close();
    }

    private void prepareAssocBeanImports() {
        this.importTypes.remove("io.ebean.DB");
        this.importTypes.remove("io.ebean.typequery.TQRootBean");
        this.importTypes.remove("io.ebean.Database");
        this.importTypes.remove("io.ebean.FetchGroup");
        this.importTypes.remove("io.ebean.Query");
        if (this.embeddable) {
            this.importTypes.add("io.ebean.typequery.TQAssoc");
        } else {
            this.importTypes.add("io.ebean.typequery.TQAssocBean");
        }
        if (this.isEntity()) {
            this.importTypes.add("io.ebean.typequery.TQProperty");
            this.importTypes.add(this.origDestPackage + ".Q" + this.origShortName);
        }
        Iterator<String> importsIterator = this.importTypes.iterator();
        String checkImportStart = this.destPackage + ".QAssoc";
        while (importsIterator.hasNext()) {
            String importType = importsIterator.next();
            if (!importType.startsWith(checkImportStart)) continue;
            importsIterator.remove();
        }
    }

    private void writeConstructors() {
        if (this.writingAssocBean) {
            this.writeAssocBeanFetch();
            this.writeAssocBeanConstructor();
        } else {
            this.writeRootBeanConstructor();
        }
    }

    private void writeRootBeanConstructor() {
        this.lang().rootBeanConstructor(this.writer, this.shortName, this.dbName);
    }

    private void writeAssocBeanFetch() {
        if (this.isEntity()) {
            // empty if block
        }
    }

    private void writeAssocBeanExpression(boolean nullable, String expression, String comment) {
        this.writeAssocBeanExpression(nullable, expression, comment, this.implementsInterfaceShortName, expression);
    }

    private void writeAssocBeanExpression(boolean nullable, String expression, String comment, String param, String actualExpression) {
        String nullableAnnotation = nullable ? "@Nullable " : "";
        String values = expression.startsWith("in") ? "values" : "value";
        this.writer.append("  /**").eol();
        this.writer.append("   * ").append(comment).eol();
        this.writer.append("   */").eol();
        this.writer.append("  fun %s(%s%s %s): R {", expression, nullableAnnotation, param, values).eol();
        this.writer.append("    expr().%s(_name, %s);", actualExpression, values).eol();
        this.writer.append("    return _root;").eol();
        this.writer.append("  }").eol();
        this.writer.eol();
    }

    private void writeAssocBeanConstructor() {
        this.lang().assocBeanConstructor(this.writer, this.shortName);
    }

    private void writeFields() {
        for (PropertyMeta property : this.properties) {
            String typeDefn = property.getTypeDefn(this.shortName, this.writingAssocBean);
            this.lang().fieldDefn(this.writer, property.getName(), typeDefn);
            this.writer.eol();
        }
        this.writer.eol();
    }

    private void writeClass() {
        if (this.writingAssocBean) {
            this.writer.append("/**").eol();
            this.writer.append(" * Association query bean for %s.", this.shortName).eol();
            this.writer.append(" * ").eol();
            this.writer.append(" * THIS IS A GENERATED OBJECT, DO NOT MODIFY THIS CLASS.").eol();
            this.writer.append(" */").eol();
            this.writer.append("@Generated(\"io.ebean.querybean.kotlin-generator\")").eol();
            this.writer.append("@TypeQueryBean(\"v1\")").eol();
            if (this.embeddable) {
                this.writer.append("class Q%s<R> : TQAssoc<%s,R> {", this.shortName, this.shortInnerName).eol();
            } else {
                this.writer.append("class Q%s<R> : TQAssocBean<%s,R,Q%s> {", this.shortName, this.shortInnerName, this.origShortName).eol();
            }
        } else {
            this.writer.append("/**").eol();
            this.writer.append(" * Query bean for %s.", this.shortName).eol();
            this.writer.append(" * ").eol();
            this.writer.append(" * THIS IS A GENERATED OBJECT, DO NOT MODIFY THIS CLASS.").eol();
            this.writer.append(" */").eol();
            this.writer.append("@Generated(\"io.ebean.querybean.kotlin-generator\")").eol();
            this.writer.append("@TypeQueryBean(\"v1\")").eol();
            this.lang().beginClass(this.writer, this.shortName);
        }
        this.writer.eol();
    }

    private void writeAlias() {
        if (!this.writingAssocBean) {
            this.lang().alias(this.writer, this.shortName);
        }
    }

    private void writeClassEnd() {
        this.writer.append("}").eol();
    }

    private void writeImports() {
        for (String importType : this.importTypes) {
            this.writer.append("import %s;", importType).eol();
        }
        this.writer.eol();
    }

    private void writePackage() {
        this.writer.append("package %s;", this.destPackage).eol().eol();
    }

    private Writer createFileWriter() throws IOException {
        String relPath = this.destPackage.replace('.', '/');
        File absDir = new File(this.generatedSourcesDir, relPath);
        if (!absDir.exists() && !absDir.mkdirs()) {
            this.processingContext.logNote("failed to create directories for:" + absDir.getAbsolutePath(), new Object[0]);
        }
        String fullPath = relPath + "/Q" + this.shortName + ".kt";
        File absFile = new File(this.generatedSourcesDir, fullPath);
        return new FileWriter(absFile);
    }
}

