/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.querybean.generator;

import io.ebean.querybean.generator.KotlinLangAdapter;
import io.ebean.querybean.generator.LangAdapter;
import io.ebean.querybean.generator.ProcessingContext;
import io.ebean.querybean.generator.PropertyMeta;
import io.ebean.querybean.generator.PropertyType;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.persistence.Entity;

class SimpleQueryBeanWriter {
    private static final String[] javaTypes = new String[]{"java.lang.String", "java.lang.Integer", "java.lang.Long", "java.lang.Double", "java.lang.Float", "java.lang.Short", "java.lang.Boolean", "java.lang.Byte", "java.lang.Char"};
    private static final String[] kotlinTypes = new String[]{"kotlin.String", "kotlin.Int", "kotlin.Long", "kotlin.Double", "kotlin.Float", "kotlin.Short", "kotlin.Boolean", "kotlin.Byte", "kotlin.Char"};
    static final String NEWLINE = "\n";
    private final Set<String> importTypes = new TreeSet<String>();
    private final List<PropertyMeta> properties = new ArrayList<PropertyMeta>();
    private final TypeElement element;
    private final ProcessingContext processingContext;
    private final String beanFullName;
    private final LangAdapter langAdapter = new KotlinLangAdapter();
    private boolean writingAssocBean;
    private final String generatedSourcesDir;
    private String destPackage;
    private String origDestPackage;
    private String shortName;
    private String origShortName;
    private Writer writer;

    SimpleQueryBeanWriter(TypeElement element, ProcessingContext processingContext) {
        this.generatedSourcesDir = processingContext.generatedSourcesDir();
        this.element = element;
        this.processingContext = processingContext;
        this.beanFullName = element.getQualifiedName().toString();
        this.destPackage = this.derivePackage(this.beanFullName) + ".query";
        this.shortName = this.deriveShortName(this.beanFullName);
        processingContext.addPackage(this.destPackage);
    }

    private LangAdapter lang() {
        return this.langAdapter;
    }

    private void gatherPropertyDetails() {
        this.importTypes.add(this.beanFullName);
        if (this.processingContext.isGeneratedAvailable()) {
            this.importTypes.add("javax.annotation.Generated");
        }
        this.importTypes.add("io.ebean.typequery.TQRootBean");
        this.importTypes.add("io.ebean.typequery.TypeQueryBean");
        this.importTypes.add("io.ebean.EbeanServer");
        this.addClassProperties();
    }

    private void addClassProperties() {
        List<VariableElement> fields = this.processingContext.allFields(this.element);
        for (VariableElement field : fields) {
            PropertyType type = this.processingContext.getPropertyType(field);
            if (type == null) continue;
            type.addImports(this.importTypes);
            this.properties.add(new PropertyMeta(field.getSimpleName().toString(), type));
        }
    }

    void writeRootBean() throws IOException {
        this.gatherPropertyDetails();
        if (this.isEntity()) {
            this.writer = this.createFileWriter();
            this.translateKotlinImportTypes();
            this.writePackage();
            this.writeImports();
            this.writeClass();
            this.writeAlias();
            this.writeFields();
            this.writeConstructors();
            this.writeClassEnd();
            this.writer.flush();
            this.writer.close();
        }
    }

    private void translateKotlinImportTypes() {
        for (int i = 0; i < javaTypes.length; ++i) {
            if (!this.importTypes.remove(javaTypes[i])) continue;
            this.importTypes.add(kotlinTypes[i]);
        }
    }

    private boolean isEntity() {
        return this.element.getAnnotation(Entity.class) != null;
    }

    void writeAssocBean() throws IOException {
        this.writingAssocBean = true;
        this.origDestPackage = this.destPackage;
        this.destPackage = this.destPackage + ".assoc";
        this.origShortName = this.shortName;
        this.shortName = "Assoc" + this.shortName;
        this.prepareAssocBeanImports();
        this.writer = this.createFileWriter();
        this.writePackage();
        this.writeImports();
        this.writeClass();
        this.writeFields();
        this.writeConstructors();
        this.writeClassEnd();
        this.writer.flush();
        this.writer.close();
    }

    private void prepareAssocBeanImports() {
        this.importTypes.remove("io.ebean.typequery.TQRootBean");
        this.importTypes.remove("io.ebean.EbeanServer");
        this.importTypes.add("io.ebean.typequery.TQAssocBean");
        if (this.isEntity()) {
            this.importTypes.add("io.ebean.typequery.TQProperty");
            this.importTypes.add(this.origDestPackage + ".Q" + this.origShortName);
        }
        Iterator<String> importsIterator = this.importTypes.iterator();
        String checkImportStart = this.destPackage + ".QAssoc";
        while (importsIterator.hasNext()) {
            String importType = importsIterator.next();
            if (!importType.startsWith(checkImportStart)) continue;
            importsIterator.remove();
        }
    }

    private void writeConstructors() throws IOException {
        if (this.writingAssocBean) {
            this.writeAssocBeanFetch();
            this.writeAssocBeanConstructor();
        } else {
            this.writeRootBeanConstructor();
        }
    }

    private void writeRootBeanConstructor() throws IOException {
        this.lang().rootBeanConstructor(this.writer, this.shortName);
    }

    private void writeAssocBeanFetch() throws IOException {
        if (this.isEntity()) {
            this.lang().fetch(this.writer, this.origShortName);
        }
    }

    private void writeAssocBeanConstructor() throws IOException {
        this.lang().assocBeanConstructor(this.writer, this.shortName);
    }

    private void writeFields() throws IOException {
        for (PropertyMeta property : this.properties) {
            String typeDefn = property.getTypeDefn(this.shortName, this.writingAssocBean);
            this.lang().fieldDefn(this.writer, property.getName(), typeDefn);
            this.writer.append(NEWLINE);
        }
        this.writer.append(NEWLINE);
    }

    private void writeClass() throws IOException {
        if (this.writingAssocBean) {
            this.writer.append("/**").append(NEWLINE);
            this.writer.append(" * Association query bean for ").append(this.shortName).append(".").append(NEWLINE);
            this.writer.append(" * ").append(NEWLINE);
            this.writer.append(" * THIS IS A GENERATED OBJECT, DO NOT MODIFY THIS CLASS.").append(NEWLINE);
            this.writer.append(" */").append(NEWLINE);
            if (this.processingContext.isGeneratedAvailable()) {
                this.writer.append("@Generated(\"io.ebean.querybean.kotlin-generator\")").append(NEWLINE);
            }
            this.writer.append("@TypeQueryBean").append(NEWLINE);
            this.lang().beginAssocClass(this.writer, this.shortName, this.origShortName);
        } else {
            this.writer.append("/**").append(NEWLINE);
            this.writer.append(" * Query bean for ").append(this.shortName).append(".").append(NEWLINE);
            this.writer.append(" * ").append(NEWLINE);
            this.writer.append(" * THIS IS A GENERATED OBJECT, DO NOT MODIFY THIS CLASS.").append(NEWLINE);
            this.writer.append(" */").append(NEWLINE);
            if (this.processingContext.isGeneratedAvailable()) {
                this.writer.append("@Generated(\"io.ebean.querybean.kotlin-generator\")").append(NEWLINE);
            }
            this.writer.append("@TypeQueryBean").append(NEWLINE);
            this.lang().beginClass(this.writer, this.shortName);
        }
        this.writer.append(NEWLINE);
    }

    private void writeAlias() throws IOException {
        if (!this.writingAssocBean) {
            this.lang().alias(this.writer, this.shortName);
        }
    }

    private void writeClassEnd() throws IOException {
        this.writer.append("}").append(NEWLINE);
    }

    private void writeImports() throws IOException {
        for (String importType : this.importTypes) {
            this.writer.append("import ").append(importType).append(";").append(NEWLINE);
        }
        this.writer.append(NEWLINE);
    }

    private void writePackage() throws IOException {
        this.writer.append("package ").append(this.destPackage).append(";").append(NEWLINE).append(NEWLINE);
    }

    private Writer createFileWriter() throws IOException {
        String relPath = this.destPackage.replace('.', '/');
        File absDir = new File(this.generatedSourcesDir, relPath);
        if (!absDir.exists() && !absDir.mkdirs()) {
            this.processingContext.logNote("failed to create directories for:" + absDir.getAbsolutePath(), new Object[0]);
        }
        String fullPath = relPath + "/Q" + this.shortName + ".kt";
        File absFile = new File(this.generatedSourcesDir, fullPath);
        return new FileWriter(absFile);
    }

    private String derivePackage(String name) {
        int pos = name.lastIndexOf(46);
        if (pos == -1) {
            return "";
        }
        return name.substring(0, pos);
    }

    private String deriveShortName(String name) {
        int pos = name.lastIndexOf(46);
        if (pos == -1) {
            return name;
        }
        return name.substring(pos + 1);
    }
}

