/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.querybean.generator;

import io.ebean.querybean.generator.ProcessingContext;
import io.ebean.querybean.generator.SimpleQueryBeanWriter;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.persistence.Embeddable;
import javax.persistence.Entity;

public class Processor
extends AbstractProcessor {
    private static final String GENERATE_KOTLIN_CODE_OPTION = "generate.kotlin.code";
    private static final String KAPT_KOTLIN_GENERATED_OPTION = "kapt.kotlin.generated";

    @Override
    public Set<String> getSupportedOptions() {
        LinkedHashSet<String> options = new LinkedHashSet<String>();
        options.add(KAPT_KOTLIN_GENERATED_OPTION);
        options.add(GENERATE_KOTLIN_CODE_OPTION);
        return options;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> annotations = new LinkedHashSet<String>();
        annotations.add(Entity.class.getCanonicalName());
        annotations.add(Embeddable.class.getCanonicalName());
        return annotations;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        int entityCount = 0;
        int embeddableCount = 0;
        String generatedDir = this.processingEnv.getOptions().get(KAPT_KOTLIN_GENERATED_OPTION);
        if (generatedDir == null) {
            generatedDir = "target/generated-sources/kapt/compile";
        }
        ProcessingContext context = new ProcessingContext(this.processingEnv, generatedDir);
        for (Element element : roundEnv.getElementsAnnotatedWith(Entity.class)) {
            this.generateQueryBeans(context, element);
            ++entityCount;
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(Embeddable.class)) {
            this.generateQueryBeans(context, element);
            ++embeddableCount;
        }
        if (entityCount > 0 || embeddableCount > 0) {
            context.logNote("Generated query beans for [" + entityCount + "] entities [" + embeddableCount + "] embeddable", new Object[0]);
        }
        return true;
    }

    private void generateQueryBeans(ProcessingContext context, Element element) {
        try {
            SimpleQueryBeanWriter beanWriter = new SimpleQueryBeanWriter((TypeElement)element, context);
            beanWriter.writeRootBean();
            beanWriter.writeAssocBean();
        }
        catch (Exception e) {
            context.logError(element, "Error generating query beans: " + e, new Object[0]);
        }
    }
}

