/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.querybean.generator;

import io.ebean.annotation.DbArray;
import io.ebean.annotation.DbJson;
import io.ebean.annotation.DbJsonB;
import io.ebean.querybean.generator.PropertyType;
import io.ebean.querybean.generator.PropertyTypeArray;
import io.ebean.querybean.generator.PropertyTypeAssoc;
import io.ebean.querybean.generator.PropertyTypeEnum;
import io.ebean.querybean.generator.PropertyTypeMap;
import io.ebean.querybean.generator.Split;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.MappedSuperclass;
import javax.tools.Diagnostic;

class ProcessingContext {
    private final String generatedSources;
    private final Types typeUtils;
    private final Messager messager;
    private final Elements elementUtils;
    private final boolean generatedAvailable;
    private final PropertyTypeMap propertyTypeMap = new PropertyTypeMap();
    private final Set<String> packages = new LinkedHashSet<String>();

    ProcessingContext(ProcessingEnvironment processingEnv, String generatedSources) {
        this.generatedSources = generatedSources;
        this.typeUtils = processingEnv.getTypeUtils();
        this.messager = processingEnv.getMessager();
        this.elementUtils = processingEnv.getElementUtils();
        this.generatedAvailable = this.isTypeAvailable("javax.annotation.Generated");
    }

    private boolean isTypeAvailable(String canonicalName) {
        return null != this.elementUtils.getTypeElement(canonicalName);
    }

    String generatedSourcesDir() {
        return this.generatedSources;
    }

    private String typeDef(TypeMirror typeMirror) {
        return ProcessingContext.typeDef(typeMirror.toString());
    }

    private static String typeDef(String typeDesc) {
        int pos = typeDesc.lastIndexOf(" :: ");
        if (pos > -1) {
            typeDesc = typeDesc.substring(pos + 4, typeDesc.length() - 1);
        }
        return typeDesc;
    }

    List<VariableElement> allFields(Element element) {
        ArrayList<VariableElement> list = new ArrayList<VariableElement>();
        this.gatherProperties(list, element);
        return list;
    }

    private void gatherProperties(List<VariableElement> fields, Element element) {
        TypeElement typeElement = (TypeElement)element;
        TypeMirror superclass = typeElement.getSuperclass();
        Element mappedSuper = this.typeUtils.asElement(superclass);
        if (this.isMappedSuperOrInheritance(mappedSuper)) {
            this.gatherProperties(fields, mappedSuper);
        }
        List<VariableElement> allFields = ElementFilter.fieldsIn(element.getEnclosedElements());
        for (VariableElement field : allFields) {
            if (this.ignoreField(field)) continue;
            fields.add(field);
        }
    }

    private boolean ignoreField(VariableElement field) {
        return this.isStaticOrTransient(field) || this.ignoreEbeanInternalFields(field);
    }

    private boolean ignoreEbeanInternalFields(VariableElement field) {
        String fieldName = field.getSimpleName().toString();
        return fieldName.startsWith("_ebean") || fieldName.startsWith("_EBEAN");
    }

    private boolean isStaticOrTransient(VariableElement field) {
        Set<Modifier> modifiers = field.getModifiers();
        return modifiers.contains((Object)Modifier.STATIC) || modifiers.contains((Object)Modifier.TRANSIENT);
    }

    private boolean isMappedSuperOrInheritance(Element mappedSuper) {
        return mappedSuper.getAnnotation(MappedSuperclass.class) != null || mappedSuper.getAnnotation(Inheritance.class) != null;
    }

    private boolean isEntityOrEmbedded(Element mappedSuper) {
        return mappedSuper != null && (mappedSuper.getAnnotation(Entity.class) != null || mappedSuper.getAnnotation(Embeddable.class) != null);
    }

    private static boolean dbJsonField(Element field) {
        return field.getAnnotation(DbJson.class) != null || field.getAnnotation(DbJsonB.class) != null;
    }

    private static boolean dbArrayField(Element field) {
        return field.getAnnotation(DbArray.class) != null;
    }

    PropertyType getPropertyType(VariableElement field) {
        String fullType;
        TypeMirror typeMirror;
        TypeMirror currentType = typeMirror = field.asType();
        while (currentType != null) {
            PropertyType type = this.propertyTypeMap.getType(this.typeDef(currentType));
            if (type != null) {
                return type;
            }
            TypeElement fieldType = (TypeElement)this.typeUtils.asElement(currentType);
            currentType = fieldType == null ? null : fieldType.getSuperclass();
        }
        if (ProcessingContext.dbJsonField(field)) {
            return this.propertyTypeMap.getDbJsonType();
        }
        if (ProcessingContext.dbArrayField(field)) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            fullType = this.typeDef(declaredType.getTypeArguments().get(0));
            String shortName = this.langShortType(Split.shortName(fullType));
            return new PropertyTypeArray(fullType, shortName);
        }
        Element fieldType = this.typeUtils.asElement(typeMirror);
        if (fieldType != null) {
            TypeMirror argType;
            Element argElement;
            DeclaredType declaredType;
            List<? extends TypeMirror> typeArguments;
            if (fieldType.getKind() == ElementKind.ENUM) {
                fullType = this.typeDef(typeMirror);
                return new PropertyTypeEnum(fullType, Split.shortName(fullType));
            }
            if (this.isEntityOrEmbedded(fieldType)) {
                return this.createPropertyTypeAssoc(this.typeDef(typeMirror));
            }
            if (typeMirror.getKind() == TypeKind.DECLARED && (typeArguments = (declaredType = (DeclaredType)typeMirror).getTypeArguments()).size() == 1 && this.isEntityOrEmbedded(argElement = this.typeUtils.asElement(argType = typeArguments.get(0)))) {
                return this.createPropertyTypeAssoc(this.typeDef(argElement.asType()));
            }
        }
        return null;
    }

    private String langShortType(String shortName) {
        if ("Integer".equals(shortName)) {
            return "Int";
        }
        return shortName;
    }

    private PropertyType createPropertyTypeAssoc(String fullName) {
        String[] split = Split.split(fullName);
        String propertyName = "QAssoc" + split[1];
        String packageName = this.packageAppend(split[0], "query.assoc");
        return new PropertyTypeAssoc(propertyName, packageName);
    }

    private String packageAppend(String origPackage, String suffix) {
        if (origPackage == null) {
            return suffix;
        }
        return origPackage + "." + suffix;
    }

    void logError(Element e, String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args), e);
    }

    void logNote(String msg, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.NOTE, String.format(msg, args));
    }

    void addPackage(String destPackage) {
        this.packages.add(destPackage);
    }

    boolean isGeneratedAvailable() {
        return this.generatedAvailable;
    }
}

