/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.querybean.generator;

import io.ebean.querybean.generator.LangAdapter;
import java.io.IOException;
import java.io.Writer;

public class KotlinLangAdapter
implements LangAdapter {
    @Override
    public void beginClass(Writer writer, String shortName) throws IOException {
        writer.append("class ").append("Q").append(shortName).append(" : TQRootBean<").append(shortName).append(", Q").append(shortName).append("> {").append("\n");
    }

    @Override
    public void beginAssocClass(Writer writer, String shortName, String origShortName) throws IOException {
        writer.append("class ").append("Q").append(shortName);
        writer.append("<R>(name: String, root: R) : TQAssocBean<").append(origShortName).append(",R>(name, root) {").append("\n");
    }

    @Override
    public void alias(Writer writer, String shortName) throws IOException {
        writer.append("  companion object {").append("\n");
        writer.append("    /**").append("\n");
        writer.append("     * shared 'Alias' instance used to provide").append("\n");
        writer.append("     * properties to select and fetch clauses").append("\n");
        writer.append("     */").append("\n");
        writer.append("    val _alias = Q").append(shortName).append("(true)").append("\n");
        writer.append("  }").append("\n").append("\n");
    }

    @Override
    public void assocBeanConstructor(Writer writer, String shortName) throws IOException {
    }

    @Override
    public void fetch(Writer writer, String origShortName) throws IOException {
        this.writeAssocBeanFetch(writer, origShortName, "", "Eagerly fetch this association loading the specified properties.");
        this.writeAssocBeanFetch(writer, origShortName, "Query", "Eagerly fetch this association using a 'query join' loading the specified properties.");
        this.writeAssocBeanFetch(writer, origShortName, "Lazy", "Use lazy loading for this association loading the specified properties.");
    }

    private void writeAssocBeanFetch(Writer writer, String origShortName, String fetchType, String comment) throws IOException {
        writer.append("  /**").append("\n");
        writer.append("   * ").append(comment).append("\n");
        writer.append("   */").append("\n");
        writer.append("  fun fetch").append(fetchType).append("(vararg properties: TQProperty<Q").append(origShortName).append(">) : R {").append("\n");
        writer.append("    return fetch").append(fetchType).append("Properties(*properties)").append("\n");
        writer.append("  }").append("\n");
        writer.append("\n");
    }

    @Override
    public void rootBeanConstructor(Writer writer, String shortName) throws IOException {
        writer.append("\n");
        writer.append("  /**").append("\n");
        writer.append("   * Construct with a given EbeanServer.").append("\n");
        writer.append("   */").append("\n");
        writer.append("  constructor(server: EbeanServer) : super(").append(shortName).append("::class.java, server)");
        writer.append("\n");
        writer.append("\n");
        writer.append("  /**").append("\n");
        writer.append("   * Construct using the default EbeanServer.").append("\n");
        writer.append("   */").append("\n");
        writer.append("  constructor() : super(").append(shortName).append("::class.java)");
        writer.append("\n");
        writer.append("\n");
        writer.append("  /**").append("\n");
        writer.append("   * Construct for Alias.").append("\n");
        writer.append("   */").append("\n");
        writer.append("  private constructor(dummy: Boolean) : super(dummy)").append("\n");
    }

    @Override
    public void fieldDefn(Writer writer, String propertyName, String typeDefn) throws IOException {
        writer.append("  lateinit var ");
        writer.append(propertyName).append(": ");
        if (typeDefn.endsWith(",Integer>")) {
            typeDefn = typeDefn.replace(",Integer>", ",Int>");
        }
        writer.append(typeDefn);
    }
}

