/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.postgis;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebean.core.type.DocPropertyType;
import io.ebean.core.type.ScalarType;
import java.io.DataInput;
import java.io.DataOutput;
import java.sql.SQLException;
import net.postgis.jdbc.PGgeometry;
import net.postgis.jdbc.PGgeometryLW;
import net.postgis.jdbc.geometry.Geometry;
import net.postgis.jdbc.geometry.GeometryBuilder;
import net.postgis.jdbc.geometry.binary.BinaryParser;
import org.postgresql.util.PGobject;

abstract class ScalarTypePgisBase<T extends Geometry>
implements ScalarType<T> {
    private final int jdbcType;
    private final Class<T> cls;

    ScalarTypePgisBase(int jdbcType, Class<T> cls) {
        this.jdbcType = jdbcType;
        this.cls = cls;
    }

    public void bind(DataBinder binder, T value) throws SQLException {
        if (value == null) {
            binder.setNull(0);
        } else {
            binder.setObject((Object)new PGgeometryLW(value));
        }
    }

    public T read(DataReader reader) throws SQLException {
        Object object = reader.getObject();
        if (object == null) {
            return null;
        }
        if (object instanceof PGgeometryLW) {
            return (T)((PGgeometryLW)object).getGeometry();
        }
        if (object instanceof PGgeometry) {
            return (T)((PGgeometry)object).getGeometry();
        }
        if (object instanceof PGobject) {
            return (T)GeometryBuilder.geomFromString((String)((PGobject)object).getValue(), (BinaryParser)new BinaryParser(), (boolean)false);
        }
        throw new IllegalStateException("Could not convert from " + String.valueOf(object.getClass()) + " to " + String.valueOf(this.cls));
    }

    public boolean jdbcNative() {
        return true;
    }

    public int jdbcType() {
        return this.jdbcType;
    }

    public Class<T> type() {
        return this.cls;
    }

    public T readData(DataInput dataInput) {
        return null;
    }

    public void writeData(DataOutput dataOutput, T v) {
    }

    public Object toJdbcType(Object value) {
        return null;
    }

    public T toBeanType(Object value) {
        return null;
    }

    public String formatValue(T value) {
        return value.toString();
    }

    public DocPropertyType docType() {
        return null;
    }

    public T jsonRead(JsonParser parser) {
        return null;
    }

    public void jsonWrite(JsonGenerator writer, T value) {
    }
}

