/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.xmlmapping;

import io.avaje.classpath.scanner.Resource;
import io.ebeaninternal.xmlmapping.model.XmEbean;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class XmlMappingReader {
    public static XmEbean read(InputStream is) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{XmEbean.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            return (XmEbean)unmarshaller.unmarshal(is);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<XmEbean> readByResourceName(ClassLoader classLoader, String resourceName) {
        try {
            Enumeration<URL> resources = classLoader.getResources(resourceName);
            ArrayList<XmEbean> mappings = new ArrayList<XmEbean>();
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                InputStream is = XmlMappingReader.openNoCache(url);
                try {
                    mappings.add(XmlMappingReader.read(is));
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            return mappings;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading ebean xml mapping", e);
        }
    }

    public static List<XmEbean> readByResourceList(List<Resource> resourceList) {
        try {
            ArrayList<XmEbean> mappings = new ArrayList<XmEbean>();
            for (Resource xmlMappingRes : resourceList) {
                try (FileInputStream is = new FileInputStream(xmlMappingRes.getLocationOnDisk());){
                    mappings.add(XmlMappingReader.read(is));
                }
            }
            return mappings;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading ebean xml mapping", e);
        }
    }

    private static InputStream openNoCache(URL url) throws IOException {
        URLConnection urlConnection = url.openConnection();
        urlConnection.setUseCaches(false);
        return urlConnection.getInputStream();
    }
}

