/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.xmlmapping;

import io.avaje.classpath.scanner.ClassPathScanner;
import io.avaje.classpath.scanner.ClassPathScannerFactory;
import io.avaje.classpath.scanner.Resource;
import io.ebeaninternal.xmapping.api.XmapEbean;
import io.ebeaninternal.xmlmapping.ToXmapEbean;
import io.ebeaninternal.xmlmapping.XmlMappingReader;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InternalConfigXmlRead {
    private static final Logger log = LoggerFactory.getLogger(InternalConfigXmlRead.class);
    private final ToXmapEbean to = new ToXmapEbean();
    private final ClassLoader classLoader;
    private final List<String> mappingLocations;

    InternalConfigXmlRead(ClassLoader classLoader, List<String> mappingLocations) {
        this.classLoader = classLoader;
        this.mappingLocations = mappingLocations;
    }

    List<XmapEbean> read() {
        ArrayList<XmapEbean> list = new ArrayList<XmapEbean>();
        list.addAll(this.to.toBeans(XmlMappingReader.readByResourceName(this.classLoader, "ebean.xml")));
        list.addAll(this.to.toBeans(XmlMappingReader.readByResourceList(this.xmlMappingResources())));
        return list;
    }

    private List<Resource> xmlMappingResources() {
        List<ClassPathScanner> scanners = this.scanners();
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        long st = System.currentTimeMillis();
        if (this.mappingLocations != null && !this.mappingLocations.isEmpty()) {
            for (ClassPathScanner finder : scanners) {
                for (String mappingLocation : this.mappingLocations) {
                    resourceList.addAll(finder.scanForResources(mappingLocation, resourceName -> resourceName.endsWith(".xml")));
                }
            }
        }
        long searchTime = System.currentTimeMillis() - st;
        log.debug("Classpath search mappings[{}] searchTime[{}]", (Object)resourceList.size(), (Object)searchTime);
        return resourceList;
    }

    private List<ClassPathScanner> scanners() {
        ArrayList<ClassPathScanner> scanners = new ArrayList<ClassPathScanner>();
        for (ClassPathScannerFactory factory : ServiceLoader.load(ClassPathScannerFactory.class, this.classLoader)) {
            scanners.add(factory.createScanner(this.classLoader));
        }
        return scanners;
    }
}

