/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.lang.parse;

import io.deephaven.internal.log.LoggerFactory;
import io.deephaven.io.logger.Logger;
import io.deephaven.lang.api.ParseCancelled;
import io.deephaven.lang.generated.Chunker;
import io.deephaven.lang.generated.ChunkerDocument;
import io.deephaven.lang.generated.ParseException;
import io.deephaven.lang.generated.TokenMgrException;
import io.deephaven.lang.parse.ParsedDocument;
import io.deephaven.lang.shared.lsp.CompletionCancelled;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class PendingParse {
    private static final Logger LOGGER = LoggerFactory.getLogger(PendingParse.class);
    private final String uri;
    private final Thread parseThread;
    private volatile ParseJob targetState;
    private ParseJob lastParseState;
    private ParseJob completedState;
    private volatile boolean alive;
    private volatile boolean valid;

    PendingParse(String uri) {
        this.uri = uri;
        this.alive = true;
        this.parseThread = new Thread(this::parse, "ParserFor" + uri);
        this.parseThread.setDaemon(true);
        this.parseThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParseJob awaitNext() {
        while (this.alive) {
            Thread thread = this.parseThread;
            synchronized (thread) {
                if (this.valid && this.targetState != null && this.targetState != this.lastParseState) {
                    return this.targetState;
                }
                try {
                    this.parseThread.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse() {
        ParseJob pending;
        while ((pending = this.awaitNext()) != null) {
            Boolean success = pending.parse();
            Thread thread = this.parseThread;
            synchronized (thread) {
                if (Boolean.TRUE.equals(success)) {
                    this.completedState = this.lastParseState = pending;
                } else if (Boolean.FALSE.equals(success)) {
                    this.lastParseState = pending;
                }
                this.parseThread.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestParse(@NotNull String version, @NotNull String text, boolean force) {
        ParseJob localTargetState;
        if (force || (localTargetState = this.targetState) == null || localTargetState.version.compareTo(version) < 0) {
            this.parseThread.interrupt();
            Thread thread = this.parseThread;
            synchronized (thread) {
                this.targetState = new ParseJob(version, text);
                this.valid = true;
                this.parseThread.notifyAll();
            }
        }
    }

    Optional<ParsedDocument> finishParse() {
        ParseJob localTargetState = this.targetState;
        Thread thread = this.parseThread;
        synchronized (thread) {
            while (this.alive && this.valid && localTargetState != this.lastParseState) {
                if (localTargetState != this.targetState) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info().append((CharSequence)"Document changed while awaiting parsing; failing current request ").append((CharSequence)localTargetState.version).endl();
                    }
                    throw new CompletionCancelled();
                }
                try {
                    this.parseThread.wait();
                }
                catch (InterruptedException failure) {
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn().append((CharSequence)"Unexpected interruption of document parser").append((Throwable)failure).endl();
                    }
                    Thread.currentThread().interrupt();
                    throw new CompletionCancelled();
                }
            }
            if (!this.alive) {
                throw new CompletionCancelled();
            }
            if (!this.valid) {
                throw new CompletionCancelled();
            }
            if (this.completedState == null) {
                return Optional.empty();
            }
            if (this.lastParseState == this.targetState) {
                if (this.completedState == this.lastParseState) {
                    return Optional.of(this.completedState.result);
                }
                return Optional.empty();
            }
            throw new CompletionCancelled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        this.alive = false;
        this.parseThread.interrupt();
        Thread thread = this.parseThread;
        synchronized (thread) {
            this.parseThread.notifyAll();
        }
    }

    public String getText() {
        ParseJob localTargetState = this.targetState;
        return localTargetState == null ? "" : localTargetState.text;
    }

    public void invalidate() {
        this.valid = false;
        this.parseThread.interrupt();
    }

    private final class ParseJob {
        private final String version;
        private final String text;
        private ParsedDocument result;

        private ParseJob(@NotNull String version, String text) {
            this.text = text;
            this.version = version;
        }

        private Boolean parse() {
            try {
                Chunker chunker = new Chunker(this.text);
                ChunkerDocument chunkerDocument = chunker.Document();
                this.result = new ParsedDocument(chunkerDocument, this.text);
                return true;
            }
            catch (ParseCancelled expected) {
                return null;
            }
            catch (ParseException | TokenMgrException e) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn().append((CharSequence)"Parser for ").append((CharSequence)PendingParse.this.uri).append((CharSequence)": Encountered parse exception ").append((Throwable)e).append((CharSequence)" while parsing ").append((CharSequence)this.text).endl();
                }
                return false;
            }
        }
    }
}

