/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.lang.generated;

import io.deephaven.lang.generated.Chunker;
import io.deephaven.lang.generated.ChunkerTreeConstants;
import io.deephaven.lang.generated.ChunkerVisitor;
import io.deephaven.lang.generated.Node;
import io.deephaven.lang.generated.Token;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected Object value;
    protected Chunker parser;
    protected Token firstToken;
    protected Token lastToken;
    private boolean wellFormed;
    private Token junk;

    public SimpleNode(int i) {
        this.id = i;
    }

    public SimpleNode(Chunker p, int i) {
        this(i);
        this.parser = p;
    }

    @Override
    public void jjtOpen() {
    }

    @Override
    public void jjtClose() {
    }

    @Override
    public void jjtSetParent(Node n) {
        assert (n != this);
        assert (n.jjtGetParent() != this) : "Cannot make a child our parent";
        assert (this.indexOf(n) == -1) : "Cannot make a child our parent";
        this.parent = n;
    }

    @Override
    public Node jjtGetParent() {
        return this.parent;
    }

    @Override
    public void jjtAddChild(Node n, int i) {
        assert (n != this);
        assert (this == n.jjtGetParent()) : "Set the parent of a node before adding it as a child!";
        assert (n != this.jjtGetParent());
        if (this.children == null) {
            this.children = new Node[i + 1];
        } else if (i >= this.children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        assert (Arrays.stream(this.children).noneMatch(n::equals)) : "Do not double-add " + n + " to " + this;
        this.children[i] = n;
    }

    @Override
    public void jjtInsertChild(Node n, int i) {
        assert (n != this);
        assert (this == n.jjtGetParent()) : "Set the parent of a node before adding it as a child!";
        assert (n != this.jjtGetParent());
        if (this.children == null) {
            this.children = new Node[i + 1];
            this.children[i] = n;
        } else if (i >= this.children.length) {
            Node[] c = new Node[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
            c[i] = n;
        } else if (this.children[i] != n) {
            Node[] c = new Node[this.children.length + 1];
            if (i > 0) {
                System.arraycopy(this.children, 0, c, 0, i);
            }
            c[i] = n;
            System.arraycopy(this.children, i, c, i + 1, this.children.length - i);
            this.children = c;
        }
    }

    @Override
    public Node jjtGetChild(int i) {
        return this.children[i];
    }

    @Override
    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public void jjtSetValue(Object value) {
        this.value = value;
    }

    public Object jjtGetValue() {
        return this.value;
    }

    @Override
    public Token jjtGetFirstToken() {
        return this.firstToken;
    }

    @Override
    public void jjtSetFirstToken(Token token) {
        this.firstToken = token;
    }

    @Override
    public Token jjtGetLastToken() {
        return this.lastToken;
    }

    @Override
    public void jjtSetLastToken(Token token) {
        this.lastToken = token;
    }

    @Override
    public Object jjtAccept(ChunkerVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object childrenAccept(ChunkerVisitor visitor, Object data) {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i].jjtAccept(visitor, data);
            }
        }
        return data;
    }

    public String toString() {
        return ChunkerTreeConstants.jjtNodeName[this.id] + "(" + this.getStartIndex() + "," + this.getEndIndex() + ")|" + this.toSource() + "|";
    }

    public String toString(String prefix) {
        return prefix + this.toString();
    }

    public void dump(String prefix) {
        System.out.println(this.toString(prefix));
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode n = (SimpleNode)this.children[i];
                if (n == null) continue;
                n.dump(prefix + " ");
            }
        }
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public boolean isWellFormed() {
        return this.wellFormed && this.junk == null;
    }

    public void setWellFormed(boolean wellFormed) {
        this.wellFormed = wellFormed;
    }

    @Override
    public void addToken(Token token, Node anchor) {
        if (this.lastToken == token) {
            return;
        }
        if (this.lastToken == null) {
            this.lastToken = token;
        } else if (anchor == null) {
            assert (this.lastToken.next == token) : "Do not add tokens without properly linking them; " + this.lastToken.next + " != " + token;
        } else {
            assert (this.lastToken.next == anchor) : "Do not add tokens without properly linking them; " + this.lastToken.next + " != " + anchor;
            assert (anchor.jjtGetLastToken() == token) : "Do not add tokens without properly linking them; " + anchor.jjtGetLastToken() + " != " + token;
        }
        assert (this.lastToken.startIndex <= token.startIndex);
        assert (this.lastToken.endIndex <= token.endIndex);
        this.lastToken = token;
    }

    @Override
    public List<Node> getChildren() {
        return this.children == null || this.children.length == 0 ? Collections.emptyList() : Arrays.asList(this.children);
    }

    @Override
    public void adopt(Node node) {
        Token tok = node.jjtGetLastToken();
        while (tok != node.jjtGetLastToken()) {
            this.addToken(tok);
            tok = tok.next;
        }
        this.addToken(tok);
        assert (node.jjtGetParent() == null) : "Cannot adopt node w/ parent " + node + "; you should jjtree.popNode() an adopted child";
        this.addChild(node);
    }

    public Token removeToken(Token token) {
        if (token == null) {
            return null;
        }
        assert (token.next == null) : "Cannot remove a token that has child tokens";
        Token removeFrom = this.firstToken;
        while (removeFrom.next != token) {
            removeFrom = removeFrom.next;
            assert (removeFrom != null) : "Cannot remove " + token + " from " + this;
        }
        removeFrom.next = null;
        this.lastToken = removeFrom;
        return removeFrom;
    }

    @Override
    public Token addJunk(Token junk) {
        this.junk = junk;
        Token prev = this.lastToken = junk;
        while (this.lastToken.next != null) {
            prev = this.lastToken;
            this.lastToken = this.lastToken.next;
            assert (prev.startIndex <= this.lastToken.startIndex);
            assert (prev.endIndex <= this.lastToken.endIndex);
        }
        return this.lastToken;
    }

    public Token getJunk() {
        return this.junk;
    }

    @Override
    public void removeChild(Node node) {
        int index = this.indexOf(node);
        if (index == -1) {
            throw new IllegalArgumentException(node + " is not a child of " + this);
        }
        Node[] newChildren = new Node[this.children.length - 1];
        if (index > 0) {
            System.arraycopy(this.children, 0, newChildren, 0, index);
        }
        if (index < this.children.length - 1) {
            System.arraycopy(this.children, index + 1, newChildren, index, this.children.length - index - 1);
        }
        this.children = newChildren;
        assert (Stream.of(this.children).noneMatch(Objects::isNull));
    }

    @Override
    public int indexOf(Node node) {
        if (this.children == null) {
            return -1;
        }
        int index = -1;
        while (++index < this.children.length && this.children[index] != node) {
        }
        return index == this.children.length ? -1 : index;
    }
}

