/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.lang.generated;

import io.deephaven.lang.api.IsScope;
import io.deephaven.lang.generated.BaseToken;
import io.deephaven.lang.generated.ChunkerVisitor;
import io.deephaven.lang.generated.Token;
import io.deephaven.lang.parse.LspTools;
import io.deephaven.proto.backplane.script.grpc.DocumentRange;
import io.deephaven.proto.backplane.script.grpc.Position;
import io.deephaven.proto.backplane.script.grpc.PositionOrBuilder;
import io.deephaven.web.shared.fu.LinkedIterable;
import java.util.Collections;
import java.util.List;

public interface Node {
    public void jjtOpen();

    public void jjtClose();

    public void jjtSetParent(Node var1);

    public Node jjtGetParent();

    public void jjtAddChild(Node var1, int var2);

    public void jjtInsertChild(Node var1, int var2);

    public Node jjtGetChild(int var1);

    public int jjtGetNumChildren();

    public int getId();

    public Token jjtGetFirstToken();

    public void jjtSetFirstToken(Token var1);

    public Token jjtGetLastToken();

    public void jjtSetLastToken(Token var1);

    default public LinkedIterable<Token> tokens(boolean strict) {
        return new LinkedIterable((Object)this.jjtGetFirstToken(), (Object)this.jjtGetLastToken(), true, strict, BaseToken::next);
    }

    default public LinkedIterable<Token> tokensReversed(boolean strict) {
        return new LinkedIterable((Object)this.jjtGetLastToken(), (Object)this.jjtGetFirstToken(), true, strict, BaseToken::prev);
    }

    default public void addToken(Token token) {
        this.addToken(token, null);
    }

    public void addToken(Token var1, Node var2);

    default public Node rescope(List<IsScope> scope) {
        if (scope != null) {
            this.addScope(scope);
        }
        return this;
    }

    default public void setScope(List<IsScope> scope) {
        throw new UnsupportedOperationException(this.getClass() + " does not support scope!");
    }

    public Object jjtAccept(ChunkerVisitor var1, Object var2);

    public void adopt(Node var1);

    default public boolean containsIndex(int i) {
        return this.getStartIndex() <= i && this.getEndIndex() > i;
    }

    default public boolean isChildOf(Node best) {
        for (Node parent : new LinkedIterable((Object)this, Node::jjtGetParent)) {
            if (parent != best) continue;
            return true;
        }
        return false;
    }

    public Token addJunk(Token var1);

    default public String toSource() {
        StringBuilder b = new StringBuilder();
        Token next = this.jjtGetFirstToken();
        while (next != this.jjtGetLastToken()) {
            this.append(b, next);
            if (next == next.next) break;
            next = next.next;
        }
        this.append(b, next);
        return b.toString();
    }

    default public void append(StringBuilder b, Token tok) {
        if (tok.specialToken != null) {
            this.append(b, tok.specialToken);
        }
        b.append(tok.image);
    }

    default public int getEndIndex() {
        Token lastToken = this.jjtGetLastToken();
        if (lastToken.kind == 0) {
            return lastToken.getEndIndex() + lastToken.specialTokenLength();
        }
        return lastToken.getEndIndex();
    }

    default public int getStartIndex() {
        Token firstToken = this.jjtGetFirstToken();
        int ind = firstToken.getStartIndex();
        return ind;
    }

    public List<Node> getChildren();

    default public boolean isAutocompleteTerminal() {
        return false;
    }

    public boolean isWellFormed();

    default public void addChild(Node child) {
        if (this.jjtGetFirstToken() == null) {
            this.jjtSetFirstToken(child.jjtGetFirstToken());
        }
        this.addChild(child, this.jjtGetNumChildren());
    }

    default public void addChild(Node child, int index) {
        child.maybeDetach();
        child.jjtSetParent(this);
        this.jjtAddChild(child, index);
    }

    default public void insertChild(Node child, int index) {
        child.maybeDetach();
        child.jjtSetParent(this);
        this.jjtInsertChild(child, index);
        if (index == 0) {
            this.jjtSetFirstToken(child.jjtGetFirstToken());
        } else if (index == this.jjtGetNumChildren()) {
            this.jjtSetLastToken(child.jjtGetLastToken());
        }
    }

    default public void addScope(IsScope scope) {
        this.addScope(Collections.singletonList(scope));
    }

    default public void addScope(List<IsScope> scope) {
        throw new UnsupportedOperationException(this.getClass() + " must implement addScope(List)");
    }

    default public void maybeDetach() {
        Node parent = this.jjtGetParent();
        if (parent != null) {
            parent.removeChild(this);
        }
    }

    public void removeChild(Node var1);

    public int indexOf(Node var1);

    default public DocumentRange.Builder asRange() {
        return DocumentRange.newBuilder().setStart(this.jjtGetFirstToken().positionStart()).setEnd(this.jjtGetLastToken().positionEnd());
    }

    default public boolean containsLines(int winStartLine, int winEndLine) {
        return this.jjtGetLastToken().endLine >= winEndLine && this.jjtGetFirstToken().beginLine <= winStartLine;
    }

    default public boolean contains(Position pos) {
        Position.Builder startPos = this.jjtGetFirstToken().positionStart();
        if (LspTools.greaterThan((PositionOrBuilder)startPos, (PositionOrBuilder)pos)) {
            return false;
        }
        Position.Builder endPos = this.jjtGetLastToken().positionEnd();
        return LspTools.greaterOrEqual((PositionOrBuilder)endPos, (PositionOrBuilder)pos);
    }

    default public Token findToken(PositionOrBuilder requested) {
        Position.Builder start = this.jjtGetFirstToken().positionStart();
        Token candidate = null;
        if (LspTools.lessOrEqual((PositionOrBuilder)start, requested)) {
            Position.Builder end = this.jjtGetLastToken().positionEnd();
            if (LspTools.greaterOrEqual((PositionOrBuilder)end, requested)) {
                for (Token token : this.tokens(true)) {
                    if (token.containsPosition(requested)) {
                        candidate = token;
                        continue;
                    }
                    if (candidate == null) continue;
                    return candidate;
                }
            } else {
                for (Token token : this.jjtGetLastToken().to(null)) {
                    if (token.containsPosition(requested)) {
                        candidate = token;
                    } else if (candidate != null) {
                        return candidate;
                    }
                    if (!1.$assertionsDisabled && !LspTools.lessThan((PositionOrBuilder)token.positionStart(), requested)) {
                        throw new AssertionError((Object)("Could not find " + requested + " after " + this.jjtGetLastToken()));
                    }
                }
            }
        } else {
            for (Token token : this.jjtGetFirstToken().toReverse(null)) {
                if (token.containsPosition(requested)) {
                    candidate = token;
                    continue;
                }
                if (candidate != null) {
                    return candidate;
                }
                if (!1.$assertionsDisabled && !LspTools.greaterThan((PositionOrBuilder)token.positionEnd(), requested)) {
                    throw new AssertionError((Object)("Could not find " + requested + " before " + this.jjtGetFirstToken()));
                }
            }
        }
        if (candidate == null) {
            throw new IllegalArgumentException("Cannot find " + requested + " from " + this);
        }
        return candidate;
    }

    default public int distanceTo(int offset) {
        int start = Math.abs(this.jjtGetFirstToken().startIndex - offset);
        int end = Math.abs(this.jjtGetLastToken().endIndex - offset);
        return Math.min(start, end);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

