/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.lang.generated;

import io.deephaven.lang.api.AbstractChunkerInvokable;
import io.deephaven.lang.api.IsScope;
import io.deephaven.lang.generated.Chunker;
import io.deephaven.lang.generated.ChunkerVisitor;
import io.deephaven.lang.generated.Node;
import io.deephaven.lang.generated.Token;
import java.util.List;

public class ChunkerInvoke
extends AbstractChunkerInvokable
implements IsScope {
    private String name;
    private boolean inArguments;

    public ChunkerInvoke(int id) {
        super(id);
    }

    public ChunkerInvoke(Chunker p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(ChunkerVisitor visitor, Object data) {
        return visitor.visitChunkerInvoke(this, data);
    }

    @Override
    public String getName() {
        if (this.name == null) {
            Token first = this.getNameToken();
            return first.image.replace("(", "").trim();
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name.trim();
    }

    public void startArguments() {
        this.inArguments = true;
    }

    public void endArguments() {
        this.inArguments = false;
    }

    @Override
    public void jjtAddChild(Node n, int i) {
        super.jjtAddChild(n, i);
        if (this.inArguments) {
            this.addArgument(n);
        }
    }

    public int indexOfArgument(Node node) {
        Node argument;
        int i;
        List<Node> arguments = this.getArguments();
        for (i = 0; i < arguments.size(); ++i) {
            argument = arguments.get(i);
            if (argument != node) continue;
            return i;
        }
        for (i = 0; i < arguments.size(); ++i) {
            argument = arguments.get(i);
            if (!node.isChildOf(argument)) continue;
            return i;
        }
        return -1;
    }

    public boolean isCursorInArguments(int offset) {
        Token tok = this.getNameToken();
        do {
            if (tok.image.contains("(")) {
                return tok.getEndIndex() - 1 <= offset;
            }
            if (!tok.containsIndex(offset)) continue;
            return false;
        } while ((tok = tok.next) != this.jjtGetLastToken());
        return this.isWellFormed();
    }

    public boolean isCursorOnName(int offset) {
        Token tok = this.getNameToken();
        do {
            if (!tok.image.contains("(")) continue;
            return tok.getEndIndex() >= offset && (tok.getStartIndex() <= offset || tok.getStartIndex() == offset + 1 && this.getScope().size() > 0);
        } while ((tok = tok.next) != this.jjtGetLastToken());
        return false;
    }

    @Override
    public boolean isAutocompleteTerminal() {
        return this.isWellFormed() || this.getArgumentCount() == 0;
    }
}

