/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.lang.generated;

import io.deephaven.lang.generated.Token;
import io.deephaven.lang.parse.LspTools;
import io.deephaven.proto.backplane.script.grpc.DocumentRangeOrBuilder;
import io.deephaven.proto.backplane.script.grpc.Position;
import io.deephaven.proto.backplane.script.grpc.PositionOrBuilder;
import io.deephaven.web.shared.fu.LinkedIterable;
import io.deephaven.web.shared.fu.MappedIterable;
import java.util.function.UnaryOperator;

public class BaseToken
implements Comparable<BaseToken> {
    public int startIndex = 0;
    public int endIndex = 0;
    public int tokenBegin = 0;
    Token prev;
    public boolean detached;

    public Token addBackLinks() {
        return this.addBackLinks(null);
    }

    public Token addBackLinks(Token until) {
        Token n;
        Token t = this.self();
        while ((n = t.next) != until) {
            n.prev = t;
            t = n;
        }
        if (until != null) {
            until.prev = t;
        }
        return this.self();
    }

    public Token prev() {
        return this.prev;
    }

    @Override
    public int compareTo(BaseToken o) {
        if (o == this) {
            return 0;
        }
        int myStart = this.getStartIndex();
        int yourStart = o.getStartIndex();
        int myEnd = this.getEndIndex();
        int yourEnd = o.getEndIndex();
        if (myStart == yourStart) {
            if (myEnd == yourEnd) {
                assert (this.self().image.isEmpty() && o.self().image.isEmpty()) : "Different non-EOF tokens have the same indices.";
                return System.identityHashCode(this) - System.identityHashCode(o);
            }
            return myEnd - yourEnd;
        }
        return myStart - yourStart;
    }

    public boolean containsIndex(int desired) {
        return desired >= this.getStartIndex() - this.specialTokenLength() && desired <= this.getEndIndex();
    }

    public int getEndIndex() {
        Token self = (Token)this;
        return this.endIndex;
    }

    public int getStartIndex() {
        Token self = (Token)this;
        return self.startIndex - this.specialTokenLength();
    }

    public int specialTokenLength() {
        Token special = ((Token)this).specialToken;
        int size = 0;
        while (special != null) {
            size += special.image.length();
            special = special.specialToken;
        }
        return size;
    }

    public void copyToken(Token token) {
        Token self = (Token)this;
        self.startIndex = token.startIndex;
        self.endIndex = token.endIndex;
        self.endColumn = token.endColumn;
        self.endLine = token.endLine;
        self.beginColumn = token.beginColumn;
        self.beginLine = token.beginLine;
        self.tokenBegin = token.tokenBegin;
        if (self.kind == 0) {
            self.kind = token.kind;
        }
        if (self.image == null) {
            self.image = token.image;
        }
        if (self.next == null) {
            self.next = token.next;
        }
        if (self.specialToken == null) {
            self.specialToken = token.specialToken;
        }
    }

    public Token next() {
        return this.self().next;
    }

    public Token special() {
        return this.self().specialToken;
    }

    private Token self() {
        return (Token)this;
    }

    public Token getNextNonWhitespace() {
        Token search = this.next();
        while (search != null && search.image.trim().isEmpty()) {
            search = search.next;
        }
        return search;
    }

    public String dump() {
        Token t = this.self();
        return "Token{kind=" + t.kind + ", beginLine=" + t.beginLine + ", beginColumn=" + t.beginColumn + ", endLine=" + t.endLine + ", endColumn=" + t.endColumn + ", image='" + t.image + "', startIndex=" + this.startIndex + ", endIndex=" + this.endIndex + "} ";
    }

    public Position.Builder positionStart() {
        return Position.newBuilder().setLine(this.self().beginLine - 1).setCharacter(this.self().beginColumn - 1);
    }

    public Position.Builder positionEnd() {
        return this.positionEnd(false);
    }

    public Position.Builder positionEnd(boolean considerEof) {
        Token tok = this.self();
        Position.Builder pos = Position.newBuilder().setLine(tok.endLine - 1).setCharacter(tok.endColumn);
        if (considerEof && tok.image.length() == 0) {
            pos.setCharacter(pos.getCharacter() - 1);
        }
        return pos;
    }

    public MappedIterable<Token> toReverse(Token end) {
        if (end == null) {
            return new ReversibleTokenIterable(this.self(), null, BaseToken::prev);
        }
        return end.to(this.self()).reverse();
    }

    public MappedIterable<Token> to(Token end) {
        Token start = this.self();
        return new ReversibleTokenIterable(start, end, BaseToken::next);
    }

    public boolean containsPosition(PositionOrBuilder pos) {
        return LspTools.lessOrEqual((PositionOrBuilder)this.positionStart(), pos) && LspTools.greaterOrEqual((PositionOrBuilder)this.positionEnd(), pos);
    }

    public boolean contains(DocumentRangeOrBuilder replaceRange) {
        Position.Builder myStart = this.positionStart();
        Position.Builder myEnd = this.positionEnd();
        return LspTools.isInside(replaceRange, (PositionOrBuilder)myStart, (PositionOrBuilder)myEnd);
    }

    private class ReversibleTokenIterable
    extends LinkedIterable<Token> {
        private final Token start;
        private final Token end;

        public ReversibleTokenIterable(Token start, Token end, UnaryOperator<Token> direction) {
            super((Object)start, (Object)end, true, end != null, direction);
            this.start = start;
            this.end = end;
        }

        public MappedIterable<Token> reverse() {
            if (this.end == null) {
                return super.reverse();
            }
            if (this.end.prev == null) {
                this.start.addBackLinks(this.end);
            }
            return new ReversibleTokenIterable(this.end, this.start, BaseToken::prev);
        }
    }
}

