/* Generated By:JJTree: Do not edit this line. ChunkerString.java Version 7.0 */
/* JavaCCOptions:MULTI=true,NODE_USES_PARSER=true,VISITOR=true,TRACK_TOKENS=true,NODE_PREFIX=Chunker,NODE_EXTENDS=,NODE_FACTORY=,SUPPORT_CLASS_VISIBILITY_PUBLIC=true */
package io.deephaven.lang.generated;

public
class ChunkerString extends SimpleNode {
  private String quoteType;
  private String body;

  public ChunkerString(int id) {
    super(id);
  }

  public ChunkerString(Chunker p, int id) {
    super(p, id);
  }


  /** Accept the visitor. **/
  public Object jjtAccept(ChunkerVisitor visitor, Object data) {

    return
    visitor.visitChunkerString(this, data);
  }

  public ChunkerString initialize(String quoteType, String body, boolean wellFormed) {
    this.quoteType = quoteType;
    this.body = body;
    setWellFormed(wellFormed);
    final int type;
    switch (quoteType) {
        case "\"":
            type = ChunkerConstants.QUOTE;
            break;
        case "'":
            type = ChunkerConstants.APOS;
            break;
        case "'''":
            type = ChunkerConstants.TRIPLE_APOS;
            break;
        case "\"\"\"":
            type = ChunkerConstants.TRIPLE_QUOTES;
            break;
        default:
            throw new IllegalArgumentException("Not a valid quote type: " + quoteType);
    }
    assert firstToken != null;
    assert lastToken != null;
    assert firstToken.to(lastToken).anyMatch(lastToken::equals);

    loop:
    for (Token token : lastToken.toReverse(firstToken)) {
        switch (token.kind) {
            case ChunkerConstants.QUOTE:
            case ChunkerConstants.APOS:
            case ChunkerConstants.TRIPLE_QUOTES:
            case ChunkerConstants.TRIPLE_APOS:
                assert token.kind == type : "Closing quote does not match opening quote";
            case ChunkerConstants.APOS_CLOSE:
            case ChunkerConstants.QUOTE_CLOSE:
                if (!"'".equals(token.image)) {
                    // TODO: better handling when these close tokens have \n in them;
                    //  if the next line below also has an open quote w/out a close,
                    //  we might assume the user wants use to add `" + \n "` for them.  IDS-1517-30
                    setWellFormed(false);
                }
            case ChunkerConstants.QUOTE_BODY:
            case ChunkerConstants.APOS_BODY:
                lastToken = token;
                break loop;
            default:

        }
    }

    return this;
  }

  public String getRaw() {
      StringBuilder b = new StringBuilder();
      Token node = firstToken;
      assert node.image.equals(quoteType);
      node = node.next;
      while (node.kind == ChunkerConstants.QUOTE_BODY || node.kind == ChunkerConstants.APOS_BODY ) {
        b.append(node.image);
        node = node.next;
      }
      // If this assert can hold through all of our testing, we will just return the body.
      // However, we should expect that for more advanced string parsing, we'll want to
      // return to the current implementation anyway...
      assert b.toString().equals(body) : b + " != " + body;
      return b.toString();
  }

  public String getQuoteType() {
    return quoteType;
  }
}
/* JavaCC - OriginalChecksum=ccc5db77cc7cbd9fe22ca104af3ee5eb (do not edit this line) */
