/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.servlet.web.websocket;

import io.grpc.Attributes;
import io.grpc.InternalLogId;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.internal.AbstractServerStream;
import io.grpc.internal.StatsTraceContext;
import io.grpc.internal.TransportFrameUtil;
import io.grpc.internal.WritableBuffer;
import io.grpc.servlet.web.websocket.AbstractWebsocketStreamImpl;
import io.grpc.servlet.web.websocket.ByteArrayWritableBuffer;
import jakarta.websocket.Session;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class WebsocketStreamImpl
extends AbstractWebsocketStreamImpl {
    private static final Logger logger = Logger.getLogger(WebsocketStreamImpl.class.getName());
    private final Sink sink = new Sink();

    public WebsocketStreamImpl(StatsTraceContext statsTraceCtx, int maxInboundMessageSize, Session websocketSession, InternalLogId logId, Attributes attributes) {
        super(ByteArrayWritableBuffer::new, statsTraceCtx, maxInboundMessageSize, websocketSession, logId, attributes, logger);
    }

    protected Sink abstractServerStreamSink() {
        return this.sink;
    }

    private final class Sink
    implements AbstractServerStream.Sink {
        private Sink() {
        }

        public void writeHeaders(Metadata headers) {
            byte[][] serializedHeaders = TransportFrameUtil.toHttp2Headers((Metadata)headers);
            int headerLength = Arrays.stream(serializedHeaders).mapToInt(arr -> ((byte[])arr).length + 2).sum();
            ByteBuffer prefix = ByteBuffer.allocate(5);
            prefix.put((byte)-128);
            prefix.putInt(headerLength);
            prefix.flip();
            ByteBuffer message = ByteBuffer.allocate(headerLength);
            AbstractWebsocketStreamImpl.writeAsciiHeadersToMessage(serializedHeaders, message);
            message.flip();
            try {
                WebsocketStreamImpl.this.websocketSession.getBasicRemote().sendBinary(prefix);
                WebsocketStreamImpl.this.websocketSession.getBasicRemote().sendBinary(message);
            }
            catch (IOException e) {
                throw Status.fromThrowable((Throwable)e).asRuntimeException();
            }
        }

        public void writeFrame(@Nullable WritableBuffer frame, boolean flush, int numMessages) {
            if (frame == null && !flush) {
                return;
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "[{0}] writeFrame: numBytes = {1}, flush = {2}, numMessages = {3}", new Object[]{WebsocketStreamImpl.this.logId, frame == null ? 0 : frame.readableBytes(), flush, numMessages});
            }
            try {
                if (frame != null) {
                    int numBytes = frame.readableBytes();
                    if (numBytes > 0) {
                        WebsocketStreamImpl.this.onSendingBytes(numBytes);
                    }
                    ByteBuffer payload = ByteBuffer.wrap(((ByteArrayWritableBuffer)frame).bytes, 0, frame.readableBytes());
                    WebsocketStreamImpl.this.websocketSession.getBasicRemote().sendBinary(payload);
                    WebsocketStreamImpl.this.transportState.runOnTransportThread(() -> WebsocketStreamImpl.this.transportState.onSentBytes(numBytes));
                }
            }
            catch (IOException e) {
                this.cancel(Status.fromThrowable((Throwable)e));
            }
        }

        public void writeTrailers(Metadata trailers, boolean headersSent, Status status) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "[{0}] writeTrailers: {1}, headersSent = {2}, status = {3}", new Object[]{WebsocketStreamImpl.this.logId, trailers, headersSent, status});
            }
            byte[][] serializedTrailers = TransportFrameUtil.toHttp2Headers((Metadata)trailers);
            int trailerLength = Arrays.stream(serializedTrailers).mapToInt(arr -> ((byte[])arr).length + 2).sum();
            ByteBuffer prefix = ByteBuffer.allocate(5);
            prefix.put((byte)-128);
            prefix.putInt(trailerLength);
            prefix.flip();
            ByteBuffer message = ByteBuffer.allocate(trailerLength);
            AbstractWebsocketStreamImpl.writeAsciiHeadersToMessage(serializedTrailers, message);
            message.flip();
            try {
                WebsocketStreamImpl.this.websocketSession.getBasicRemote().sendBinary(prefix);
                WebsocketStreamImpl.this.websocketSession.getBasicRemote().sendBinary(message);
                WebsocketStreamImpl.this.websocketSession.close();
            }
            catch (IOException e) {
                throw Status.fromThrowable((Throwable)e).asRuntimeException();
            }
            WebsocketStreamImpl.this.transportState().runOnTransportThread(() -> WebsocketStreamImpl.this.transportState().complete());
        }

        public void cancel(Status status) {
            WebsocketStreamImpl.this.cancelSink(status);
        }
    }
}

