/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.servlet.web.websocket;

import io.grpc.Attributes;
import io.grpc.InternalLogId;
import io.grpc.Metadata;
import io.grpc.ServerStreamTracer;
import io.grpc.Status;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.ReadableBuffers;
import io.grpc.internal.ServerTransportListener;
import io.grpc.internal.StatsTraceContext;
import io.grpc.servlet.web.websocket.AbstractWebSocketServerStream;
import io.grpc.servlet.web.websocket.WebsocketStreamImpl;
import jakarta.websocket.CloseReason;
import jakarta.websocket.Session;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WebSocketServerStream
extends AbstractWebSocketServerStream {
    private static final Logger logger = Logger.getLogger(WebSocketServerStream.class.getName());
    private final InternalLogId logId = InternalLogId.allocate(WebSocketServerStream.class, null);
    public static final String GRPC_WEBSOCKETS_PROTOCOL = "grpc-websockets";
    private WebsocketStreamImpl stream;
    private boolean headersProcessed = false;
    private final boolean isTextRequest = false;

    public WebSocketServerStream(ServerTransportListener transportListener, List<? extends ServerStreamTracer.Factory> streamTracerFactories, int maxInboundMessageSize, Attributes attributes) {
        super(transportListener, streamTracerFactories, maxInboundMessageSize, attributes);
    }

    @Override
    public void onMessage(String message) {
        if (this.stream != null) {
            this.stream.transportReportStatus(Status.fromCode((Status.Code)Status.Code.UNKNOWN));
        }
        try {
            this.websocketSession.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.PROTOCOL_ERROR, "Can't read string payloads"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void onMessage(ByteBuffer message) throws IOException {
        if (message.remaining() == 0) {
            if (this.stream != null) {
                this.stream.transportReportStatus(Status.fromCode((Status.Code)Status.Code.UNKNOWN));
            }
            this.websocketSession.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.PROTOCOL_ERROR, "Unexpected empty message"));
            return;
        }
        if (!this.headersProcessed) {
            this.processHeaders(message);
            this.headersProcessed = true;
            return;
        }
        byte controlFlow = message.get();
        if (controlFlow == 1) {
            if (message.remaining() != 0) {
                this.stream.transportReportStatus(Status.fromCode((Status.Code)Status.Code.UNKNOWN));
                this.websocketSession.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.PROTOCOL_ERROR, "Unexpected bytes in close message"));
                return;
            }
            this.stream.inboundDataReceived(ReadableBuffers.empty(), true);
            return;
        }
        this.stream.inboundDataReceived(ReadableBuffers.wrap((ByteBuffer)message), false);
    }

    public void onError(Session session, Throwable error) {
        this.stream.transportReportStatus(Status.UNKNOWN);
        if (!(error instanceof ClosedChannelException)) {
            logger.log(Level.SEVERE, "Error from websocket", error);
        }
    }

    private String methodName() {
        return this.websocketSession.getRequestURI().getPath().substring(1);
    }

    private void processHeaders(ByteBuffer headerPayload) {
        Metadata headers = WebSocketServerStream.readHeaders(headerPayload);
        Long timeoutNanos = (Long)headers.get(GrpcUtil.TIMEOUT_KEY);
        if (timeoutNanos == null) {
            timeoutNanos = 0L;
        }
        StatsTraceContext statsTraceCtx = StatsTraceContext.newServerContext((List)this.streamTracerFactories, (String)this.methodName(), (Metadata)headers);
        this.stream = new WebsocketStreamImpl(statsTraceCtx, this.maxInboundMessageSize, this.websocketSession, this.logId, this.attributes);
        this.stream.createStream(this.transportListener, this.methodName(), headers);
    }
}

