/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.servlet.web.websocket;

import io.grpc.Attributes;
import io.grpc.InternalLogId;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.internal.AbstractServerStream;
import io.grpc.internal.StatsTraceContext;
import io.grpc.internal.TransportFrameUtil;
import io.grpc.internal.WritableBuffer;
import io.grpc.servlet.web.websocket.AbstractWebsocketStreamImpl;
import io.grpc.servlet.web.websocket.ByteArrayWritableBuffer;
import jakarta.websocket.Session;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class MultiplexedWebsocketStreamImpl
extends AbstractWebsocketStreamImpl {
    private static final Logger logger = Logger.getLogger(MultiplexedWebsocketStreamImpl.class.getName());
    private final Sink sink = new Sink();
    private final int streamId;

    public MultiplexedWebsocketStreamImpl(StatsTraceContext statsTraceCtx, int maxInboundMessageSize, Session websocketSession, InternalLogId logId, Attributes attributes, int streamId) {
        super(ByteArrayWritableBuffer::new, statsTraceCtx, maxInboundMessageSize, websocketSession, logId, attributes, logger);
        if (streamId < 0) {
            throw new IllegalStateException("Can't create stream with negative id");
        }
        this.streamId = streamId;
    }

    protected AbstractServerStream.Sink abstractServerStreamSink() {
        return this.sink;
    }

    private final class Sink
    implements AbstractServerStream.Sink {
        private Sink() {
        }

        public void writeHeaders(Metadata headers) {
            this.writeMetadataToStream(headers, false);
        }

        private void writeMetadataToStream(Metadata headers, boolean closeBitSet) {
            byte[][] serializedHeaders = TransportFrameUtil.toHttp2Headers((Metadata)headers);
            int headerLength = Arrays.stream(serializedHeaders).mapToInt(arr -> ((byte[])arr).length + 2).sum();
            ByteBuffer message = ByteBuffer.allocate(headerLength + 9);
            message.putInt(closeBitSet ? MultiplexedWebsocketStreamImpl.this.streamId ^ Integer.MIN_VALUE : MultiplexedWebsocketStreamImpl.this.streamId);
            message.put((byte)-128);
            message.putInt(headerLength);
            AbstractWebsocketStreamImpl.writeAsciiHeadersToMessage(serializedHeaders, message);
            if (message.hasRemaining()) {
                throw new IllegalStateException("Incorrectly sized buffer, header/trailer payload will be sized wrong");
            }
            message.flip();
            try {
                MultiplexedWebsocketStreamImpl.this.websocketSession.getBasicRemote().sendBinary(message);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void writeFrame(@Nullable WritableBuffer frame, boolean flush, int numMessages) {
            if (frame == null && !flush) {
                return;
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "[{0}] writeFrame: numBytes = {1}, flush = {2}, numMessages = {3}", new Object[]{MultiplexedWebsocketStreamImpl.this.logId, frame == null ? 0 : frame.readableBytes(), flush, numMessages});
            }
            try {
                if (frame != null) {
                    int numBytes = frame.readableBytes();
                    if (numBytes > 0) {
                        MultiplexedWebsocketStreamImpl.this.onSendingBytes(numBytes);
                    }
                    ByteBuffer payload = ByteBuffer.allocate(numBytes + 4);
                    payload.putInt(MultiplexedWebsocketStreamImpl.this.streamId);
                    payload.put(((ByteArrayWritableBuffer)frame).bytes, 0, numBytes);
                    payload.flip();
                    MultiplexedWebsocketStreamImpl.this.websocketSession.getBasicRemote().sendBinary(payload);
                    MultiplexedWebsocketStreamImpl.this.transportState.runOnTransportThread(() -> MultiplexedWebsocketStreamImpl.this.transportState.onSentBytes(numBytes));
                }
            }
            catch (IOException e) {
                this.cancel(Status.fromThrowable((Throwable)e));
            }
        }

        public void writeTrailers(Metadata trailers, boolean headersSent, Status status) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "[{0}] writeTrailers: {1}, headersSent = {2}, status = {3}", new Object[]{MultiplexedWebsocketStreamImpl.this.logId, trailers, headersSent, status});
            }
            this.writeMetadataToStream(trailers, true);
            MultiplexedWebsocketStreamImpl.this.transportState().runOnTransportThread(() -> MultiplexedWebsocketStreamImpl.this.transportState().complete());
        }

        public void cancel(Status status) {
            MultiplexedWebsocketStreamImpl.this.cancelSink(status);
        }
    }
}

