/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.servlet.web.websocket;

import io.grpc.Attributes;
import io.grpc.InternalLogId;
import io.grpc.Metadata;
import io.grpc.ServerStreamTracer;
import io.grpc.Status;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.ReadableBuffers;
import io.grpc.internal.ServerTransportListener;
import io.grpc.internal.StatsTraceContext;
import io.grpc.servlet.web.websocket.AbstractWebSocketServerStream;
import io.grpc.servlet.web.websocket.MultiplexedWebsocketStreamImpl;
import jakarta.websocket.CloseReason;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.Session;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MultiplexedWebSocketServerStream
extends AbstractWebSocketServerStream {
    public static final String GRACEFUL_CLOSE = MultiplexedWebSocketServerStream.class.getName() + ".graceful_close";
    private static final Logger logger = Logger.getLogger(MultiplexedWebSocketServerStream.class.getName());
    public static final Metadata.Key<String> PATH = Metadata.Key.of((String)"grpc-websockets-path", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    public static final String GRPC_WEBSOCKETS_MULTIPLEX_PROTOCOL = "grpc-websockets-multiplex";
    private final Map<Integer, MultiplexedWebsocketStreamImpl> streams = new HashMap<Integer, MultiplexedWebsocketStreamImpl>();
    private final boolean isTextRequest = false;
    private ClosedState closed = ClosedState.OPEN;
    private final CompletableFuture<Void> closingFuture = new CompletableFuture();

    public MultiplexedWebSocketServerStream(ServerTransportListener transportListener, List<? extends ServerStreamTracer.Factory> streamTracerFactories, int maxInboundMessageSize, Attributes attributes) {
        super(transportListener, streamTracerFactories, maxInboundMessageSize, attributes);
    }

    private CompletableFuture<Void> stopAcceptingNewStreams() {
        if (this.closed != ClosedState.OPEN) {
            return this.closingFuture;
        }
        this.closed = ClosedState.CLOSING;
        ByteBuffer end = ByteBuffer.allocate(4);
        end.putInt(0, Integer.MAX_VALUE);
        this.websocketSession.getAsyncRemote().sendBinary(end);
        return this.closingFuture;
    }

    @Override
    public void onOpen(Session websocketSession, EndpointConfig config) {
        super.onOpen(websocketSession, config);
        websocketSession.getUserProperties().put(GRACEFUL_CLOSE, this::stopAcceptingNewStreams);
    }

    public void onClose(Session session, CloseReason closeReason) {
        this.closingFuture.complete(null);
    }

    @Override
    public void onMessage(String message) {
        for (MultiplexedWebsocketStreamImpl stream : this.streams.values()) {
            stream.transportReportStatus(Status.fromCode((Status.Code)Status.Code.UNKNOWN));
        }
        this.streams.clear();
        try {
            this.websocketSession.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.PROTOCOL_ERROR, "Can't read string payloads"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void onMessage(ByteBuffer message) throws IOException {
        boolean closed;
        int streamId = message.getInt();
        if (streamId < 0) {
            closed = true;
            streamId ^= Integer.MIN_VALUE;
        } else {
            closed = false;
        }
        if (closed && streamId == Integer.MAX_VALUE) {
            if (this.closed != ClosedState.CLOSING) {
                this.websocketSession.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.PROTOCOL_ERROR, "Unexpected close ACK"));
                return;
            }
            this.closed = ClosedState.CLOSED;
            this.closingFuture.complete(null);
            return;
        }
        MultiplexedWebsocketStreamImpl stream = this.streams.get(streamId);
        if (message.remaining() == 0) {
            if (stream != null) {
                stream.transportReportStatus(Status.fromCode((Status.Code)Status.Code.UNKNOWN));
                this.streams.remove(streamId);
            }
            this.websocketSession.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.PROTOCOL_ERROR, "Unexpected empty message"));
            return;
        }
        if (stream == null) {
            if (this.closed == ClosedState.CLOSED) {
                this.websocketSession.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.PROTOCOL_ERROR, "Stream created after closing initiated"));
                return;
            }
            this.processHeaders(message, streamId);
            return;
        }
        byte controlFlow = message.get();
        if (controlFlow == 1) {
            assert (closed);
            if (message.remaining() != 0) {
                stream.transportReportStatus(Status.fromCode((Status.Code)Status.Code.UNKNOWN));
                this.streams.remove(streamId);
                this.websocketSession.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.PROTOCOL_ERROR, "Unexpected bytes in close message"));
                return;
            }
            stream.inboundDataReceived(ReadableBuffers.empty(), true);
            this.streams.remove(streamId);
            return;
        }
        assert (!closed);
        stream.inboundDataReceived(ReadableBuffers.wrap((ByteBuffer)message), false);
    }

    public void onError(Session session, Throwable error) {
        for (MultiplexedWebsocketStreamImpl stream : this.streams.values()) {
            stream.transportReportStatus(Status.UNKNOWN);
        }
        this.streams.clear();
        if (!(error instanceof ClosedChannelException) && !(error instanceof EOFException)) {
            logger.log(Level.SEVERE, "Error from websocket", error);
        }
    }

    private void processHeaders(ByteBuffer headerPayload, int streamId) {
        Metadata headers = MultiplexedWebSocketServerStream.readHeaders(headerPayload);
        String path = (String)headers.get(PATH);
        Long timeoutNanos = (Long)headers.get(GrpcUtil.TIMEOUT_KEY);
        if (timeoutNanos == null) {
            timeoutNanos = 0L;
        }
        StatsTraceContext statsTraceCtx = StatsTraceContext.newServerContext((List)this.streamTracerFactories, (String)path, (Metadata)headers);
        InternalLogId logId = InternalLogId.allocate(MultiplexedWebSocketServerStream.class, null);
        MultiplexedWebsocketStreamImpl stream = new MultiplexedWebsocketStreamImpl(statsTraceCtx, this.maxInboundMessageSize, this.websocketSession, logId, this.attributes, streamId);
        stream.createStream(this.transportListener, path, headers);
        this.streams.put(streamId, stream);
    }

    static enum ClosedState {
        OPEN,
        CLOSING,
        CLOSED;

    }

    public static interface GracefulClose
    extends Supplier<CompletableFuture<Void>> {
    }
}

