/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.servlet.web.websocket;

import jakarta.websocket.CloseReason;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.Session;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class GrpcWebsocket
extends Endpoint {
    private final Map<String, Supplier<Endpoint>> endpointFactories = new HashMap<String, Supplier<Endpoint>>();
    private Endpoint endpoint;

    public GrpcWebsocket(Map<String, Supplier<Endpoint>> endpoints) {
        this.endpointFactories.putAll(endpoints);
    }

    public void onOpen(Session session, EndpointConfig endpointConfig) {
        Supplier<Endpoint> supplier = this.endpointFactories.get(session.getNegotiatedSubprotocol());
        if (supplier == null) {
            try {
                session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.PROTOCOL_ERROR, "Unsupported subprotocol"));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return;
        }
        this.endpoint = supplier.get();
        this.endpoint.onOpen(session, endpointConfig);
    }

    public void onClose(Session session, CloseReason closeReason) {
        this.endpoint.onClose(session, closeReason);
    }

    public void onError(Session session, Throwable thr) {
        this.endpoint.onError(session, thr);
    }
}

